/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class JPDACodeEvaluator
extends CodeEvaluator.EvaluatorService {
    private final JPDADebugger debugger;
    private final DebuggerChangeListener debuggerListener;
    private final CodeEvaluator.DefaultExpressionsHistoryPersistence historyPersistence;
    private final RequestProcessor rp;
    private final RequestProcessor.Task evalTask;
    private String expression;
    private CodeEvaluator.Result<Variable, CodeEvaluator.Result.DefaultHistoryItem> result;

    public JPDACodeEvaluator(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.rp = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
        this.evalTask = this.rp.create((Runnable)new EvaluateTask());
        this.historyPersistence = CodeEvaluator.DefaultExpressionsHistoryPersistence.create((String)"debugger.jpda");
        this.debuggerListener = new DebuggerChangeListener();
        this.debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this.debuggerListener);
        this.debugger.addPropertyChangeListener("classesFixed", (PropertyChangeListener)this.debuggerListener);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.debuggerListener);
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)contextProvider.lookupFirst(null, DebuggerEngine.class)));
    }

    public void setupContext(JEditorPane editorPane, Runnable contextSetUp) {
        WatchPanel.setupContext(editorPane, contextSetUp);
    }

    public boolean canEvaluate() {
        return this.debugger.getCurrentThread() != null && this.debugger.getState() == 3;
    }

    public List<String> getExpressionsHistory() {
        return this.historyPersistence.getExpressions();
    }

    public void evaluate(String expression) {
        this.expression = expression;
        this.evalTask.schedule(0);
    }

    public String getExpression() {
        return this.expression;
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    private CodeEvaluator.Result.DefaultHistoryItem getHistoryItem(String expr, Variable result) {
        if (result != null) {
            String type = result.getType();
            String value = result.getValue();
            String toString = "";
            if (result instanceof ObjectVariable) {
                try {
                    toString = ((ObjectVariable)result).getToStringValue();
                }
                catch (InvalidExpressionException ex) {}
            } else {
                toString = value;
            }
            return new CodeEvaluator.Result.DefaultHistoryItem(expr, type, value, toString);
        }
        return null;
    }

    private class DebuggerChangeListener
    implements PropertyChangeListener {
        private DebuggerChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("currentCallStackFrame".equals(propertyName) || "classesFixed".equals(propertyName)) {
                JPDACodeEvaluator.this.firePropertyChange("canEvaluate", null, null);
            } else if ("state".equals(propertyName)) {
                JPDACodeEvaluator.this.firePropertyChange("canEvaluate", null, null);
            }
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            String exp = JPDACodeEvaluator.this.getExpression();
            if (exp == null || "".equals(exp)) {
                return;
            }
            try {
                Variable var = JPDACodeEvaluator.this.debugger.evaluate(exp);
                JPDACodeEvaluator.this.result.setAndOpen(exp, (Object)var, (Object)JPDACodeEvaluator.this.getHistoryItem(exp, var));
                JPDACodeEvaluator.this.historyPersistence.addExpression(exp);
                JPDACodeEvaluator.this.firePropertyChange("expressionsHistory", null, null);
            }
            catch (InvalidExpressionException ieex) {
                String message = ieex.getLocalizedMessage();
                Throwable t = ieex.getTargetException();
                if (t != null && t instanceof ApplicationException) {
                    StringWriter s = new StringWriter();
                    PrintWriter p = new PrintWriter(s);
                    t.printStackTrace(p);
                    p.close();
                    message = message + " \n" + s.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeEvaluator.getDefault().requestFocus();
                    }
                });
            }
        }
    }
}

