/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.ui.models.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.datatransfer.PasteType;

public class LabelVarsFilter
implements NodeActionsProviderFilter,
ExtendedNodeModelFilter {
    private final JPDADebuggerImpl debugger;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final Action MARK_OBJECT_ACTION = Models.createAction((String)Bundle.CTL_MarkObject_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            if (node == null || !(node instanceof ObjectVariable)) {
                return false;
            }
            ObjectVariable var = (ObjectVariable)node;
            return var.getUniqueID() != 0L;
        }

        public void perform(Object[] nodes) {
            ObjectVariable var = (ObjectVariable)nodes[0];
            if (var.getUniqueID() == 0L) {
                return;
            }
            String title = Bundle.CTL_MarkObject_DLG_Title();
            String label = Bundle.CTL_MarkObject_DLG_Label();
            NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(label, title);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (NotifyDescriptor.InputLine.OK_OPTION == ret) {
                label = nd.getInputText().trim();
                if (label.length() == 0) {
                    label = null;
                }
                LabelVarsFilter.this.debugger.markObject(var, label);
                LabelVarsFilter.this.fireNodeChange(null);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public LabelVarsFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        if (node instanceof ObjectVariable) {
            int index;
            for (index = 0; index < actions.length && actions[index] != null; ++index) {
            }
            Action[] newActions = new Action[actions.length + 1];
            System.arraycopy(actions, 0, newActions, 0, index);
            newActions[index] = this.MARK_OBJECT_ACTION;
            if (index < actions.length) {
                System.arraycopy(actions, index, newActions, index + 1, actions.length - index);
            }
            actions = newActions;
        }
        return actions;
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        original.setName(node, name);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBaseWithExtension(node);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        String label;
        String displayName = original.getDisplayName(node);
        if (node instanceof ObjectVariable && (label = this.debugger.getLabel((ObjectVariable)node)) != null) {
            return displayName + " [" + label + "]";
        }
        return displayName;
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        String label;
        String sd = original.getShortDescription(node);
        if (node instanceof ObjectVariable && (label = this.debugger.getLabel((ObjectVariable)node)) != null) {
            return "[" + label + "] " + sd;
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChange(ObjectVariable var) {
        ModelListener[] ls;
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, (Object)var, 5);
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ModelListener[0]);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)event);
        }
    }
}

