/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class RuntimeHelper {
    public static final String GRAILS_HOME_PROPERTY = "GRAILS_HOME";
    public static final String WIN_EXECUTABLE_FILE = "grails.bat";
    public static final String WIN_EXECUTABLE = "\\bin\\grails.bat";
    public static final String WIN_DEBUG_EXECUTABLE = "\\bin\\grails-debug.bat";
    public static final String NIX_EXECUTABLE_FILE = "grails";
    public static final String NIX_EXECUTABLE = "/bin/grails";
    public static final String NIX_DEBUG_EXECUTABLE = "/bin/grails-debug";
    public static final String DEB_EXECUTABLE = "/usr/bin/grails";
    public static final String DEB_DEBUG_EXECUTABLE = "/usr/bin/grails-debug";
    public static final String DEB_START_FILE = "/bin/startGrails";
    public static final String DEB_LOCATION = "/usr/share/grails";
    private static final Logger LOGGER = Logger.getLogger(RuntimeHelper.class.getName());

    private RuntimeHelper() {
    }

    public static boolean isValidRuntime(File grailsBase) {
        String pathToBinary = Utilities.isWindows() ? WIN_EXECUTABLE : NIX_EXECUTABLE;
        return new File(grailsBase, pathToBinary).isFile() || RuntimeHelper.isDebian(grailsBase);
    }

    public static boolean isDebian(File grailsBase) {
        return new File(grailsBase, DEB_START_FILE).isFile() && new File(DEB_EXECUTABLE).isFile() && FileUtil.normalizeFile((File)grailsBase).equals(new File(DEB_LOCATION));
    }

    public static File getGrailsExecutable(File grailsBase, boolean debug) {
        assert (grailsBase != null);
        if (grailsBase == null) {
            return null;
        }
        File grailsExecutable = null;
        grailsExecutable = debug ? (Utilities.isWindows() ? new File(grailsBase, WIN_DEBUG_EXECUTABLE) : (RuntimeHelper.isDebian(grailsBase) ? new File(DEB_DEBUG_EXECUTABLE) : new File(grailsBase, NIX_DEBUG_EXECUTABLE))) : (Utilities.isWindows() ? new File(grailsBase, WIN_EXECUTABLE) : (RuntimeHelper.isDebian(grailsBase) ? new File(DEB_EXECUTABLE) : new File(grailsBase, NIX_EXECUTABLE)));
        return grailsExecutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRuntimeVersion(File grailsBase) {
        if (!RuntimeHelper.isValidRuntime(grailsBase)) {
            return null;
        }
        Properties props = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(grailsBase, "build.properties")));
            try {
                props.load(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        return props.getProperty("grails.version");
    }
}

