/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.util.LinkedList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;

public class KODataBindDescriptor {
    private static final String NAME_PROPERTY = "name";
    private static final String DATA_PROPERTY = "data";
    private static final String FOREACH_PROPERTY = "foreach";
    private static final String AS_PROPERTY = "as";
    private final String name;
    private final String data;
    private final boolean isForEach;
    private final String alias;

    private KODataBindDescriptor(String name, String data, boolean isForEach, String alias) {
        this.name = name;
        this.data = data;
        this.isForEach = isForEach;
        this.alias = alias;
    }

    public static KODataBindDescriptor getDataBindDescriptor(Snapshot snapshot, TokenSequence<? extends JsTokenId> ts, boolean simpleForEach) {
        if (ts == null) {
            return null;
        }
        ts.moveStart();
        ts.moveNext();
        String name = null;
        String alias = null;
        String data = null;
        boolean forEach = false;
        Token<? extends JsTokenId> token = LexUtilities.findNextNonWsNonComment(ts);
        if (token.id() == JsTokenId.BRACKET_LEFT_CURLY) {
            while ((token = KODataBindDescriptor.findNext(ts, JsTokenId.IDENTIFIER, false)) != null) {
                String text = token.text().toString();
                if ((NAME_PROPERTY.equals(text) || AS_PROPERTY.equals(text)) && ts.moveNext()) {
                    token = LexUtilities.findNextNonWsNonComment(ts);
                    if (token.id() == JsTokenId.OPERATOR_COLON && ts.moveNext() && (token = LexUtilities.findNextNonWsNonComment(ts)).id() == JsTokenId.STRING_BEGIN && ts.moveNext() && (token = LexUtilities.findNextNonWsNonComment(ts)).id() == JsTokenId.STRING) {
                        if (NAME_PROPERTY.equals(text)) {
                            name = token.text().toString();
                        } else {
                            alias = token.text().toString();
                        }
                    }
                } else if ((DATA_PROPERTY.equals(text) || FOREACH_PROPERTY.equals(text)) && ts.moveNext() && (token = LexUtilities.findNextNonWsNonComment(ts)).id() == JsTokenId.OPERATOR_COLON && ts.moveNext()) {
                    LexUtilities.findNextNonWsNonComment(ts);
                    int start = ts.offset();
                    token = KODataBindDescriptor.findNext(ts, JsTokenId.OPERATOR_COMMA, true);
                    if (token != null) {
                        data = snapshot.getText().subSequence(start, ts.offset()).toString().trim();
                        forEach = FOREACH_PROPERTY.equals(text);
                    }
                }
                if (token != null && token.id() == JsTokenId.OPERATOR_COMMA) continue;
                KODataBindDescriptor.findNext(ts, JsTokenId.OPERATOR_COMMA, false);
            }
            if ((name != null || simpleForEach) && data != null) {
                return new KODataBindDescriptor(name, data, forEach, forEach || simpleForEach ? alias : null);
            }
        }
        return null;
    }

    private static Token<? extends JsTokenId> findNext(TokenSequence<? extends JsTokenId> ts, JsTokenId toFind, boolean findEnd) {
        LinkedList<JsTokenId> stack = new LinkedList<JsTokenId>();
        block6: while (ts.moveNext()) {
            Token token = LexUtilities.findNextNonWsNonComment(ts);
            JsTokenId id = (JsTokenId)token.id();
            switch (id) {
                case BRACKET_LEFT_BRACKET: 
                case BRACKET_LEFT_CURLY: 
                case BRACKET_LEFT_PAREN: {
                    stack.push(id);
                    continue block6;
                }
                case BRACKET_RIGHT_BRACKET: {
                    if (!stack.isEmpty() && stack.pop() == JsTokenId.BRACKET_LEFT_BRACKET) continue block6;
                    return null;
                }
                case BRACKET_RIGHT_CURLY: {
                    if (stack.isEmpty() && findEnd) {
                        return token;
                    }
                    if (!stack.isEmpty() && stack.pop() == JsTokenId.BRACKET_LEFT_CURLY) continue block6;
                    return null;
                }
                case BRACKET_RIGHT_PAREN: {
                    if (!stack.isEmpty() && stack.pop() == JsTokenId.BRACKET_LEFT_PAREN) continue block6;
                    return null;
                }
            }
            if (toFind != id || !stack.isEmpty()) continue;
            return token;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public boolean isIsForEach() {
        return this.isForEach;
    }

    public String getAlias() {
        return this.alias;
    }
}

