/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Comparator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;

public class SmallSet<T>
implements Destructors.ClassWithDestructor {
    private final long N;
    private SmallVector<T> Vector;
    private std.set<T> Set;

    public SmallSet(long N) {
        this(N, null);
    }

    public SmallSet(long N, Comparator<T> C) {
        this.N = N;
        this.Vector = new SmallVector((int)N);
        this.Set = new std.set(C);
    }

    public SmallSet(SmallSet<T> other) {
        this.N = other.N;
        this.Vector = new SmallVector<T>(other.Vector);
        this.Set = new std.set(other.Set);
    }

    public boolean empty() {
        return this.Vector.empty() && this.Set.empty();
    }

    public long size() {
        return this.isSmall() ? (long)this.Vector.size() : this.Set.size();
    }

    public boolean count(T V) {
        if (this.isSmall()) {
            return Native.$noteq(this.vfind(V), this.Vector.end());
        }
        return this.Set.count(V);
    }

    public boolean insert(T V) {
        if (!this.isSmall()) {
            return this.Set.insert(V).second;
        }
        SmallVectorImpl.iterator<T> I = this.vfind(V);
        if (Native.$noteq(I, this.Vector.end())) {
            return false;
        }
        if ((long)this.Vector.size() < this.N) {
            this.Vector.push_back(V);
            return true;
        }
        while (!this.Vector.empty()) {
            this.Set.insert(this.Vector.back());
            this.Vector.pop_back();
        }
        this.Set.insert(V);
        return true;
    }

    public <IterT extends type.iterator<?, T>> void insert(IterT I, IterT E) {
        while (Native.$noteq(I, E)) {
            this.insert(I.$star());
            I.$preInc();
        }
    }

    public boolean erase(T V) {
        if (!this.isSmall()) {
            return this.Set.erase(V);
        }
        SmallVectorImpl.iterator I = this.Vector.begin();
        SmallVectorImpl.iterator E = this.Vector.end();
        while (Native.$noteq(I, E)) {
            if (Native.$eq(I, V)) {
                this.Vector.erase(I);
                return true;
            }
            I.$preInc();
        }
        return false;
    }

    public void clear() {
        this.Vector.clear();
        this.Set.clear();
    }

    private boolean isSmall() {
        return this.Set.empty();
    }

    private SmallVectorImpl.iterator<T> vfind(T V) {
        SmallVectorImpl.iterator I = this.Vector.begin();
        SmallVectorImpl.iterator E = this.Vector.end();
        while (Native.$noteq(I, E)) {
            if (Native.$eq(I.$star(), V)) {
                return I;
            }
            I.$preInc();
        }
        return this.Vector.end();
    }

    public void $destroy() {
        this.Vector.$destroy();
        this.Set.$destroy();
    }
}

