/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.support.llvm;

public class ArrayRefUInt
implements Iterable<Long> {
    private static final ArrayRefUInt NONE;
    private uint.ptr Data;
    private int Length;
    private final boolean isDataPointerLike;

    public static ArrayRefUInt None() {
        return NONE;
    }

    public ArrayRefUInt() {
        this.Data = NativePointer.create_uint$ptr((long[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
    }

    public ArrayRefUInt(NoneType $Prm0) {
        this.Data = NativePointer.create_uint$ptr((long[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
        if (NONE != null) {
            new Exception("use ArrayRefUInt.None() instead").printStackTrace(System.err);
        }
    }

    public ArrayRefUInt(long OneElt) {
        this(OneElt, false);
    }

    public ArrayRefUInt(long OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_uint$ptr((long[])NativePointer.new$uint$elem((long)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(long[] data, long length) {
        this(data, length, false);
    }

    public ArrayRefUInt(long[] data, long length, boolean isDataPointerLike) {
        this(NativePointer.create_uint$ptr((long[])data), length, isDataPointerLike);
    }

    public ArrayRefUInt(long[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefUInt(long[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_uint$ptr((long[])data), length, isDataPointerLike);
    }

    public ArrayRefUInt(uint.ptr data, long length) {
        this(data, length, false);
    }

    public ArrayRefUInt(uint.ptr data, long length, boolean isDataPointerLike) {
        this(data, Unsigned.long2uint((long)length), isDataPointerLike);
    }

    public ArrayRefUInt(uint.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefUInt(uint.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (uint.ptr)data.clone();
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(uint.ptr begin, uint.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefUInt(uint.ptr begin, uint.ptr end, boolean isDataPointerLike) {
        this.Data = (uint.ptr)begin.clone();
        this.Length = end.$sub((abstract_iterator)begin);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefUInt(SmallVectorImplUInt Vec) {
        this.Data = (uint.ptr)Vec.data().clone();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public <A> ArrayRefUInt(std.vectorUInt Vec) {
        this.Data = Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefUInt(std.vectorString Vec) {
        this.Data = (uint.ptr)Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefUInt(long[] Arr) {
        this(Arr, false);
    }

    public ArrayRefUInt(long[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_uint$ptr((long[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUInt(ArrayRefUInt other) {
        this.Data = (uint.ptr)Native.$tryClone((NativeCloneable)other.data());
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public uint.ptr begin() {
        return this.Data;
    }

    public uint.ptr end() {
        return (uint.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorUInt rbegin() {
        return new std.reverse_iteratorUInt((uint.iterator)this.end());
    }

    public std.reverse_iteratorUInt rend() {
        return new std.reverse_iteratorUInt((uint.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public uint.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public long front() {
        return this.Data.$at(0);
    }

    public long back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefUInt copy(Class<Long> cls, NativeMemory.Allocator A) {
        uint.ptr Buff = (uint.ptr)A.Allocate(cls, this.Length);
        std.copy((uint.iterator)this.begin(), (uint.iterator)this.end(), (uint.iterator)Buff);
        return new ArrayRefUInt(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefUInt RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        uint.ptr L = this.begin();
        uint.ptr LE = this.end();
        uint.ptr R = RHS.begin();
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((long)L.$star(), (long)R.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R.$preInc();
        }
        return true;
    }

    public ArrayRefUInt slice(int N) {
        return new ArrayRefUInt((uint.ptr)this.data().$add(N), this.size() - N);
    }

    public ArrayRefUInt slice(int N, int M) {
        return new ArrayRefUInt((uint.ptr)this.data().$add(N), M);
    }

    public ArrayRefUInt drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefUInt drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public long $at(int Index) {
        return this.Data.$at(Index);
    }

    public std.vectorUInt vec() {
        return new std.vectorUInt((uint.iterator)this.Data, (uint.iterator)this.Data.$add(this.Length), 0L);
    }

    public std.vectorUInt $vector() {
        return new std.vectorUInt((uint.iterator)this.Data, (uint.iterator)this.Data.$add(this.Length), 0L);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((long)this.$at(i), (long)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public void $assign(ArrayRefUInt other) {
        this.Data = other.Data;
        this.Length = other.Length;
    }

    @Override
    public Iterator<Long> iterator() {
        return new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefUInt obj;
        NONE = obj = new ArrayRefUInt(NoneType.None);
    }

    private static final class ArrayRefIterator
    implements Iterator<Long> {
        private final uint.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(uint.ptr Data, int Length) {
            this.localData = (uint.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Long next() {
            Long val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public long TPtr;

        public TRefOrNothing() {
            this.TPtr = 0L;
        }

        public TRefOrNothing(long TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

