/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapBaseUIntType;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.support.llvm;

public class DenseMapUIntType<ValueT>
extends DenseMapBaseUIntType<DenseMapUIntType<ValueT>, ValueT>
implements Native.assignable<DenseMapUIntType<ValueT>>,
Destructors.ClassWithDestructor {
    private std.pairUIntType<ValueT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;

    public DenseMapUIntType(DenseMapInfoUInt keyInfo, ValueT defaultValue) {
        this(keyInfo, 0L, defaultValue);
    }

    public DenseMapUIntType(DenseMapInfoUInt keyInfo, long NumInitBuckets, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public DenseMapUIntType(DenseMapUIntType<ValueT> other) {
        super(other.keyInfoT, other.defaultValue);
        this.init(0L);
        this.copyFrom(other);
    }

    public DenseMapUIntType(DenseMapInfoUInt keyInfo, type.iterator<?, std.pairUIntType<ValueT>> I, type.iterator<?, std.pairUIntType<ValueT>> E, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        this.destroyAll();
    }

    public void swap(DenseMapUIntType<ValueT> RHS) {
        std.pairUIntType<ValueT>[] BucketsOther = RHS.Buckets;
        RHS.Buckets = this.Buckets;
        this.Buckets = BucketsOther;
        int NumBucketsOther = RHS.NumBuckets;
        RHS.NumBuckets = this.NumBuckets;
        this.NumBuckets = NumBucketsOther;
        int NumEntriesOther = RHS.NumEntries;
        RHS.NumEntries = this.NumEntries;
        this.NumEntries = NumEntriesOther;
        int NumTombstonesOther = RHS.NumTombstones;
        RHS.NumTombstones = this.NumTombstones;
        this.NumTombstones = NumTombstonesOther;
    }

    public DenseMapUIntType<ValueT> $assign(DenseMapUIntType<ValueT> other) {
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(DenseMapUIntType<ValueT> other) {
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(long InitBuckets) {
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(long AtLeast) {
        int OldNumBuckets = this.NumBuckets;
        std.pairUIntType<ValueT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)((int)llvm.NextPowerOf2(AtLeast - 1L))));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        long OldNumEntries = this.NumEntries;
        this.destroyAll();
        long NewNumBuckets = 0L;
        if (OldNumEntries != 0L) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == (long)this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std.pairUIntType<ValueT>> getBuckets() {
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std.pairUIntType<ValueT>[] $Buckets() {
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        return this.NumBuckets;
    }

    private boolean allocateBuckets(long Num) {
        this.NumBuckets = (int)Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std.pairUIntType[] bucketsArray = new std.pairUIntType[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std.pairUIntType();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    public String toString() {
        return "DenseMap{Buckets=[\n" + Arrays.toString(this.Buckets) + "\n], NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + '}';
    }
}

