/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.int;

public abstract class SmallVectorImplInt
implements Native.assignable<SmallVectorImplInt>,
Native.NativeComparable<SmallVectorImplInt>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Integer> {
    protected final int defaultValue;
    private int[] array;
    private static final int[] EMPTY = NativePointer.new$int((int)0);
    private int end;

    public final int[] $array() {
        return this.array;
    }

    protected SmallVectorImplInt(int capacity, int defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$int((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplInt(long capacity, int defaultValue) {
        this.array = capacity == 0L ? EMPTY : NativePointer.new$int((long)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplInt(int capacity, int initialSize, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplInt(long capacity, long initialSize, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplInt(int capacity, int initialSize, int value, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplInt(long capacity, long initialSize, int value, int defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplInt(int[] array2, int length, int defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplInt(int[] array2, long length, int defaultValue) {
        this.array = array2;
        this.end = (int)length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplInt(int capacity, int.iterator<?> iter, int length, int defaultValue) {
        this(capacity, iter, (int.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplInt(long capacity, int.iterator<?> iter, long length, int defaultValue) {
        this(capacity, iter, (int.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplInt(int capacity, int.iterator<?> begin, int.iterator<?> end, int defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplInt(long capacity, int.iterator<?> begin, int.iterator<?> end, int defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplInt(SmallVectorImplInt other) {
        this.defaultValue = other.defaultValue;
        this.array = (int[])other.array.clone();
        this.end = other.end;
    }

    protected SmallVectorImplInt(JavaDifferentiators.Move _dparam, SmallVectorImplInt other) {
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = null;
    }

    public final SmallVectorImplInt $assign(SmallVectorImplInt other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(long newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(long newSize, int defaultValue) {
        return this.resize(Unsigned.long2uint((long)newSize), defaultValue);
    }

    public final boolean resize(int newSize, int defaultValue) {
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.array.length) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.array.length) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((int)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(long N) {
        this.reserve(Unsigned.long2uint((long)N));
    }

    public final void reserve(int N) {
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(long NumElts, int Elt) {
        this.assign(Unsigned.long2uint((long)NumElts), Elt);
    }

    public final void assign(int NumElts, int Elt) {
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign(int.iterator<?> __first, int.iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorImplInt RHS) {
        int[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final long find(int elem) {
        return this.find(elem, 0L);
    }

    public final long find(int elem, long from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = Unsigned.long2uint((long)from); i < this.end; ++i) {
            if (!Native.$eq((int)this.array[i], (int)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(int elem) {
        return this.find(elem) != (long)std.string.npos;
    }

    public final boolean erase(int elem) {
        long _index = this.find(elem);
        if (_index == (long)std.string.npos) {
            return false;
        }
        int index = Unsigned.long2uint((long)_index);
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy((int[])this.array, (int)(index + 1), (int)(this.end - index), (int[])this.array, (int)index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy((int.iterator)I.$add(1), (int.iterator)this.end(), (int.iterator)I);
        this.pop_back();
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((int.iterator)E, (int.iterator)this.end(), (int.iterator)S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public final iterator insert(iterator I, int Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((int.iterator)I, (int.iterator)this.end().$sub(1), (int.iterator)this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public final iterator insert(iterator I, long NumToInsert, int Elt) {
        return this.insert(I, Unsigned.long2uint((long)NumToInsert), Elt);
    }

    public final iterator insert(iterator I, int NumToInsert, int Elt) {
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((int.iterator)I, (int.iterator)OldEnd.$sub(NumToInsert), (int.iterator)OldEnd);
            std.fill_n((int.iterator)I, (int)NumToInsert, (int)Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy((int.iterator)I, (int.iterator)OldEnd, (int.iterator)this.end().$sub(NumOverwritten));
        std.fill_n((int.iterator)I, (int)NumOverwritten, (int)Elt);
        std.fill_n((int.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (int)Elt);
        return I;
    }

    public final iterator insert(iterator I, int.iterator<?> From, int.iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((int.iterator)I, (int.iterator)OldEnd.$sub(NumToInsert), (int.iterator)OldEnd);
            std.copy(From, To, (int.iterator)I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((int.iterator)I, (int.iterator)OldEnd, (int.iterator)this.end().$sub(NumOverwritten));
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, (int.iterator)OldEnd);
        return I;
    }

    public final void append(int.iterator<?> in_start, int.iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        int.iterator iter = (int.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(int[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(int[] a, int fromIndex, int count) {
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            int el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(long NumInputs, int Elt) {
        this.append(Unsigned.long2uint((long)NumInputs), Elt);
    }

    public final void append(int NumInputs, int Elt) {
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final boolean $eq(SmallVectorImplInt RHS) {
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((int)this.array[i], (int)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplInt RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplInt)obj).begin(), (Object)((SmallVectorImplInt)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorImplInt)obj);
    }

    public final int.ref ref$at(int idx) {
        return NativePointer.create_int$ref((int[])this.array, (long)idx);
    }

    public final int.ref ref$at(long idx) {
        return NativePointer.create_int$ref((int[])this.array, (long)idx);
    }

    public final int $at(int idx) {
        return this.array[idx];
    }

    public final int $at(long idx) {
        return this.array[(int)idx];
    }

    public final int $set(int idx, int value) {
        this.array[idx] = value;
        return value;
    }

    public final int $set(long idx, int value) {
        this.array[(int)idx] = value;
        return value;
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
    }

    public final void push_back(int val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final int pop_back_val() {
        int val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public final std.reverse_iteratorInt rbegin() {
        return new std.reverse_iteratorInt((int.iterator)NativePointer.create_int$ptr((int[])this.array, (long)this.end));
    }

    public final std.reverse_iteratorInt rend() {
        return new std.reverse_iteratorInt((int.iterator)NativePointer.create_int$ptr((int[])this.array));
    }

    public final int.ptr data() {
        return NativePointer.create_int$ptr((int[])this.array);
    }

    public final int front() {
        return this.array[0];
    }

    public final int back() {
        return this.array[this.end - 1];
    }

    public final int.ref ref$front() {
        return new int.ref(){
            private final int stored;
            private final int index = 0;
            {
                this.stored = SmallVectorImplInt.this.array[0];
                this.index = 0;
            }

            public int $deref() {
                return this.stored;
            }

            public int $set(int value) {
                ((SmallVectorImplInt)SmallVectorImplInt.this).array[0] = value;
                return value;
            }

            public int.ptr deref$ptr() {
                return (int.ptr)SmallVectorImplInt.this.data().$add(0);
            }
        };
    }

    public final int.ref ref$back() {
        return new int.ref(){
            private final int stored;
            private final int index;
            {
                this.stored = SmallVectorImplInt.this.array[SmallVectorImplInt.this.end - 1];
                this.index = SmallVectorImplInt.this.end - 1;
            }

            public int $deref() {
                return this.stored;
            }

            public int $set(int value) {
                ((SmallVectorImplInt)SmallVectorImplInt.this).array[this.index] = value;
                return value;
            }

            public int.ptr deref$ptr() {
                return (int.ptr)SmallVectorImplInt.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final long $sizeof() {
        return this.capacity_in_bytes();
    }

    public final long capacity_in_bytes() {
        int oneElemSize = NativeType.sizeof((int)this.defaultValue);
        for (int elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((int)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final int.ptr ptr$at(int idx) {
        return NativePointer.create_int$ptr((int[])this.array, (long)idx);
    }

    public final int.ptr ptr$at(long idx) {
        return NativePointer.create_int$ptr((int[])this.array, (long)idx);
    }

    public final void set_size(long N) {
        this.set_size(Unsigned.long2uint((long)N));
    }

    public final void set_size(int N) {
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(long from, long to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        int[] oldArray = this.array;
        this.array = NativePointer.new$int((int)capacity);
        NativePointer.copy$Object((int[])oldArray, (int)0, (int[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplInt{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            int element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplInt}\n");
        return out.toString();
    }

    private static final class JavaIterator
    implements Iterator<Integer> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = (iterator)Native.$tryClone((NativeCloneable)begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public Integer next() {
            Integer val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements int.iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorImplInt delegate;
        private int index;

        private iterator(SmallVectorImplInt delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public int $arrow() {
            return this.$at(0);
        }

        public int $star() {
            return this.$at(0);
        }

        public int.ref star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator $inc(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index + amount);
            return this;
        }

        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator $dec(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index - amount);
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        public iterator $add(long amount) {
            return new iterator(this.delegate, (int)((long)this.index + amount), false);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public iterator $sub(long amount) {
            return new iterator(this.delegate, (int)((long)this.index - amount), false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public int $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public int $at(long index) {
            return this.delegate.$at((long)this.index + index);
        }

        public int.ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public int.ref ref$at(long index) {
            return this.delegate.ref$at((long)this.index + index);
        }

        public int.ptr toPointer() {
            return NativePointer.create_int$ptr((int[])this.delegate.array, (long)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

