/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.short;

public abstract class SmallVectorImplShort
implements Native.assignable<SmallVectorImplShort>,
Native.NativeComparable<SmallVectorImplShort>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Short> {
    protected final short defaultValue;
    private short[] array;
    private static final short[] EMPTY = NativePointer.new$short((int)0);
    private int end;

    public final short[] $array() {
        return this.array;
    }

    protected SmallVectorImplShort(int capacity, short defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$short((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplShort(long capacity, short defaultValue) {
        this.array = capacity == 0L ? EMPTY : NativePointer.new$short((long)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplShort(int capacity, int initialSize, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplShort(long capacity, long initialSize, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplShort(int capacity, int initialSize, short value, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplShort(long capacity, long initialSize, short value, short defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplShort(short[] array2, int length, short defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplShort(short[] array2, long length, short defaultValue) {
        this.array = array2;
        this.end = (int)length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplShort(int capacity, short.iterator<?> iter, int length, short defaultValue) {
        this(capacity, iter, (short.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplShort(long capacity, short.iterator<?> iter, long length, short defaultValue) {
        this(capacity, iter, (short.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplShort(int capacity, short.iterator<?> begin, short.iterator<?> end, short defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplShort(long capacity, short.iterator<?> begin, short.iterator<?> end, short defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplShort(SmallVectorImplShort other) {
        this.defaultValue = other.defaultValue;
        this.array = (short[])other.array.clone();
        this.end = other.end;
    }

    protected SmallVectorImplShort(JavaDifferentiators.Move _dparam, SmallVectorImplShort other) {
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = null;
    }

    public final SmallVectorImplShort $assign(SmallVectorImplShort other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(long newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(long newSize, short defaultValue) {
        return this.resize(Unsigned.long2uint((long)newSize), defaultValue);
    }

    public final boolean resize(int newSize, short defaultValue) {
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.array.length) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.array.length) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((short)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(long N) {
        this.reserve(Unsigned.long2uint((long)N));
    }

    public final void reserve(int N) {
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(long NumElts, short Elt) {
        this.assign(Unsigned.long2uint((long)NumElts), Elt);
    }

    public final void assign(int NumElts, short Elt) {
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign(short.iterator<?> __first, short.iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorImplShort RHS) {
        short[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final long find(short elem) {
        return this.find(elem, 0L);
    }

    public final long find(short elem, long from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = Unsigned.long2uint((long)from); i < this.end; ++i) {
            if (!Native.$eq((short)this.array[i], (short)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(short elem) {
        return this.find(elem) != (long)std.string.npos;
    }

    public final boolean erase(short elem) {
        long _index = this.find(elem);
        if (_index == (long)std.string.npos) {
            return false;
        }
        int index = Unsigned.long2uint((long)_index);
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy((short[])this.array, (int)(index + 1), (int)(this.end - index), (short[])this.array, (int)index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy((short.iterator)I.$add(1), (short.iterator)this.end(), (short.iterator)I);
        this.pop_back();
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((short.iterator)E, (short.iterator)this.end(), (short.iterator)S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public final iterator insert(iterator I, short Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((short.iterator)I, (short.iterator)this.end().$sub(1), (short.iterator)this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public final iterator insert(iterator I, long NumToInsert, short Elt) {
        return this.insert(I, Unsigned.long2uint((long)NumToInsert), Elt);
    }

    public final iterator insert(iterator I, int NumToInsert, short Elt) {
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((short.iterator)I, (short.iterator)OldEnd.$sub(NumToInsert), (short.iterator)OldEnd);
            std.fill_n((short.iterator)I, (int)NumToInsert, (short)Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy((short.iterator)I, (short.iterator)OldEnd, (short.iterator)this.end().$sub(NumOverwritten));
        std.fill_n((short.iterator)I, (int)NumOverwritten, (short)Elt);
        std.fill_n((short.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (short)Elt);
        return I;
    }

    public final iterator insert(iterator I, short.iterator<?> From, short.iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((short.iterator)I, (short.iterator)OldEnd.$sub(NumToInsert), (short.iterator)OldEnd);
            std.copy(From, To, (short.iterator)I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((short.iterator)I, (short.iterator)OldEnd, (short.iterator)this.end().$sub(NumOverwritten));
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, (short.iterator)OldEnd);
        return I;
    }

    public final void append(short.iterator<?> in_start, short.iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        short.iterator iter = (short.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(short[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(short[] a, int fromIndex, int count) {
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            short el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(long NumInputs, short Elt) {
        this.append(Unsigned.long2uint((long)NumInputs), Elt);
    }

    public final void append(int NumInputs, short Elt) {
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final boolean $eq(SmallVectorImplShort RHS) {
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((int)this.array[i], (int)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplShort RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplShort)obj).begin(), (Object)((SmallVectorImplShort)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorImplShort)obj);
    }

    public final short.ref ref$at(int idx) {
        return NativePointer.create_short$ref((short[])this.array, (long)idx);
    }

    public final short.ref ref$at(long idx) {
        return NativePointer.create_short$ref((short[])this.array, (long)idx);
    }

    public final short $at(int idx) {
        return this.array[idx];
    }

    public final short $at(long idx) {
        return this.array[(int)idx];
    }

    public final short $set(int idx, short value) {
        this.array[idx] = value;
        return value;
    }

    public final short $set(long idx, short value) {
        this.array[(int)idx] = value;
        return value;
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
    }

    public final void push_back(short val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final short pop_back_val() {
        short val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public final std.reverse_iteratorShort rbegin() {
        return new std.reverse_iteratorShort((short.iterator)NativePointer.create_short$ptr((short[])this.array, (long)this.end));
    }

    public final std.reverse_iteratorShort rend() {
        return new std.reverse_iteratorShort((short.iterator)NativePointer.create_short$ptr((short[])this.array));
    }

    public final short.ptr data() {
        return NativePointer.create_short$ptr((short[])this.array);
    }

    public final short front() {
        return this.array[0];
    }

    public final short back() {
        return this.array[this.end - 1];
    }

    public final short.ref ref$front() {
        return new short.ref(){
            private final short stored;
            private final int index = 0;
            {
                this.stored = SmallVectorImplShort.this.array[0];
                this.index = 0;
            }

            public short $deref() {
                return this.stored;
            }

            public short $set(short value) {
                ((SmallVectorImplShort)SmallVectorImplShort.this).array[0] = value;
                return value;
            }

            public short.ptr deref$ptr() {
                return (short.ptr)SmallVectorImplShort.this.data().$add(0);
            }
        };
    }

    public final short.ref ref$back() {
        return new short.ref(){
            private final short stored;
            private final int index;
            {
                this.stored = SmallVectorImplShort.this.array[SmallVectorImplShort.this.end - 1];
                this.index = SmallVectorImplShort.this.end - 1;
            }

            public short $deref() {
                return this.stored;
            }

            public short $set(short value) {
                ((SmallVectorImplShort)SmallVectorImplShort.this).array[this.index] = value;
                return value;
            }

            public short.ptr deref$ptr() {
                return (short.ptr)SmallVectorImplShort.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final long $sizeof() {
        return this.capacity_in_bytes();
    }

    public final long capacity_in_bytes() {
        int oneElemSize = NativeType.sizeof((short)this.defaultValue);
        for (short elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((short)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final short.ptr ptr$at(int idx) {
        return NativePointer.create_short$ptr((short[])this.array, (long)idx);
    }

    public final short.ptr ptr$at(long idx) {
        return NativePointer.create_short$ptr((short[])this.array, (long)idx);
    }

    public final void set_size(long N) {
        this.set_size(Unsigned.long2uint((long)N));
    }

    public final void set_size(int N) {
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(long from, long to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        short[] oldArray = this.array;
        this.array = NativePointer.new$short((int)capacity);
        NativePointer.copy$Object((short[])oldArray, (int)0, (short[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Short> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplShort{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            short element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplShort}\n");
        return out.toString();
    }

    private static final class JavaIterator
    implements Iterator<Short> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = (iterator)Native.$tryClone((NativeCloneable)begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public Short next() {
            Short val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements short.iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorImplShort delegate;
        private int index;

        private iterator(SmallVectorImplShort delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public short $arrow() {
            return this.$at(0);
        }

        public short $star() {
            return this.$at(0);
        }

        public short.ref star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator $inc(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index + amount);
            return this;
        }

        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator $dec(long amount) {
            assert (!this._const);
            this.index = (int)((long)this.index - amount);
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        public iterator $add(long amount) {
            return new iterator(this.delegate, (int)((long)this.index + amount), false);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public iterator $sub(long amount) {
            return new iterator(this.delegate, (int)((long)this.index - amount), false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public short $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public short $at(long index) {
            return this.delegate.$at((long)this.index + index);
        }

        public short.ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public short.ref ref$at(long index) {
            return this.delegate.ref$at((long)this.index + index);
        }

        public short.ptr toPointer() {
            return NativePointer.create_short$ptr((short[])this.delegate.array, (long)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

