/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryUInt;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapUInt<AllocatorTy extends NativeMemory.Allocator>
extends StringMapImpl
implements Destructors.ClassWithDestructor {
    private AllocatorTy Allocator;
    private final long defaultValue;

    public StringMapUInt(long defaultValue) {
        super(StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapUInt(long InitialSize, long defaultValue) {
        super(InitialSize, StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapUInt(AllocatorTy A, long defaultValue) {
        super(StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapUInt(long InitialSize, AllocatorTy A, long defaultValue) {
        super(InitialSize, StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapUInt(StringMapUInt<AllocatorTy> RHS, long defaultValue) {
        super(StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        this.defaultValue = defaultValue;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapUInt(JavaDifferentiators.Move _dparam, StringMapUInt<AllocatorTy> RHS) {
        super((StringMapImpl)std.move(RHS));
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
    }

    public StringMapUInt<AllocatorTy> $assign(StringMapUInt<AllocatorTy> RHS) {
        super.swap(RHS);
        AllocatorTy tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public AllocatorTy getAllocator() {
        return this.Allocator;
    }

    public StringMapIteratorUInt begin() {
        return new StringMapIteratorUInt(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorUInt end() {
        return new StringMapIteratorUInt(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorUInt find(StringRef Key) {
        int Bucket = this.FindKey(Key);
        if (Bucket == -1) {
            return this.end();
        }
        return new StringMapIteratorUInt(this.TheTable, Bucket, true);
    }

    public long lookup(StringRef Key) {
        return this.lookup(Key.data(), Key.size());
    }

    public long lookup(char.ptr Key, int KeyLen) {
        int Bucket = this.FindKey(Key, KeyLen);
        if (Bucket != -1) {
            return ((StringMapEntryUInt)this.TheTable[Bucket]).getValue();
        }
        return Native.$tryClone((long)this.defaultValue);
    }

    public long $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public uint.ref ref$at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std.pairTypeBool<StringMapIteratorUInt> insert(std.pairTypeUInt<StringRef> KV) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapUInt.getTombstoneVal()) {
            return std.make_pair((Object)new StringMapIteratorUInt(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = StringMapEntryUInt.Create(keyData, keyLength, FullHashValue, this.Allocator, (Long)std.move((Object)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair((Object)new StringMapIteratorUInt(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntryUInt KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapUInt.getTombstoneVal()) {
            return false;
        }
        if (Bucket == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntryUInt GetOrCreateValue(StringRef Key, long Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntryUInt GetOrCreateValue(char.ptr Key, int Len, long Val) {
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapUInt.getTombstoneVal()) {
            return (StringMapEntryUInt)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((long)Val);
        }
        StringMapEntryUInt NewItem = StringMapEntryUInt.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryUInt)Bucket;
    }

    private StringMapEntryUInt GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, long Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntryBase Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapUInt.getTombstoneVal()) {
            return (StringMapEntryUInt)Bucket;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((long)Val);
        }
        StringMapEntryUInt NewItem = StringMapEntryUInt.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (StringMapEntryUInt)Bucket;
    }

    public StringMapEntryUInt GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntryUInt GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntryUInt GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntryUInt KeyValue) {
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIteratorUInt I) {
        StringMapEntryUInt V = I.$star();
        this.remove(V);
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIteratorUInt I = this.find(Key);
        if (Native.$eq((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy(this.Allocator);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIteratorUInt B = this.begin();
        StringMapIteratorUInt E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(B.$star().first()).append("=>").append(B.$star().getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }
}

