/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.uint;
import org.llvm.support.ZeroBehavior;
import org.llvm.support.llvm;

public final class APIntStatics {
    public static uint.ptr getClearedMemory(int numWords) {
        assert (numWords >= 0) : "must be non negative " + numWords;
        uint.ptr result = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)numWords));
        assert (result != null) : "APInt memory allocation fails!";
        std.memset((uint.ptr)result, (long)0L, (int)(numWords * NativeType.sizeof(Long.TYPE)));
        return result;
    }

    public static uint.ptr getMemory(int numWords) {
        assert (numWords >= 0) : "must be non negative " + numWords;
        uint.ptr result = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)numWords));
        assert (result != null) : "APInt memory allocation fails!";
        return result;
    }

    public static int getDigit(byte cdigit, int radix) {
        int r;
        assert (radix >= 0) : "must be non negative " + radix;
        if (radix == 16 || radix == 36) {
            r = cdigit - NativePointer.$0;
            if (r <= 9) {
                return r;
            }
            r = cdigit - NativePointer.$A;
            if ((long)r <= (long)radix - 11L) {
                return r + 10;
            }
            r = cdigit - NativePointer.$a;
            if ((long)r <= (long)radix - 11L) {
                return r + 10;
            }
            radix = 10;
        }
        if ((r = cdigit - NativePointer.$0) < radix) {
            return r;
        }
        return -1;
    }

    public static boolean add_1(uint.ptr dest, uint.ptr x, int len, long y) {
        assert (len >= 0) : "must be non negative " + len;
        for (int i = 0; i < len; ++i) {
            dest.$set(i, y + x.$at(i));
            if (dest.$at(i) >= y) {
                y = 0L;
                break;
            }
            y = 1L;
        }
        return y != 0L;
    }

    public static boolean sub_1(uint.ptr x, int len, long y) {
        assert (len >= 0) : "must be non negative " + len;
        for (int i = 0; i < len; ++i) {
            long X = x.$at(i);
            x.$set$minusassign(i, y);
            if (y <= X) {
                y = 0L;
                break;
            }
            y = 1L;
        }
        return y != 0L;
    }

    public static boolean add(uint.ptr dest, uint.ptr x, uint.ptr y, int len) {
        assert (len >= 0) : "must be non negative " + len;
        boolean carry = false;
        for (int i = 0; i < len; ++i) {
            long limit = std.min((long)x.$at(i), (long)y.$at(i));
            dest.$set(i, x.$at(i) + y.$at(i) + (long)(carry ? 1 : 0));
            carry = dest.$at(i) < limit || carry && dest.$at(i) == limit;
        }
        return carry;
    }

    public static boolean sub(uint.ptr dest, uint.ptr x, uint.ptr y, int len) {
        assert (len >= 0) : "must be non negative " + len;
        boolean borrow = false;
        for (int i = 0; i < len; ++i) {
            long x_tmp = borrow ? x.$at(i) - 1L : x.$at(i);
            borrow = y.$at(i) > x_tmp || borrow && x.$at(i) == 0L;
            dest.$set(i, x_tmp - y.$at(i));
        }
        return borrow;
    }

    public static long mul_1(uint.ptr dest, uint.ptr x, int len, long y) {
        assert (len >= 0) : "must be non negative " + len;
        long ly = y & 0xFFFFFFFFL;
        long hy = y >> 32;
        long carry = 0L;
        for (int i = 0; i < len; ++i) {
            long lx = x.$at(i) & 0xFFFFFFFFL;
            long hx = x.$at(i) >> 32;
            byte hasCarry = 0;
            dest.$set(i, carry + lx * ly);
            hasCarry = (byte)(dest.$at(i) < carry ? 1 : 0);
            carry = hx * ly + (dest.$at(i) >> 32) + (hasCarry != 0 ? 0x100000000L : 0L);
            hasCarry = (byte)(carry == 0L && hasCarry != 0 ? 1 : (carry == 0L ? 2 : 0));
            dest.$set(i, (carry += lx * hy & 0xFFFFFFFFL) << 32 | dest.$at(i) & 0xFFFFFFFFL);
            carry = (carry == 0L && hasCarry != 2 || hasCarry == 1 ? 0x100000000L : 0L) + (carry >> 32) + (lx * hy >> 32) + hx * hy;
        }
        return carry;
    }

    public static void mul(uint.ptr dest, uint.ptr x, int xlen, uint.ptr y, int ylen) {
        assert (xlen >= 0) : "must be non negative " + xlen;
        assert (ylen >= 0) : "must be non negative " + ylen;
        dest.$set(xlen, APIntStatics.mul_1(dest, x, xlen, y.$at(0)));
        for (int i = 1; i < ylen; ++i) {
            long ly = y.$at(i) & 0xFFFFFFFFL;
            long hy = y.$at(i) >> 32;
            long carry = 0L;
            long lx = 0L;
            long hx = 0L;
            for (int j = 0; j < xlen; ++j) {
                lx = x.$at(j) & 0xFFFFFFFFL;
                hx = x.$at(j) >> 32;
                byte hasCarry = 0;
                long resul = carry + lx * ly;
                hasCarry = (byte)(resul < carry ? 1 : 0);
                hasCarry = (byte)((carry = (hasCarry != 0 ? 0x100000000L : 0L) + hx * ly + (resul >> 32)) == 0L && hasCarry != 0 ? 1 : (carry == 0L ? 2 : 0));
                resul = (carry += lx * hy & 0xFFFFFFFFL) << 32 | resul & 0xFFFFFFFFL;
                dest.$set$addassign(i + j, resul);
                carry = (carry == 0L && hasCarry != 2 || hasCarry == 1 ? 0x100000000L : 0L) + (carry >> 32) + (long)(dest.$at(i + j) < resul ? 1 : 0) + (lx * hy >> 32) + hx * hy;
            }
            dest.$set(i + xlen, carry);
        }
    }

    public static void lshrNear(uint.ptr Dst, uint.ptr Src, int Words, int Shift) {
        assert (Words >= 0) : "must be non negative " + Words;
        assert (Shift >= 0) : "must be non negative " + Shift;
        long Carry = 0L;
        for (int I = Words - 1; I >= 0; --I) {
            long Tmp = Src.$at(I);
            Dst.$set(I, Tmp >> Shift | Carry);
            Carry = Tmp << 64 - Shift;
        }
    }

    public static void KnuthDiv(uint.ptr u, uint.ptr v, uint.ptr q, uint.ptr r, int m, int n) {
        block21: {
            assert (m >= 0) : "must be non negative " + m;
            assert (n >= 0) : "must be non negative " + n;
            assert (u != null) : "Must provide dividend";
            assert (v != null) : "Must provide divisor";
            assert (q != null) : "Must provide quotient";
            assert (u.$noteq((Object)v) && u.$noteq((Object)q) && v.$noteq((Object)q)) : "Must us different memory";
            assert (n > 1) : "n must be > 1";
            long b = 0x100000000L;
            int shift = llvm.countLeadingZeros(v.$at(n - 1));
            long v_carry = 0L;
            long u_carry = 0L;
            if (shift != 0) {
                int i;
                for (i = 0; i < m + n; ++i) {
                    long u_tmp = u.$at(i) >> 32 - shift;
                    u.$set(i, u.$at(i) << shift | u_carry);
                    u_carry = u_tmp;
                }
                for (i = 0; i < n; ++i) {
                    long v_tmp = v.$at(i) >> 32 - shift;
                    v.$set(i, v.$at(i) << shift | v_carry);
                    v_carry = v_tmp;
                }
            }
            u.$set(m + n, u_carry);
            int j = m;
            do {
                boolean carry;
                long dividend = (u.$at(j + n) << 32) + u.$at(j + n - 1);
                long qp = dividend / v.$at(n - 1);
                long rp = dividend % v.$at(n - 1);
                if (!(qp != b && qp * v.$at(n - 2) <= b * rp + u.$at(j + n - 2) || (rp += v.$at(n - 1)) >= b || --qp != b && qp * v.$at(n - 2) <= b * rp + u.$at(j + n - 2))) {
                    --qp;
                }
                boolean isNeg = false;
                for (int i = 0; i < n; ++i) {
                    long u_tmp = u.$at(j + i) | u.$at(j + i + 1) << 32;
                    long subtrahend = qp * v.$at(i);
                    boolean borrow = subtrahend > u_tmp;
                    long result = u_tmp - subtrahend;
                    int k = j + i;
                    u.$set(k++, result & b - 1L);
                    u.$set(k++, result >> 32);
                    while (borrow && k <= m + n) {
                        borrow = u.$at(k) == 0L;
                        u.$set$postDec(k);
                        ++k;
                    }
                    isNeg |= borrow;
                }
                if (isNeg) {
                    carry = true;
                    for (int i = 0; i <= m + n; ++i) {
                        u.$set(i, (u.$at(i) ^ 0xFFFFFFFFFFFFFFFFL) + (long)(carry ? 1 : 0));
                        carry = carry && u.$at(i) == 0L;
                    }
                }
                q.$set(j, qp);
                if (!isNeg) continue;
                q.$set$postDec(j);
                carry = false;
                for (int i = 0; i < n; ++i) {
                    long limit = std.min((long)u.$at(j + i), (long)v.$at(i));
                    u.$set$addassign(j + i, v.$at(i) + (long)(carry ? 1 : 0));
                    carry = u.$at(j + i) < limit || carry && u.$at(j + i) == limit;
                }
                u.$set$addassign(j + n, (long)(carry ? 1 : 0));
            } while (--j >= 0);
            if (r == null) break block21;
            if (shift != 0) {
                long carry = 0L;
                for (int i = n - 1; i >= 0; --i) {
                    r.$set(i, u.$at(i) >> shift | carry);
                    carry = u.$at(i) << 32 - shift;
                }
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    r.$set(i, u.$at(i));
                }
            }
        }
    }

    public static long lowBitMask(int bits) {
        assert (bits >= 0) : "must be non negative " + bits;
        assert (bits != 0 && bits <= llvm.integerPartWidth);
        return -1L >> llvm.integerPartWidth - bits;
    }

    public static long lowHalf(long part) {
        return part & APIntStatics.lowBitMask(llvm.integerPartWidth / 2);
    }

    public static long highHalf(long part) {
        return part >> llvm.integerPartWidth / 2;
    }

    public static int partMSB(long value) {
        return llvm.findLastSet(value, ZeroBehavior.ZB_Max);
    }

    public static int partLSB(long value) {
        return llvm.findFirstSet(value, ZeroBehavior.ZB_Max);
    }
}

