/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.support.llvm_unreachable;

public final class TripleStatics {
    public static Triple.ArchType parseARMArch(StringRef ArchName) {
        int offset = StringRef.npos;
        Triple.ArchType arch = Triple.ArchType.UnknownArch;
        boolean isThumb = ArchName.startswith("thumb");
        if (ArchName.equals("arm")) {
            return Triple.ArchType.arm;
        }
        if (ArchName.equals("armeb")) {
            return Triple.ArchType.armeb;
        }
        if (ArchName.equals("thumb")) {
            return Triple.ArchType.thumb;
        }
        if (ArchName.equals("thumbeb")) {
            return Triple.ArchType.thumbeb;
        }
        if (ArchName.equals("arm64") || ArchName.equals("aarch64")) {
            return Triple.ArchType.aarch64;
        }
        if (ArchName.equals("aarch64_be")) {
            return Triple.ArchType.aarch64_be;
        }
        if (ArchName.startswith("armv")) {
            offset = 3;
            if (ArchName.endswith("eb")) {
                arch = Triple.ArchType.armeb;
                ArchName.$assign$substr(0, ArchName.size() - 2);
            } else {
                arch = Triple.ArchType.arm;
            }
        } else if (ArchName.startswith("armebv")) {
            offset = 5;
            arch = Triple.ArchType.armeb;
        } else if (ArchName.startswith("thumbv")) {
            offset = 5;
            if (ArchName.endswith("eb")) {
                arch = Triple.ArchType.thumbeb;
                ArchName.$assign$substr(0, ArchName.size() - 2);
            } else {
                arch = Triple.ArchType.thumb;
            }
        } else if (ArchName.startswith("thumbebv")) {
            offset = 7;
            arch = Triple.ArchType.thumbeb;
        }
        return new StringSwitch<Triple.ArchType>(ArchName.substr(offset)).Cases("v2", "v2a", isThumb ? Triple.ArchType.UnknownArch : arch).Cases("v3", "v3m", isThumb ? Triple.ArchType.UnknownArch : arch).Cases("v4", "v4t", arch).Cases("v5", "v5e", "v5t", "v5te", "v5tej", arch).Cases("v6", "v6j", "v6k", "v6m", arch).Cases("v6t2", "v6z", "v6zk", arch).Cases("v7", "v7a", "v7em", "v7l", arch).Cases("v7m", "v7r", "v7s", arch).Cases("v8", "v8a", arch).Default(Triple.ArchType.UnknownArch);
    }

    public static Triple.ArchType parseArch(StringRef ArchName) {
        Triple.ArchType ARMArch = TripleStatics.parseARMArch(ArchName);
        return new StringSwitch<Triple.ArchType>(ArchName).Cases("i386", "i486", "i586", "i686", Triple.ArchType.x86).Cases("i786", "i886", "i986", Triple.ArchType.x86).Cases("amd64", "x86_64", "x86_64h", Triple.ArchType.x86_64).Case("powerpc", Triple.ArchType.ppc).Cases("powerpc64", "ppu", Triple.ArchType.ppc64).Case("powerpc64le", Triple.ArchType.ppc64le).Case("xscale", Triple.ArchType.arm).Case("xscaleeb", Triple.ArchType.armeb).StartsWith((CharSequence)"arm", ARMArch).StartsWith((CharSequence)"thumb", ARMArch).StartsWith((CharSequence)"aarch64", ARMArch).Case("msp430", Triple.ArchType.msp430).Cases("mips", "mipseb", "mipsallegrex", Triple.ArchType.mips).Cases("mipsel", "mipsallegrexel", Triple.ArchType.mipsel).Cases("mips64", "mips64eb", Triple.ArchType.mips64).Case("mips64el", Triple.ArchType.mips64el).Case("r600", Triple.ArchType.r600).Case("amdgcn", Triple.ArchType.amdgcn).Case("hexagon", Triple.ArchType.hexagon).Case("s390x", Triple.ArchType.systemz).Case("sparc", Triple.ArchType.sparc).Cases("sparcv9", "sparc64", Triple.ArchType.sparcv9).Case("tce", Triple.ArchType.tce).Case("xcore", Triple.ArchType.xcore).Case("nvptx", Triple.ArchType.nvptx).Case("nvptx64", Triple.ArchType.nvptx64).Case("le32", Triple.ArchType.le32).Case("le64", Triple.ArchType.le64).Case("amdil", Triple.ArchType.amdil).Case("amdil64", Triple.ArchType.amdil64).Case("hsail", Triple.ArchType.hsail).Case("hsail64", Triple.ArchType.hsail64).Case("spir", Triple.ArchType.spir).Case("spir64", Triple.ArchType.spir64).StartsWith((CharSequence)"kalimba", Triple.ArchType.kalimba).Default(Triple.ArchType.UnknownArch);
    }

    public static Triple.VendorType parseVendor(StringRef VendorName) {
        return new StringSwitch<Triple.VendorType>(VendorName).Case("apple", Triple.VendorType.Apple).Case("pc", Triple.VendorType.PC).Case("scei", Triple.VendorType.SCEI).Case("bgp", Triple.VendorType.BGP).Case("bgq", Triple.VendorType.BGQ).Case("fsl", Triple.VendorType.Freescale).Case("ibm", Triple.VendorType.IBM).Case("img", Triple.VendorType.ImaginationTechnologies).Case("mti", Triple.VendorType.MipsTechnologies).Case("nvidia", Triple.VendorType.NVIDIA).Case("csr", Triple.VendorType.CSR).Default(Triple.VendorType.UnknownVendor);
    }

    public static Triple.OSType parseOS(StringRef OSName) {
        return new StringSwitch<Triple.OSType>(OSName).StartsWith((CharSequence)"darwin", Triple.OSType.Darwin).StartsWith((CharSequence)"dragonfly", Triple.OSType.DragonFly).StartsWith((CharSequence)"freebsd", Triple.OSType.FreeBSD).StartsWith((CharSequence)"ios", Triple.OSType.IOS).StartsWith((CharSequence)"kfreebsd", Triple.OSType.KFreeBSD).StartsWith((CharSequence)"linux", Triple.OSType.Linux).StartsWith((CharSequence)"lv2", Triple.OSType.Lv2).StartsWith((CharSequence)"macosx", Triple.OSType.MacOSX).StartsWith((CharSequence)"netbsd", Triple.OSType.NetBSD).StartsWith((CharSequence)"openbsd", Triple.OSType.OpenBSD).StartsWith((CharSequence)"solaris", Triple.OSType.Solaris).StartsWith((CharSequence)"win32", Triple.OSType.Win32).StartsWith((CharSequence)"windows", Triple.OSType.Win32).StartsWith((CharSequence)"haiku", Triple.OSType.Haiku).StartsWith((CharSequence)"minix", Triple.OSType.Minix).StartsWith((CharSequence)"rtems", Triple.OSType.RTEMS).StartsWith((CharSequence)"nacl", Triple.OSType.NaCl).StartsWith((CharSequence)"cnk", Triple.OSType.CNK).StartsWith((CharSequence)"bitrig", Triple.OSType.Bitrig).StartsWith((CharSequence)"aix", Triple.OSType.AIX).StartsWith((CharSequence)"cuda", Triple.OSType.CUDA).StartsWith((CharSequence)"nvcl", Triple.OSType.NVCL).StartsWith((CharSequence)"amdhsa", Triple.OSType.AMDHSA).Default(Triple.OSType.UnknownOS);
    }

    public static Triple.EnvironmentType parseEnvironment(StringRef EnvironmentName) {
        return new StringSwitch<Triple.EnvironmentType>(EnvironmentName).StartsWith((CharSequence)"eabihf", Triple.EnvironmentType.EABIHF).StartsWith((CharSequence)"eabi", Triple.EnvironmentType.EABI).StartsWith((CharSequence)"gnueabihf", Triple.EnvironmentType.GNUEABIHF).StartsWith((CharSequence)"gnueabi", Triple.EnvironmentType.GNUEABI).StartsWith((CharSequence)"gnux32", Triple.EnvironmentType.GNUX32).StartsWith((CharSequence)"code16", Triple.EnvironmentType.CODE16).StartsWith((CharSequence)"gnu", Triple.EnvironmentType.GNU).StartsWith((CharSequence)"android", Triple.EnvironmentType.Android).StartsWith((CharSequence)"msvc", Triple.EnvironmentType.MSVC).StartsWith((CharSequence)"itanium", Triple.EnvironmentType.Itanium).StartsWith((CharSequence)"cygnus", Triple.EnvironmentType.Cygnus).Default(Triple.EnvironmentType.UnknownEnvironment);
    }

    public static Triple.ObjectFormatType parseFormat(StringRef EnvironmentName) {
        return new StringSwitch<Triple.ObjectFormatType>(EnvironmentName).EndsWith("coff", Triple.ObjectFormatType.COFF).EndsWith("elf", Triple.ObjectFormatType.ELF).EndsWith("macho", Triple.ObjectFormatType.MachO).Default(Triple.ObjectFormatType.UnknownObjectFormat);
    }

    public static Triple.SubArchType parseSubArch(StringRef SubArchName) {
        if (SubArchName.endswith("eb")) {
            SubArchName.$assign$substr(0, SubArchName.size() - 2);
        }
        return new StringSwitch<Triple.SubArchType>(SubArchName).EndsWith("v8", Triple.SubArchType.ARMSubArch_v8).EndsWith("v8a", Triple.SubArchType.ARMSubArch_v8).EndsWith("v7", Triple.SubArchType.ARMSubArch_v7).EndsWith("v7a", Triple.SubArchType.ARMSubArch_v7).EndsWith("v7em", Triple.SubArchType.ARMSubArch_v7em).EndsWith("v7l", Triple.SubArchType.ARMSubArch_v7).EndsWith("v7m", Triple.SubArchType.ARMSubArch_v7m).EndsWith("v7r", Triple.SubArchType.ARMSubArch_v7).EndsWith("v7s", Triple.SubArchType.ARMSubArch_v7s).EndsWith("v6", Triple.SubArchType.ARMSubArch_v6).EndsWith("v6m", Triple.SubArchType.ARMSubArch_v6m).EndsWith("v6t2", Triple.SubArchType.ARMSubArch_v6t2).EndsWith("v5", Triple.SubArchType.ARMSubArch_v5).EndsWith("v5e", Triple.SubArchType.ARMSubArch_v5).EndsWith("v5t", Triple.SubArchType.ARMSubArch_v5).EndsWith("v5te", Triple.SubArchType.ARMSubArch_v5te).EndsWith("v4t", Triple.SubArchType.ARMSubArch_v4t).EndsWith("kalimba3", Triple.SubArchType.KalimbaSubArch_v3).EndsWith("kalimba4", Triple.SubArchType.KalimbaSubArch_v4).EndsWith("kalimba5", Triple.SubArchType.KalimbaSubArch_v5).Default(Triple.SubArchType.NoSubArch);
    }

    public static char.ptr getObjectFormatTypeName(Triple.ObjectFormatType Kind2) {
        switch (Kind2) {
            case UnknownObjectFormat: {
                return NativePointer.$((String)"");
            }
            case COFF: {
                return NativePointer.$((String)"coff");
            }
            case ELF: {
                return NativePointer.$((String)"elf");
            }
            case MachO: {
                return NativePointer.$((String)"macho");
            }
        }
        throw new llvm_unreachable((CharSequence)"unknown object format type");
    }

    public static Triple.ObjectFormatType getDefaultFormat(Triple T) {
        if (T.isOSDarwin()) {
            return Triple.ObjectFormatType.MachO;
        }
        if (T.isOSWindows()) {
            return Triple.ObjectFormatType.COFF;
        }
        return Triple.ObjectFormatType.ELF;
    }

    public static long EatNumber(StringRef Str) {
        assert (!Str.empty() && Str.$at(0) >= 48 && Str.$at(0) <= 57) : "Not a number";
        long Result = 0L;
        do {
            Result = Result * 10L + (long)(Str.$at(0) - NativePointer.$((char)'0'));
            Str.$assign$substr(1);
        } while (!Str.empty() && Str.$at(0) >= NativePointer.$((char)'0') && Str.$at(0) <= NativePointer.$((char)'9'));
        return Result;
    }

    public static long getArchPointerBitWidth(Triple.ArchType Arch) {
        switch (Arch) {
            case UnknownArch: {
                return 0L;
            }
            case msp430: {
                return 16L;
            }
            case arm: 
            case armeb: 
            case hexagon: 
            case le32: 
            case mips: 
            case mipsel: 
            case nvptx: 
            case ppc: 
            case r600: 
            case sparc: 
            case tce: 
            case thumb: 
            case thumbeb: 
            case x86: 
            case xcore: 
            case amdil: 
            case hsail: 
            case spir: 
            case kalimba: {
                return 32L;
            }
            case aarch64: 
            case aarch64_be: 
            case amdgcn: 
            case le64: 
            case mips64: 
            case mips64el: 
            case nvptx64: 
            case ppc64: 
            case ppc64le: 
            case sparcv9: 
            case systemz: 
            case x86_64: 
            case amdil64: 
            case hsail64: 
            case spir64: {
                return 64L;
            }
        }
        throw new llvm_unreachable((CharSequence)"Invalid architecture value");
    }
}

