/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import java.io.File;
import java.util.Comparator;
import java.util.Locale;
import org.clank.java.built_in;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.llint;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uchar;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ullint;
import org.clank.support.aliases.ushort;
import org.clank.support.void;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.APInt;
import org.llvm.adt.APSInt;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.LLVMMemoryBufferRef;
import org.llvm.adt.Optional;
import org.llvm.adt.OwningArrayPtr;
import org.llvm.adt.PointerUnion;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefChar;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.DenseMapIntType;
import org.llvm.adt.aliases.DenseMapIteratorIntType;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.adt.aliases.tierTypeUInt;
import org.llvm.adt.impl.Iterator_rangeLlvmGlobals;
import org.llvm.adt.iterator_range;
import org.llvm.adt.mapped_iterator;
import org.llvm.adt.tier;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCContext;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.mcparser.MCAsmParser;
import org.llvm.support.ConvertUTFGlobals;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.SourceMgr;
import org.llvm.support.ZeroBehavior;
import org.llvm.support.endian.EndianGlobals;
import org.llvm.support.format_object1;
import org.llvm.support.format_object2;
import org.llvm.support.format_object3;
import org.llvm.support.format_object4;
import org.llvm.support.format_object5;
import org.llvm.support.impl.ErrorHandlingLlvmGlobals;
import org.llvm.support.impl.LlvmStatics;
import org.llvm.support.impl.ManagedStaticStatics;
import org.llvm.support.impl.PrettyStackTraceStatics;
import org.llvm.support.impl.StatisticInfo;
import org.llvm.support.impl.StatisticStatics;
import org.llvm.support.impl.StringRefStatics;
import org.llvm.support.impl.ThreadingStatics;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_null_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.sys;

public final class llvm {
    public static final boolean DebugFlag = false;
    public static final boolean LLVM_ON_WIN32 = llvm.isWindows();
    public static short[] BitReverseTable256 = new short[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    public static final float huge_valf = built_in.__builtin_huge_valf();
    public static final int host_char_bit = 8;
    public static final int integerPartWidth = 8 * NativeType.sizeof(Long.class);
    private static final raw_ostream OUTS = new raw_fd_ostream(1, true);
    private static final raw_ostream ERRS = new raw_fd_ostream(2, false, true);
    private static final raw_ostream NULLS = new raw_null_ostream();
    private static final Comparator<?> array_pod_sort_comparatorCallback = new Comparator(){

        public int compare(Object o1, Object o2) {
            return llvm.array_pod_sort_comparator(o1, o2);
        }
    };
    public static final StringRef STRING_REF_DELIMETERS = new StringRef(" \t\n\u000b\f\r");
    private static final int SmallBufferSize = 64;

    private llvm() {
    }

    public static void LLVM_BUILTIN_TRAP() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        if ("Windows NT".equals(osName)) {
            return true;
        }
        if ("Windows 95".equals(osName)) {
            return true;
        }
        if ("Windows 98".equals(osName)) {
            return true;
        }
        if ("Windows 2000".equals(osName)) {
            return true;
        }
        if ("Windows Vista".equals(osName)) {
            return true;
        }
        if (osName.startsWith("Windows ")) {
            return true;
        }
        if ("Solaris".equals(osName)) {
            return false;
        }
        if (osName.startsWith("SunOS")) {
            return false;
        }
        if (osName.endsWith("Linux")) {
            return false;
        }
        if ("HP-UX".equals(osName)) {
            return false;
        }
        if ("AIX".equals(osName)) {
            return false;
        }
        if ("Irix".equals(osName)) {
            return false;
        }
        if ("SunOS".equals(osName)) {
            return false;
        }
        if ("Digital UNIX".equals(osName)) {
            return false;
        }
        if ("OS/2".equals(osName)) {
            return false;
        }
        if ("OpenVMS".equals(osName)) {
            return false;
        }
        if (osName.equals("Mac OS X")) {
            return false;
        }
        if (osName.startsWith("Darwin")) {
            return false;
        }
        if (osName.toLowerCase(Locale.US).startsWith("freebsd")) {
            return false;
        }
        if ("OpenBSD".equals(osName)) {
            return false;
        }
        if (File.pathSeparatorChar == ':') {
            return false;
        }
        return false;
    }

    public static <T> std_ptr.unique_ptr<T> make_unique(T val) {
        return std.make_unique(val);
    }

    public static int alignmentAdjustment(char.ptr Ptr, int Alignment) {
        return llvm.alignAddr(Ptr, Alignment) - Native.$ptr_index((char.ptr)Ptr);
    }

    public static int alignAddr(char.ptr Addr, int Alignment) {
        assert (Alignment != 0 && llvm.isPowerOf2_32(Alignment)) : "Alignment is not a power of two!";
        assert (Native.$ptr_index((char.ptr)Addr) + Alignment - 1 >= Native.$ptr_index((char.ptr)Addr));
        return Native.$ptr_index((char.ptr)Addr) + Alignment - 1 & ~(Alignment - 1);
    }

    public static boolean getAsUnsignedInteger(StringRef Str, int Radix, ullint.ref Result) {
        if (Radix == 0) {
            Radix = StringRefStatics.GetAutoSenseRadix(Str);
        }
        if (Str.empty()) {
            return true;
        }
        Result.$set(0L);
        while (!Str.empty()) {
            long CharVal;
            if (Str.$at(0) >= NativePointer.$((char)'0') && Str.$at(0) <= NativePointer.$((char)'9')) {
                CharVal = Str.$at(0) - 48;
            } else if (Str.$at(0) >= NativePointer.$((char)'a') && Str.$at(0) <= NativePointer.$((char)'z')) {
                CharVal = Str.$at(0) - 97 + 10;
            } else if (Str.$at(0) >= NativePointer.$((char)'A') && Str.$at(0) <= NativePointer.$((char)'Z')) {
                CharVal = Str.$at(0) - 65 + 10;
            } else {
                return true;
            }
            if (CharVal >= (long)Radix) {
                return true;
            }
            long PrevResult = Result.$deref();
            Result.$set(Result.$deref() * (long)Radix + CharVal);
            if (Result.$deref() / (long)Radix < PrevResult) {
                return true;
            }
            Str.$assign$substr(1);
        }
        return false;
    }

    public static boolean getAsSignedInteger(StringRef Str, int Radix, llint.ref Result) {
        ullint.ref ULLVal = NativePointer.create_ullint$ref((long)0L);
        if (Str.empty() || Str.front() != NativePointer.$((char)'-')) {
            if (llvm.getAsUnsignedInteger(Str, Radix, ULLVal) || ULLVal.$deref() < 0L) {
                return true;
            }
            Result.$set(ULLVal.$deref());
            return false;
        }
        if (llvm.getAsUnsignedInteger(Str.substr(1), Radix, ULLVal) || -ULLVal.$deref() > 0L) {
            return true;
        }
        Result.$set(-ULLVal.$deref());
        return false;
    }

    public static MCAsmParser createMCAsmParser(SourceMgr $Prm0, MCContext $Prm1, MCStreamer $Prm2, MCAsmInfo $Prm3) {
        throw new UnsupportedOperationException();
    }

    public static MCStreamer createNullStreamer(MCContext Context) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean $eq_StringRef(StringRef LHS, StringRef RHS) {
        return LHS.equals(RHS);
    }

    public static boolean $eq_StringRef(StringRef LHS, CharSequence RHS) {
        return LHS.equals(RHS);
    }

    public static boolean $eq_StringRef(CharSequence LHS, StringRef RHS) {
        return RHS.equals(LHS);
    }

    public static boolean $eq_StringRef(SmallString LHS, CharSequence RHS) {
        int Len = RHS.length();
        return LHS.size() == Len && std.memcmp((byte[])LHS.$array(), (int)0, (CharSequence)RHS, (int)Len) == 0;
    }

    public static boolean $eq_StringRef(std.string LHS, StringRef RHS) {
        return RHS.equals(LHS);
    }

    public static boolean $eq_StringRef(StringRef LHS, std.string RHS) {
        return llvm.$eq_StringRef(RHS, LHS);
    }

    public static boolean $eq_StringRef(char.ptr LHS, int LHSLen, CharSequence RHS) {
        return LHSLen == RHS.length() && std.memcmp((char.ptr)LHS, (CharSequence)RHS, (int)LHSLen) == 0;
    }

    public static boolean $eq_RawStringRef(char.ptr LHS, int LHSLen, char.ptr RHS, int RHSLen) {
        return LHSLen == RHSLen && (LHSLen == 0 || std.memcmp((char.ptr)LHS, (char.ptr)RHS, (int)RHSLen) == 0);
    }

    public static boolean $eq_RawStringRef(char.ptr LHS, int LHSLen, byte[] RHS, int RHSIdx, int RHSLen) {
        return LHSLen == RHSLen && (LHSLen == 0 || std.memcmp((char.ptr)LHS, (byte[])RHS, (int)RHSIdx, (int)RHSLen) == 0);
    }

    public static boolean $eq_RawStringRef_with_null_termed(char.ptr LHS, int LHSLen, byte[] RHSWithNullTerm, int RHSFromIdx) {
        return std.memcmp_null_termed((char.ptr)LHS, (byte[])RHSWithNullTerm, (int)RHSFromIdx, (int)LHSLen) == 0;
    }

    public static boolean $eq_RawStringRef_with_null_termed(byte[] LHS, int LHSStartIndex, int LHSLen, byte[] RHSWithNullTerm, int RHSFromIdx) {
        return std.memcmp_null_termed((byte[])LHS, (int)LHSStartIndex, (byte[])RHSWithNullTerm, (int)RHSFromIdx, (int)LHSLen) == 0;
    }

    public static boolean $noteq_StringRef(StringRef LHS, StringRef RHS) {
        return !LHS.equals(RHS);
    }

    public static boolean $noteq_StringRef(std.string LHS, StringRef RHS) {
        return !RHS.equals(LHS);
    }

    public static boolean $noteq_StringRef(StringRef LHS, std.string RHS) {
        return llvm.$noteq_StringRef(RHS, LHS);
    }

    public static boolean $noteq_StringRef(char.ptr LHS, int LHSLen, CharSequence RHS) {
        return !llvm.$eq_StringRef(LHS, LHSLen, RHS);
    }

    public static boolean $less_StringRef(StringRef LHS, StringRef RHS) {
        return LHS.compare(RHS) == -1;
    }

    public static boolean $lesseq_StringRef(StringRef LHS, StringRef RHS) {
        return LHS.compare(RHS) != 1;
    }

    public static boolean $greater_StringRef(StringRef LHS, StringRef RHS) {
        return LHS.compare(RHS) == 1;
    }

    public static boolean $greatereq_StringRef(StringRef LHS, StringRef RHS) {
        return LHS.compare(RHS) != -1;
    }

    public static std.string $addassign_str_StringRef(std.string buffer, StringRef string2) {
        return buffer.append((char.iterator)string2.data(), string2.size());
    }

    public static StringRef toStringRef(boolean B) {
        return new StringRef(B ? "true" : "false");
    }

    public static Twine $plus_Twine(Twine LHS, Twine RHS) {
        return LHS.concat(RHS);
    }

    public static Twine $plus_char$ptr_StringRef(char.ptr LHS, StringRef RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_char$ptr_StringRef(CharSequence LHS, StringRef RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_T_StringRef(char.ptr LHS, StringRef RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_T_StringRef(CharSequence LHS, StringRef RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_StringRef_char$ptr(StringRef LHS, char.ptr RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_StringRef_char$ptr(StringRef LHS, CharSequence RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_StringRef_T(StringRef LHS, char.ptr RHS) {
        return new Twine(LHS, RHS);
    }

    public static Twine $plus_StringRef_T(StringRef LHS, CharSequence RHS) {
        return new Twine(LHS, RHS);
    }

    public static raw_ostream $out_raw_ostream_Twine(raw_ostream OS, Twine RHS) {
        RHS.print(OS);
        return OS;
    }

    public static <T> int alignOf(Class<T> cls) {
        if (cls == Byte.TYPE) {
            return 8;
        }
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> int countTrailingZeros(T Val) {
        return llvm.countTrailingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static <T> int countTrailingZeros(T Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("Use dedicated methods instead!");
    }

    public static int countTrailingZeros_uint32_t_ZeroBehavior(long Val) {
        return llvm.countTrailingZeros_uint32_t_ZeroBehavior(Val, ZeroBehavior.ZB_Width);
    }

    public static int countTrailingZeros_uint32_t_ZeroBehavior(long Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0L) {
            return 32;
        }
        return Integer.numberOfTrailingZeros(Long.valueOf(Val).intValue());
    }

    public static int countTrailingZeros_uint64_t_ZeroBehavior(long Val) {
        return llvm.countTrailingZeros_uint64_t_ZeroBehavior(Val, ZeroBehavior.ZB_Width);
    }

    public static int countTrailingZeros_uint64_t_ZeroBehavior(long Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0L) {
            return 64;
        }
        return Long.numberOfTrailingZeros(Val);
    }

    public static int countTrailingZeros(long Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int countLeadingZeros(long Val) {
        return llvm.countLeadingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros(long Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0L) {
            return 64;
        }
        return Long.numberOfLeadingZeros(Val);
    }

    public static int countLeadingZeros(int Val) {
        return llvm.countLeadingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros(int Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0) {
            return 32;
        }
        return Integer.numberOfLeadingZeros(Val);
    }

    public static int countLeadingZeros(short Val) {
        return llvm.countLeadingZeros(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros(short Val, ZeroBehavior ZB) {
        if (ZB != ZeroBehavior.ZB_Undefined && Val == 0) {
            return 16;
        }
        throw new UnsupportedOperationException();
    }

    public static int countLeadingZeros_uint64_t_ZeroBehavior(long Val) {
        return llvm.countLeadingZeros_uint64_t_ZeroBehavior(Val, ZeroBehavior.ZB_Width);
    }

    public static int countLeadingZeros_uint64_t_ZeroBehavior(long Val, ZeroBehavior ZB) {
        return llvm.countLeadingZeros(Val, ZB);
    }

    public static <T> int findFirstSet(T Val) {
        return llvm.findFirstSet(Val, ZeroBehavior.ZB_Max);
    }

    public static <T> int findFirstSet(T Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> int findLastSet(T Val) {
        return llvm.findLastSet(Val, ZeroBehavior.ZB_Max);
    }

    public static <T> int findLastSet(T Val, ZeroBehavior ZB) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> T reverseBits(T Val) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long Hi_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long Lo_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isInt(long x, int N) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isInt(long x) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isShiftedInt(long x, int N, int S) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isUInt(long x, int N) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isUInt(long x) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isShiftedUInt(long x, int N, int S) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isUIntN(int N, long x) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isIntN(int N, long x) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isMask_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isMask_64(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isShiftedMask_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isShiftedMask_64(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isPowerOf2_32(long Value) {
        return Value != 0L && (Value & Value - 1L) == 0L;
    }

    public static boolean isPowerOf2_64(long Value) {
        return Value != 0L && (Value & Value - 1L) == 0L;
    }

    public static char ByteSwap_16(char Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long ByteSwap_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long ByteSwap_64(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int CountLeadingOnes_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int CountLeadingOnes_64(long Value) {
        return llvm.countLeadingZeros_uint64_t_ZeroBehavior(Value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int CountTrailingOnes_32(long Value) {
        return llvm.countTrailingZeros_uint32_t_ZeroBehavior(Value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int CountTrailingOnes_64(long Value) {
        return llvm.countTrailingZeros_uint64_t_ZeroBehavior(Value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int CountPopulation_32(long Value) {
        return Long.bitCount(Value);
    }

    public static int CountPopulation_64(long Value) {
        return Long.bitCount(Value);
    }

    public static int Log2_32(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int Log2_64(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int Log2_32_Ceil(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int Log2_64_Ceil(long Value) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long GreatestCommonDivisor64(long A, long B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static double BitsToDouble(long Bits) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static float BitsToFloat(long Bits) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long DoubleToBits(double Double2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long FloatToBits(float Float2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int IsNAN(float f) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int IsNAN(double d) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int IsInf(float f) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int IsInf(double d) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long MinAlign(long A, long B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long NextPowerOf2(long A) {
        A |= A >> 1;
        A |= A >> 2;
        A |= A >> 4;
        A |= A >> 8;
        A |= A >> 16;
        A |= A >> 32;
        return A + 1L;
    }

    public static int NextPowerOf2(int A) {
        A |= A >> 1;
        A |= A >> 2;
        A |= A >> 4;
        A |= A >> 8;
        A |= A >> 16;
        return A + 1;
    }

    public static long RoundUpToAlignment(long Value, long Align) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long OffsetToAlignment(long Value, long Align) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long abs64(long x) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int SignExtend32(long x, int B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long SignExtend64(long X, int B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> long capacity_in_bytes(SmallVector<T> X, int N) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <X, Y> boolean isa(Class<X> cls, Y Val) {
        return cls.isInstance(Val);
    }

    public static <X, Y> X cast(Class<X> cls, Y Val) {
        return cls.cast(Val);
    }

    public static <X, Y> X cast_or_null(Class<X> cls, Y Val) {
        return Val != null ? (X)llvm.cast(cls, Val) : null;
    }

    public static std_errors.error_code make_error_code(std_errors.errc E) {
        return new std_errors.error_code(E.getValue(), std.generic_category());
    }

    public static <T, U> boolean $eq_IntrusiveRefCntPtr(IntrusiveRefCntPtr<T> A, IntrusiveRefCntPtr<U> B) {
        return A.get() == B.get();
    }

    public static <T, U> boolean $noteq_IntrusiveRefCntPtr(IntrusiveRefCntPtr<T> A, IntrusiveRefCntPtr<U> B) {
        return A.get() != B.get();
    }

    public static <T, U> boolean $eq_IntrusiveRefCntPtr_T(IntrusiveRefCntPtr<T> A, U B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> boolean $noteq_IntrusiveRefCntPtr_T(IntrusiveRefCntPtr<T> A, U B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> boolean $eq_T_IntrusiveRefCntPtr(T A, IntrusiveRefCntPtr<U> B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> boolean $noteq_T_IntrusiveRefCntPtr(T A, IntrusiveRefCntPtr<U> B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> void swap(std_ptr.unique_ptr<T> a, std_ptr.unique_ptr<T> b) {
        a.swap(b);
    }

    public static <T> void swap(OwningArrayPtr<T> a, OwningArrayPtr<T> b) {
        a.swap(b);
    }

    public static raw_ostream outs() {
        return OUTS;
    }

    public static raw_ostream errs() {
        return ERRS;
    }

    public static raw_ostream nulls() {
        return NULLS;
    }

    public static boolean isCurrentDebugType(char.ptr Type2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean isCurrentDebugType(CharSequence Type2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void setCurrentDebugType(char.ptr Type2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static raw_ostream dbgs() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> void $eq_T(Optional<T> X, Optional<U> Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> void $noteq_T(Optional<T> X, Optional<U> Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> void $less_T(Optional<T> X, Optional<U> Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> void $lesseq_T(Optional<T> X, Optional<U> Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> void $greatereq_T(Optional<T> X, Optional<U> Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T, U> void $greater_T(Optional<T> X, Optional<U> Y) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static MemoryBuffer unwrap(LLVMMemoryBufferRef P) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static LLVMMemoryBufferRef wrap(MemoryBuffer P) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> ArrayRef<T> makeArrayRef(T OneElt) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> ArrayRef<T> makeArrayRef(T data, int length) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> ArrayRef<T> makeArrayRef(type.ptr<T> data, int length) {
        return new ArrayRef<T>(data, length);
    }

    public static ArrayRefUInt makeArrayRef(uint.ptr begin, int length) {
        return new ArrayRefUInt(begin, length);
    }

    public static <T> ArrayRef<T> makeArrayRef(type.iterator<?, T> begin, type.iterator<?, T> end) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static ArrayRefUInt makeArrayRef(uint.ptr begin, uint.ptr end) {
        return new ArrayRefUInt(begin, end);
    }

    public static <T> ArrayRef<T> makeArrayRef(SmallVectorImpl<T> Vec) {
        return new ArrayRef<T>(Vec);
    }

    public static <T> ArrayRef<T> makeArrayRef(SmallVector<T> Vec, int N) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> ArrayRef<T> makeArrayRef(std.vector<T> Vec) {
        return new ArrayRef<T>(Vec);
    }

    public static <T> ArrayRef<T> makeArrayRef(T[] arr, int N) {
        return new ArrayRef<T>(arr, N);
    }

    public static ArrayRefUInt makeArrayRef(long[] arr, int N) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> boolean $eq_T(ArrayRef<T> LHS, ArrayRef<T> RHS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> boolean $noteq_T(ArrayRef<T> LHS, ArrayRef<T> RHS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <PT1, PT2> boolean $eq_T(PointerUnion<PT1, PT2> lhs, PointerUnion<PT1, PT2> rhs) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <PT1, PT2> boolean $noteq_T(PointerUnion<PT1, PT2> lhs, PointerUnion<PT1, PT2> rhs) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean $eq_uint64_t_APInt(long V1, APInt V2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean $noteq_uint64_t_APInt(long V1, APInt V2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static raw_ostream $out_raw_ostream_APInt(raw_ostream OS, APInt I) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> void deleter(T Ptr) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <_Iterator, Func> mapped_iterator<_Iterator, Func> $plus_T(int N, mapped_iterator<_Iterator, Func> X) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ItTy, FuncTy> mapped_iterator<ItTy, FuncTy> map_iterator(ItTy I, FuncTy F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ItTy, Dist> ItTy next(ItTy it, Dist n) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ItTy> ItTy next(ItTy it) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ItTy, Dist> ItTy prior(ItTy it, Dist n) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ItTy> ItTy prior(ItTy it) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T1, T2> tier<T1, T2> tie(type.ref<T1> f, type.ref<T2> s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static tier<StringRef, StringRef> tie(StringRef f, StringRef s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> tierTypeUInt<T> tie_T_uint(type.ref<T> f, uint.ref s) {
        return new tierTypeUInt<T>(f, s);
    }

    public static <T> type.ptr<T> array_endof(T[] x) {
        return NativePointer.create_type$ptr((Object[])x, (long)x.length);
    }

    public static int.ptr array_endof(int[] x) {
        return NativePointer.create_int$ptr((int[])x, (long)x.length);
    }

    public static int array_lengthof(Object[] arr) {
        return arr.length;
    }

    public static int array_lengthof(byte[] arr) {
        return arr.length;
    }

    public static int array_lengthof(boolean[] arr) {
        return arr.length;
    }

    public static int array_lengthof(CharSequence arr) {
        return arr.length();
    }

    public static <T> int array_pod_sort_comparator(T P1, T P2) {
        if (Native.$less(P1, P2)) {
            return -1;
        }
        if (Native.$less(P2, P1)) {
            return 1;
        }
        return 0;
    }

    public static <T> Comparator<T> get_array_pod_sort_comparator(T $Prm0) {
        return array_pod_sort_comparatorCallback;
    }

    public static <T> void array_pod_sort(type.ptr<T> Start, type.ptr<T> End) {
        if (Native.$eq(Start, End)) {
            return;
        }
        std.qsort(Start, (long)End.$sub(Start), (long)NativeType.sizeof((Object)Start.$star()), llvm.get_array_pod_sort_comparator(Start.$star()));
    }

    public static <T> void array_pod_sort(type.ptr<T> Start, type.ptr<T> End, Comparator<T> Compare2) {
        if (Native.$eq(Start, End)) {
            return;
        }
        std.qsort(Start, (long)End.$sub(Start), (long)NativeType.sizeof((Object)Start.$star()), Compare2);
    }

    public static <Container> void DeleteContainerPointers(Container C) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void DeleteContainerSeconds(DenseMapIntType<?> C) {
        DenseMapIteratorIntType I = C.begin();
        DenseMapIteratorIntType E = C.end();
        while (I.$noteq((Object)E)) {
            Native.destroy((Object)I.$star().second);
            I.$preInc();
        }
        C.clear();
    }

    public static void DeleteContainerSeconds(StringMap C) {
        StringMapIterator I = C.begin();
        StringMapIterator E = C.end();
        while (I.$noteq(E)) {
            Native.destroy(((StringMapEntry)I.$star()).second);
            I.$preInc();
        }
        C.clear();
    }

    public static byte hexdigit(long X) {
        return llvm.hexdigit(X, false);
    }

    public static byte hexdigit(long X, boolean LowerCase) {
        byte HexChar = (byte)(LowerCase ? 97 : 65);
        return (byte)(X < 10L ? 48L + X : (long)HexChar + X - 10L);
    }

    public static long hexDigitValue(byte C) {
        if (C >= NativePointer.$((char)'0') && C <= NativePointer.$((char)'9')) {
            return C - 48;
        }
        if (C >= NativePointer.$((char)'a') && C <= NativePointer.$((char)'f')) {
            return (long)(C - 97) + 10L;
        }
        if (C >= NativePointer.$((char)'A') && C <= NativePointer.$((char)'F')) {
            return (long)(C - 65) + 10L;
        }
        return -1L;
    }

    public static <IntTy> char.ptr utohex_buffer(IntTy X, char.ptr BufferEnd) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string utohexstr(long X) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string utostr_32(long X) {
        return llvm.utostr_32(X, false);
    }

    public static std.string utostr_32(long X, boolean isNeg) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string utostr(long X) {
        return llvm.utostr(X, false);
    }

    public static std.string utostr(long X, boolean isNeg) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.string itostr(long X) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long StrInStrNoCase(StringRef s1, StringRef s2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static std.pair<StringRef, StringRef> getToken(StringRef Source) {
        return llvm.getToken(Source, STRING_REF_DELIMETERS);
    }

    public static std.pair<StringRef, StringRef> getToken(StringRef Source, StringRef Delimiters) {
        int Start = Source.find_first_not_of(new StringRef(Delimiters));
        int End = Source.find_first_of(new StringRef(Delimiters), Start);
        return std.make_pair((Object)Source.slice(Start, End), (Object)Source.substr(End));
    }

    public static void SplitString(StringRef Source, SmallVectorImpl<StringRef> OutFragments) {
        llvm.SplitString(Source, OutFragments, STRING_REF_DELIMETERS);
    }

    public static void SplitString(StringRef Source, SmallVectorImpl<StringRef> OutFragments, StringRef Delimiters) {
        std.pair<StringRef, StringRef> S = llvm.getToken(new StringRef(Source), new StringRef(Delimiters));
        while (!((StringRef)S.first).empty()) {
            OutFragments.push_back((StringRef)S.first);
            S.$assign(llvm.getToken(new StringRef((StringRef)S.second), new StringRef(Delimiters)));
        }
    }

    public static int HashString(StringRef Str) {
        return llvm.HashString(Str, 0);
    }

    public static int HashString(StringRef Str, int Result) {
        int e = Str.size();
        for (int i = 0; i != e; ++i) {
            Result = Result * 33 + Str.$at(i);
        }
        return Result;
    }

    public static int HashString(char.ptr Str, int KeyLen) {
        return llvm.HashString(Str, KeyLen, 0);
    }

    public static int HashString(char.ptr Str, int KeyLen, int Result) {
        int e = KeyLen;
        for (int i = 0; i != e; ++i) {
            Result = Result * 33 + Str.$at(i);
        }
        return Result;
    }

    public static int HashString(byte[] Str, int fromIdx, int KeyLen) {
        int Result = 0;
        int e = fromIdx + KeyLen;
        for (int i = fromIdx; i != e; ++i) {
            Result = Result * 33 + Str[i];
        }
        return Result;
    }

    public static StringRef getOrdinalSuffix(long Val) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <IteratorT> std.string join_impl(IteratorT Begin, IteratorT End, StringRef Separator, std.input_iterator_tag $Prm3) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <IteratorT> std.string join_impl(IteratorT Begin, IteratorT End, StringRef Separator, std.forward_iterator_tag $Prm3) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <IteratorT> std.string join(IteratorT Begin, IteratorT End, StringRef Separator) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> format_object1<T> format(CharSequence Fmt, T Val) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T> format_object1<T> format(char.ptr Fmt, T Val) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T1, T2> format_object2<T1, T2> format(CharSequence Fmt, T1 Val1, T2 Val2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T1, T2, T3> format_object3<T1, T2, T3> format(CharSequence Fmt, T1 Val1, T2 Val2, T3 Val3) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T1, T2, T3, T4> format_object4<T1, T2, T3, T4> format(CharSequence Fmt, T1 Val1, T2 Val2, T3 Val3, T4 Val4) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T1, T2, T3, T4, T5> format_object5<T1, T2, T3, T4, T5> format(CharSequence Fmt, T1 Val1, T2 Val2, T3 Val3, T4 Val4, T5 Val5) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean $eq_int64_t_APSInt(long V1, APSInt V2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean $noteq_int64_t_APSInt(long V1, APSInt V2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static raw_ostream $out_raw_ostream_APSInt(raw_ostream OS, APSInt I) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean llvm_start_multithreaded() {
        assert (!ThreadingStatics.multithreaded_mode) : "Already multithreaded!";
        ThreadingStatics.multithreaded_mode = true;
        ThreadingStatics.global_lock = new sys.Mutex(true);
        sys.MemoryFence();
        return true;
    }

    public static void llvm_stop_multithreaded() {
        assert (ThreadingStatics.multithreaded_mode) : "Not currently multithreaded!";
        sys.MemoryFence();
        ThreadingStatics.multithreaded_mode = false;
        if (ThreadingStatics.global_lock != null) {
            ThreadingStatics.global_lock.$destroy();
        }
    }

    public static boolean llvm_is_multithreaded() {
        return ThreadingStatics.multithreaded_mode;
    }

    public static void llvm_acquire_global_lock() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void llvm_release_global_lock() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void llvm_execute_on_thread(ADTFunctionPointers.onePtr UserFn, void.ptr UserData) {
        llvm.llvm_execute_on_thread(UserFn, UserData, 0);
    }

    public static void llvm_execute_on_thread(ADTFunctionPointers.onePtr UserFn, void.ptr UserData, int RequestedStackSize) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <T extends NativeType.SizeofCapable> long capacity_in_bytes(T X) {
        return X.$sizeof();
    }

    public static boolean ConvertUTF8toWide(long WideCharWidth, StringRef Source, type.ref<char.ptr> ResultPtr, type.ref<char.ptr> ErrorPtr) {
        assert (WideCharWidth == 1L || WideCharWidth == 2L || WideCharWidth == 4L);
        ConvertUTFGlobals.ConversionResult result = ConvertUTFGlobals.ConversionResult.conversionOK;
        if (WideCharWidth == 1L) {
            char.ptr Pos = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)Source.begin())));
            if (ConvertUTFGlobals.isLegalUTF8String((type.ptr<char.ptr>)Pos.$addr(), (char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)Source.end())) == 0) {
                result = ConvertUTFGlobals.ConversionResult.sourceIllegal;
                ErrorPtr.$set((Object)Pos);
            } else {
                std.memcpy((char.ptr)((char.ptr)ResultPtr.$deref()), (char.ptr)Source.data(), (int)Source.size());
                ((char.ptr)ResultPtr.$deref()).$inc(Source.size());
            }
        } else if (WideCharWidth == 2L) {
            char.ptr sourceStart = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)Source.data())));
            ushort.ptr targetStart = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)((void.ptr)ResultPtr.$deref()))));
            ConvertUTFGlobals.ConversionFlags flags = ConvertUTFGlobals.ConversionFlags.strictConversion;
            result = ConvertUTFGlobals.ConvertUTF8toUTF16((type.ptr<char.ptr>)sourceStart.$addr(), (char.ptr)sourceStart.$add(Source.size()), (type.ptr<ushort.ptr>)targetStart.$addr(), (ushort.ptr)targetStart.$add(2 * Source.size()), flags);
            if (result == ConvertUTFGlobals.ConversionResult.conversionOK) {
                ResultPtr.$set(Casts.reinterpret_cast(char.ptr.class, (void.ptr)targetStart));
            } else {
                ErrorPtr.$set((Object)sourceStart);
            }
        } else if (WideCharWidth == 4L) {
            char.ptr sourceStart = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)Source.data())));
            uint.ptr targetStart = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)((void.ptr)ResultPtr.$deref()))));
            ConvertUTFGlobals.ConversionFlags flags = ConvertUTFGlobals.ConversionFlags.strictConversion;
            result = ConvertUTFGlobals.ConvertUTF8toUTF32((type.ptr<char.ptr>)sourceStart.$addr(), (char.ptr)sourceStart.$add(Source.size()), (type.ptr<uint.ptr>)targetStart.$addr(), (uint.ptr)targetStart.$add(4 * Source.size()), flags);
            if (result == ConvertUTFGlobals.ConversionResult.conversionOK) {
                ResultPtr.$set(Casts.reinterpret_cast(char.ptr.class, (void.ptr)targetStart));
            } else {
                ErrorPtr.$set((Object)sourceStart);
            }
        }
        assert (result != ConvertUTFGlobals.ConversionResult.targetExhausted) : "ConvertUTF8toUTFXX exhausted target buffer";
        return result == ConvertUTFGlobals.ConversionResult.conversionOK;
    }

    public static boolean ConvertCodePointToUTF8(long Source, type.ref<char.ptr> ResultPtr) {
        uint.ptr SourceStart = NativePointer.create_uint$ptr((long[])NativePointer.new$uint$elem((long)Source));
        uint.ptr SourceEnd = (uint.ptr)Native.$tryClone((NativeCloneable)SourceStart.$add(1));
        char.ptr TargetStart = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)ResultPtr.$deref()))));
        char.ptr TargetEnd = Native.$tryClone((char.ptr)((char.ptr)TargetStart.$add(4)));
        ConvertUTFGlobals.ConversionResult CR = ConvertUTFGlobals.ConvertUTF32toUTF8((type.ptr<uint.ptr>)SourceStart.$addr(), SourceEnd, (type.ptr<char.ptr>)TargetStart.$addr(), TargetEnd, ConvertUTFGlobals.ConversionFlags.strictConversion);
        if (CR != ConvertUTFGlobals.ConversionResult.conversionOK) {
            return false;
        }
        ResultPtr.$set(Casts.reinterpret_cast(char.ptr.class, (void.ptr)TargetStart));
        return true;
    }

    public static ConvertUTFGlobals.ConversionResult convertUTF8Sequence(type.ptr<char.ptr> source, char.ptr sourceEnd, long[] CodePoint, ConvertUTFGlobals.ConversionFlags flags) {
        if (((char.ptr)source.$star()).$eq((Object)sourceEnd)) {
            return ConvertUTFGlobals.ConversionResult.sourceExhausted;
        }
        long size = ConvertUTFGlobals.getNumBytesForUTF8(((char.ptr)source.$star()).$star());
        if (size > (long)sourceEnd.$sub((abstract_iterator)source.$star())) {
            return ConvertUTFGlobals.ConversionResult.sourceExhausted;
        }
        uint.ptr target = NativePointer.create_uint$ptr((long[])CodePoint);
        return ConvertUTFGlobals.ConvertUTF8toUTF32(source, (char.ptr)((char.ptr)source.$star()).$add(size), (type.ptr<uint.ptr>)target.$addr(), (uint.ptr)target.$add(1), flags);
    }

    public static boolean hasUTF16ByteOrderMark(ArrayRefChar SrcBytes) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean convertUTF16ToUTF8String(ArrayRefChar SrcBytes, std.string Out) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void EnablePrettyStackTrace() {
        boolean dummyFieldHandlerRegisteredAccess = EnablePrettyStackTraceHolder.HandlerRegistered;
    }

    public static int ComputeEditDistance(ArrayRefChar FromArray, ArrayRefChar ToArray) {
        return llvm.ComputeEditDistance(FromArray, ToArray, true, 0);
    }

    public static int ComputeEditDistance(ArrayRefChar FromArray, ArrayRefChar ToArray, boolean AllowReplacements) {
        return llvm.ComputeEditDistance(FromArray, ToArray, AllowReplacements, 0);
    }

    public static int ComputeEditDistance(ArrayRefChar FromArray, ArrayRefChar ToArray, boolean AllowReplacements, int MaxEditDistance) {
        int.ptr Previous;
        int m = FromArray.size();
        int n = ToArray.size();
        if (2 * (n + 1) > 64) {
            Previous = NativePointer.create_int$ptr((int[])NativePointer.new$int((int)(2 * (n + 1))));
        } else {
            int[] SmallBuffer = NativePointer.new$int((int)64);
            Previous = NativePointer.create_int$ptr((int[])SmallBuffer);
        }
        int.ptr Current = (int.ptr)Previous.$add(n + 1);
        for (int i = 0; i <= n; ++i) {
            Previous.$set(i, i);
        }
        for (int y = 1; y <= m; ++y) {
            Current.$set(0, y);
            int BestThisRow = Current.$at(0);
            for (int x = 1; x <= n; ++x) {
                if (AllowReplacements) {
                    Current.$set(x, std.min((int)(Previous.$at(x - 1) + (FromArray.$at(y - 1) == ToArray.$at(x - 1) ? 0 : 1)), (int)(std.min((int)Current.$at(x - 1), (int)Previous.$at(x)) + 1)));
                } else if (FromArray.$at(y - 1) == ToArray.$at(x - 1)) {
                    Current.$set(x, Previous.$at(x - 1));
                } else {
                    Current.$set(x, std.min((int)Current.$at(x - 1), (int)Previous.$at(x)) + 1);
                }
                BestThisRow = std.min((int)BestThisRow, (int)Current.$at(x));
            }
            if (MaxEditDistance != 0 && BestThisRow > MaxEditDistance) {
                return MaxEditDistance + 1;
            }
            int tmp = Current.$index();
            Native.$setIndex((int.ptr)Current, (int)Previous.$index());
            Native.$setIndex((int.ptr)Previous, (int)tmp);
        }
        int Result = Previous.$at(n);
        return Result;
    }

    public static void InitializeAllTargetInfos() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static <Iter extends type.iterator<Iter, Type>, Type> iterator_range<Iter, Type> make_range(Iter x, Iter y) {
        return Iterator_rangeLlvmGlobals.make_range(x, y);
    }

    public static <Iter extends type.iterator<Iter, Type>, Type> iterator_range<Iter, Type> make_range(std.pair<Iter, Iter> p) {
        return Iterator_rangeLlvmGlobals.make_range(p);
    }

    public static void InitializeAllTargets() {
        llvm.errs().$out("InitializeAllTargets is not yet implemented\n");
    }

    public static void InitializeAllTargetMCs() {
        llvm.errs().$out("InitializeAllTargetMCs is not yet implemented\n");
    }

    public static void InitializeAllAsmPrinters() {
        llvm.errs().$out("InitializeAllAsmPrinters is not yet implemented\n");
    }

    public static void InitializeAllAsmParsers() {
        llvm.errs().$out("InitializeAllAsmParsers is not yet implemented\n");
    }

    public static void EnableStatistics() {
        StatisticStatics.Enabled.setValue(true);
    }

    public static boolean AreStatisticsEnabled() {
        return StatisticStatics.Enabled.$boolean();
    }

    public static void PrintStatistics() {
        StatisticInfo Stats = StatisticStatics.StatInfo.$star();
        if (Stats.Stats.empty()) {
            return;
        }
        raw_ostream OutStream = LlvmStatics.CreateInfoOutputFile();
        llvm.PrintStatistics(OutStream);
        if (OutStream != null) {
            OutStream.$destroy();
        }
    }

    public static void PrintStatistics(raw_ostream OS) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void llvm_shutdown() {
        while (ManagedStaticStatics.StaticList != null) {
            ManagedStaticStatics.StaticList.destroy();
        }
        ManagedStaticStatics.StaticList = null;
        if (llvm.llvm_is_multithreaded()) {
            llvm.llvm_stop_multithreaded();
        }
    }

    public static void install_fatal_error_handler(ADTFunctionPointers.fatal_error_handler_t handler) {
        ErrorHandlingLlvmGlobals.install_fatal_error_handler(handler);
    }

    public static void install_fatal_error_handler(ADTFunctionPointers.fatal_error_handler_t handler, Object user_data) {
        ErrorHandlingLlvmGlobals.install_fatal_error_handler(handler, user_data);
    }

    public static void remove_fatal_error_handler() {
        ErrorHandlingLlvmGlobals.remove_fatal_error_handler();
    }

    public static void report_fatal_error(char.ptr Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason);
    }

    public static void report_fatal_error(char.ptr Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, GenCrashDiag);
    }

    public static void report_fatal_error(CharSequence Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(NativePointer.create_char$ptr((CharSequence)Reason));
    }

    public static void report_fatal_error(std.string Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason);
    }

    public static void report_fatal_error(std.string Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, GenCrashDiag);
    }

    public static void report_fatal_error(StringRef Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason);
    }

    public static void report_fatal_error(StringRef Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, GenCrashDiag);
    }

    public static void report_fatal_error(Twine Reason) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason);
    }

    public static void report_fatal_error(Twine Reason, boolean GenCrashDiag) {
        ErrorHandlingLlvmGlobals.report_fatal_error(Reason, GenCrashDiag);
    }

    public static void llvm_unreachable_internal() {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal();
    }

    public static void llvm_unreachable_internal(char.ptr msg) {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal(msg);
    }

    public static void llvm_unreachable_internal(char.ptr msg, char.ptr file) {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal(msg, file);
    }

    public static void llvm_unreachable_internal(char.ptr msg, char.ptr file, long line) {
        ErrorHandlingLlvmGlobals.llvm_unreachable_internal(msg, file, line);
    }

    public static void llvm_unreachable_internal(CharSequence msg, CharSequence file, long line) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void llvm_unreachable_internal(String msg) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static final class support {
        public static final int aligned = 0;
        public static final int unaligned = 1;

        public final class unaligned_int64_t
        extends detail.packed_endian_specific_integral<Long> {
            public unaligned_int64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.__native, 1L);
            }
        }

        public final class unaligned_int32_t
        extends detail.packed_endian_specific_integral<Integer> {
            public unaligned_int32_t(char.ptr buffer) {
                super(buffer, Integer.class, endianness.__native, 1L);
            }
        }

        public final class unaligned_int16_t
        extends detail.packed_endian_specific_integral<Short> {
            public unaligned_int16_t(char.ptr buffer) {
                super(buffer, Short.class, endianness.__native, 1L);
            }
        }

        public final class unaligned_uint64_t
        extends detail.packed_endian_specific_integral<Long> {
            public unaligned_uint64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.__native, 1L);
            }
        }

        public final class unaligned_uint32_t
        extends detail.packed_endian_specific_integral<Long> {
            public unaligned_uint32_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.__native, 1L);
            }
        }

        public final class unaligned_uint16_t
        extends detail.packed_endian_specific_integral<Character> {
            public unaligned_uint16_t(char.ptr buffer) {
                super(buffer, Character.class, endianness.__native, 1L);
            }
        }

        public final class aligned_big64_t
        extends detail.packed_endian_specific_integral<Long> {
            public aligned_big64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.big, 0L);
            }
        }

        public final class aligned_big32_t
        extends detail.packed_endian_specific_integral<Integer> {
            public aligned_big32_t(char.ptr buffer) {
                super(buffer, Integer.class, endianness.big, 0L);
            }
        }

        public final class aligned_big16_t
        extends detail.packed_endian_specific_integral<Short> {
            public aligned_big16_t(char.ptr buffer) {
                super(buffer, Short.class, endianness.big, 0L);
            }
        }

        public final class aligned_big8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public aligned_big8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.big, 0L);
            }
        }

        public final class aligned_ubig64_t
        extends detail.packed_endian_specific_integral<Long> {
            public aligned_ubig64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.big, 0L);
            }
        }

        public final class aligned_ubig32_t
        extends detail.packed_endian_specific_integral<Long> {
            public aligned_ubig32_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.big, 0L);
            }
        }

        public final class aligned_ubig16_t
        extends detail.packed_endian_specific_integral<Character> {
            public aligned_ubig16_t(char.ptr buffer) {
                super(buffer, Character.class, endianness.big, 0L);
            }
        }

        public final class aligned_ubig8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public aligned_ubig8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.big, 0L);
            }
        }

        public final class big64_t
        extends detail.packed_endian_specific_integral<Long> {
            public big64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.big, 1L);
            }
        }

        public final class big32_t
        extends detail.packed_endian_specific_integral<Integer> {
            public big32_t(char.ptr buffer) {
                super(buffer, Integer.class, endianness.big, 1L);
            }
        }

        public final class big16_t
        extends detail.packed_endian_specific_integral<Short> {
            public big16_t(char.ptr buffer) {
                super(buffer, Short.class, endianness.big, 1L);
            }
        }

        public final class big8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public big8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.big, 1L);
            }
        }

        public final class ubig64_t
        extends detail.packed_endian_specific_integral<Long> {
            public ubig64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.big, 1L);
            }
        }

        public final class ubig32_t
        extends detail.packed_endian_specific_integral<Long> {
            public ubig32_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.big, 1L);
            }
        }

        public final class ubig16_t
        extends detail.packed_endian_specific_integral<Character> {
            public ubig16_t(char.ptr buffer) {
                super(buffer, Character.class, endianness.big, 1L);
            }
        }

        public final class ubig8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public ubig8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.big, 1L);
            }
        }

        public final class aligned_little64_t
        extends detail.packed_endian_specific_integral<Long> {
            public aligned_little64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.little, 0L);
            }
        }

        public final class aligned_little32_t
        extends detail.packed_endian_specific_integral<Integer> {
            public aligned_little32_t(char.ptr buffer) {
                super(buffer, Integer.class, endianness.little, 0L);
            }
        }

        public final class aligned_little16_t
        extends detail.packed_endian_specific_integral<Short> {
            public aligned_little16_t(char.ptr buffer) {
                super(buffer, Short.class, endianness.little, 0L);
            }
        }

        public final class aligned_little8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public aligned_little8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.little, 0L);
            }
        }

        public final class aligned_ulittle64_t
        extends detail.packed_endian_specific_integral<Long> {
            public aligned_ulittle64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.little, 0L);
            }
        }

        public final class aligned_ulittle32_t
        extends detail.packed_endian_specific_integral<Long> {
            public aligned_ulittle32_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.little, 0L);
            }
        }

        public final class aligned_ulittle16_t
        extends detail.packed_endian_specific_integral<Character> {
            public aligned_ulittle16_t(char.ptr buffer) {
                super(buffer, Character.class, endianness.little, 0L);
            }
        }

        public final class aligned_ulittle8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public aligned_ulittle8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.little, 0L);
            }
        }

        public final class little64_t
        extends detail.packed_endian_specific_integral<Long> {
            public little64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.little, 1L);
            }
        }

        public final class little32_t
        extends detail.packed_endian_specific_integral<Integer> {
            public little32_t(char.ptr buffer) {
                super(buffer, Integer.class, endianness.little, 1L);
            }
        }

        public final class little16_t
        extends detail.packed_endian_specific_integral<Short> {
            public little16_t(char.ptr buffer) {
                super(buffer, Short.class, endianness.little, 1L);
            }
        }

        public final class little8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public little8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.little, 1L);
            }
        }

        public final class ulittle64_t
        extends detail.packed_endian_specific_integral<Long> {
            public ulittle64_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.little, 1L);
            }
        }

        public static final class ulittle32_t
        extends detail.packed_endian_specific_integral<Long> {
            public ulittle32_t(char.ptr buffer) {
                super(buffer, Long.class, endianness.little, 1L);
            }
        }

        public static final class ulittle16_t
        extends detail.packed_endian_specific_integral<Character> {
            public ulittle16_t(char.ptr buffer) {
                super(buffer, Character.class, endianness.little, 1L);
            }
        }

        public static final class ulittle8_t
        extends detail.packed_endian_specific_integral<Byte> {
            public ulittle8_t(char.ptr buffer) {
                super(buffer, Byte.class, endianness.little, 1L);
            }
        }

        public static final class endian {
            public static <value_type> value_type byte_swap(value_type value, endianness endian2) {
                if (endian2 != endianness.__native && sys.IsBigEndianHost != (endian2 == endianness.big)) {
                    return sys.SwapByteOrder(value);
                }
                return value;
            }

            public static <value_type> value_type read(char.ptr memory, Class<value_type> Type2, endianness endian2, long alignment) {
                return EndianGlobals.read(memory, Type2, endian2, alignment);
            }

            public static <value_type> value_type readNext(uchar.ptr memory, Class<value_type> Type2, endianness endian2, long alignment) {
                return EndianGlobals.readNext(memory, Type2, endian2, alignment);
            }

            public static <value_type> void write(char.ptr memory, value_type value, Class<value_type> Type2, endianness endian2, long alignment) {
                EndianGlobals.write(memory, value, Type2, endian2, alignment);
            }
        }

        public static final class detail {
            public static void printBumpPtrAllocatorStats(long NumSlabs, long BytesAllocated, long TotalMemory) {
                detail.printBumpPtrAllocatorStats(llvm.errs(), NumSlabs, BytesAllocated, TotalMemory, 0L, 0L);
            }

            public static void printBumpPtrAllocatorStats(raw_ostream OS, long NumSlabs, long BytesAllocated, long TotalMemory, long SizeThreshold, long SlabSize) {
                OS.$out("\nNumber of memory regions: ").$out(NativeTrace.formatNumber((long)NumSlabs)).$out_char(NativePointer.$((char)'\n')).$out("Bytes      used: ").$out(NativeTrace.formatNumber((long)BytesAllocated)).$out_char(NativePointer.$((char)'\n')).$out("Bytes allocated: ").$out(NativeTrace.formatNumber((long)TotalMemory)).$out_char(NativePointer.$((char)'\n')).$out("Bytes    wasted: ").$out(NativeTrace.formatNumber((long)(TotalMemory - BytesAllocated))).$out(" (includes alignment, etc)\n");
                if (SizeThreshold > 0L) {
                    OS.$out("SizeThreashold : ").$out(NativeTrace.formatNumber((long)SizeThreshold)).$out('\n').$out("SlabSize       : ").$out(NativeTrace.formatNumber((long)SlabSize)).$out('\n');
                }
            }

            public static class packed_endian_specific_integral<value_type> {
                private final char.ptr Buffer;
                private final Class<value_type> Type;
                private final endianness endian;
                long alignment;

                public packed_endian_specific_integral(char.ptr Buffer, Class<value_type> Type2, endianness endian2, long alignment) {
                    this.Buffer = Buffer;
                    this.Type = Type2;
                    this.endian = endian2;
                    this.alignment = alignment;
                }

                public value_type $value() {
                    return org.llvm.support.llvm$support$endian.read(this.Buffer, this.Type, this.endian, this.alignment);
                }

                public void $assign(value_type newValue) {
                    org.llvm.support.llvm$support$endian.write(this.Buffer, newValue, this.Type, this.endian, this.alignment);
                }
            }
        }

        public static final class endianness
        extends Enum<endianness> {
            public static final /* enum */ endianness big = new endianness(0L);
            public static final /* enum */ endianness little = new endianness(1L);
            public static final /* enum */ endianness __native = new endianness(2L);
            private final int value;
            private static final /* synthetic */ endianness[] $VALUES;

            public static endianness[] values() {
                return (endianness[])$VALUES.clone();
            }

            public static endianness valueOf(String name) {
                return Enum.valueOf(endianness.class, name);
            }

            public static endianness valueOf(int val) {
                endianness out;
                endianness endianness2 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
                assert (out != null) : "no value for " + val;
                return out;
            }

            private endianness(long val) {
                this.value = (int)val;
            }

            public int getValue() {
                return this.value;
            }

            static {
                $VALUES = new endianness[]{big, little, __native};
            }

            private static final class Values {
                private static final endianness[] VALUES;
                private static final endianness[] _VALUES;

                private Values() {
                }

                static {
                    int max = 0;
                    int min = 0;
                    for (endianness kind : endianness.values()) {
                        if (kind.value > max) {
                            max = kind.value;
                        }
                        if (kind.value >= min) continue;
                        min = kind.value;
                    }
                    _VALUES = new endianness[min < 0 ? 1 - min : 0];
                    VALUES = new endianness[max >= 0 ? 1 + max : 0];
                    for (endianness kind : endianness.values()) {
                        if (kind.value < 0) {
                            Values._VALUES[-((endianness)kind).value] = kind;
                            continue;
                        }
                        Values.VALUES[((endianness)kind).value] = kind;
                    }
                }
            }
        }
    }

    public static class llvm_shutdown_obj
    implements Destructors.ClassWithDestructor {
        public llvm_shutdown_obj() {
        }

        public llvm_shutdown_obj(boolean multithreaded) {
            if (multithreaded) {
                llvm.llvm_start_multithreaded();
            }
        }

        public void $destroy() {
            llvm.llvm_shutdown();
        }
    }

    private static final class EnablePrettyStackTraceHolder {
        private static final boolean HandlerRegistered = PrettyStackTraceStatics.RegisterCrashPrinter();

        private EnablePrettyStackTraceHolder() {
        }
    }

    public static class ScopedFatalErrorHandler
    implements Destructors.ClassWithDestructor {
        public ScopedFatalErrorHandler(ADTFunctionPointers.fatal_error_handler_t handler) {
            this(handler, null);
        }

        public ScopedFatalErrorHandler(ADTFunctionPointers.fatal_error_handler_t handler, Object user_data) {
            llvm.install_fatal_error_handler(handler, user_data);
        }

        public void $destroy() {
            llvm.remove_fatal_error_handler();
        }
    }
}

