/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SpringXMLConfigEditorUtils {
    private static final Logger LOGGER = Logger.getLogger(SpringXMLConfigEditorUtils.class.getName());
    public static final String BEAN_NAME_DELIMITERS = ",; ";

    private SpringXMLConfigEditorUtils() {
    }

    public static String getPNamespacePrefix(Document document, int offset) {
        DocumentContext context = DocumentContext.create(document, offset);
        if (context == null) {
            return null;
        }
        return context.getNamespacePrefix("http://www.springframework.org/schema/p");
    }

    public static Map<String, String> getTagAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attribs = new HashMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribNode = namedNodeMap.item(i);
            attribs.put(attribNode.getNodeName(), attribNode.getNodeValue());
        }
        return Collections.unmodifiableMap(attribs);
    }

    public static String getBeanPropertySetterName(String property) {
        char[] buffer = property.toCharArray();
        buffer[0] = Character.toUpperCase(buffer[0]);
        return "set" + String.valueOf(buffer);
    }

    public static String getBeanFactoryMethod(Tag tag) {
        NamedNodeMap attribs;
        Node bean = SpringXMLConfigEditorUtils.getBean((Node)tag);
        if (bean != null && (attribs = bean.getAttributes()) != null && attribs.getNamedItem("factory-method") != null) {
            return attribs.getNamedItem("factory-method").getNodeValue();
        }
        return null;
    }

    public static Node getBean(Node tag) {
        if (tag == null) {
            return null;
        }
        if (tag.getNodeName().equals("bean")) {
            return tag;
        }
        if (tag.getNodeName().equals("lookup-method") || tag.getNodeName().equals("replaced-method") || tag.getNodeName().equals("property")) {
            Node parent = tag.getParentNode();
            if (parent != null && parent.getNodeName() != null && parent.getNodeName().equals("bean")) {
                return parent;
            }
            return null;
        }
        return null;
    }

    public static String getBeanClassName(Node tag) {
        NamedNodeMap attribs;
        Node bean = SpringXMLConfigEditorUtils.getBean(tag);
        if (bean != null && (attribs = bean.getAttributes()) != null && attribs.getNamedItem("class") != null) {
            return attribs.getNamedItem("class").getNodeValue();
        }
        return null;
    }

    public static final Tag getDocumentRoot(Document doc) {
        Tag retTag = null;
        XMLSyntaxSupport syntaxSupport = null;
        try {
            syntaxSupport = (XMLSyntaxSupport)((BaseDocument)doc).getSyntaxSupport();
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.FINE, cce.getMessage());
            syntaxSupport = new XMLSyntaxSupport((BaseDocument)doc);
        }
        if (syntaxSupport == null) {
            return retTag;
        }
        try {
            TokenItem tok = syntaxSupport.getTokenChain(0, 1);
            if (tok != null) {
                Tag tag;
                TokenItem prevTok = null;
                while (!ContextUtilities.isTagToken(tok) && tok != prevTok) {
                    prevTok = tok;
                    if (tok.getNext() == null) continue;
                    tok = tok.getNext();
                }
                SyntaxElement element = syntaxSupport.getElementChain(tok.getOffset() + tok.getImage().length());
                if ((element instanceof StartTag || element instanceof EmptyTag) && (tag = (Tag)element).getParentNode() instanceof org.w3c.dom.Document) {
                    return tag;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return retTag;
    }

    public static final boolean hasAttribute(Node node, String attributeName) {
        return node != null && node.getAttributes() != null && node.getAttributes().getNamedItem(attributeName) != null;
    }

    public static final String getAttribute(Node node, String attributeName) {
        if (SpringXMLConfigEditorUtils.hasAttribute(node, attributeName)) {
            return node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        return null;
    }

    public static boolean openFile(File file, int offset) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            return SpringXMLConfigEditorUtils.openFile(fo, offset);
        }
        return false;
    }

    public static boolean openFile(FileObject fo, int offset) {
        DataObject dataObject;
        boolean opened = false;
        try {
            dataObject = DataObject.find((FileObject)fo);
            if (offset > 0) {
                opened = SpringXMLConfigEditorUtils.openFileAtOffset(dataObject, offset);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
        if (opened) {
            return true;
        }
        OpenCookie oc = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (oc != null) {
            oc.open();
            return true;
        }
        return false;
    }

    private static boolean openFileAtOffset(DataObject dataObject, int offset) throws IOException {
        Line line;
        int lineNumber;
        StyledDocument doc;
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (ec != null && lc != null && (doc = ec.openDocument()) != null && (lineNumber = NbDocument.findLineNumber((StyledDocument)doc, (int)offset)) != -1 && (line = lc.getLineSet().getCurrent(lineNumber)) != null) {
            int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNumber);
            int column = offset - lineOffset;
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
            return true;
        }
        return false;
    }

    public static SpringBean getMergedBean(SpringBean origBean, FileObject fileObject) {
        if (origBean == null) {
            return null;
        }
        if (origBean.getParent() == null) {
            return origBean;
        }
        ModelBasedSpringBean logicalBean = new ModelBasedSpringBean(origBean, fileObject);
        return SpringXMLConfigEditorUtils.getMergedBean(logicalBean, fileObject);
    }

    public static SpringBean getMergedBean(Map<String, String> beanAttribs, FileObject fileObject) {
        NodeBasedSpringBean logicalBean = new NodeBasedSpringBean(beanAttribs);
        if (!StringUtils.hasText(logicalBean.getParent())) {
            return logicalBean;
        }
        SpringBean mergedBean = SpringXMLConfigEditorUtils.getMergedBean(logicalBean, fileObject);
        return mergedBean != null ? mergedBean : logicalBean;
    }

    private static SpringBean getMergedBean(MutableSpringBean startBean, FileObject fileObject) {
        final MutableSpringBean[] logicalBean = new MutableSpringBean[]{startBean};
        SpringConfigModel model = SpringConfigModel.forFileObject(fileObject);
        if (model == null) {
            return null;
        }
        try {
            model.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans springBeans) {
                    String currParent = logicalBean[0].getParent();
                    HashSet<SpringBean> walkedBeans = new HashSet<SpringBean>();
                    while (currParent != null && (logicalBean[0].getClassName() == null || logicalBean[0].getFactoryBean() == null || logicalBean[0].getFactoryMethod() == null)) {
                        SpringBean currBean = springBeans.findBean(currParent);
                        if (currBean == null || walkedBeans.contains(currBean)) {
                            logicalBean[0] = null;
                            break;
                        }
                        if (logicalBean[0].getClassName() == null) {
                            logicalBean[0].setClassName(currBean.getClassName());
                        }
                        if (logicalBean[0].getFactoryBean() == null) {
                            logicalBean[0].setFactoryBean(currBean.getFactoryBean());
                        }
                        if (logicalBean[0].getFactoryMethod() == null) {
                            logicalBean[0].setFactoryMethod(currBean.getFactoryMethod());
                        }
                        walkedBeans.add(currBean);
                        currParent = currBean.getParent();
                    }
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            logicalBean[0] = null;
        }
        return logicalBean[0];
    }

    private static class NodeBasedSpringBean
    implements MutableSpringBean {
        private String className;
        private String factoryBean;
        private String factoryMethod;
        private String parent;
        private String id;
        private List<String> names;

        public NodeBasedSpringBean(Map<String, String> beanAttribs) {
            this.className = beanAttribs.get("class");
            this.factoryBean = beanAttribs.get("factory-bean");
            this.factoryMethod = beanAttribs.get("factory-method");
            this.parent = beanAttribs.get("parent");
            this.id = beanAttribs.get("id");
            if (beanAttribs.get("name") == null) {
                this.names = Collections.emptyList();
            }
            this.names = StringUtils.tokenize(beanAttribs.get("name"), SpringXMLConfigEditorUtils.BEAN_NAME_DELIMITERS);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public String getFactoryBean() {
            return this.factoryBean;
        }

        @Override
        public void setFactoryBean(String factoryBean) {
            this.factoryBean = factoryBean;
        }

        @Override
        public String getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public void setFactoryMethod(String factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        @Override
        public Location getLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<SpringBeanProperty> getProperties() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ModelBasedSpringBean
    implements MutableSpringBean {
        private String className;
        private String factoryBean;
        private String factoryMethod;
        private String parent;
        private String id;
        private List<String> names;
        private Location location;

        public ModelBasedSpringBean(SpringBean springBean, FileObject fileObject) {
            this.className = springBean.getClassName();
            this.factoryBean = springBean.getFactoryBean();
            this.factoryMethod = springBean.getFactoryMethod();
            this.parent = springBean.getParent();
            this.id = springBean.getId();
            this.location = springBean.getLocation();
            this.names = springBean.getNames();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public String getFactoryBean() {
            return this.factoryBean;
        }

        @Override
        public void setFactoryBean(String factoryBean) {
            this.factoryBean = factoryBean;
        }

        @Override
        public String getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public void setFactoryMethod(String factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public Set<SpringBeanProperty> getProperties() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static interface MutableSpringBean
    extends SpringBean {
        public void setClassName(String var1);

        public void setFactoryBean(String var1);

        public void setFactoryMethod(String var1);
    }
}

