/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.EntityModelDetector;

public class ShadowedIdentifierDetector
extends EntityModelDetector {
    @Override
    public String getName() {
        return "shadow-id";
    }

    @Override
    public void visitProperty(Configuration configuration, PersistentClass clazz, Property property, IssueCollector collector) {
        if (property.getName().equals("id") && property != property.getPersistentClass().getIdentifierProperty()) {
            collector.reportIssue(new Issue("ID_SHADOWED", 0, property.getPersistentClass().getEntityName() + " has a normal property named 'id'. This can cause issues since HQL queries will always interpret 'id' as the identifier and not the concrete property"));
        }
    }
}

