/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootsToFile {
    private final Map<File, File> files = new LinkedHashMap<File, File>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, File> eldest) {
            return this.size() > 1500;
        }
    };
    private long cachedAccesCount = 0L;
    private long accesCount = 0L;
    private final int statisticsFrequency;
    private final Callback callback;
    private final Logger log;

    public RootsToFile(Callback callback, Logger log, int statisticsFrequency) {
        this.statisticsFrequency = statisticsFrequency;
        this.callback = callback;
        this.log = log;
    }

    synchronized void put(Collection<File> files, File root) {
        for (File file : files) {
            this.put(file, root);
        }
    }

    synchronized void put(File file, File root) {
        this.files.put(file, root);
    }

    synchronized File get(File file) {
        return this.get(file, false);
    }

    synchronized File get(File file, boolean statistics) {
        File root = this.files.get(file);
        if (statistics && this.log.isLoggable(Level.FINEST)) {
            this.cachedAccesCount += root != null ? 1L : 0L;
            ++this.accesCount;
        }
        return root;
    }

    synchronized int size() {
        return this.files.size();
    }

    synchronized void logStatistics() {
        if (!this.log.isLoggable(Level.FINEST) || this.statisticsFrequency > 0 && this.accesCount % (long)this.statisticsFrequency != 0L) {
            return;
        }
        this.log.finest("Repository roots cache statistics:\n  cached roots size       = " + this.files.size() + "\n" + "  access count            = " + this.accesCount + "\n" + "  cached access count     = " + this.cachedAccesCount + "\n" + "  not cached access count = " + (this.accesCount - this.cachedAccesCount) + "\n");
    }

    public synchronized void clear() {
        this.files.clear();
        this.cachedAccesCount = 0L;
        this.accesCount = 0L;
    }

    public File getRepositoryRoot(File file) {
        File oFile = file;
        this.logStatistics();
        File root = this.get(file, true);
        if (root != null) {
            return root;
        }
        root = this.callback.getTopmostManagedAncestor(file);
        if (root != null) {
            if (file.isFile()) {
                file = file.getParentFile();
            }
            ArrayList<File> folders = new ArrayList<File>();
            while (file != null && !file.getAbsolutePath().equals(root.getAbsolutePath())) {
                File knownRoot = this.get(file);
                if (knownRoot != null) {
                    this.put(folders, knownRoot);
                    this.put(oFile, knownRoot);
                    return knownRoot;
                }
                folders.add(file);
                if (this.callback.repositoryExistsFor(file)) {
                    this.put(folders, file);
                    this.put(oFile, file);
                    return file;
                }
                file = file.getParentFile();
            }
            folders.add(root);
            this.put(folders, root);
            this.put(oFile, root);
            return root;
        }
        return null;
    }

    public static interface Callback {
        public boolean repositoryExistsFor(File var1);

        public File getTopmostManagedAncestor(File var1);
    }
}

