/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class GetRemotesCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final ProgressMonitor monitor;
    private Map<String, GitRemoteConfig> remotes;

    public GetRemotesCommand(JGitRepository repository, GitClassFactory gitFactory, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
    }

    public Map<String, GitRemoteConfig> getRemotes() {
        return this.remotes;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "remote");
        this.addArgument(0, "-v");
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                this.remotes = new LinkedHashMap<String, GitRemoteConfig>();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        GetRemotesCommand.this.parseRemoteOutput(output);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        GetRemotesCommand.this.parseAddError(error);
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parseRemoteOutput(String output) {
        LinkedHashMap<String, RemoteContainer> list = new LinkedHashMap<String, RemoteContainer>();
        for (String line : output.split("\n")) {
            if (line.isEmpty()) continue;
            String[] s = (line = line.replace('\t', ' ').trim()).split(" ");
            String remoteName = s[0];
            RemoteContainer conf = (RemoteContainer)list.get(remoteName);
            if (conf == null) {
                conf = new RemoteContainer();
                list.put(remoteName, conf);
            }
            if (s.length != 3) continue;
            if ("(fetch)".equals(s[2])) {
                conf.fetchSpecs.add(s[1]);
                continue;
            }
            if (!"(push)".equals(s[2])) continue;
            conf.pushSpecs.add(s[1]);
        }
        for (Map.Entry e : list.entrySet()) {
            GitRemoteConfig conf = new GitRemoteConfig((String)e.getKey(), ((RemoteContainer)e.getValue()).uris, ((RemoteContainer)e.getValue()).pushUris, ((RemoteContainer)e.getValue()).fetchSpecs, ((RemoteContainer)e.getValue()).pushSpecs);
            this.remotes.put((String)e.getKey(), conf);
        }
    }

    private void parseAddError(String error) {
        this.processMessages(error);
    }

    private static final class RemoteContainer {
        List<String> uris = new ArrayList<String>();
        List<String> pushUris = new ArrayList<String>();
        List<String> fetchSpecs = new ArrayList<String>();
        List<String> pushSpecs = new ArrayList<String>();

        private RemoteContainer() {
        }
    }
}

