/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.indexing.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.indexing.spi.TextIndexLayer;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class DiskTextIndexLayer
implements TextIndexLayer {
    private static final boolean CHECK_KEY;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final Logger LOG;
    private final DocumentIndex index;
    private final ConcurrentLinkedQueue<StoreQueueEntry> unsavedQueue = new ConcurrentLinkedQueue();
    private static final RequestProcessor RP;
    private static final int STORE_DELAY = 3000;
    private final ScheduledFuture<?> scheduleAtFixedRate = RP.scheduleAtFixedRate(new Runnable(){

        @Override
        public void run() {
            DiskTextIndexLayer.this.store();
        }
    }, 3000L, 3000L, TimeUnit.MILLISECONDS);
    private final LayerDescriptor layerDescriptor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DiskTextIndexLayer(LayerDescriptor layerDescriptor, DocumentIndex index) {
        this.layerDescriptor = layerDescriptor;
        this.index = index;
    }

    @Override
    public void put(CndTextIndexKey indexKey, Set<CharSequence> ids) {
        if (this.closed.get()) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (indexKey.getFileNameIndex() < 2) {
                LOG.log(Level.FINE, "Cnd Text Index put for {0}:\n\t{1}", new Object[]{indexKey, ids});
            } else {
                LOG.log(Level.FINE, "Cnd Text Index put for {0}:{1}", new Object[]{indexKey, ids.size()});
            }
        }
        this.unsavedQueue.add(new StoreQueueEntry(indexKey, ids));
    }

    @Override
    public Collection<CndTextIndexKey> query(CharSequence text) {
        this.store();
        try {
            Collection queryRes = this.index.query("ids", text.toString(), Queries.QueryKind.EXACT, new String[]{"_sn"});
            HashSet<CndTextIndexKey> res = new HashSet<CndTextIndexKey>(queryRes.size());
            for (IndexDocument doc : queryRes) {
                res.add(this.fromPrimaryKey(doc.getPrimaryKey()));
            }
            LOG.log(Level.FINE, "Cnd Text Index query for {0}:\n\t{1}", new Object[]{text, res});
            return res;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public void remove(CndTextIndexKey indexKey) {
        this.put(indexKey, Collections.<CharSequence>emptySet());
    }

    @Override
    public LayerDescriptor getDescriptor() {
        return this.layerDescriptor;
    }

    @Override
    public boolean isValid() {
        try {
            return this.index.getStatus() != Index.Status.INVALID;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public synchronized void unitRemoved(int unitId) {
        if (unitId < 0) {
            return;
        }
        try {
            String unitPrefix = this.toPrimaryKeyPrefix(unitId);
            Collection queryRes = this.index.query("unitId", unitPrefix, Queries.QueryKind.EXACT, new String[]{"_sn"});
            TreeSet<String> keys = new TreeSet<String>();
            for (IndexDocument doc : queryRes) {
                keys.add(doc.getPrimaryKey());
            }
            for (String pk : keys) {
                this.index.removeDocument(pk);
            }
            this.index.store(false);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        this.closed.set(true);
        this.store();
        this.scheduleAtFixedRate.cancel(false);
    }

    synchronized void store() {
        if (this.unsavedQueue.isEmpty() || this.closed.get()) {
            return;
        }
        long start = System.currentTimeMillis();
        StoreQueueEntry entry = this.unsavedQueue.poll();
        while (entry != null) {
            CndTextIndexKey key = entry.key;
            IndexDocument doc = IndexManager.createDocument((String)this.toPrimaryKey(key));
            for (CharSequence id : entry.ids) {
                doc.addPair("ids", id.toString(), true, false);
            }
            this.index.addDocument(doc);
            entry = this.unsavedQueue.poll();
        }
        try {
            this.index.store(false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.closed.get()) {
            try {
                this.index.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        LOG.log(Level.FINE, "Cnd Text Index store took {0}ms", System.currentTimeMillis() - start);
    }

    private String toPrimaryKeyPrefix(int unitId) {
        return String.valueOf((long)unitId << 32);
    }

    private String toPrimaryKey(CndTextIndexKey key) {
        String result = String.valueOf(((long)key.getUnitId() << 32) + (long)key.getFileNameIndex());
        if (CHECK_KEY) {
            CndTextIndexKey fromPrimaryKey = this.fromPrimaryKey(result);
            if (!($assertionsDisabled || fromPrimaryKey.getUnitId() == key.getUnitId() && fromPrimaryKey.getFileNameIndex() == key.getFileNameIndex())) {
                throw new AssertionError();
            }
        }
        return result;
    }

    private CndTextIndexKey fromPrimaryKey(String ext) {
        long value = Long.parseLong(ext);
        int unitId = (int)(value >> 32);
        int fileNameIndex = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        return new CndTextIndexKey(unitId, fileNameIndex);
    }

    static {
        boolean check;
        boolean bl = $assertionsDisabled = !DiskTextIndexLayer.class.desiredAssertionStatus();
        if (System.getProperty("org.netbeans.modules.cnd.indexing.check.key") != null) {
            check = Boolean.getBoolean("org.netbeans.modules.cnd.indexing.check.key");
        } else {
            boolean debug = false;
            if (!$assertionsDisabled) {
                debug = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            check = debug;
        }
        CHECK_KEY = check;
        LOG = Logger.getLogger("CndTextIndexImpl");
        RP = new RequestProcessor("CndTextIndexImpl saver", 1);
    }

    private static class StoreQueueEntry {
        private final CndTextIndexKey key;
        private final Collection<CharSequence> ids;

        public StoreQueueEntry(CndTextIndexKey key, Collection<CharSequence> ids) {
            this.key = key;
            this.ids = ids;
        }
    }
}

