/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteServerSetup {
    private final Map<String, BinarySetupMapEntry> binarySetupMap;
    private final Map<ExecutionEnvironment, List<String>> updateMap;
    private final ExecutionEnvironment executionEnvironment;
    private boolean problems;
    private String reason;
    private String libDir;

    RemoteServerSetup(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(SetupProvider.class));
        Collection list = results.allInstances();
        SetupProvider[] providers = list.toArray(new SetupProvider[list.size()]);
        this.libDir = HostInfoProvider.getLibDir((ExecutionEnvironment)executionEnvironment);
        if (!this.libDir.endsWith("/")) {
            this.libDir = this.libDir + "/";
        }
        this.binarySetupMap = new HashMap<String, BinarySetupMapEntry>();
        for (SetupProvider provider : providers) {
            Map map = provider.getBinaryFiles(executionEnvironment);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                String remotePath = this.libDir + (String)entry.getKey();
                this.binarySetupMap.put(remotePath, new BinarySetupMapEntry((File)entry.getValue(), remotePath, provider));
            }
        }
        this.updateMap = new HashMap<ExecutionEnvironment, List<String>>();
    }

    boolean needsSetupOrUpdate() {
        List<Object> updateList = new ArrayList();
        this.updateMap.clear();
        updateList = this.getBinaryUpdates();
        if (!updateList.isEmpty()) {
            this.updateMap.put(this.executionEnvironment, updateList);
            return true;
        }
        return false;
    }

    protected void setup() {
        List<String> list = this.updateMap.remove(this.executionEnvironment);
        HashMap<SetupProvider, ArrayList<BinarySetupMapEntry>> problematic = new HashMap<SetupProvider, ArrayList<BinarySetupMapEntry>>();
        for (String path : list) {
            RemoteUtil.LOGGER.log(Level.FINE, "RSS.setup: Updating \"{0}\" on {1}", new Object[]{path, this.executionEnvironment});
            if (!this.binarySetupMap.containsKey(path)) continue;
            BinarySetupMapEntry entry = this.binarySetupMap.get(path);
            CndUtils.assertNotNullInConsole((Object)entry, (String)"Null entry");
            if (entry == null) continue;
            if (entry.localFile == null) {
                RemoteUtil.LOGGER.severe("Can not find file " + entry.remotePath + " in IDE installation");
                continue;
            }
            File file = entry.localFile;
            CndUtils.assertAbsoluteFileInConsole((File)file);
            String remotePath = path;
            boolean success = false;
            try {
                success = file.exists() && this.copyTo(file, remotePath);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            if (success) continue;
            ArrayList<BinarySetupMapEntry> l = (ArrayList<BinarySetupMapEntry>)problematic.get(entry.setupProvider);
            if (l == null) {
                l = new ArrayList<BinarySetupMapEntry>();
                problematic.put(entry.setupProvider, l);
            }
            l.add(entry);
        }
        if (!problematic.isEmpty()) {
            StringBuilder message = new StringBuilder(NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure_Start", (Object)this.executionEnvironment));
            StringBuilder consequences = new StringBuilder(NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure_Consequences"));
            for (Map.Entry tmp : problematic.entrySet()) {
                ArrayList<File> files = new ArrayList<File>();
                for (BinarySetupMapEntry entry : (List)tmp.getValue()) {
                    files.add(entry.localFile);
                    message.append('\n').append(NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure_Line", (Object)entry.localFile.getName(), (Object)CndPathUtilities.getDirName((String)entry.remotePath)));
                }
                consequences.append('\n');
                ((SetupProvider)tmp.getKey()).failed(files, consequences);
            }
            message.append('\n');
            message.append((CharSequence)consequences);
            this.setProblems(message.toString());
        }
    }

    private boolean copyTo(File file, String remoteFilePath) throws InterruptedException, ExecutionException {
        return ((CommonTasksSupport.UploadStatus)CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)remoteFilePath, (int)509, (boolean)true).get()).isOK();
    }

    private List<String> getBinaryUpdates() {
        return new ArrayList<String>(this.binarySetupMap.keySet());
    }

    public String getReason() {
        return this.reason;
    }

    private void setProblems(String reason) {
        this.problems = true;
        this.reason = reason;
    }

    protected boolean hasProblems() {
        return this.problems;
    }

    private static class BinarySetupMapEntry {
        public final File localFile;
        public final String remotePath;
        public final SetupProvider setupProvider;

        public BinarySetupMapEntry(File file, String remotePath, SetupProvider provider) {
            this.localFile = file;
            this.remotePath = remotePath;
            this.setupProvider = provider;
        }
    }
}

