/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncFactory;
import org.netbeans.modules.cnd.remote.sync.RfsSetupProvider;
import org.netbeans.modules.cnd.remote.sync.RfsSyncWorker;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RfsSyncFactory
extends BaseSyncFactory {
    public static final boolean ENABLE_RFS = CndUtils.getBoolean((String)"cnd.remote.fs", (boolean)true);
    public static final String ID = "rfs";

    public RemoteSyncWorker createNew(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, FileObject privProjectStorageDir, String workingDir, List<FSPath> files, List<FSPath> buildResults) {
        return new RfsSyncWorker(executionEnvironment, out, err, privProjectStorageDir, files, buildResults);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_Factory_Name");
    }

    public String getDescription() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_Factory_Description");
    }

    public String getID() {
        return ID;
    }

    public boolean isCopying() {
        return true;
    }

    public boolean isApplicable(ExecutionEnvironment execEnv) {
        if (ENABLE_RFS && execEnv.isRemote() && !RemoteUtil.isForeign(execEnv)) {
            Boolean applicable = RfsSetupProvider.isApplicable(execEnv);
            if (applicable == null) {
                RemoteUtil.LOGGER.log(Level.WARNING, "Can not determine whether RFS is applicable for {0}", execEnv.getDisplayName());
                return true;
            }
            return applicable;
        }
        return false;
    }

    public PathMap getPathMap(ExecutionEnvironment executionEnvironment) {
        return RemotePathMap.getPathMap(executionEnvironment, false);
    }
}

