/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.ui.setup.StopWatch;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.remote.ui.wizard.HostValidatorImpl;
import org.netbeans.modules.cnd.spi.remote.setup.HostValidator;
import org.netbeans.modules.cnd.spi.remote.setup.support.TextComponentWriter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ValidatablePanelListener;
import org.netbeans.modules.nativeexecution.api.util.ValidateablePanel;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class CreateHostVisualPanel2
extends JPanel {
    private final ChangeListener wizardListener;
    private final CreateHostData data;
    private final ConfigPanelListener cfgListener = new ConfigPanelListener();
    private final ValidateablePanel configurationPanel;
    private static final RequestProcessor RP = new RequestProcessor(CreateHostVisualPanel2.class.getName(), 1);
    private ProgressHandle phandle;
    private volatile HostValidator hostValidator;
    private ExecutionEnvironment hostFound = null;
    private Runnable runOnFinish = null;
    private JPanel authPanel;
    private JCheckBox cbACL;
    private JCheckBox cbFindCompilers;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel pbarStatusPanel;
    private JTextField textLoginName;
    private JTextPane tpOutput;

    public CreateHostVisualPanel2(CreateHostData data, ChangeListener listener) {
        this.data = data;
        this.wizardListener = listener;
        this.initComponents();
        this.cbACL.setEnabled(true);
        this.cbACL.setSelected(false);
        this.textLoginName.setText(System.getProperty("user.name"));
        this.configurationPanel = ConnectionManager.getInstance().getConfigurationPanel(null);
        this.configurationPanel.addValidationListener((ValidatablePanelListener)this.cfgListener);
        this.authPanel.add((Component)this.configurationPanel, "Center");
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateHostVisualPanel2.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateHostVisualPanel2.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateHostVisualPanel2.this.fireChange();
            }
        };
        this.textLoginName.getDocument().addDocumentListener(dl);
    }

    private void fireChange() {
        this.hostFound = null;
        this.wizardListener.stateChanged(null);
        this.configurationPanel.putClientProperty((Object)"ExecutionEnvironment", (Object)this.textLoginName.getText().concat("@").concat(this.data.getHostName()).concat(":").concat(Integer.toString(this.data.getPort())));
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.Title");
    }

    void init() {
        this.configurationPanel.putClientProperty((Object)"ExecutionEnvironment", (Object)this.data.getUserName().concat("@").concat(this.data.getHostName()).concat(":").concat(Integer.toString(this.data.getPort())));
        this.cbFindCompilers.setSelected(this.data.getSearchTools());
    }

    private String getLoginName() {
        return this.textLoginName.getText();
    }

    private void initComponents() {
        this.authPanel = new JPanel();
        this.cbFindCompilers = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.tpOutput = new JTextPane();
        this.pbarStatusPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textLoginName = new JTextField();
        this.cbACL = new JCheckBox();
        this.setPreferredSize(new Dimension(534, 409));
        this.setRequestFocusEnabled(false);
        this.authPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbFindCompilers, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.cbFindCompilers.text"));
        this.cbFindCompilers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateHostVisualPanel2.this.cbFindCompilersActionPerformed(evt);
            }
        });
        this.tpOutput.setEditable(false);
        this.tpOutput.setText(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.tpOutput.text"));
        this.tpOutput.setOpaque(false);
        this.jScrollPane1.setViewportView(this.tpOutput);
        this.pbarStatusPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        this.pbarStatusPanel.setMinimumSize(new Dimension(100, 10));
        this.pbarStatusPanel.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.jPanel1.border.title")));
        this.jLabel1.setLabelFor(this.textLoginName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.jLabel1.text"));
        this.textLoginName.setText(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.textLoginName.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textLoginName).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLoginName, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.cbACL, (String)NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"CreateHostVisualPanel2.cbACL.text"));
        this.cbACL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateHostVisualPanel2.this.cbACLActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pbarStatusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.authPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbACL, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cbFindCompilers, -2, 502, -2).addGap(0, 2, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authPanel, -1, 10, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbFindCompilers).addGap(2, 2, 2).addComponent(this.cbACL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pbarStatusPanel, -2, 11, -2)));
    }

    private void cbFindCompilersActionPerformed(ActionEvent evt) {
        this.data.setSearchTools(this.cbFindCompilers.isSelected());
        HostValidator v = this.hostValidator;
        if (v != null) {
            this.cbFindCompilers.setEnabled(false);
            if (!this.cbFindCompilers.isSelected()) {
                v.cancelToolSearch();
            }
        }
    }

    private void cbACLActionPerformed(ActionEvent evt) {
        this.data.enableACL(this.cbACL.isSelected());
        ExecutionEnvironment env = this.data.getExecutionEnvironment();
        if (env != null) {
            FileSystemProvider.setAccessCheckType((ExecutionEnvironment)env, (FileSystemProvider.AccessCheckType)(this.cbACL.isSelected() ? FileSystemProvider.AccessCheckType.FULL : FileSystemProvider.AccessCheckType.FAST));
        }
    }

    ExecutionEnvironment getHost() {
        return this.hostFound;
    }

    Runnable getRunOnFinish() {
        return this.runOnFinish;
    }

    public void enableControls(boolean enable) {
        this.configurationPanel.setEnabled(enable);
        this.textLoginName.setEnabled(enable);
    }

    public boolean canValidateHost() {
        ArrayList records = new ArrayList();
        if (this.data.getCacheManager().getServerUpdateCache() != null && this.data.getCacheManager().getServerUpdateCache().getHosts() != null) {
            records.addAll(this.data.getCacheManager().getServerUpdateCache().getHosts());
        } else {
            records = new ArrayList(ServerList.getRecords());
        }
        for (ServerRecord record : records) {
            if (!record.isRemote() || !record.getServerName().equals(this.data.getHostName()) || record.getExecutionEnvironment().getSSHPort() != this.data.getPort() || !record.getUserName().equals(this.textLoginName.getText())) continue;
            return false;
        }
        return true;
    }

    public Future<Boolean> validateHost() {
        FutureTask<Boolean> validationTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                CreateHostVisualPanel2.this.tpOutput.setText("");
                TextComponentWriter textComponentWriter = new TextComponentWriter(CreateHostVisualPanel2.this.tpOutput);
                if (CreateHostVisualPanel2.isEmpty(CreateHostVisualPanel2.this.getLoginName())) {
                    textComponentWriter.println(NbBundle.getMessage(CreateHostVisualPanel2.class, (String)"EmptyLoginMessage"));
                    return Boolean.FALSE;
                }
                ExecutionEnvironment env = ExecutionEnvironmentFactory.createNew((String)CreateHostVisualPanel2.this.getLoginName(), (String)CreateHostVisualPanel2.this.data.getHostName(), (int)CreateHostVisualPanel2.this.data.getPort());
                CreateHostVisualPanel2.this.configurationPanel.applyChanges((Object)env);
                CreateHostVisualPanel2.this.tpOutput.setText("");
                CreateHostVisualPanel2.this.phandle = ProgressHandleFactory.createHandle((String)"");
                CreateHostVisualPanel2.this.pbarStatusPanel.removeAll();
                CreateHostVisualPanel2.this.pbarStatusPanel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)CreateHostVisualPanel2.this.phandle), "Center");
                CreateHostVisualPanel2.this.pbarStatusPanel.validate();
                CreateHostVisualPanel2.this.phandle.start();
                try {
                    StopWatch sw = StopWatch.createAndStart(RemoteServerList.TRACE_SETUP, "#HostSetup", env, "hostValidator.validate", new Object[0]);
                    CreateHostVisualPanel2.this.hostValidator = new HostValidatorImpl(CreateHostVisualPanel2.this.data.getCacheManager());
                    FileSystemProvider.setAccessCheckType((ExecutionEnvironment)env, (FileSystemProvider.AccessCheckType)(CreateHostVisualPanel2.this.cbACL.isSelected() ? FileSystemProvider.AccessCheckType.FULL : FileSystemProvider.AccessCheckType.FAST));
                    if (CreateHostVisualPanel2.this.hostValidator.validate(env, CreateHostVisualPanel2.this.data.getSearchTools(), new TextComponentWriter(CreateHostVisualPanel2.this.tpOutput))) {
                        sw.stop();
                        CreateHostVisualPanel2.this.hostFound = env;
                        CreateHostVisualPanel2.this.runOnFinish = CreateHostVisualPanel2.this.hostValidator.getRunOnFinish();
                    }
                }
                finally {
                    CreateHostVisualPanel2.this.hostValidator = null;
                    CreateHostVisualPanel2.this.phandle.finish();
                    CreateHostVisualPanel2.this.wizardListener.stateChanged(null);
                    CreateHostVisualPanel2.this.pbarStatusPanel.setVisible(false);
                }
                return true;
            }
        });
        RP.post(validationTask);
        return validationTask;
    }

    boolean hasConfigProblems() {
        return this.configurationPanel.hasProblem();
    }

    String getConfigProblem() {
        return this.configurationPanel.getProblem();
    }

    void storeConfiguration() {
        if (!CreateHostVisualPanel2.isEmpty(this.getLoginName())) {
            ExecutionEnvironment env = ExecutionEnvironmentFactory.createNew((String)this.getLoginName(), (String)this.data.getHostName(), (int)this.data.getPort());
            this.configurationPanel.applyChanges((Object)env);
        }
    }

    private static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    private class ConfigPanelListener
    implements ValidatablePanelListener {
        private ConfigPanelListener() {
        }

        public void stateChanged(ValidateablePanel src) {
            CreateHostVisualPanel2.this.fireChange();
        }
    }
}

