/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.javascript2.editor.CompletionContextFinder;
import org.netbeans.modules.javascript2.editor.EditorExtender;
import org.netbeans.modules.javascript2.editor.JsCompletionItem;
import org.netbeans.modules.javascript2.editor.JsKeyWords;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationCodeCompletion;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationElement;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.lexer.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.IdentifierImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelExtender;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.netbeans.modules.javascript2.editor.options.OptionsUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class JsCodeCompletion
implements CodeCompletionHandler2 {
    private static final Logger LOGGER = Logger.getLogger(JsCodeCompletion.class.getName());
    private static final List<String> WINDOW_EXPRESSION_CHAIN = Arrays.asList("window", "@pro");
    private boolean caseSensitive;
    private static final String CHARS_NO_AUTO_COMPLETE = ";,/+-\\:={}[]()";
    private int checkRecursion;

    JsCodeCompletion() {
    }

    public CodeCompletionResult complete(CodeCompletionContext ccContext) {
        CancelSupport cancelSupport = CancelSupport.getDefault();
        if (cancelSupport.isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        long start = System.currentTimeMillis();
        BaseDocument doc = (BaseDocument)ccContext.getParserResult().getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return CodeCompletionResult.NONE;
        }
        this.caseSensitive = ccContext.isCaseSensitive();
        ParserResult info = ccContext.getParserResult();
        int caretOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(ccContext.getCaretOffset());
        FileObject fileObject = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
        JsParserResult jsParserResult = (JsParserResult)info;
        CompletionContext context = CompletionContextFinder.findCompletionContext(info, caretOffset);
        LOGGER.log(Level.FINE, String.format("CC context: %s", context.toString()));
        JsCompletionItem.CompletionRequest request = new JsCompletionItem.CompletionRequest();
        String pref = ccContext.getPrefix();
        request.anchor = pref == null ? caretOffset : caretOffset - pref.length();
        request.result = jsParserResult;
        request.info = info;
        request.prefix = pref;
        request.completionContext = context;
        request.addHtmlTagAttributes = false;
        request.cancelSupport = cancelSupport;
        jsParserResult.getModel().resolve();
        ArrayList<CompletionProposal> resultList = new ArrayList<CompletionProposal>();
        HashMap<String, List<JsElement>> added = new HashMap<String, List<JsElement>>();
        if (cancelSupport.isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        if (ccContext.getQueryType() == CodeCompletionHandler.QueryType.ALL_COMPLETION) {
            switch (context) {
                case GLOBAL: {
                    this.addGlobalObjectsFromIndex(request, added);
                    break;
                }
                case EXPRESSION: {
                    this.completeKeywords(request, resultList);
                    this.completeExpression(request, added);
                    break;
                }
                case OBJECT_PROPERTY: {
                    this.completeObjectProperty(request, added);
                    break;
                }
                case OBJECT_MEMBERS: {
                    this.completeObjectMember(request, added);
                    break;
                }
            }
            if (!(context != CompletionContext.EXPRESSION && context != CompletionContext.OBJECT_MEMBERS && context != CompletionContext.OBJECT_PROPERTY || request.prefix.isEmpty())) {
                Collection<? extends IndexResult> indexResults = JsIndex.get(fileObject).query("bn", request.prefix, QuerySupport.Kind.PREFIX, JsIndex.TERMS_BASIC_INFO);
                for (IndexResult indexResult : indexResults) {
                    IndexedElement indexElement = IndexedElement.create(indexResult);
                    this.addPropertyToMap(request, added, indexElement);
                }
            }
        } else {
            switch (context) {
                case STRING: {
                    if (request.prefix.startsWith(".")) {
                        request.prefix = request.prefix.substring(1);
                        ++request.anchor;
                    }
                    List<String> expression = this.resolveExpressionChainFromString(request);
                    Map<String, List<JsElement>> toAdd = this.getCompletionFromExpressionChain(request, expression);
                    JsCompletionItem.Factory.create(toAdd, request, resultList);
                    break;
                }
                case STRING_ELEMENTS_BY_ID: {
                    this.completeTagIds(request, resultList);
                    break;
                }
                case STRING_ELEMENTS_BY_CLASS_NAME: {
                    this.completeCSSClassNames(request, resultList);
                    break;
                }
                case GLOBAL: {
                    HashMap<String, List<JsElement>> hashMap = new HashMap<String, List<JsElement>>();
                    hashMap.putAll(this.getDomCompletionResults(request));
                    for (JsObject jsObject : ModelExtender.getDefault().getExtendingGlobalObjects(fileObject)) {
                        for (JsObject jsObject2 : jsObject.getProperties().values()) {
                            this.addPropertyToMap(request, hashMap, jsObject2);
                        }
                    }
                    for (JsObject jsObject : request.result.getModel().getVariables(caretOffset)) {
                        if (jsObject instanceof JsFunction && ((JsFunction)jsObject).isAnonymous()) continue;
                        this.addPropertyToMap(request, hashMap, jsObject);
                    }
                    this.completeKeywords(request, resultList);
                    this.addGlobalObjectsFromIndex(request, hashMap);
                    this.completeInWith(request, hashMap);
                    JsCompletionItem.Factory.create(hashMap, request, resultList);
                    break;
                }
                case CALL_ARGUMENT: {
                    this.completeCallArguments(request, resultList);
                }
                case EXPRESSION: {
                    this.completeKeywords(request, resultList);
                    this.completeExpression(request, added);
                    this.completeObjectProperty(request, added);
                    this.completeInWith(request, added);
                    added.remove("prototype");
                    break;
                }
                case OBJECT_PROPERTY: {
                    this.completeObjectProperty(request, added);
                    break;
                }
                case OBJECT_MEMBERS: {
                    this.completeObjectMember(request, added);
                    break;
                }
                case DOCUMENTATION: {
                    JsDocumentationCodeCompletion.complete(request, resultList);
                    break;
                }
                case OBJECT_PROPERTY_NAME: {
                    this.completeObjectPropertyName(request, added);
                }
            }
        }
        JsCompletionItem.Factory.create(added, request, resultList);
        if (request.addHtmlTagAttributes) {
            this.completeTagAttributes(request, resultList);
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Counting JS CC took {0}ms ", end - start);
        for (CompletionProvider interceptor : EditorExtender.getDefault().getCompletionProviders()) {
            resultList.addAll(interceptor.complete(ccContext, context, pref));
        }
        if (!resultList.isEmpty()) {
            return new DefaultCompletionResult(resultList, false);
        }
        return CodeCompletionResult.NONE;
    }

    private void addGlobalObjectsFromIndex(JsCompletionItem.CompletionRequest request, HashMap<String, List<JsElement>> addedProperties) {
        FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            JsIndex jsIndex = JsIndex.get(fileObject);
            Collection<IndexedElement> fromIndex = jsIndex.getGlobalVar(request.prefix);
            for (IndexedElement indexElement : fromIndex) {
                this.addPropertyToMap(request, addedProperties, indexElement);
            }
            fromIndex = jsIndex.getPropertiesWithPrefix("window", request.prefix);
            for (IndexedElement indexElement : fromIndex) {
                this.addPropertyToMap(request, addedProperties, indexElement);
            }
        }
    }

    public String document(ParserResult info, ElementHandle element) {
        Documentation doc = this.documentElement(info, element, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return false;
            }
        });
        if (doc != null) {
            return doc.getContent();
        }
        return null;
    }

    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        String documentation;
        JsObject jsObject;
        if (element == null) {
            return null;
        }
        if (element instanceof IndexedElement) {
            final Documentation[] result = new Documentation[1];
            final IndexedElement indexedElement = (IndexedElement)element;
            FileObject nextFo = indexedElement.getFileObject();
            if (nextFo != null) {
                try {
                    ParserManager.parse(Collections.singleton(Source.create((FileObject)nextFo)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result parserResult = resultIterator.getParserResult();
                            if (parserResult instanceof JsParserResult) {
                                JsParserResult jsInfo = (JsParserResult)parserResult;
                                String fqn = indexedElement.getFQN();
                                JsObject jsObjectGlobal = jsInfo.getModel().getGlobalObject();
                                JsObject property = ModelUtils.findJsObjectByName(jsObjectGlobal, fqn);
                                if (property != null) {
                                    Documentation doc;
                                    result[0] = doc = property.getDocumentation();
                                }
                            } else {
                                LOGGER.log(Level.INFO, "Not instance of JsParserResult: {0}", parserResult);
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
            if (result[0] != null) {
                return result[0];
            }
        } else if (element instanceof JsObject && (jsObject = (JsObject)element).getDocumentation() != null) {
            return jsObject.getDocumentation();
        }
        for (CompletionProvider interceptor : EditorExtender.getDefault().getCompletionProviders()) {
            String doc = interceptor.getHelpDocumentation(info, element);
            if (doc == null || doc.isEmpty()) continue;
            return Documentation.create((String)doc);
        }
        if (element instanceof JsDocumentationElement) {
            documentation = ((JsDocumentationElement)element).getDocumentation();
            return documentation != null ? Documentation.create((String)documentation) : null;
        }
        if (element instanceof JsCompletionItem.SimpleDocElement) {
            documentation = ((JsCompletionItem.SimpleDocElement)element).getDocumentation();
            return documentation != null ? Documentation.create((String)documentation) : null;
        }
        if (OffsetRange.NONE.equals((Object)element.getOffsetRange(info))) {
            return Documentation.create((String)NbBundle.getMessage(JsCodeCompletion.class, (String)"MSG_ItemFromUsageDoc"));
        }
        return Documentation.create((String)NbBundle.getMessage(JsCodeCompletion.class, (String)"MSG_DocNotAvailable"));
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        Token token;
        String prefix = "";
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return null;
        }
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(info.getSnapshot(), caretOffset);
        if (ts == null) {
            return null;
        }
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.offset() == offset) {
            ts.movePrevious();
        }
        if ((token = ts.token()) != null && token.id() != JsTokenId.EOL) {
            JsTokenId id = (JsTokenId)token.id();
            if (id == JsTokenId.STRING_END && ts.movePrevious()) {
                if (ts.token().id() == JsTokenId.STRING_BEGIN) {
                    return "";
                }
                ts.moveNext();
            }
            if (id == JsTokenId.STRING) {
                prefix = token.text().toString();
                if (upToOffset) {
                    int prefixIndex = JsCodeCompletion.getPrefixIndexFromSequence(prefix.substring(0, offset - ts.offset()));
                    prefix = prefix.substring(prefixIndex, offset - ts.offset());
                }
            }
            if (id == JsTokenId.IDENTIFIER || id.isKeyword()) {
                prefix = token.text().toString();
                if (upToOffset && offset - ts.offset() >= 0) {
                    prefix = prefix.substring(0, offset - ts.offset());
                }
            }
            if (id == JsTokenId.DOC_COMMENT) {
                TokenSequence<? extends JsDocumentationTokenId> docTokenSeq = LexUtilities.getJsDocumentationTokenSequence(info.getSnapshot(), offset);
                if (docTokenSeq == null) {
                    return null;
                }
                docTokenSeq.move(offset);
                if (!docTokenSeq.moveNext() && !docTokenSeq.movePrevious()) {
                    return null;
                }
                if (docTokenSeq.token().id() == JsDocumentationTokenId.KEYWORD) {
                    prefix = docTokenSeq.token().text().toString();
                    if (upToOffset) {
                        prefix = prefix.substring(0, offset - docTokenSeq.offset());
                    }
                } else {
                    docTokenSeq.movePrevious();
                    prefix = docTokenSeq.token().text().toString();
                }
            }
            if (id.isError()) {
                prefix = token.text().toString();
                prefix = prefix.substring(0, offset - ts.offset());
            }
        }
        LOGGER.log(Level.FINE, String.format("Prefix for cc: %s", prefix));
        return prefix;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        if (typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        int offset = component.getCaretPosition();
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(component.getDocument(), offset);
        if (ts != null) {
            int diff = ts.move(offset);
            TokenId currentTokenId = null;
            if (diff == 0 && ts.movePrevious() || ts.moveNext()) {
                currentTokenId = ts.token().id();
            }
            char lastChar = typedText.charAt(typedText.length() - 1);
            if (currentTokenId == JsTokenId.BLOCK_COMMENT || currentTokenId == JsTokenId.DOC_COMMENT || currentTokenId == JsTokenId.LINE_COMMENT) {
                if (lastChar == '@') {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
            } else {
                if (currentTokenId == JsTokenId.STRING && lastChar == '/') {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
                switch (lastChar) {
                    case '.': {
                        if (!OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).autoCompletionAfterDot()) break;
                        return CodeCompletionHandler.QueryType.COMPLETION;
                    }
                    default: {
                        if (OptionsUtils.forLanguage(JsTokenId.javascriptLanguage()).autoCompletionFull() && !Character.isWhitespace(lastChar) && CHARS_NO_AUTO_COMPLETE.indexOf(lastChar) == -1) {
                            return CodeCompletionHandler.QueryType.COMPLETION;
                        }
                        return CodeCompletionHandler.QueryType.NONE;
                    }
                }
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private void completeExpression(JsCompletionItem.CompletionRequest request, HashMap<String, List<JsElement>> addedItems) {
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        addedItems.putAll(this.getDomCompletionResults(request));
        JsIndex index = JsIndex.get(fo);
        Collection<IndexedElement> fromIndex = index.getGlobalVar(request.prefix);
        for (IndexedElement indexedElement : fromIndex) {
            this.addPropertyToMap(request, addedItems, indexedElement);
        }
        for (JsObject jsObject : ModelExtender.getDefault().getExtendingGlobalObjects(fo)) {
            for (JsObject jsObject2 : jsObject.getProperties().values()) {
                this.addPropertyToMap(request, addedItems, jsObject2);
            }
        }
        for (JsObject jsObject : request.result.getModel().getVariables(request.anchor)) {
            if (jsObject instanceof JsFunction && ((JsFunction)jsObject).isAnonymous()) continue;
            this.addPropertyToMap(request, addedItems, jsObject);
        }
    }

    private void completeObjectProperty(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        List<String> expChain = ModelUtils.resolveExpressionChain(request.result.getSnapshot(), request.anchor, false);
        if (!expChain.isEmpty()) {
            Map<String, List<JsElement>> toAdd = this.getCompletionFromExpressionChain(request, expChain);
            if (request.cancelSupport.isCancelled()) {
                return;
            }
            FileObject fo = request.result.getSnapshot().getSource().getFileObject();
            if (fo != null) {
                long start = System.currentTimeMillis();
                Collection<IndexedElement> fromUsages = JsIndex.get(request.result.getSnapshot().getSource().getFileObject()).getUsagesFromExpression(expChain);
                for (IndexedElement indexedElement : fromUsages) {
                    if (fo.equals(indexedElement.getFileObject()) && indexedElement.getName().equals(request.prefix)) continue;
                    this.addPropertyToMap(request, addedItems, indexedElement);
                }
                long end = System.currentTimeMillis();
                LOGGER.log(Level.FINE, String.format("Counting cc based on usages took: %dms", end - start));
            }
            addedItems.putAll(toAdd);
        }
    }

    private Map<String, List<JsElement>> getCompletionFromExpressionChain(JsCompletionItem.CompletionRequest request, List<String> expChain) {
        boolean bl;
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        JsIndex jsIndex = JsIndex.get(fo);
        Collection<Object> resolveTypeFromExpression = new ArrayList<TypeUsage>();
        HashMap<String, List<JsElement>> addedProperties = new HashMap<String, List<JsElement>>();
        resolveTypeFromExpression.addAll(ModelUtils.resolveTypeFromExpression(request.result.getModel(), jsIndex, expChain, request.anchor, true));
        if (request.cancelSupport.isCancelled()) {
            return addedProperties;
        }
        resolveTypeFromExpression = ModelUtils.resolveTypes(resolveTypeFromExpression, request.result, true, true);
        ArrayList<String> windowProp = new ArrayList<String>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            if (!typeUsage.isResolved() || typeUsage.getType().startsWith("window")) continue;
            windowProp.add("window." + typeUsage.getType());
        }
        ArrayList<String> prototypeChain = new ArrayList<String>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            prototypeChain.addAll(ModelUtils.findPrototypeChain(typeUsage.getType(), jsIndex));
        }
        for (String string : windowProp) {
            resolveTypeFromExpression.add(new TypeUsageImpl(string));
        }
        for (String string : prototypeChain) {
            resolveTypeFromExpression.add(new TypeUsageImpl(string));
        }
        if (request.cancelSupport.isCancelled()) {
            return addedProperties;
        }
        boolean bl2 = false;
        ArrayList<JsObject> arrayList = new ArrayList<JsObject>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            boolean bl3;
            this.checkRecursion = 0;
            boolean addFunctionProp = this.processTypeInModel(request, request.result.getModel(), typeUsage, arrayList, expChain.get(1).equals("@pro"), jsIndex, addedProperties);
            boolean bl4 = bl3 = bl3 || addFunctionProp;
            if (!typeUsage.isResolved()) continue;
            this.addObjectPropertiesFromIndex(typeUsage.getType(), jsIndex, request, addedProperties);
        }
        boolean isPublic = arrayList.isEmpty();
        for (JsObject resolved : arrayList) {
            if (!bl && resolved.getJSKind().isFunction()) {
                bl = true;
            }
            this.addObjectPropertiesToCC(resolved, request, addedProperties);
            if (!resolved.isDeclared()) {
                this.addObjectPropertiesFromIndex(resolved.getFullyQualifiedName(), jsIndex, request, addedProperties);
                isPublic = true;
                continue;
            }
            if (resolved.getModifiers().contains(Modifier.PRIVATE)) continue;
            isPublic = true;
        }
        if (bl) {
            this.addObjectPropertiesFromIndex("Function", jsIndex, request, addedProperties);
        }
        if (request.cancelSupport.isCancelled()) {
            return addedProperties;
        }
        this.addObjectPropertiesFromIndex("Object", jsIndex, request, addedProperties);
        if (isPublic) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = expChain.size() - 1; i > -1; --i) {
                stringBuilder.append(expChain.get(--i));
                stringBuilder.append('.');
            }
            if (stringBuilder.length() > 0) {
                Collection<IndexedElement> indexResults = jsIndex.getPropertiesWithPrefix(stringBuilder.toString().substring(0, stringBuilder.length() - 1), request.prefix);
                for (IndexedElement indexedElement : indexResults) {
                    if (indexedElement.isAnonymous() || !indexedElement.getModifiers().contains(Modifier.PUBLIC)) continue;
                    this.addPropertyToMap(request, addedProperties, indexedElement);
                }
            }
        }
        return addedProperties;
    }

    private Identifier findNameOfFunctionCall(JsCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.result.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return null;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.javascriptLanguage());
        if (ts == null) {
            return null;
        }
        ts.move(request.anchor);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        int curlyDeep = 0;
        Token token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        while (ts.movePrevious() && tokenId != JsTokenId.BRACKET_LEFT_PAREN && tokenId != JsTokenId.OPERATOR_SEMICOLON) {
            if (tokenId == JsTokenId.BRACKET_LEFT_CURLY) {
                ++curlyDeep;
            }
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (tokenId == JsTokenId.BRACKET_LEFT_PAREN && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence<? extends JsTokenId>)ts)) != null && token.id() == JsTokenId.IDENTIFIER) {
            String functionName = token.text().toString();
            return new IdentifierImpl(functionName, new OffsetRange(ts.offset(), ts.offset() + functionName.length()));
        }
        return null;
    }

    private List<IndexedElement.FunctionIndexedElement> findFunctionInIndex(Identifier functionName, JsCompletionItem.CompletionRequest request) {
        ArrayList<IndexedElement.FunctionIndexedElement> result;
        block5: {
            result = new ArrayList<IndexedElement.FunctionIndexedElement>();
            List<String> expChain = ModelUtils.resolveExpressionChain(request.result.getSnapshot(), functionName.getOffsetRange().getStart() - 1, false);
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            if (fo == null) break block5;
            JsIndex jsIndex = JsIndex.get(fo);
            if (expChain.isEmpty()) {
                Collection<IndexedElement> globalVars = jsIndex.getGlobalVar(functionName.getName());
                for (IndexedElement globalVar : globalVars) {
                    if (!globalVar.getName().equals(functionName) || !globalVar.getJSKind().isFunction()) continue;
                    result.add((IndexedElement.FunctionIndexedElement)globalVar);
                }
            } else {
                Collection<TypeUsage> types = ModelUtils.resolveTypeFromExpression(request.result.getModel(), jsIndex, expChain, request.anchor, false);
                for (TypeUsage type : types) {
                    Collection<IndexedElement> properties = jsIndex.getPropertiesWithPrefix(type.getType(), functionName.getName());
                    properties.addAll(jsIndex.getPropertiesWithPrefix(type.getType() + "." + "prototype", functionName.getName()));
                    for (IndexedElement property : properties) {
                        if (!property.getName().equals(functionName.getName()) || !property.getJSKind().isFunction()) continue;
                        IndexedElement.FunctionIndexedElement function = (IndexedElement.FunctionIndexedElement)property;
                        result.add(function);
                    }
                }
            }
        }
        return result;
    }

    private List<TypeUsage> findPossibleCallArgTypes(JsCompletionItem.CompletionRequest request) {
        Identifier functionName = this.findNameOfFunctionCall(request);
        if (functionName == null) {
            return null;
        }
        ArrayList<TypeUsage> result = new ArrayList<TypeUsage>();
        List<IndexedElement.FunctionIndexedElement> functions = this.findFunctionInIndex(functionName, request);
        for (IndexedElement.FunctionIndexedElement function : functions) {
            LinkedHashMap<String, Collection<String>> parameters = function.getParameters();
            for (Collection<String> assignments : parameters.values()) {
                if (assignments.isEmpty()) continue;
                for (String assignment : assignments) {
                    result.add(new TypeUsageImpl(assignment));
                }
            }
        }
        return result;
    }

    private void completeObjectPropertyName(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        TokenHierarchy th = request.result.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.javascriptLanguage());
        if (ts == null) {
            return;
        }
        ts.move(request.anchor);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return;
        }
        int curlyDeep = 0;
        Token token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        while (ts.movePrevious() && tokenId != JsTokenId.BRACKET_LEFT_PAREN && tokenId != JsTokenId.OPERATOR_SEMICOLON) {
            if (tokenId == JsTokenId.BRACKET_LEFT_CURLY) {
                ++curlyDeep;
            }
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (curlyDeep == 1 && tokenId == JsTokenId.BRACKET_LEFT_PAREN && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence<? extends JsTokenId>)ts)) != null && token.id() == JsTokenId.IDENTIFIER) {
            String functionName = token.text().toString();
            List<String> expChain = ModelUtils.resolveExpressionChain(request.result.getSnapshot(), ts.offset() - 1, false);
            ArrayList<? extends TypeUsage> possibleTypes = new ArrayList<TypeUsage>();
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            JsIndex jsIndex = JsIndex.get(fo);
            if (expChain.isEmpty()) {
                Collection<? extends JsObject> variables = ModelUtils.getVariables(request.result.getModel(), request.anchor);
                for (JsObject jsObject : variables) {
                    if (!jsObject.getName().equals(functionName) || !jsObject.getJSKind().isFunction()) continue;
                    JsFunction function = (JsFunction)jsObject;
                    Collection<? extends JsObject> parameters = function.getParameters();
                    for (JsObject jsObject2 : parameters) {
                        if (jsObject2.getAssignments().isEmpty()) continue;
                        possibleTypes.addAll(jsObject2.getAssignments());
                    }
                }
                Collection<IndexedElement> collection = jsIndex.getGlobalVar(functionName);
                for (IndexedElement globalVar : collection) {
                    if (!globalVar.getName().equals(functionName) || !globalVar.getJSKind().isFunction()) continue;
                    IndexedElement.FunctionIndexedElement function = (IndexedElement.FunctionIndexedElement)globalVar;
                    LinkedHashMap<String, Collection<String>> parameters = function.getParameters();
                    for (Collection<String> assignments : parameters.values()) {
                        if (assignments.isEmpty()) continue;
                        for (String string : assignments) {
                            possibleTypes.add(new TypeUsageImpl(string));
                        }
                    }
                }
            } else {
                Collection<TypeUsage> types = ModelUtils.resolveTypeFromExpression(request.result.getModel(), jsIndex, expChain, request.anchor, false);
                for (TypeUsage typeUsage : types) {
                    Collection<IndexedElement> properties = jsIndex.getPropertiesWithPrefix(typeUsage.getType(), functionName);
                    properties.addAll(jsIndex.getPropertiesWithPrefix(typeUsage.getType() + "." + "prototype", functionName));
                    for (IndexedElement property : properties) {
                        if (!property.getName().equals(functionName) || !property.getJSKind().isFunction()) continue;
                        IndexedElement.FunctionIndexedElement functionIndexedElement = (IndexedElement.FunctionIndexedElement)property;
                        LinkedHashMap<String, Collection<String>> parameters = functionIndexedElement.getParameters();
                        for (Collection collection : parameters.values()) {
                            if (collection.isEmpty()) continue;
                            for (String assignment : collection) {
                                possibleTypes.add(new TypeUsageImpl(assignment));
                            }
                        }
                    }
                }
            }
            if (!possibleTypes.isEmpty()) {
                for (TypeUsage typeUsage : possibleTypes) {
                    this.addObjectPropertiesFromIndex(typeUsage.getType(), jsIndex, request, addedItems);
                }
            }
        }
    }

    private List<String> resolveExpressionChainFromString(JsCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(th, request.anchor);
        if (ts == null) {
            return Collections.emptyList();
        }
        int offset = request.info.getSnapshot().getEmbeddedOffset(request.anchor);
        ts.move(offset);
        String text = null;
        if (ts.moveNext()) {
            if (ts.token().id() == JsTokenId.STRING_END) {
                if (ts.movePrevious() && ts.token().id() == JsTokenId.STRING) {
                    text = ts.token().text().toString();
                }
            } else if (ts.token().id() == JsTokenId.STRING) {
                text = ts.token().text().toString().substring(0, offset - ts.offset());
            }
        }
        if (text != null && !text.isEmpty()) {
            int index = text.length() - 1;
            ArrayList<String> exp = new ArrayList<String>();
            int parenBalancer = 0;
            boolean methodCall = false;
            char ch = text.charAt(index);
            String part = "";
            while (index > -1 && ch != ' ' && ch != '\n' && ch != ';' && ch != '}' && ch != '{' && ch != '(' && ch != '=' && ch != '+' && ch != '[') {
                if (ch == '.') {
                    if (!part.isEmpty()) {
                        exp.add(part);
                        part = "";
                        if (methodCall) {
                            exp.add("@mtd");
                            methodCall = false;
                        } else {
                            exp.add("@pro");
                        }
                    }
                } else if (ch == ')') {
                    ++parenBalancer;
                    methodCall = true;
                    while (parenBalancer > 0 && --index > -1) {
                        ch = text.charAt(index);
                        if (ch == ')') {
                            ++parenBalancer;
                            continue;
                        }
                        if (ch != '(') continue;
                        --parenBalancer;
                    }
                } else {
                    part = ch + part;
                }
                if (--index <= -1) continue;
                ch = text.charAt(index);
            }
            if (!part.isEmpty()) {
                exp.add(part);
                if (methodCall) {
                    exp.add("@mtd");
                } else {
                    exp.add("@pro");
                }
            }
            return exp;
        }
        return Collections.emptyList();
    }

    private List<String> resolveExpressionChain(JsCompletionItem.CompletionRequest request, int offset, boolean lookBefore) {
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(th, offset);
        if (ts == null) {
            return Collections.emptyList();
        }
        ts.move(offset);
        if (ts.movePrevious() && (ts.moveNext() || ts.offset() + ts.token().length() == request.result.getSnapshot().getText().length())) {
            if (!lookBefore && ts.token().id() != JsTokenId.OPERATOR_DOT) {
                ts.movePrevious();
            }
            Token<? extends JsTokenId> token = lookBefore ? LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.EOL)) : ts.token();
            int parenBalancer = 0;
            int partType = 0;
            boolean wasLastDot = lookBefore;
            int offsetFirstRightParen = -1;
            ArrayList<String> exp = new ArrayList<String>();
            while (token.id() != JsTokenId.WHITESPACE && token.id() != JsTokenId.OPERATOR_SEMICOLON && token.id() != JsTokenId.BRACKET_RIGHT_CURLY && token.id() != JsTokenId.BRACKET_LEFT_CURLY && token.id() != JsTokenId.BRACKET_LEFT_PAREN && token.id() != JsTokenId.BLOCK_COMMENT && token.id() != JsTokenId.LINE_COMMENT && token.id() != JsTokenId.OPERATOR_ASSIGNMENT && token.id() != JsTokenId.OPERATOR_PLUS) {
                if (token.id() != JsTokenId.EOL) {
                    if (token.id() != JsTokenId.OPERATOR_DOT) {
                        if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                            ++parenBalancer;
                            partType = 1;
                            if (offsetFirstRightParen == -1) {
                                offsetFirstRightParen = ts.offset();
                            }
                            while (parenBalancer > 0 && ts.movePrevious()) {
                                token = ts.token();
                                if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                                    ++parenBalancer;
                                    continue;
                                }
                                if (token.id() != JsTokenId.BRACKET_LEFT_PAREN) continue;
                                --parenBalancer;
                            }
                        } else if (token.id() == JsTokenId.BRACKET_RIGHT_BRACKET) {
                            ++parenBalancer;
                            partType = 2;
                            while (parenBalancer > 0 && ts.movePrevious()) {
                                token = ts.token();
                                if (token.id() == JsTokenId.BRACKET_RIGHT_BRACKET) {
                                    ++parenBalancer;
                                    continue;
                                }
                                if (token.id() != JsTokenId.BRACKET_LEFT_BRACKET) continue;
                                --parenBalancer;
                            }
                        } else {
                            if (parenBalancer == 0 && "operator".equals(((JsTokenId)token.id()).primaryCategory())) {
                                return exp;
                            }
                            exp.add(token.text().toString());
                            switch (partType) {
                                case 0: {
                                    exp.add("@pro");
                                    break;
                                }
                                case 1: {
                                    exp.add("@mtd");
                                    offsetFirstRightParen = -1;
                                    break;
                                }
                                case 2: {
                                    exp.add("@arr");
                                    break;
                                }
                            }
                            partType = 0;
                            wasLastDot = false;
                        }
                    } else {
                        wasLastDot = true;
                    }
                } else if (!wasLastDot && ts.movePrevious() && (token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() != JsTokenId.OPERATOR_DOT) break;
                if (!ts.movePrevious()) break;
                token = ts.token();
            }
            if (token.id() == JsTokenId.WHITESPACE) {
                if (ts.movePrevious()) {
                    token = LexUtilities.findPrevious(ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.EOL));
                    if (token.id() == JsTokenId.KEYWORD_NEW && !exp.isEmpty()) {
                        exp.remove(exp.size() - 1);
                        exp.add("@pro");
                    } else if (!lookBefore && offsetFirstRightParen > -1) {
                        exp.addAll(this.resolveExpressionChain(request, offsetFirstRightParen - 1, true));
                    }
                }
            } else if (exp.isEmpty() && !lookBefore && offsetFirstRightParen > -1) {
                exp.addAll(this.resolveExpressionChain(request, offsetFirstRightParen - 1, true));
            }
            return exp;
        }
        return Collections.emptyList();
    }

    private void completeObjectMember(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        JsParserResult result = (JsParserResult)request.info;
        JsObject jsObject = (JsObject)((Object)ModelUtils.getDeclarationScope(result.getModel(), request.anchor));
        if (jsObject.getJSKind() == JsElement.Kind.METHOD) {
            jsObject = jsObject.getParent();
        }
        this.completeObjectMembers(jsObject, request, addedItems);
        if ("prototype".equals(jsObject.getName())) {
            this.completeObjectMembers(jsObject.getParent(), request, addedItems);
        }
    }

    private void completeObjectMembers(JsObject jsObject, JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> properties) {
        if (jsObject.getJSKind() == JsElement.Kind.OBJECT || jsObject.getJSKind() == JsElement.Kind.CONSTRUCTOR || jsObject.getJSKind() == JsElement.Kind.OBJECT_LITERAL) {
            for (JsObject jsObject2 : jsObject.getProperties().values()) {
                if (request.completionContext == CompletionContext.OBJECT_MEMBERS && jsObject2.getModifiers().contains(Modifier.PRIVATE) && jsObject2.getModifiers().size() == 1 || jsObject2.isAnonymous()) continue;
                this.addPropertyToMap(request, properties, jsObject2);
            }
        }
        String fqn = jsObject.getFullyQualifiedName();
        FileObject fileObject = request.info.getSnapshot().getSource().getFileObject();
        Collection<IndexedElement> indexedProperties = JsIndex.get(fileObject).getProperties(fqn);
        for (IndexedElement indexedElement : indexedProperties) {
            this.addPropertyToMap(request, properties, indexedElement);
        }
    }

    private void completeInWith(JsCompletionItem.CompletionRequest request, HashMap<String, List<JsElement>> addedItems) {
        int offset = request.anchor;
        Collection<? extends TypeUsage> typesFromWith = ModelUtils.getTypeFromWith(request.result.getModel(), offset);
        if (!typesFromWith.isEmpty()) {
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            JsIndex jsIndex = JsIndex.get(fo);
            Collection<TypeUsage> resolveTypes = ModelUtils.resolveTypes(typesFromWith, request.result, true, true);
            for (TypeUsage type : resolveTypes) {
                JsObject localObject = ModelUtils.findJsObjectByName(request.result.getModel(), type.getType());
                if (localObject != null) {
                    this.addObjectPropertiesToCC(localObject, request, addedItems);
                }
                this.addObjectPropertiesFromIndex(type.getType(), jsIndex, request, addedItems);
            }
        }
    }

    private void completeCallArguments(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        List<TypeUsage> types = this.findPossibleCallArgTypes(request);
        FileObject fo = request.result.getSnapshot().getSource().getFileObject();
        if (types != null && fo != null && !types.isEmpty()) {
            JsIndex jsIndex = JsIndex.get(fo);
            for (TypeUsage type : types) {
                Collection<? extends IndexResult> fromIndex = jsIndex.findByFqn(type.getType(), JsIndex.TERMS_BASIC_INFO);
                for (IndexResult indexResult : fromIndex) {
                    IndexedElement indexElement = IndexedElement.create(indexResult);
                    if (indexElement.getJSKind() != JsElement.Kind.CALLBACK) continue;
                    resultList.add(new JsCompletionItem.JsCallbackCompletionItem((IndexedElement.FunctionIndexedElement)indexElement, request));
                }
            }
        }
    }

    private void completeKeywords(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        for (String keyword : JsKeyWords.KEYWORDS.keySet()) {
            if (!this.startsWith(keyword, request.prefix)) continue;
            resultList.add(new JsCompletionItem.KeywordItem(keyword, request));
        }
    }

    private void completeTagAttributes(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        for (HtmlTagAttribute attribute : this.getAllAttributes()) {
            if (!attribute.getName().startsWith(request.prefix)) continue;
            resultList.add(new JsCompletionItem.JsHtmlAttributeItem(attribute, request));
        }
    }

    private void completeTagIds(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        FileObject fo = request.result.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findIdsByPrefix(request.prefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    if (id.isEmpty()) continue;
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!unique.isEmpty()) {
            Iterator iterator = unique.iterator();
            while (iterator.hasNext()) {
                resultList.add(new JsCompletionItem.CssCompletionItem((String)iterator.next(), request));
            }
        }
    }

    private void completeCSSClassNames(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        FileObject fo = request.result.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findClassesByPrefix(request.prefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    if (id.isEmpty()) continue;
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!unique.isEmpty()) {
            Iterator iterator = unique.iterator();
            while (iterator.hasNext()) {
                resultList.add(new JsCompletionItem.CssCompletionItem((String)iterator.next(), request));
            }
        }
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean processTypeInModel(JsCompletionItem.CompletionRequest request, Model model, TypeUsage type, List<JsObject> lastResolvedObjects, boolean prop, JsIndex index, Map<String, List<JsElement>> addedProperties) {
        if (++this.checkRecursion > 10) {
            return false;
        }
        boolean isFunction = false;
        JsObject jsObject = ModelUtils.findJsObjectByName(model, type.getType());
        if (jsObject != null) {
            lastResolvedObjects.add(jsObject);
        }
        for (JsObject jsObject2 : ModelExtender.getDefault().getExtendingGlobalObjects(request.result.getSnapshot().getSource().getFileObject())) {
            JsObject jsObject3 = ModelUtils.findJsObjectByName(jsObject2, type.getType());
            if (jsObject3 == null || jsObject3 == jsObject2) continue;
            jsObject = jsObject3;
            lastResolvedObjects.add(jsObject);
            break;
        }
        if (jsObject == null || !jsObject.isDeclared()) {
            boolean isObject = type.getType().equals("Object");
            if (prop && !isObject) {
                for (IndexResult indexResult : index.findByFqn(type.getType(), "flag")) {
                    JsElement.Kind kind = IndexedElement.Flag.getJsKind(Integer.parseInt(indexResult.getValue("flag")));
                    if (!kind.isFunction()) continue;
                    isFunction = true;
                }
            }
            if (!isObject) {
                this.addObjectPropertiesFromIndex(type.getType(), index, request, addedProperties);
            }
        } else if (jsObject.getDeclarationName() != null) {
            Collection<? extends TypeUsage> assignments = jsObject.getAssignmentForOffset(jsObject.getDeclarationName().getOffsetRange().getEnd());
            for (TypeUsage typeUsage : assignments) {
                boolean isFun = this.processTypeInModel(request, model, typeUsage, lastResolvedObjects, prop, index, addedProperties);
                isFunction = isFunction ? true : isFun;
            }
        }
        return isFunction;
    }

    private void addObjectPropertiesToCC(JsObject jsObject, JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedProperties) {
        JsObject prototype = jsObject.getProperty("prototype");
        if (prototype != null) {
            this.addObjectPropertiesToCC(prototype, request, addedProperties);
        }
        for (JsObject jsObject2 : jsObject.getProperties().values()) {
            if (jsObject2 instanceof JsFunction && ((JsFunction)jsObject2).isAnonymous() || ModelUtils.getDisplayName(jsObject2.getName()).isEmpty() || jsObject2.getModifiers().contains(Modifier.PRIVATE) || jsObject2.getJSKind().isPropertyGetterSetter()) continue;
            this.addPropertyToMap(request, addedProperties, jsObject2);
        }
    }

    private void addObjectPropertiesFromIndex(String fqn, JsIndex jsIndex, JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedProperties) {
        Collection<IndexedElement> properties = jsIndex.getProperties(fqn);
        for (IndexedElement indexedElement : properties) {
            this.addPropertyToMap(request, addedProperties, indexedElement);
            if (!"prototype".equals(indexedElement.getName())) continue;
            Collection<IndexedElement> protoProperties = jsIndex.getProperties(indexedElement.getFQN());
            for (IndexedElement protoProperty : protoProperties) {
                this.addPropertyToMap(request, addedProperties, protoProperty);
            }
        }
        if (fqn.equals("Element")) {
            request.addHtmlTagAttributes = true;
        }
    }

    private void addPropertyToMap(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedProperties, JsElement property) {
        String name = property.getName();
        if (this.startsWith(name, request.prefix) && !ModelUtils.getDisplayName(property.getName()).isEmpty() && property.getJSKind() != JsElement.Kind.CALLBACK && (!name.equals(request.prefix) || property.isDeclared() || request.anchor != property.getOffset())) {
            List<JsElement> elements = addedProperties.get(name);
            if (!"prototype".equals(name)) {
                if (elements == null || elements.isEmpty()) {
                    ArrayList<JsElement> properties = new ArrayList<JsElement>(1);
                    properties.add(property);
                    addedProperties.put(name, properties);
                } else if (property.isDeclared()) {
                    boolean addAsNew = true;
                    if (!elements.isEmpty()) {
                        for (int i = 0; i < elements.size(); ++i) {
                            JsElement element = elements.get(i);
                            FileObject fo = element.getFileObject();
                            if (!element.isDeclared() || fo != null && fo.equals(property.getFileObject())) {
                                if (!element.isDeclared() || element.getOffsetRange() == OffsetRange.NONE && property.getOffsetRange() != OffsetRange.NONE) {
                                    elements.remove(i);
                                    elements.add(property);
                                    addAsNew = false;
                                    break;
                                }
                                if (fo == null || !fo.equals(property.getFileObject())) continue;
                                addAsNew = false;
                                break;
                            }
                            if (!element.isPlatform() || !property.isPlatform()) continue;
                            addAsNew = false;
                            break;
                        }
                    }
                    if (addAsNew) {
                        elements.add(property);
                    }
                }
            } else if (elements == null && property.isPlatform()) {
                ArrayList<JsElement> properties = new ArrayList<JsElement>(1);
                properties.add(property);
                addedProperties.put(name, properties);
            }
        }
    }

    private Map<String, List<JsElement>> getDomCompletionResults(JsCompletionItem.CompletionRequest request) {
        HashMap<String, List<JsElement>> result = new HashMap<String, List<JsElement>>(1);
        result.putAll(this.getCompletionFromExpressionChain(request, WINDOW_EXPRESSION_CHAIN));
        return result;
    }

    private static int getPrefixIndexFromSequence(String prefix) {
        int spaceIndex = prefix.lastIndexOf(" ") + 1;
        int dotIndex = prefix.lastIndexOf(".") + 1;
        int hashIndex = prefix.lastIndexOf("#") + 1;
        int bracketIndex = prefix.lastIndexOf("[") + 1;
        int columnIndex = prefix.lastIndexOf(":") + 1;
        int parenIndex = prefix.lastIndexOf("(") + 1;
        int slashIndex = prefix.lastIndexOf(47) + 1;
        return Math.max(0, Math.max(hashIndex, Math.max(dotIndex, Math.max(parenIndex, Math.max(columnIndex, Math.max(bracketIndex, Math.max(spaceIndex, slashIndex)))))));
    }

    private Collection<HtmlTagAttribute> getAllAttributes() {
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        HashMap<String, HtmlTagAttribute> result = new HashMap<String, HtmlTagAttribute>();
        for (HtmlTag htmlTag : htmlModel.getAllTags()) {
            for (HtmlTagAttribute htmlTagAttribute : htmlTag.getAttributes()) {
                if (result.containsKey(htmlTagAttribute.getName())) continue;
                result.put(htmlTagAttribute.getName(), htmlTagAttribute);
            }
        }
        return result.values();
    }
}

