/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.impl.ModelExtender;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.spi.model.TypeDisplayNameConvertor;

public class Utils {
    public static Collection<String> getDisplayNames(Collection<? extends Type> types) {
        ArrayList<String> displayNames = new ArrayList<String>(types.size());
        List<TypeDisplayNameConvertor> convertors = ModelExtender.getDefault().getTypeDisplayNameConvertors();
        for (Type type : types) {
            TypeDisplayNameConvertor convertor;
            String displayName = null;
            Iterator<TypeDisplayNameConvertor> i$ = convertors.iterator();
            while (i$.hasNext() && ((displayName = (convertor = i$.next()).getDisplayName(type)) == null || displayName.isEmpty() || displayName.equals(type.getType()))) {
            }
            if (displayName == null || displayName.isEmpty() || displayName.equals(type.getType())) {
                displayName = ModelUtils.getDisplayName(type.getType());
            }
            if (displayName == null || displayName.isEmpty() || displayNames.contains(displayName)) continue;
            displayNames.add(displayName);
        }
        Collections.sort(displayNames);
        return displayNames;
    }

    public static String getDisplayName(Type type) {
        TypeDisplayNameConvertor convertor;
        List<TypeDisplayNameConvertor> convertors = ModelExtender.getDefault().getTypeDisplayNameConvertors();
        String displayName = null;
        Iterator<TypeDisplayNameConvertor> i$ = convertors.iterator();
        while (i$.hasNext() && ((displayName = (convertor = i$.next()).getDisplayName(type)) == null || displayName.isEmpty() || displayName.equals(type.getType()))) {
        }
        if (displayName == null || displayName.isEmpty() || displayName.equals(type.getType())) {
            displayName = ModelUtils.getDisplayName(type.getType());
        }
        return displayName;
    }

    public static Collection<String> getDisplayNamesFromStrings(Collection<String> fqns) {
        ArrayList<String> displayNames = new ArrayList<String>(fqns.size());
        for (String fqn : fqns) {
            String displayName = ModelUtils.getDisplayName(fqn);
            if (displayName.length() == 0) continue;
            displayNames.add(displayName);
        }
        return displayNames;
    }
}

