/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectReference;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.OccurrenceImpl;

public class OccurrencesSupport {
    private static final Logger LOGGER = Logger.getLogger(OccurrencesSupport.class.getName());
    private final Model model;

    public OccurrencesSupport(Model model) {
        this.model = model;
    }

    public Occurrence getOccurrence(int offset) {
        long start = System.currentTimeMillis();
        JsObject object = this.model.getGlobalObject();
        Occurrence result = this.findOccurrence(object, offset);
        if (result == null) {
            result = this.findDeclaration(object, offset);
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Computing getOccurences({0}) took {1}ms. Returns {2}", new Object[]{offset, end - start, result});
        return result;
    }

    private Occurrence findOccurrence(JsObject object, int offset) {
        Occurrence result = null;
        JsElement.Kind kind = object.getJSKind();
        for (Occurrence occurrence : object.getOccurrences()) {
            if (!occurrence.getOffsetRange().containsInclusive(offset)) continue;
            return occurrence;
        }
        if (kind.isFunction() || kind == JsElement.Kind.CATCH_BLOCK) {
            JsObject jsObject;
            Iterator<Object> i$ = ((JsFunction)object).getParameters().iterator();
            while (i$.hasNext() && (result = this.findOccurrence(jsObject = (JsObject)i$.next(), offset)) == null) {
            }
            if (result != null) {
                return result;
            }
        }
        if (!(object instanceof JsObjectReference) || !ModelUtils.isDescendant(object, ((JsObjectReference)object).getOriginal())) {
            for (JsObject jsObject : object.getProperties().values()) {
                if (!(jsObject instanceof JsObjectReference) || ((JsObjectReference)jsObject).getOriginal().isAnonymous()) {
                    result = this.findOccurrence(jsObject, offset);
                    if (result == null) continue;
                    break;
                }
                for (Occurrence occurrence : jsObject.getOccurrences()) {
                    if (!occurrence.getOffsetRange().containsInclusive(offset)) continue;
                    return occurrence;
                }
            }
        }
        return result;
    }

    private Occurrence findDeclaration(JsObject object, int offset) {
        Occurrence result;
        block6: {
            result = null;
            JsElement.Kind kind = object.getJSKind();
            if (kind != JsElement.Kind.ANONYMOUS_OBJECT && kind != JsElement.Kind.WITH_OBJECT && object.getDeclarationName() != null && object.getDeclarationName().getOffsetRange().containsInclusive(offset) && !ModelUtils.isGlobal(object)) {
                if (kind.isPropertyGetterSetter()) {
                    String propertyName = object.getName();
                    propertyName = propertyName.substring(propertyName.lastIndexOf(32) + 1);
                    JsObject jsObject = object.getParent().getProperty(propertyName);
                    if (jsObject != null) {
                        return new OccurrenceImpl(jsObject.getDeclarationName().getOffsetRange(), jsObject);
                    }
                }
                result = new OccurrenceImpl(object.getDeclarationName().getOffsetRange(), object);
            }
            if (result == null && (kind.isFunction() || kind == JsElement.Kind.CATCH_BLOCK)) {
                for (JsObject jsObject : ((JsFunction)object).getParameters()) {
                    if (!jsObject.getDeclarationName().getOffsetRange().containsInclusive(offset)) continue;
                    result = new OccurrenceImpl(jsObject.getDeclarationName().getOffsetRange(), object);
                    return result;
                }
            }
            if (result != null) break block6;
            for (JsObject jsObject : object.getProperties().values()) {
                if (!(jsObject instanceof JsObjectReference) && (result = this.findDeclaration(jsObject, offset)) != null) break;
            }
        }
        return result;
    }
}

