/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.OccurrencesSupport;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectReference;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class OccurrencesFinderImpl
extends OccurrencesFinder<JsParserResult> {
    private Map<OffsetRange, ColoringAttributes> range2Attribs;
    private int caretPosition;
    private volatile boolean cancelled;

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void run(JsParserResult result, SchedulerEvent event) {
        this.range2Attribs = null;
        if (this.cancelled) {
            this.cancelled = false;
            return;
        }
        int offset = result.getSnapshot().getEmbeddedOffset(this.caretPosition);
        Set<OffsetRange> ranges = OccurrencesFinderImpl.findOccurrenceRanges(result, offset);
        this.range2Attribs = new HashMap<OffsetRange, ColoringAttributes>();
        if (this.cancelled) {
            this.cancelled = false;
            return;
        }
        for (OffsetRange offsetRange : ranges) {
            this.range2Attribs.put(ModelUtils.documentOffsetRange(result, offsetRange.getStart(), offsetRange.getEnd()), ColoringAttributes.MARK_OCCURRENCES);
        }
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private static List<OffsetRange> findMemberUsage(JsObject object, String fqnType, String property, int offset, List<String> processedObjects) {
        Collection<? extends TypeUsage> assignments;
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        if (ModelUtils.wasProcessed(object, processedObjects)) {
            return Collections.emptyList();
        }
        String fqn = fqnType;
        if (fqn.endsWith(".prototype")) {
            fqn = fqn.substring(0, fqn.length() - 10);
        }
        if (!(assignments = object.getAssignments()).isEmpty()) {
            for (TypeUsage typeUsage : assignments) {
                JsObject member;
                if (!typeUsage.getType().equals(fqn) || (member = object.getProperty(property)) == null) continue;
                result.add(member.getDeclarationName().getOffsetRange());
                List<Occurrence> occurrences = member.getOccurrences();
                for (Occurrence occurence : occurrences) {
                    result.add(occurence.getOffsetRange());
                }
            }
        }
        if (!(object instanceof JsObjectReference) || !ModelUtils.isDescendant(object, ((JsObjectReference)object).getOriginal())) {
            for (JsObject jsObject : object.getProperties().values()) {
                result.addAll(OccurrencesFinderImpl.findMemberUsage(jsObject, fqn, property, offset, processedObjects));
            }
        }
        return result;
    }

    public static Set<OffsetRange> findOccurrenceRanges(JsParserResult result, int caretPosition) {
        HashSet<OffsetRange> offsets = new HashSet<OffsetRange>();
        Model model = result.getModel();
        OccurrencesSupport os = model.getOccurrencesSupport();
        Occurrence occurrence = os.getOccurrence(caretPosition);
        if (occurrence != null) {
            for (JsObject jsObject : occurrence.getDeclarations()) {
                if (jsObject == null || jsObject.getDeclarationName() == null) continue;
                offsets.add(jsObject.getDeclarationName().getOffsetRange());
                for (Occurrence oc : jsObject.getOccurrences()) {
                    offsets.add(oc.getOffsetRange());
                }
                JsObject parent = jsObject.getParent();
                if (parent == null || parent.getJSKind() == JsElement.Kind.FILE || jsObject.getJSKind() == JsElement.Kind.PARAMETER || jsObject.getModifiers().contains(Modifier.PRIVATE)) continue;
                Collection<? extends TypeUsage> types = parent.getAssignmentForOffset(caretPosition);
                if (types.isEmpty()) {
                    types = parent.getAssignments();
                }
                for (Type type : types) {
                    JsObject declaration = ModelUtils.findJsObjectByName(model, type.getType());
                    if (declaration != null && !jsObject.getName().equals(declaration.getName())) {
                        JsObject prototype = declaration.getProperty("prototype");
                        if ((declaration = declaration.getProperty(jsObject.getName())) == null && prototype != null) {
                            declaration = prototype.getProperty(jsObject.getName());
                        }
                    }
                    if (declaration == null || declaration.getModifiers().contains(Modifier.PRIVATE)) continue;
                    offsets.add(declaration.getDeclarationName().getOffsetRange());
                    for (Occurrence oc : declaration.getOccurrences()) {
                        offsets.add(oc.getOffsetRange());
                    }
                }
                if (!types.isEmpty()) continue;
                List<OffsetRange> usages = OccurrencesFinderImpl.findMemberUsage(result.getModel().getGlobalObject(), parent.getFullyQualifiedName(), jsObject.getName(), caretPosition, new ArrayList<String>());
                for (OffsetRange range : usages) {
                    offsets.add(range);
                }
            }
        }
        return offsets;
    }
}

