/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.actions;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.spi.framework.actions.GoToActionAction;
import org.netbeans.modules.php.symfony.util.SymfonyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class SymfonyGoToActionAction
extends GoToActionAction {
    private static final long serialVersionUID = 89756313874L;
    private static final Pattern ACTION_METHOD_NAME = Pattern.compile("^(\\w+)[A-Z]");
    private final FileObject fo;

    public SymfonyGoToActionAction(FileObject fo) {
        assert (SymfonyUtils.isViewWithAction(fo));
        this.fo = fo;
    }

    public boolean goToAction() {
        FileObject action = SymfonyUtils.getAction(this.fo);
        if (action != null) {
            UiUtils.open((FileObject)action, (int)this.getActionMethodOffset(action));
            return true;
        }
        return false;
    }

    private int getActionMethodOffset(FileObject action) {
        String actionMethodName = SymfonyGoToActionAction.getActionMethodName(this.fo.getName());
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        Iterator i$ = editorSupport.getClasses(action).iterator();
        if (i$.hasNext()) {
            PhpClass phpClass = (PhpClass)i$.next();
            if (actionMethodName != null) {
                for (PhpClass.Method method : phpClass.getMethods()) {
                    if (!actionMethodName.equals(method.getName())) continue;
                    return method.getOffset();
                }
            }
            return phpClass.getOffset();
        }
        return 0;
    }

    static String getActionMethodName(String filename) {
        Matcher matcher = ACTION_METHOD_NAME.matcher(filename);
        if (matcher.find()) {
            String group = matcher.group(1);
            return "execute" + group.substring(0, 1).toUpperCase() + group.substring(1);
        }
        return null;
    }
}

