/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AllSourceFileFilter
extends FileAndFileObjectFilter {
    private static AllSourceFileFilter instance = null;
    private static String[] suffixes = null;

    public static AllSourceFileFilter getInstance() {
        if (instance == null) {
            instance = new AllSourceFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AllSourceFileFilter.class, (String)"FILECHOOSER_All_SOURCES_FILEFILTER");
    }

    @Override
    protected boolean mimeAccept(File f) {
        if (FileUtil.getExtension((String)f.getName()).length() == 0) {
            return "text/x-h".equals(MIMESupport.getSourceFileMIMEType(f));
        }
        return super.mimeAccept(f);
    }

    @Override
    protected boolean mimeAccept(FileObject f) {
        if (f.getExt().isEmpty()) {
            "text/x-h".equals(MIMESupport.getSourceFileMIMEType(f));
        }
        return super.mimeAccept(f);
    }

    @Override
    public String[] getSuffixes() {
        if (suffixes == null) {
            suffixes = this.getAllSuffixes();
        }
        return suffixes;
    }

    private String[] getAllSuffixes() {
        HashSet<String> allSuffixes = new HashSet<String>();
        allSuffixes.addAll(MIMEExtensions.get("text/x-c++").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-c").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-h").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-fortran").getValues());
        allSuffixes.addAll(MIMEExtensions.get("text/x-asm").getValues());
        return allSuffixes.toArray(new String[allSuffixes.size()]);
    }
}

