/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.web.debug.util.Utils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FirstSourceURLProvider
extends SourcePathProvider {
    private static final String[] NO_SOURCE_ROOTS = new String[0];
    private final JPDADebugger debugger;
    private final ThreadLocal<Boolean> evaluating = new ThreadLocal();
    private final Map<JPDAClassType, String> urlsByClassType = new HashMap<JPDAClassType, String>();

    public FirstSourceURLProvider(ContextProvider context) {
        this.debugger = (JPDADebugger)context.lookupFirst(null, JPDADebugger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String relativePath, boolean global) {
        if (!Utils.hasContext(relativePath)) {
            return null;
        }
        Boolean isEval = this.evaluating.get();
        if (Boolean.TRUE.equals(isEval)) {
            return null;
        }
        JPDAClassType currentType = this.getCurrentType();
        if (currentType == null) {
            return null;
        }
        Map<JPDAClassType, String> map = this.urlsByClassType;
        synchronized (map) {
            if (this.urlsByClassType.containsKey(currentType)) {
                String url = this.urlsByClassType.get(currentType);
                return url;
            }
        }
        String url = null;
        try {
            FileObject fo;
            FileObject docBase;
            this.evaluating.set(Boolean.TRUE);
            Variable contextPathVar = this.debugger.evaluate("request.getContextPath()");
            String contextPath = contextPathVar.getValue();
            if (contextPath.startsWith("\"") && contextPath.endsWith("\"")) {
                contextPath = contextPath.substring(1, contextPath.length() - 1);
            }
            if ((docBase = Utils.getDocumentBaseForContextPath(contextPath)) != null && (fo = docBase.getFileObject(relativePath)) != null) {
                url = fo.toURL().toExternalForm();
            }
        }
        catch (InvalidExpressionException ex) {
        }
        finally {
            this.evaluating.remove();
        }
        Map<JPDAClassType, String> map2 = this.urlsByClassType;
        synchronized (map2) {
            this.urlsByClassType.put(currentType, url);
        }
        return url;
    }

    private JPDAClassType getCurrentType() {
        CallStackFrame currentCallStackFrame = this.debugger.getCurrentCallStackFrame();
        if (currentCallStackFrame == null) {
            return null;
        }
        try {
            Method getClassTypeMethod = currentCallStackFrame.getClass().getMethod("getClassType", new Class[0]);
            return (JPDAClassType)getClassTypeMethod.invoke((Object)currentCallStackFrame, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        return null;
    }

    public String[] getSourceRoots() {
        return NO_SOURCE_ROOTS;
    }

    public void setSourceRoots(String[] sourceRoots) {
    }

    public String[] getOriginalSourceRoots() {
        return NO_SOURCE_ROOTS;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

