/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.GenericToolbar;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.api.icons.Icons;

public class DropdownButton
extends JPanel {
    private static final Icon DROPDOWN_ICON = Icons.getIcon((String)"GeneralIcons.PopupArrow");
    private static final int DROPDOWN_ICON_WIDTH = DROPDOWN_ICON.getIconWidth();
    private static final int DROPDOWN_ICON_HEIGHT = DROPDOWN_ICON.getIconHeight();
    private static final String NO_ACTION = "none";
    private static final String POPUP_ACTION = "displayPopup";
    private static final int POPUP_EXTENT;
    private static final int POPUP_OFFSET;
    private static final int POPUP_XWIDTH;
    private static final int POPUP_MARGIN;
    private final JComponent container;
    private final Button button;
    private final Popup popup;
    private boolean pushed;

    public DropdownButton(String text, Icon icon, boolean toolbar) {
        this.setOpaque(false);
        if (toolbar) {
            GenericToolbar tb = new GenericToolbar(){

                public void doLayout() {
                    for (Component c : this.getComponents()) {
                        c.setBounds(0, 0, this.getWidth(), this.getHeight());
                    }
                }

                public void paint(Graphics g) {
                    this.paintChildren(g);
                }
            };
            tb.setFloatable(false);
            tb.setFocusable(false);
            this.container = tb;
            this.add(this.container);
        } else {
            this.container = this;
        }
        this.button = new Button(text, icon);
        this.container.add((Component)((Object)this.button));
        this.popup = new Popup();
        this.container.add(this.popup);
        KeyStroke down = KeyStroke.getKeyStroke(40, 0);
        this.container.getInputMap(1).put(down, POPUP_ACTION);
        this.container.getActionMap().put(POPUP_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DropdownButton.this.displayPopup();
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.button != null) {
            this.button.setEnabled(enabled);
            if (enabled) {
                this.exposeButton();
            } else {
                this.exposePopup();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.button == null ? false : this.button.isEnabled();
    }

    public void setPopupEnabled(boolean enabled) {
        if (this.popup != null) {
            this.popup.setEnabled(enabled);
        }
    }

    public boolean isPopupEnabled() {
        return this.popup == null ? false : this.popup.isEnabled();
    }

    public void setPushed(boolean p) {
        this.pushed = p;
        this.repaint();
    }

    public boolean isPushed() {
        return this.pushed;
    }

    @Override
    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }

    public void setPushedToolTipText(String text) {
        this.button.putClientProperty("PUSHED_TOOLTIP", text);
    }

    public void setPopupToolTipText(String text) {
        this.popup.setToolTipText(text);
    }

    public void setText(String text) {
        if (this.button != null) {
            String _text = this.button.getText();
            this.button.setText(text);
            Container parent = this.getParent();
            if (!Objects.equals(text, _text) && parent != null) {
                ((Component)parent).invalidate();
                parent.revalidate();
                parent.repaint();
            }
        }
    }

    public String getText() {
        return this.button == null ? null : this.button.getText();
    }

    public void setIcon(Icon icon) {
        if (this.button != null) {
            Icon _icon = this.button.getIcon();
            this.button.setIcon(icon);
            Container parent = this.getParent();
            if (!Objects.equals(icon, _icon) && parent != null) {
                ((Component)parent).invalidate();
                parent.revalidate();
                parent.repaint();
            }
        }
    }

    public Icon getIcon() {
        return this.button == null ? null : this.button.getIcon();
    }

    public void clickPopup() {
        if (this.popup != null) {
            this.popup.doClick();
        }
    }

    public void displayPopup() {
        JPopupMenu menu = new JPopupMenu();
        this.populatePopup(menu);
        if (menu.getComponentCount() > 0) {
            Dimension size = menu.getPreferredSize();
            size.width = Math.max(size.width, this.getWidth());
            menu.setPreferredSize(size);
            menu.show(this, 0, this.getHeight());
        }
    }

    protected void populatePopup(JPopupMenu menu) {
    }

    protected void performAction() {
    }

    @Override
    public void paint(Graphics g) {
        this.paintChildren(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        DROPDOWN_ICON.paintIcon(this, g, this.getWidth() - DROPDOWN_ICON_WIDTH - POPUP_OFFSET, (this.getHeight() - DROPDOWN_ICON_HEIGHT) / 2);
        if (this.pushed || !this.button.isEnabled() || this.container.getComponent(0) == this.popup || this.button.getModel().isRollover() || this.button.isFocusOwner()) {
            g.setColor(Color.GRAY);
            g.drawLine(this.getWidth() - POPUP_EXTENT, POPUP_MARGIN, this.getWidth() - POPUP_EXTENT, this.getHeight() - POPUP_MARGIN);
        }
    }

    private void processChildMouseEvent(MouseEvent e) {
        if (e.getX() >= this.getWidth() - POPUP_EXTENT && this.contains(e.getX(), e.getY())) {
            if (this.exposePopup()) {
                this.button.processEventImpl(DropdownButton.fromEvent(e, (Component)((Object)this.button), 505));
                this.popup.processEventImpl(DropdownButton.fromEvent(e, this.popup, 504));
            } else {
                this.popup.processEventImpl(e);
            }
        } else if (this.exposeButton()) {
            this.popup.processEventImpl(DropdownButton.fromEvent(e, this.popup, 505));
            if (this.contains(e.getX(), e.getY())) {
                this.button.processEventImpl(DropdownButton.fromEvent(e, (Component)((Object)this.button), 504));
            }
        } else {
            this.button.processEventImpl(e);
        }
    }

    private static MouseEvent fromEvent(MouseEvent e, Component source, int id) {
        return new MouseEvent(source, id, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
    }

    private boolean exposeButton() {
        if (this.container.getComponent(0) == this.button) {
            return false;
        }
        Object c = this.button.isEnabled() ? this.button : this.popup;
        boolean focus = ((Component)c).isFocusOwner();
        if (focus) {
            this.setFocusable(true);
            this.requestFocusInWindow();
        }
        this.container.add(this.popup);
        if (focus) {
            ((Component)c).requestFocusInWindow();
            this.setFocusable(false);
        }
        this.repaint();
        return true;
    }

    private boolean exposePopup() {
        if (this.container.getComponent(0) == this.popup) {
            return false;
        }
        Object c = this.button.isEnabled() ? this.button : this.popup;
        boolean focus = ((Component)c).isFocusOwner();
        if (focus) {
            this.setFocusable(true);
            this.requestFocusInWindow();
        }
        this.container.add((Component)((Object)this.button));
        if (focus) {
            ((Component)c).requestFocusInWindow();
            this.setFocusable(false);
        }
        this.repaint();
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.button.getPreferredSize();
        d.width += POPUP_EXTENT + POPUP_XWIDTH;
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        for (Component c : this.getComponents()) {
            c.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    static {
        if (UIUtils.isWindowsLookAndFeel()) {
            POPUP_EXTENT = 15;
            POPUP_OFFSET = 4;
            POPUP_XWIDTH = -1;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isNimbus()) {
            POPUP_EXTENT = 17;
            POPUP_OFFSET = 6;
            POPUP_XWIDTH = -1;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isMetalLookAndFeel()) {
            POPUP_EXTENT = 16;
            POPUP_OFFSET = 5;
            POPUP_XWIDTH = -2;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isAquaLookAndFeel()) {
            POPUP_EXTENT = 19;
            POPUP_OFFSET = 7;
            POPUP_XWIDTH = -8;
            POPUP_MARGIN = 6;
        } else {
            POPUP_EXTENT = 16;
            POPUP_OFFSET = 5;
            POPUP_XWIDTH = -2;
            POPUP_MARGIN = 6;
        }
    }

    private class Popup
    extends JButton {
        Popup() {
            super(" ");
            this.putClientProperty("MetalListener", new Object());
            this.setModel(new DefaultButtonModel(){

                @Override
                public boolean isRollover() {
                    return super.isRollover() || DropdownButton.this.pushed;
                }
            });
            this.setHorizontalAlignment(10);
            this.setDefaultCapable(false);
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0, false), DropdownButton.NO_ACTION);
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0, true), DropdownButton.NO_ACTION);
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            super.fireActionPerformed(e);
            DropdownButton.this.displayPopup();
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (!(e instanceof MouseEvent)) {
                this.processEventImpl(e);
            } else {
                DropdownButton.this.processChildMouseEvent((MouseEvent)e);
            }
        }

        private void processEventImpl(AWTEvent e) {
            super.processEvent(e);
            if (e.getID() == 501) {
                if (this.isFocusable()) {
                    this.requestFocus();
                } else {
                    DropdownButton.this.button.requestFocus();
                }
            }
        }

        @Override
        public boolean hasFocus() {
            return this.isFocusable() ? super.hasFocus() : DropdownButton.this.button.hasFocus();
        }

        @Override
        public boolean isFocusable() {
            return !DropdownButton.this.button.isEnabled();
        }

        @Override
        public void paint(Graphics g) {
            if (DropdownButton.this.pushed || !DropdownButton.this.button.isEnabled() || DropdownButton.this.container.getComponent(0) == this) {
                Rectangle c = g.getClipBounds();
                g.setClip(this.getWidth() - POPUP_EXTENT, 0, POPUP_EXTENT, this.getHeight());
                super.paint(g);
                g.setClip(c);
            }
        }

        @Override
        public void repaint() {
            DropdownButton.this.repaint();
        }
    }

    private class Button
    extends SmallButton {
        Button(String text, Icon icon) {
            super(text, icon);
            this.putClientProperty("MetalListener", new Object());
            if (UIUtils.isAquaLookAndFeel()) {
                this.putClientProperty("JComponent.sizeVariant", "regular");
            }
            this.setModel(new DefaultButtonModel(){

                @Override
                public boolean isRollover() {
                    return super.isRollover() || this.isEnabled() && DropdownButton.this.popup != null && DropdownButton.this.popup.getModel().isRollover();
                }

                @Override
                public boolean isPressed() {
                    return DropdownButton.this.pushed || super.isPressed();
                }

                @Override
                public boolean isArmed() {
                    return DropdownButton.this.pushed || super.isArmed();
                }
            });
            this.setHorizontalAlignment(10);
            this.setDefaultCapable(false);
        }

        public String getToolTipText() {
            Object pushedTT;
            if (DropdownButton.this.pushed && (pushedTT = this.getClientProperty("PUSHED_TOOLTIP")) != null) {
                return pushedTT.toString();
            }
            return super.getToolTipText();
        }

        protected void fireActionPerformed(ActionEvent e) {
            super.fireActionPerformed(e);
            DropdownButton.this.performAction();
        }

        protected void processEvent(AWTEvent e) {
            if (!(e instanceof MouseEvent)) {
                this.processEventImpl(e);
            } else {
                DropdownButton.this.processChildMouseEvent((MouseEvent)e);
            }
        }

        private void processEventImpl(AWTEvent e) {
            super.processEvent(e);
        }

        public boolean hasFocus() {
            return this.isEnabled() ? super.hasFocus() : DropdownButton.this.popup.hasFocus();
        }

        public void paint(Graphics g) {
            Rectangle c = g.getClipBounds();
            if (DropdownButton.this.pushed || !this.isEnabled() || DropdownButton.this.container.getComponent(0) != this) {
                g.setClip(0, 0, this.getWidth() - POPUP_EXTENT, this.getHeight());
            }
            super.paint(g);
            g.setClip(c);
        }

        public void repaint() {
            DropdownButton.this.repaint();
        }

        public Insets getMargin() {
            Insets i = super.getMargin();
            if (UIUtils.isNimbusLookAndFeel()) {
                if (i == null) {
                    i = new Insets(0, 2, 0, 2);
                } else {
                    i.left = 2;
                    i.right = 2;
                }
            } else if (UIUtils.isAquaLookAndFeel()) {
                if (i == null) {
                    i = new Insets(0, -6, 0, 0);
                } else {
                    i.left = -6;
                    i.right = 0;
                }
            }
            return i;
        }
    }
}

