/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.Bundle;
import org.netbeans.modules.java.hints.introduce.InstanceRefFinder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class InitializerCanBeStatic {
    public static ErrorDescription run(HintContext ctx) {
        TreePath path = ctx.getPath();
        if (((BlockTree)path.getLeaf()).isStatic()) {
            return null;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        Tree l = parentPath.getLeaf();
        if (!(l instanceof ClassTree)) {
            return null;
        }
        InstanceRefFinder finder = new InstanceRefFinder(ctx.getInfo(), path);
        finder.process();
        if (finder.containsInstanceReferences() || finder.containsReferencesToSuper()) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)path, (String)Bundle.TEXT_InitializerCanBeStatic(), (Fix[])new Fix[]{new MakeInitStatic(TreePathHandle.create((TreePath)path, (CompilationInfo)ctx.getInfo())).toEditorFix()});
    }

    private static class MakeInitStatic
    extends JavaFix {
        public MakeInitStatic(TreePathHandle handle) {
            super(handle);
        }

        protected String getText() {
            return Bundle.FIX_InitializerCanBeStatic();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            Tree t = ctx.getPath().getLeaf();
            if (t.getKind() != Tree.Kind.BLOCK) {
                return;
            }
            BlockTree bl = (BlockTree)t;
            WorkingCopy wc = ctx.getWorkingCopy();
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
            gu.importComments((Tree)bl, wc.getCompilationUnit());
            TreeMaker mk = wc.getTreeMaker();
            BlockTree nbl = mk.Block(bl.getStatements(), true);
            gu.copyComments((Tree)bl, (Tree)nbl, true);
            gu.copyComments((Tree)bl, (Tree)nbl, false);
            wc.rewrite((Tree)bl, (Tree)nbl);
        }
    }
}

