/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class InfiniteRecursion {
    private static final boolean DEFAUL_EXCLUDE_OVERRIDABLES = false;
    public static final String OPTION_EXCLUDE_OVERRIDABLES = "no.overridables";

    public static ErrorDescription run(HintContext ctx) {
        RecursionVisitor visitor;
        State result;
        Tree leaf = ctx.getPath().getLeaf();
        if (leaf.getKind() != Tree.Kind.METHOD) {
            return null;
        }
        MethodTree mt = (MethodTree)leaf;
        Element ee = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (ee == null || ee.getKind() != ElementKind.METHOD || mt.getBody() == null) {
            return null;
        }
        boolean overridable = false;
        boolean excludeOverridables = ctx.getPreferences().getBoolean(OPTION_EXCLUDE_OVERRIDABLES, false);
        Set<Modifier> mods = ee.getModifiers();
        if (!(mods.contains((Object)Modifier.STATIC) || mods.contains((Object)Modifier.PRIVATE) || mods.contains((Object)Modifier.FINAL))) {
            TypeElement clazz = ctx.getInfo().getElementUtilities().enclosingTypeElement(ee);
            if (clazz == null) {
                return null;
            }
            if (!clazz.getModifiers().contains((Object)Modifier.PRIVATE) && !clazz.getModifiers().contains((Object)Modifier.FINAL)) {
                for (ExecutableElement ce : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
                    if (ce.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    if (excludeOverridables) {
                        return null;
                    }
                    overridable = true;
                }
            }
        }
        if ((result = (State)((Object)(visitor = new RecursionVisitor(ctx.getInfo(), (ExecutableElement)ee)).scan(new TreePath(ctx.getPath(), mt.getBody()), null))) == State.MUST) {
            TreePath somePoint = visitor.recursionPoints.isEmpty() ? ctx.getPath() : (TreePath)visitor.recursionPoints.get(0);
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)somePoint, (String)(overridable ? Bundle.ERR_MethodMayRecurse(mt.getName().toString()) : Bundle.ERR_MethodWillRecurse(mt.getName().toString())), (Fix[])new Fix[0]);
        }
        return null;
    }

    private static class RecursionVisitor
    extends TreePathScanner<State, Void> {
        private final CompilationInfo ci;
        private final ExecutableElement checkMethod;
        private State knownResult;
        private Set breakContinueJumps = new HashSet();
        private final Deque<Tree> breakContinueTargets = new LinkedList<Tree>();
        private Tree currentBreakTarget;
        private boolean definitePath;
        private final List<TreePath> recursionPoints = new LinkedList<TreePath>();
        private Tree thisTree;

        private void registerBreakTarget(Tree t) {
            if (this.currentBreakTarget != null && this.currentBreakTarget != t) {
                this.breakContinueTargets.offer(this.currentBreakTarget);
            }
            this.currentBreakTarget = t;
        }

        public RecursionVisitor(CompilationInfo ci, ExecutableElement checkMethod) {
            this.ci = ci;
            this.checkMethod = checkMethod;
        }

        @Override
        public State scan(Tree tree, Void p) {
            if (this.knownResult != null) {
                return this.knownResult;
            }
            State s = (State)((Object)super.scan(tree, p));
            if (s == State.NO) {
                this.knownResult = null;
                this.recursionPoints.clear();
            }
            if (tree == this.currentBreakTarget) {
                this.currentBreakTarget = this.breakContinueTargets.poll();
                this.breakContinueTargets.remove(tree);
            }
            return s == null ? State.NO : s;
        }

        @Override
        public State scan(Iterable<? extends Tree> nodes, Void p) {
            State s = (State)((Object)super.scan(nodes, p));
            return s == null ? State.NO : s;
        }

        @Override
        public State reduce(State r1, State r2) {
            if (this.knownResult != null) {
                return this.knownResult;
            }
            if (r1 == null) {
                return r2;
            }
            if (r2 == null) {
                return r1;
            }
            return r1.append(r2);
        }

        private boolean returnIfRecurse(State s) {
            if (s == State.MUST || s == State.RETURN) {
                this.knownResult = s;
            }
            return s == State.MUST;
        }

        @Override
        public State visitBinary(BinaryTree node, Void p) {
            State s1 = this.scan((Tree)node.getLeftOperand(), p);
            if (this.returnIfRecurse(s1)) {
                return s1;
            }
            Object result = null;
            if ((node.getKind() == Tree.Kind.CONDITIONAL_AND || node.getKind() == Tree.Kind.CONDITIONAL_OR) && (result = ArithmeticUtilities.compute(this.ci, new TreePath(this.getCurrentPath(), node.getLeftOperand()), true, true)) != null && result == Boolean.TRUE == (node.getKind() == Tree.Kind.CONDITIONAL_OR)) {
                return State.NO;
            }
            boolean saveDefinite = this.definitePath;
            this.definitePath = result != null;
            State s2 = this.scan((Tree)node.getRightOperand(), p);
            this.returnIfRecurse(s2);
            this.definitePath = saveDefinite;
            this.thisTree = null;
            return s2;
        }

        @Override
        public State visitIdentifier(IdentifierTree node, Void p) {
            if (node.getName().contentEquals("this")) {
                this.thisTree = node;
            }
            return (State)((Object)super.visitIdentifier(node, p));
        }

        @Override
        public State visitMemberSelect(MemberSelectTree node, Void p) {
            Element el;
            this.thisTree = null;
            State s = (State)((Object)super.visitMemberSelect(node, p));
            if (this.thisTree != null && ((el = this.ci.getTrees().getElement(this.getCurrentPath())) == null || el.getKind() != ElementKind.METHOD)) {
                this.thisTree = null;
            }
            return s;
        }

        @Override
        public State visitMethodInvocation(MethodInvocationTree node, Void p) {
            Element target = this.ci.getTrees().getElement(this.getCurrentPath());
            if (target == null) {
                return State.NO;
            }
            State r = null;
            if (target == this.checkMethod && this.breakContinueJumps.isEmpty()) {
                if (node.getMethodSelect().getKind() != Tree.Kind.IDENTIFIER) {
                    this.thisTree = null;
                    r = this.scan((Tree)node.getMethodSelect(), p);
                    this.returnIfRecurse(r);
                    if (this.thisTree != null) {
                        r = State.MUST;
                    }
                } else {
                    r = State.MUST;
                }
            } else {
                r = this.scan((Tree)node.getMethodSelect(), p);
            }
            if (r == null) {
                Tree arg;
                Iterator<? extends ExpressionTree> i$ = node.getArguments().iterator();
                while (i$.hasNext() && !this.returnIfRecurse(r = this.scan(arg = (Tree)i$.next(), p))) {
                }
            }
            this.thisTree = null;
            if (r == null || r == State.NO) {
                return State.NO;
            }
            this.recursionPoints.add(this.getCurrentPath());
            this.knownResult = State.MUST;
            return this.knownResult;
        }

        @Override
        public State visitContinue(ContinueTree node, Void p) {
            StatementTree target = this.ci.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            this.breakContinueJumps.add(target);
            return State.NO;
        }

        @Override
        public State visitBreak(BreakTree node, Void p) {
            StatementTree target = this.ci.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            this.breakContinueJumps.add(target);
            return State.NO;
        }

        @Override
        public State visitReturn(ReturnTree node, Void p) {
            State s = this.scan((Tree)node.getExpression(), p);
            if (this.returnIfRecurse(s)) {
                return s;
            }
            this.knownResult = State.RETURN;
            return this.knownResult;
        }

        @Override
        public State visitLambdaExpression(LambdaExpressionTree node, Void p) {
            return State.NO;
        }

        @Override
        public State visitLabeledStatement(LabeledStatementTree node, Void p) {
            this.registerBreakTarget(node);
            this.registerBreakTarget(node.getStatement());
            return (State)((Object)super.visitLabeledStatement(node, p));
        }

        @Override
        public State visitIf(IfTree node, Void p) {
            return this.visitConditional(node.getCondition(), node.getThenStatement(), node.getElseStatement(), p);
        }

        private State visitConditional(Tree conditionTree, Tree trueTree, Tree falseTree, Void p) {
            State s = this.scan(conditionTree, p);
            if (this.returnIfRecurse(s)) {
                return s;
            }
            Object conditionValue = ArithmeticUtilities.compute(this.ci, new TreePath(this.getCurrentPath(), conditionTree), true, true);
            if (conditionValue == Boolean.TRUE) {
                return this.scan(trueTree, p);
            }
            if (conditionValue == Boolean.FALSE) {
                if (falseTree == null) {
                    return State.NO;
                }
                return this.scan(falseTree, p);
            }
            boolean saveDefinite = this.definitePath;
            this.definitePath = false;
            HashSet saveBreaks = new HashSet(this.breakContinueJumps);
            this.breakContinueJumps = new HashSet();
            State s1 = this.scan(trueTree, p);
            this.knownResult = null;
            State s2 = this.scan(falseTree, p);
            this.definitePath = saveDefinite;
            if (!this.breakContinueJumps.isEmpty()) {
                this.breakContinueJumps.addAll(saveBreaks);
                return State.NO;
            }
            s = s1.join(s2);
            this.returnIfRecurse(s);
            return s;
        }

        @Override
        public State visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            return this.visitConditional(node.getCondition(), node.getTrueExpression(), node.getFalseExpression(), p);
        }

        @Override
        public State visitSwitch(SwitchTree node, Void p) {
            this.registerBreakTarget(node);
            State s = this.scan((Tree)node.getExpression(), p);
            if (this.returnIfRecurse(s)) {
                return s;
            }
            boolean defaultFound = false;
            Set saveBreaks = this.breakContinueJumps;
            Set collectBreaks = Collections.emptySet();
            State lastState = State.NO;
            boolean saveDefinite = this.definitePath;
            this.definitePath = false;
            for (CaseTree caseTree : node.getCases()) {
                if (caseTree.getExpression() == null) {
                    defaultFound = true;
                }
                this.knownResult = null;
                this.breakContinueJumps = new HashSet();
                s = this.scan((Tree)caseTree, p);
                if (s == State.RETURN) {
                    this.definitePath = saveDefinite;
                    this.knownResult = s;
                    return this.knownResult;
                }
                boolean self = this.breakContinueJumps.remove(node);
                if (self || !this.breakContinueJumps.isEmpty()) {
                    saveBreaks.addAll(this.breakContinueJumps);
                    saveBreaks.addAll(collectBreaks);
                    this.breakContinueJumps = saveBreaks;
                    this.definitePath = saveDefinite;
                    this.recursionPoints.clear();
                    return State.NO;
                }
                lastState = s;
            }
            this.definitePath = saveDefinite;
            if (defaultFound) {
                return lastState;
            }
            this.recursionPoints.clear();
            return State.NO;
        }

        @Override
        public State visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
            this.registerBreakTarget(node);
            State s = this.scan((Tree)node.getExpression(), p);
            this.returnIfRecurse(s);
            return s;
        }

        @Override
        public State visitForLoop(ForLoopTree node, Void p) {
            this.registerBreakTarget(node);
            State s = this.scan((Iterable<? extends Tree>)node.getInitializer(), p);
            if (this.returnIfRecurse(s)) {
                return s;
            }
            s = s.append(this.scan((Tree)node.getCondition(), p));
            this.returnIfRecurse(s);
            return s;
        }

        @Override
        public State visitWhileLoop(WhileLoopTree node, Void p) {
            this.registerBreakTarget(node);
            State s = this.scan((Tree)node.getCondition(), p);
            this.returnIfRecurse(s);
            return s;
        }

        @Override
        public State visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            this.registerBreakTarget(node);
            State s = this.scan((Tree)node.getStatement(), p);
            if (this.returnIfRecurse(s)) {
                return s;
            }
            s = s.append(this.scan((Tree)node.getCondition(), p));
            this.returnIfRecurse(s);
            return s;
        }

        @Override
        public State visitClass(ClassTree node, Void p) {
            return State.NO;
        }

        @Override
        public State visitNewClass(NewClassTree node, Void p) {
            State r1 = this.scan((Tree)node.getEnclosingExpression(), p);
            if (this.returnIfRecurse(r1)) {
                return r1;
            }
            State r = r1;
            r = r.append(this.scan((Iterable<? extends Tree>)node.getArguments(), p));
            this.returnIfRecurse(r);
            return r;
        }
    }

    private static enum State {
        UNKNOWN{

            @Override
            public State join(State other) {
                return this;
            }

            @Override
            public State append(State other) {
                return other;
            }
        }
        ,
        NO{

            @Override
            public State join(State other) {
                return this;
            }

            @Override
            public State append(State other) {
                return other;
            }
        }
        ,
        MUST{

            @Override
            public State join(State other) {
                return other;
            }

            @Override
            public State append(State other) {
                return this;
            }
        }
        ,
        RETURN{

            @Override
            public State join(State other) {
                return this;
            }

            @Override
            public State append(State other) {
                return this;
            }
        };


        public abstract State join(State var1);

        public abstract State append(State var1);
    }
}

