/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.OverrideErrorMessage;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ImplementAllAbstractMethods
implements ErrorRule<Boolean>,
OverrideErrorMessage<Boolean> {
    private static final String PREMATURE_EOF_CODE = "compiler.err.premature.eof";

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.abstract.cant.be.instantiated", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated", "compiler.err.enum.constant.does.not.override.abstract"));
    }

    @Override
    public String createMessage(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Boolean> data) {
        TreePath path = ImplementAllAbstractMethods.deepTreePath(info, offset);
        Element e = info.getTrees().getElement(path);
        if (e == null || !e.getKind().isClass()) {
            TypeMirror tm = info.getTrees().getTypeMirror(path);
            if ((tm == null || tm.getKind() != TypeKind.DECLARED) && path.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                tm = info.getTrees().getTypeMirror(new TreePath(path, ((NewClassTree)path.getLeaf()).getIdentifier()));
            }
            if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                e = ((DeclaredType)tm).asElement();
            } else {
                return null;
            }
        }
        if (e == null) {
            return null;
        }
        List lee = info.getElementUtilities().findUnimplementedMethods((TypeElement)e);
        Scope s = info.getTrees().getScope(path);
        for (ExecutableElement ee : lee) {
            if (info.getTrees().isAccessible(s, ee, (DeclaredType)e.asType())) continue;
            data.setData((Object)true);
            return Bundle.ERR_CannotOverrideAbstractMethods();
        }
        return null;
    }

    public List<Fix> run(final CompilationInfo info, String diagnosticKey, final int offset, TreePath treePath, ErrorRule.Data<Boolean> data) {
        final ArrayList<Fix> result = new ArrayList<Fix>();
        if (data != null && Boolean.TRUE == data.getData()) {
            return null;
        }
        ImplementAllAbstractMethods.analyze(offset, info, new Performer(){

            @Override
            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                result.add(new FixImpl(info.getJavaSource(), offset, null));
            }

            @Override
            public void makeClassAbstract(TreePath pathToModify, String className) {
                Tree toModify = pathToModify.getLeaf();
                Element el = info.getTrees().getElement(pathToModify);
                if (el == null) {
                    return;
                }
                if (el.getKind() == ElementKind.ENUM) {
                    result.add(new ImplementOnEnumValues(info.getJavaSource(), offset));
                } else {
                    result.add(new FixImpl(info.getJavaSource(), offset, className));
                }
            }

            public void inaccessibleMethod(ExecutableElement ee) {
            }
        });
        return result;
    }

    public void cancel() {
    }

    public String getId() {
        return ImplementAllAbstractMethods.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_Impl_Abstract_Methods");
    }

    public String getDescription() {
        return NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"DSC_Impl_Abstract_Methods");
    }

    private static TreePath deepTreePath(CompilationInfo info, int offset) {
        TreePath basic = info.getTreeUtilities().pathFor(offset);
        TreePath plusOne = info.getTreeUtilities().pathFor(offset + 1);
        if (plusOne.getParentPath() != null && plusOne.getParentPath().getLeaf() == basic.getLeaf()) {
            return plusOne;
        }
        return basic;
    }

    private static void analyze(int offset, CompilationInfo info, Performer performer) {
        ImplementAllAbstractMethods.analyze(ImplementAllAbstractMethods.deepTreePath(info, offset), info, performer);
    }

    private static void analyze(TreePath path, CompilationInfo info, Performer performer) {
        VariableTree var;
        Element e = info.getTrees().getElement(path);
        boolean isUsableElement = e != null && (e.getKind().isClass() || e.getKind().isInterface());
        final Tree leaf = path.getLeaf();
        if (isUsableElement) {
            for (ExecutableElement ee : ElementFilter.methodsIn(e.getEnclosedElements())) {
                if (!ee.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                performer.makeClassAbstract(path, e.getSimpleName().toString());
                return;
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)leaf.getKind())) {
                CompilationUnitTree cut = info.getCompilationUnit();
                long start = info.getTrees().getSourcePositions().getStartPosition(cut, leaf);
                long end = info.getTrees().getSourcePositions().getEndPosition(cut, leaf);
                for (Diagnostic d : info.getDiagnostics()) {
                    long position = d.getPosition();
                    if (!d.getCode().equals(PREMATURE_EOF_CODE) || position <= start || position >= end) continue;
                    return;
                }
            }
            performer.fixAllAbstractMethods(path, leaf);
            if (e.getKind() == ElementKind.CLASS && e.getSimpleName() != null && !e.getSimpleName().contentEquals("")) {
                performer.makeClassAbstract(path, e.getSimpleName().toString());
            }
        } else if (leaf.getKind() == Tree.Kind.NEW_CLASS) {
            final boolean[] parentError = new boolean[]{false};
            new TreePathScanner(){

                @Override
                public Object visitNewClass(NewClassTree nct, Object o) {
                    if (leaf == nct) {
                        parentError[0] = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ERRONEOUS;
                    }
                    return super.visitNewClass(nct, o);
                }
            }.scan(path.getParentPath(), null);
            if (!parentError[0]) {
                performer.fixAllAbstractMethods(path, leaf);
            }
        } else if (e != null && e.getKind() == ElementKind.ENUM_CONSTANT && leaf.getKind() == Tree.Kind.VARIABLE && (var = (VariableTree)leaf).getInitializer() != null && var.getInitializer().getKind() == Tree.Kind.NEW_CLASS) {
            NewClassTree nct = (NewClassTree)var.getInitializer();
            TreePath toModify = new TreePath(path, var.getInitializer());
            if (nct.getClassBody() != null) {
                performer.fixAllAbstractMethods(new TreePath(toModify, nct.getClassBody()), nct.getClassBody());
            } else {
                performer.fixAllAbstractMethods(toModify, leaf);
            }
        }
    }

    public static Map<? extends ExecutableElement, ? extends ExecutableElement> generateAllAbstractMethodImplementations(WorkingCopy wc, TreePath path) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te == null) {
            return null;
        }
        ClassTree clazz = (ClassTree)path.getLeaf();
        GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
        ElementUtilities elemUtils = wc.getElementUtilities();
        List toImplement = elemUtils.findUnimplementedMethods(te);
        Map<? extends ExecutableElement, ? extends ExecutableElement> ret = Utilities.findConflictingMethods((CompilationInfo)wc, te, toImplement);
        if (ret.size() < toImplement.size()) {
            toImplement.removeAll(ret.keySet());
            List res = gu.createAbstractMethodImplementations(te, (Iterable)toImplement);
            clazz = gu.insertClassMembers(clazz, (Iterable)res);
            wc.rewrite(path.getLeaf(), (Tree)clazz);
        }
        if (ret.isEmpty()) {
            return ret;
        }
        String msg = ret.size() == 1 ? NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"WARN_FoundConflictingMethods1", (Object)ret.keySet().iterator().next().getSimpleName()) : NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"WARN_FoundConflictingMethodsMany", (Object)ret.keySet().size());
        StatusDisplayer.getDefault().setStatusText(msg, 700);
        return ret;
    }

    private static void fixClassOrVariable(WorkingCopy copy, TreePath pathToModify, Tree toModify, int[] offset, boolean[] repeat) {
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)toModify.getKind())) {
            ImplementAllAbstractMethods.generateAllAbstractMethodImplementations(copy, pathToModify);
            return;
        }
        if (toModify.getKind() != Tree.Kind.NEW_CLASS && toModify.getKind() != Tree.Kind.VARIABLE) {
            return;
        }
        int insertOffset = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), toModify);
        if (insertOffset != -1) {
            try {
                copy.getDocument().insertString(insertOffset, " {}", null);
                offset[0] = insertOffset + 1;
                repeat[0] = true;
            }
            catch (GuardedException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String message = NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"ERR_CannotApplyGuarded");
                        StatusDisplayer.getDefault().setStatusText(message);
                    }
                });
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    static final class FixImpl
    implements Fix {
        private JavaSource js;
        private int offset;
        private String makeClassAbstractName;

        public FixImpl(JavaSource js, int offset, String makeClassAbstractName) {
            this.js = js;
            this.offset = offset;
            this.makeClassAbstractName = makeClassAbstractName;
        }

        public String getText() {
            return this.makeClassAbstractName == null ? NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_FIX_Impl_Abstract_Methods") : NbBundle.getMessage(ImplementAllAbstractMethods.class, (String)"LBL_FIX_Make_Class_Abstract", (Object)this.makeClassAbstractName);
        }

        public ChangeInfo implement() throws IOException {
            final boolean[] repeat = new boolean[]{true};
            while (repeat[0]) {
                repeat[0] = false;
                this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(final WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.RESOLVED);
                        final int[] offsetArr = new int[]{FixImpl.this.offset};
                        ImplementAllAbstractMethods.analyze(FixImpl.this.offset, (CompilationInfo)copy, new Performer(){

                            @Override
                            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                                if (FixImpl.this.makeClassAbstractName != null) {
                                    return;
                                }
                                ImplementAllAbstractMethods.fixClassOrVariable(copy, pathToModify, toModify, offsetArr, repeat);
                            }

                            @Override
                            public void makeClassAbstract(TreePath pathToModify, String className) {
                                Tree toModify = pathToModify.getLeaf();
                                if (FixImpl.this.makeClassAbstractName == null) {
                                    return;
                                }
                                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)toModify.getKind())) {
                                    ClassTree clazz = (ClassTree)toModify;
                                    ModifiersTree modifiers = clazz.getModifiers();
                                    HashSet<Modifier> newModifiersSet = new HashSet<Modifier>(modifiers.getFlags());
                                    newModifiersSet.add(Modifier.ABSTRACT);
                                    copy.rewrite((Tree)modifiers, (Tree)copy.getTreeMaker().Modifiers(newModifiersSet, modifiers.getAnnotations()));
                                }
                            }
                        });
                        FixImpl.this.offset = offsetArr[0];
                    }
                }).commit();
            }
            return null;
        }

        String toDebugString() {
            return this.makeClassAbstractName == null ? "IAAM" : "MA:" + this.makeClassAbstractName;
        }
    }

    static final class ImplementOnEnumValues
    implements Fix {
        private final JavaSource js;
        private final int offset;

        public ImplementOnEnumValues(JavaSource js, int offset) {
            this.js = js;
            this.offset = offset;
        }

        public String getText() {
            return Bundle.LBL_FIX_Impl_Methods_Enum_Values();
        }

        public ChangeInfo implement() throws IOException {
            final boolean[] repeat = new boolean[]{false};
            final int[] offsetArr = new int[]{this.offset};
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(final WorkingCopy copy) throws IOException {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath enumPath = ImplementAllAbstractMethods.deepTreePath((CompilationInfo)copy, ImplementOnEnumValues.this.offset);
                    if (enumPath.getLeaf().getKind() != Tree.Kind.ENUM) {
                        return;
                    }
                    Element el = copy.getTrees().getElement(enumPath);
                    if (el == null) {
                        return;
                    }
                    ArrayList<? extends Element> al = new ArrayList<Element>(el.getEnclosedElements());
                    Collections.reverse(al);
                    for (VariableElement e : ElementFilter.fieldsIn(al)) {
                        if (e.getKind() != ElementKind.ENUM_CONSTANT) continue;
                        ImplementAllAbstractMethods.analyze(copy.getTrees().getPath(e), (CompilationInfo)copy, new Performer(){

                            @Override
                            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                                ImplementAllAbstractMethods.fixClassOrVariable(copy, pathToModify, toModify, offsetArr, repeat);
                            }

                            @Override
                            public void makeClassAbstract(TreePath toModify, String className) {
                            }
                        });
                    }
                }
            }).commit();
            if (!repeat[0]) {
                return null;
            }
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(final WorkingCopy copy) throws IOException {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath enumPath = ImplementAllAbstractMethods.deepTreePath((CompilationInfo)copy, ImplementOnEnumValues.this.offset);
                    if (enumPath.getLeaf().getKind() != Tree.Kind.ENUM) {
                        return;
                    }
                    Element el = copy.getTrees().getElement(enumPath);
                    if (el == null) {
                        return;
                    }
                    for (VariableElement e : ElementFilter.fieldsIn(el.getEnclosedElements())) {
                        if (e.getKind() != ElementKind.ENUM_CONSTANT) continue;
                        ImplementAllAbstractMethods.analyze(copy.getTrees().getPath(e), (CompilationInfo)copy, new Performer(){

                            @Override
                            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                                ImplementAllAbstractMethods.fixClassOrVariable(copy, pathToModify, toModify, offsetArr, repeat);
                            }

                            @Override
                            public void makeClassAbstract(TreePath toModify, String className) {
                            }
                        });
                    }
                }
            }).commit();
            return null;
        }
    }

    private static interface Performer {
        public void fixAllAbstractMethods(TreePath var1, Tree var2);

        public void makeClassAbstract(TreePath var1, String var2);
    }
}

