/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.OverrideErrorMessage;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;

final class TypeErroneous
implements OverrideErrorMessage<Void> {
    private static final Set<String> CODES = Collections.singleton("compiler.err.type.error");

    TypeErroneous() {
    }

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        return Collections.emptyList();
    }

    @Override
    public String createMessage(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        Tree t = treePath.getLeaf();
        if (t.getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        TypeMirror mt = info.getTrees().getTypeMirror(treePath);
        if (!Utilities.isValidType(mt)) {
            return null;
        }
        Collection<Object> unreachables = Collections.emptyList();
        if (mt.getKind() == TypeKind.EXECUTABLE) {
            ExecutableType etype = (ExecutableType)mt;
            ArrayList<TypeMirror> toCheck = new ArrayList<TypeMirror>();
            toCheck.addAll(etype.getParameterTypes());
            toCheck.add(etype.getReturnType());
            toCheck.addAll(etype.getThrownTypes());
            V v = new V(info);
            for (TypeMirror m : toCheck) {
                m.accept(v, null);
            }
            unreachables = v.unknownDeclaredTypes;
        }
        if (unreachables.isEmpty()) {
            return null;
        }
        switch (unreachables.size()) {
            case 1: {
                return Bundle.ERR_Unreachable_Type_1(unreachables.iterator().next());
            }
            case 2: {
                Iterator it = unreachables.iterator();
                return Bundle.ERR_Unreachable_Type_2(it.next(), it.next());
            }
        }
        return Bundle.ERR_Unreachable_Type_2(unreachables.iterator().next(), unreachables.size());
    }

    public String getId() {
        return TypeErroneous.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_TypeErroneous();
    }

    public void cancel() {
    }

    private static class V
    extends SimpleTypeVisitor8 {
        private final CompilationInfo info;
        Collection<TypeMirror> unknownDeclaredTypes = new ArrayList<TypeMirror>();

        public V(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Object visitDeclared(DeclaredType t, Object p) {
            Element e = t.asElement();
            if (e == null) {
                this.unknownDeclaredTypes.add(t);
            } else {
                TypeMirror back = e.asType();
                if (back == null || back.getKind() == TypeKind.ERROR) {
                    this.unknownDeclaredTypes.add(t);
                }
            }
            return super.visitDeclared(t, p);
        }
    }
}

