/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.UseSpecificCatchCustomizer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class UseSpecificCatch
implements CustomizerProvider {
    public static final String OPTION_EXCEPTION_LIST = "specificCatch.exceptions";
    static final String DEFAULT_EXCEPTION_LIST = "java.lang.Throwable, java.lang.Exception";
    public static final String SW_KEY = "UseSpecificCatch";

    public JComponent getCustomizer(Preferences prefs) {
        return new UseSpecificCatchCustomizer(prefs);
    }

    public static List<ErrorDescription> hint1(HintContext ctx) {
        if (ctx.getPath().getLeaf().getKind() != Tree.Kind.TRY) {
            return null;
        }
        TryTree tt = (TryTree)ctx.getPath().getLeaf();
        Set exceptions = ctx.getInfo().getTreeUtilities().getUncaughtExceptions(new TreePath(ctx.getPath(), tt.getBlock()));
        if (exceptions.size() <= 1) {
            return null;
        }
        StringTokenizer tukac = new StringTokenizer(ctx.getPreferences().get(OPTION_EXCEPTION_LIST, DEFAULT_EXCEPTION_LIST), ", ");
        ArrayList<TypeMirror> generics = new ArrayList<TypeMirror>(3);
        while (tukac.hasMoreTokens()) {
            String th = tukac.nextToken();
            TypeElement throwable = ctx.getInfo().getElements().getTypeElement(th);
            if (throwable == null) continue;
            generics.add(throwable.asType());
        }
        ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>(2);
        Collection catchPaths = (Collection)ctx.getMultiVariables().get("$catches$");
        String displayName = NbBundle.getMessage(UseSpecificCatch.class, (String)"ERR_UseSpecificCatch");
        block1: for (TreePath p : catchPaths) {
            TreePath parameterPath;
            if (p.getLeaf().getKind() != Tree.Kind.CATCH) continue;
            CatchTree kec = (CatchTree)p.getLeaf();
            TypeMirror t = ctx.getInfo().getTrees().getTypeMirror(new TreePath(p, kec.getParameter().getType()));
            if (t == null || exceptions.remove(t) || !generics.contains(t) || UseSpecificCatch.assignsTo(ctx, parameterPath = new TreePath(p, kec.getParameter()), Collections.singletonList(new TreePath(p, kec.getBlock())))) continue;
            TypeElement sw = ctx.getInfo().getElements().getTypeElement(SuppressWarnings.class.getName());
            Element catchParamElement = ctx.getInfo().getTrees().getElement(parameterPath);
            if (sw != null && catchParamElement != null) {
                for (AnnotationMirror annotationMirror : catchParamElement.getAnnotationMirrors()) {
                    if (!sw.equals(annotationMirror.getAnnotationType().asElement())) continue;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attrEntry : annotationMirror.getElementValues().entrySet()) {
                        if (!attrEntry.getKey().getSimpleName().contentEquals("value") || !(attrEntry.getValue().getValue() instanceof List)) continue;
                        for (AnnotationValue av : NbCollections.checkedListByCopy((List)((List)attrEntry.getValue().getValue()), AnnotationValue.class, (boolean)false)) {
                            if (!SW_KEY.equals(av.getValue())) continue;
                            continue block1;
                        }
                    }
                }
            }
            LinkedHashSet<TypeMirrorHandle<TypeMirror>> exceptionHandles = new LinkedHashSet<TypeMirrorHandle<TypeMirror>>();
            for (TypeMirror tm : exceptions) {
                if (!ctx.getInfo().getTypes().isSubtype(tm, t)) continue;
                exceptionHandles.add(TypeMirrorHandle.create((TypeMirror)tm));
            }
            boolean bl = ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0;
            descs.add(ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)kec.getParameter().getType(), (String)displayName, (Fix[])new Fix[]{bl ? new FixImpl(ctx.getInfo(), p, exceptionHandles).toEditorFix() : new SplitExceptionInCatches(ctx.getInfo(), p, exceptionHandles).toEditorFix()}));
        }
        return descs;
    }

    public static boolean assignsTo(final HintContext ctx, TreePath variable, Iterable<? extends TreePath> statements) {
        final Element tEl = ctx.getInfo().getTrees().getElement(variable);
        if (tEl == null || tEl.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        final boolean[] result = new boolean[1];
        for (TreePath treePath : statements) {
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitAssignment(AssignmentTree node, Void p) {
                    if (tEl.equals(ctx.getInfo().getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable())))) {
                        result[0] = true;
                    }
                    return (Void)super.visitAssignment(node, p);
                }
            }.scan(treePath, (Void)null);
        }
        return result[0];
    }

    public static class SplitExceptionInCatches
    extends JavaFix {
        private Collection<TypeMirrorHandle<TypeMirror>> newTypes;

        public SplitExceptionInCatches(CompilationInfo info, TreePath tp, Collection<TypeMirrorHandle<TypeMirror>> newTypes) {
            super(info, tp);
            this.newTypes = newTypes;
        }

        protected String getText() {
            return NbBundle.getMessage(UseSpecificCatch.class, (String)"FIX_UseSpecificCatchSplit");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            CatchTree oldTree = (CatchTree)ctx.getPath().getLeaf();
            TryTree oldTry = (TryTree)ctx.getPath().getParentPath().getLeaf();
            WorkingCopy wcopy = ctx.getWorkingCopy();
            GeneratorUtilities gen = GeneratorUtilities.get((WorkingCopy)wcopy);
            TreeMaker mk = wcopy.getTreeMaker();
            int index = oldTry.getCatches().indexOf(oldTree);
            TryTree result = mk.removeTryCatch(oldTry, index);
            for (TypeMirrorHandle<TypeMirror> h : this.newTypes) {
                TypeMirror m = h.resolve((CompilationInfo)wcopy);
                if (m == null || m.getKind() != TypeKind.DECLARED) continue;
                CatchTree branch = mk.Catch(mk.Variable(oldTree.getParameter().getModifiers(), (CharSequence)oldTree.getParameter().getName(), mk.Type(m), oldTree.getParameter().getInitializer()), oldTree.getBlock());
                gen.copyComments((Tree)oldTree, (Tree)branch, true);
                result = mk.insertTryCatch(result, index++, branch);
            }
            wcopy.rewrite((Tree)oldTry, (Tree)result);
        }
    }

    public static final class FixImpl
    extends JavaFix {
        private final Set<TypeMirrorHandle<TypeMirror>> exceptionHandles;

        public FixImpl(CompilationInfo info, TreePath tryStatement, Set<TypeMirrorHandle<TypeMirror>> exceptionHandles) {
            super(info, tryStatement);
            this.exceptionHandles = exceptionHandles;
        }

        protected String getText() {
            return NbBundle.getMessage(UseSpecificCatch.class, (String)"FIX_UseSpecificCatch");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            LinkedList<Tree> exceptions = new LinkedList<Tree>();
            for (TypeMirrorHandle<TypeMirror> h : this.exceptionHandles) {
                TypeMirror tm = h.resolve((CompilationInfo)wc);
                if (tm == null) {
                    return;
                }
                exceptions.add(wc.getTreeMaker().Type(tm));
            }
            VariableTree excVar = ((CatchTree)tp.getLeaf()).getParameter();
            wc.rewrite(excVar.getType(), (Tree)wc.getTreeMaker().UnionType(exceptions));
        }
    }
}

