/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.project;

import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class IncompleteClassPath
implements ErrorRule<Void> {
    private static final String CODE = "nb.classpath.incomplete";
    private static final Set<String> CODES = Collections.singleton("nb.classpath.incomplete");

    @NonNull
    public Set<String> getCodes() {
        return CODES;
    }

    @NonNull
    public String getId() {
        return IncompleteClassPath.class.getName();
    }

    @NonNull
    public String getDisplayName() {
        return NbBundle.getMessage(IncompleteClassPath.class, (String)"TXT_IncompleteClassPath");
    }

    @NonNull
    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        Project prj;
        FileObject file = compilationInfo.getFileObject();
        if (file != null && (prj = FileOwnerQuery.getOwner((FileObject)file)) != null) {
            return Collections.singletonList(new ResolveFix(prj));
        }
        return Collections.emptyList();
    }

    public void cancel() {
    }

    private static final class ResolveFix
    implements Fix {
        private final Project prj;

        ResolveFix(@NonNull Project prj) {
            Parameters.notNull((CharSequence)"prj", (Object)prj);
            this.prj = prj;
        }

        public String getText() {
            return NbBundle.getMessage(IncompleteClassPath.class, (String)"TXT_ResolveProjectProblems");
        }

        public ChangeInfo implement() throws Exception {
            ProjectProblems.showCustomizer((Project)this.prj);
            return null;
        }
    }
}

