/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.filemodels.FileModelEntry;
import com.sun.javacard.filemodels.XListInstanceEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XListEntry
implements FileModelEntry {
    private int order;
    private final List<XListInstanceEntry> instances = Collections.synchronizedList(new ArrayList());
    private String displayName;
    private String type;

    public List<? extends XListInstanceEntry> getInstances() {
        return Collections.unmodifiableList(this.instances);
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isValid() {
        return this.type != null && this.displayName != null;
    }

    public void addInstance(XListInstanceEntry instance) {
        this.instances.add(instance);
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("        <name>");
        sb.append(this.getDisplayName());
        sb.append("</name>\n");
        sb.append("        <type>");
        sb.append(this.getType());
        sb.append("</type>\n");
        if (!this.instances.isEmpty()) {
            sb.append("        <instances>\n");
            for (XListInstanceEntry e : this.instances) {
                sb.append("            <instance>");
                sb.append(e.getContent());
                sb.append("</instance>\n");
            }
            sb.append("        </instances>\n");
        }
        return sb.toString();
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getProblem() {
        return null;
    }

    @Override
    public int compareTo(FileModelEntry o) {
        return this.getOrder() - o.getOrder();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XListEntry other = (XListEntry)obj;
        if (this.order != other.order) {
            return false;
        }
        if (!(this.instances == other.instances || this.instances != null && this.instances.equals(other.instances))) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + this.order;
        hash = 29 * hash + (this.instances != null ? this.instances.hashCode() : 0);
        hash = 29 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        hash = 29 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }
}

