/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.create;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.ui.spi.TestCreatorConfiguration;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.codeception.CodeceptionTestingProvider;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.netbeans.modules.php.codeception.create.Bundle;
import org.netbeans.modules.php.codeception.create.TestCreator;
import org.netbeans.modules.php.codeception.ui.CodeceptionCreateTestPanel;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.create.CreateTestsSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public final class CodeceptionTestCreatorConfiguration
extends TestCreatorConfiguration {
    private final CreateTestsSupport createTestsSupport;
    private CodeceptionCreateTestPanel panel;
    private List<String> suites;

    CodeceptionTestCreatorConfiguration(FileObject[] activatedFileObjects) {
        assert (activatedFileObjects != null);
        assert (activatedFileObjects.length > 0);
        this.createTestsSupport = CreateTestsSupport.create((PhpTestingProvider)CodeceptionTestingProvider.getInstance(), (FileObject[])activatedFileObjects);
    }

    public boolean canHandleProject(String framework) {
        return "Codeception".equals(framework);
    }

    public Component getConfigurationPanel(TestCreatorConfiguration.Context context) {
        assert (EventQueue.isDispatchThread());
        if (this.panel == null) {
            this.panel = new CodeceptionCreateTestPanel(TestCreator.TEST_COMMANDS, this.getSuites());
        }
        return this.panel;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        if (this.getSuites().isEmpty()) {
            return Bundle.CodeceptionTestCreatorConfiguration_error_suites_none();
        }
        return null;
    }

    public void persistConfigurationPanel(TestCreatorConfiguration.Context context) {
        assert (EventQueue.isDispatchThread());
        context.getProperties().put("GENERATE_COMMAND_PARAM", this.panel.getSelectedCommand());
        context.getProperties().put("SUITE_PARAM", this.panel.getSelectedSuite());
    }

    public Object[] getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject fo) {
        return this.createTestsSupport.getTestSourceRoots(createdSourceRoots, fo);
    }

    public boolean showClassNameInfo() {
        return false;
    }

    public boolean showClassToTestInfo() {
        return false;
    }

    public Pair<String, String> getSourceAndTestClassNames(FileObject fo, boolean isTestNG, boolean isSelenium) {
        return Pair.of((Object)"whatever", (Object)"donotcareTest");
    }

    private synchronized List<String> getSuites() {
        if (this.suites == null) {
            PhpModule phpModule = this.createTestsSupport.getPhpModule();
            assert (phpModule != null);
            this.suites = new ArrayList<String>(Codecept.getSuiteNames(phpModule));
        }
        return Collections.unmodifiableList(this.suites);
    }
}

