/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.run;

import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.codeception.run.TestCaseVo;
import org.netbeans.modules.php.codeception.run.TestSessionVo;
import org.netbeans.modules.php.codeception.run.TestSuiteVo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CodeceptionLogParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(CodeceptionLogParser.class.getName());
    final XMLReader xmlReader;
    private final TestSessionVo givenTestSession;
    private final TestSessionVo tmpTestSession = new TestSessionVo();
    private final Deque<TestSuiteVo> testSuites = new LinkedList<TestSuiteVo>();
    private final Set<TestSuiteVo> parentTestSuites = new HashSet<TestSuiteVo>();
    private TestCaseVo testCase;
    private Content content = Content.NONE;
    private StringBuilder buffer = new StringBuilder(200);

    private CodeceptionLogParser(TestSessionVo testSession) throws SAXException {
        assert (testSession != null);
        this.givenTestSession = testSession;
        this.xmlReader = FileUtils.createXmlReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean parse(Reader reader, TestSessionVo testSession) {
        try {
            CodeceptionLogParser parser = new CodeceptionLogParser(testSession);
            parser.xmlReader.setContentHandler(parser);
            parser.xmlReader.parse(new InputSource(reader));
            parser.finish();
            boolean bl = true;
            return bl;
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        assert (qName != null);
        switch (qName) {
            case "testsuites": {
                break;
            }
            case "testsuite": {
                this.processTestSuiteStart(attributes);
                break;
            }
            case "testcase": {
                this.processTestCase(attributes);
                break;
            }
            case "failure": {
                this.startTestFailure(attributes);
                break;
            }
            case "error": {
                this.startTestError(attributes);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        assert (qName != null);
        switch (qName) {
            case "testsuite": {
                this.processTestSuiteEnd();
                break;
            }
            case "testcase": {
                assert (this.testCase != null);
                this.testCase = null;
                break;
            }
            case "failure": 
            case "error": {
                this.endTestContent();
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.content) {
            case FAILURE: 
            case ERROR: {
                this.buffer.append(new String(ch, start, length));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false) : "Unknown content: " + (Object)((Object)this.content);
                break;
            }
        }
    }

    private void processTestSuiteStart(Attributes attributes) {
        long time = this.getTime(attributes);
        if (this.tmpTestSession.getTime() != -1L) {
            time += this.tmpTestSession.getTime();
        }
        this.tmpTestSession.setTime(time);
        int testSize = this.getTests(attributes);
        if (this.tmpTestSession.getTests() != -1) {
            testSize += this.tmpTestSession.getTests();
        }
        this.tmpTestSession.setTests(testSize);
        TestSuiteVo parentSuite = this.testSuites.peek();
        if (parentSuite != null) {
            this.parentTestSuites.add(parentSuite);
        }
        TestSuiteVo testSuite = new TestSuiteVo(this.getName(attributes), this.getTime(attributes));
        this.testSuites.push(testSuite);
        this.tmpTestSession.addTestSuite(testSuite);
    }

    private void processTestSuiteEnd() {
        this.testSuites.pop();
    }

    private void processTestCase(Attributes attributes) {
        assert (this.testCase == null);
        this.testCase = new TestCaseVo(this.getClass(attributes), this.getName(attributes), this.getFile(attributes), this.getLine(attributes), this.getTime(attributes));
        this.testSuites.getFirst().addTestCase(this.testCase);
    }

    private void startTestError(Attributes attributes) {
        this.content = Content.ERROR;
    }

    private void startTestFailure(Attributes attributes) {
        this.content = Content.FAILURE;
    }

    private void endTestContent() {
        assert (this.testCase != null);
        assert (this.buffer.length() > 0);
        this.fillStacktrace();
        switch (this.content) {
            case FAILURE: {
                this.testCase.setFailureStatus();
                break;
            }
            case ERROR: {
                this.testCase.setErrorStatus();
                break;
            }
            default: {
                assert (false) : "Unknown content type: " + (Object)((Object)this.content);
                break;
            }
        }
        this.buffer = new StringBuilder(200);
        this.content = Content.NONE;
    }

    private void fillStacktrace() {
        String[] lines = this.buffer.toString().trim().split("\n");
        assert (lines.length >= 2) : "At least 2 lines must be found (message + stacktrace)";
        this.buffer = new StringBuilder(200);
        boolean stacktraceStarted = false;
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            if (line.trim().length() == 0) {
                if (stacktraceStarted) continue;
                stacktraceStarted = true;
                this.testCase.addStacktrace(this.buffer.toString().trim());
                continue;
            }
            if (line.startsWith("\n\n")) {
                stacktraceStarted = true;
                this.testCase.addStacktrace(this.buffer.toString().trim());
                continue;
            }
            if (!stacktraceStarted) {
                this.buffer.append(line);
                this.buffer.append("\n");
                continue;
            }
            this.testCase.addStacktrace(line.trim());
        }
        if (this.testCase.getStackTrace().length == 0) {
            this.testCase.addStacktrace(this.buffer.toString().trim());
        }
    }

    private int getTests(Attributes attributes) {
        return this.getInt(attributes, "tests");
    }

    private long getTime(Attributes attributes) {
        long l = -1L;
        try {
            l = Math.round(Double.parseDouble(attributes.getValue("time")) * 1000.0);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        return l;
    }

    private String getClass(Attributes attributes) {
        return attributes.getValue("class");
    }

    private String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    private String getFile(Attributes attributes) {
        return this.getFile(attributes, null);
    }

    private String getFile(Attributes attributes, String defaultFile) {
        String f = attributes.getValue("file");
        if (f != null) {
            return f;
        }
        if (defaultFile != null) {
            return defaultFile;
        }
        return null;
    }

    private int getLine(Attributes attributes) {
        return this.getInt(attributes, "line");
    }

    private int getInt(Attributes attributes, String name) {
        int i = -1;
        try {
            i = Integer.parseInt(attributes.getValue(name));
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        return i;
    }

    private void finish() {
        this.givenTestSession.setTime(this.tmpTestSession.getTime());
        this.givenTestSession.setTests(this.tmpTestSession.getTests());
        for (TestSuiteVo testSuiteVo : this.tmpTestSession.getTestSuites()) {
            if (testSuiteVo.getPureTestCases().isEmpty() && this.parentTestSuites.contains(testSuiteVo)) continue;
            this.givenTestSession.addTestSuite(testSuiteVo);
        }
    }

    private static enum Content {
        NONE,
        ERROR,
        FAILURE;

    }
}

