/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.codeception.preferences.CodeceptionPreferences;
import org.netbeans.modules.php.codeception.preferences.CodeceptionPreferencesValidator;
import org.netbeans.modules.php.codeception.ui.customizer.Bundle;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerCodeception
extends JPanel
implements HelpCtx.Provider {
    private final ProjectCustomizer.Category category;
    private final PhpModule phpModule;
    private JCheckBox askForAdditionalParametersCheckBox;
    private JButton codeceptionBrowseButton;
    private JCheckBox codeceptionCheckBox;
    private JLabel codeceptionLabel;
    private JTextField codeceptionTextField;
    private JButton scriptBrowseButton;
    private JCheckBox scriptCheckBox;
    private JLabel scriptLabel;
    private JTextField scriptTextField;

    public CustomizerCodeception(ProjectCustomizer.Category category, PhpModule phpModule) {
        this.category = category;
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initFile(CodeceptionPreferences.isCustomCodeceptEnabled(this.phpModule), CodeceptionPreferences.getCustomCodeceptPath(this.phpModule), this.scriptCheckBox, this.scriptTextField);
        this.initFile(CodeceptionPreferences.isCustomCodeceptionYmlEnabled(this.phpModule), CodeceptionPreferences.getCustomCodeceptionYmlPath(this.phpModule), this.codeceptionCheckBox, this.codeceptionTextField);
        this.enableFile(this.scriptCheckBox.isSelected(), this.scriptLabel, this.scriptTextField, this.scriptBrowseButton);
        this.enableFile(this.codeceptionCheckBox.isSelected(), this.codeceptionLabel, this.codeceptionTextField, this.codeceptionBrowseButton);
        this.askForAdditionalParametersCheckBox.setSelected(CodeceptionPreferences.askForAdditionalParameters(this.phpModule));
        this.addListeners();
        this.validateData();
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerCodeception.this.storeData();
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.codeception.ui.customizer.CustomizerCodeception");
    }

    void storeData() {
        CodeceptionPreferences.setCustomCodeceptEnabled(this.phpModule, this.scriptCheckBox.isSelected());
        CodeceptionPreferences.setCustomCodeceptPath(this.phpModule, this.scriptTextField.getText());
        CodeceptionPreferences.setCustomCodeceptionYmlEnabled(this.phpModule, this.codeceptionCheckBox.isSelected());
        CodeceptionPreferences.setCustomCodeceptionYmlPath(this.phpModule, this.codeceptionTextField.getText());
        CodeceptionPreferences.setAskForAdditionalParameters(this.phpModule, this.askForAdditionalParametersCheckBox.isSelected());
    }

    private void initFile(boolean enabled, String file, JCheckBox checkBox, JTextField textField) {
        checkBox.setSelected(enabled);
        textField.setText(file);
    }

    void enableFile(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    void validateData() {
        ValidationResult result = new CodeceptionPreferencesValidator().validateCodecept(this.scriptCheckBox.isSelected(), this.scriptTextField.getText()).validateCodeceptionYml(this.codeceptionCheckBox.isSelected(), this.codeceptionTextField.getText()).getResult();
        Iterator i$ = result.getErrors().iterator();
        if (i$.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)i$.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(false);
            return;
        }
        i$ = result.getWarnings().iterator();
        if (i$.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)i$.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.scriptCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerCodeception.this.enableFile(e.getStateChange() == 1, CustomizerCodeception.this.scriptLabel, CustomizerCodeception.this.scriptTextField, CustomizerCodeception.this.scriptBrowseButton);
                CustomizerCodeception.this.validateData();
            }
        });
        this.scriptTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.codeceptionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerCodeception.this.enableFile(e.getStateChange() == 1, CustomizerCodeception.this.codeceptionLabel, CustomizerCodeception.this.codeceptionTextField, CustomizerCodeception.this.codeceptionBrowseButton);
                CustomizerCodeception.this.validateData();
            }
        });
        this.codeceptionTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    private File getDefaultDirectory() {
        File defaultDirectory;
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        if (sourceDirectory != null) {
            defaultDirectory = FileUtil.toFile((FileObject)sourceDirectory);
        } else {
            FileObject projectDirectory = this.phpModule.getProjectDirectory();
            defaultDirectory = FileUtil.toFile((FileObject)projectDirectory);
        }
        assert (defaultDirectory != null);
        return defaultDirectory;
    }

    private void initComponents() {
        this.scriptCheckBox = new JCheckBox();
        this.scriptLabel = new JLabel();
        this.scriptTextField = new JTextField();
        this.scriptBrowseButton = new JButton();
        this.codeceptionCheckBox = new JCheckBox();
        this.codeceptionLabel = new JLabel();
        this.codeceptionTextField = new JTextField();
        this.codeceptionBrowseButton = new JButton();
        this.askForAdditionalParametersCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.scriptCheckBox, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.scriptCheckBox.text"));
        this.scriptLabel.setLabelFor(this.scriptTextField);
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.scriptLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.scriptBrowseButton, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.scriptBrowseButton.text"));
        this.scriptBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerCodeception.this.scriptBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.codeceptionCheckBox, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.codeceptionCheckBox.text"));
        this.codeceptionLabel.setLabelFor(this.codeceptionTextField);
        Mnemonics.setLocalizedText((JLabel)this.codeceptionLabel, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.codeceptionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeceptionBrowseButton, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.codeceptionBrowseButton.text"));
        this.codeceptionBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerCodeception.this.codeceptionBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.askForAdditionalParametersCheckBox, (String)NbBundle.getMessage(CustomizerCodeception.class, (String)"CustomizerCodeception.askForAdditionalParametersCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.codeceptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeceptionTextField)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.scriptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptTextField))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scriptBrowseButton).addComponent(this.codeceptionBrowseButton))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scriptCheckBox).addComponent(this.codeceptionCheckBox).addComponent(this.askForAdditionalParametersCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scriptCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptTextField, -2, -1, -2).addComponent(this.scriptLabel).addComponent(this.scriptBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeceptionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codeceptionLabel).addComponent(this.codeceptionTextField, -2, -1, -2).addComponent(this.codeceptionBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.askForAdditionalParametersCheckBox)));
    }

    private void scriptBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerCodeception.class).setTitle(Bundle.CustomizerCodeception_chooser_codecept()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.scriptTextField.setText(file.getAbsolutePath());
        }
    }

    private void codeceptionBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerCodeception.class).setTitle(Bundle.CustomizerCodeception_chooser_codeception_yml()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.codeceptionTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerCodeception.this.validateData();
        }
    }
}

