/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.codegen.AbstractGenerator;
import org.netbeans.modules.maven.codegen.Bundle;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyContainer;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.grammar.DialogFactory;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.w3c.dom.Node;

public class DependencyGenerator
extends AbstractGenerator<POMModel> {
    private DependencyGenerator(POMModel model, JTextComponent component) {
        super(model, component);
    }

    public String getDisplayName() {
        return Bundle.NAME_Dependency();
    }

    @Override
    protected void doInvoke() {
        String[] ret;
        FileObject fo = (FileObject)((POMModel)this.model).getModelSource().getLookup().lookup(FileObject.class);
        assert (fo != null);
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        assert (prj != null);
        int pos = this.component.getCaretPosition();
        DocumentComponent c = ((POMModel)this.model).findComponent(pos);
        boolean dm = false;
        if (c != null) {
            String xpath = ((POMModel)this.model).getXPathExpression(c);
            dm = xpath.contains("dependencyManagement");
        }
        if ((ret = DialogFactory.showDependencyDialog((Project)prj, (!dm ? 1 : 0) != 0)) != null) {
            final String groupId = ret[0];
            final String artifactId = ret[1];
            final String version = ret[2];
            final String scope = ret[3];
            final String type = ret[4];
            final String classifier = ret[5];
            this.writeModel(new AbstractGenerator.ModelWriter(){

                @Override
                public int write() {
                    int pos = DependencyGenerator.this.component.getCaretPosition();
                    DependencyContainer container = DependencyGenerator.this.findContainer(pos, (POMModel)DependencyGenerator.this.model);
                    Dependency dep = container.findDependencyById(groupId, artifactId, classifier);
                    if (dep == null) {
                        dep = ((POMModel)DependencyGenerator.this.model).getFactory().createDependency();
                        dep.setGroupId(groupId);
                        dep.setArtifactId(artifactId);
                        dep.setVersion(version);
                        dep.setScope(scope);
                        dep.setType(type);
                        dep.setClassifier(classifier);
                        container.addDependency(dep);
                    }
                    return dep.getModel().getAccess().findPosition((Node)dep.getPeer());
                }
            });
        }
    }

    private DependencyContainer findContainer(int pos, POMModel model) {
        for (DocumentComponent dc = model.findComponent(pos); dc != null; dc = dc.getParent()) {
            if (!(dc instanceof DependencyContainer)) continue;
            return (DependencyContainer)dc;
        }
        return model.getProject();
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<DependencyGenerator> toRet = new ArrayList<DependencyGenerator>();
            POMModel model = (POMModel)context.lookup(POMModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new DependencyGenerator(model, component));
            }
            return toRet;
        }
    }
}

