/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.Constants;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.grammar.MavenSettingsGrammar;
import org.netbeans.modules.maven.grammar.spi.AbstractSchemaBasedGrammar;
import org.netbeans.modules.maven.grammar.spi.GrammarExtensionProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenProjectGrammar
extends AbstractSchemaBasedGrammar {
    private static final Logger LOG = Logger.getLogger(MavenProjectGrammar.class.getName());
    private static final String[] SCOPES = new String[]{"compile", "test", "runtime", "provided", "system"};
    private static RequestProcessor RP = new RequestProcessor(MavenProjectGrammar.class.getName(), 3);
    private final Project owner;

    MavenProjectGrammar(GrammarEnvironment env, Project owner) {
        super(env);
        this.owner = owner;
    }

    @Override
    protected InputStream getSchemaStream() {
        return this.getClass().getResourceAsStream("/org/netbeans/modules/maven/grammar/maven-4.0.0.xsd");
    }

    private List<GrammarResult> hardwiredProperty(HintContext hintCtx, String name, String htmlDesc) {
        if (name.startsWith(hintCtx.getCurrentPrefix())) {
            AbstractSchemaBasedGrammar.MyElement el = new AbstractSchemaBasedGrammar.MyElement(name);
            el.setDescription(htmlDesc);
            return Collections.singletonList(el);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<GrammarResult> getDynamicCompletion(String path, HintContext hintCtx, org.jdom.Element parent) {
        GrammarExtensionProvider extProvider;
        ArrayList<GrammarResult> result = new ArrayList<GrammarResult>();
        if (path.endsWith("plugins/plugin/configuration") || path.endsWith("plugins/plugin/executions/execution/configuration")) {
            Document pluginDoc;
            MavenEmbedder embedder;
            Node previous = path.indexOf("execution") > 0 ? hintCtx.getParentNode().getParentNode().getParentNode().getPreviousSibling() : hintCtx.getParentNode().getPreviousSibling();
            ArtifactInfoHolder info = this.findPluginInfo(previous, embedder = EmbedderFactory.getOnlineEmbedder(), true);
            List<GrammarResult> res = this.collectPluginParams(info, hintCtx);
            if (res == null && (pluginDoc = this.loadDocument(info, embedder)) != null) {
                res = this.collectPluginParams(pluginDoc, hintCtx);
            }
            if (res != null) {
                result.addAll(res);
            }
        }
        if (path.endsWith("project/properties") || path.endsWith("profile/properties")) {
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.displayName", "<html><h4>netbeans.hint.displayName</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to customize the display of the project in question.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.license", "<html><h4>netbeans.hint.license</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to select a license header template from the IDE's default set.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.licensePath", "<html><h4>netbeans.hint.licensePath</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to find license header template from project's space in the filesystem. <br/>Value is an absolute or relative path to the template file.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.hint.jdkPlatform", "<html><h4>netbeans.hint.jdkPlatform</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to determine which JDK platform defined in Tools/Java Platforms should be used to run the Maven builds.</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.compile.on.save", "<html><h4>netbeans.compile.on.save</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Used by NetBeans to determine if Compile on Save feature should be enabled for the project or not.<br/>Allowed values are: true/false</html>"));
            result.addAll(this.hardwiredProperty(hintCtx, "netbeans.checkstyle.format", "<html><h4>netbeans.checkstyle.format</h4><p>A NetBeans specific property, only applicable within the IDE.</p><br/>Allowed values are: true/false</html>"));
        }
        if ((extProvider = (GrammarExtensionProvider)Lookup.getDefault().lookup(GrammarExtensionProvider.class)) != null) {
            result.addAll(extProvider.getDynamicCompletion(path, hintCtx, parent));
        }
        return result;
    }

    private ArtifactInfoHolder findArtifactInfo(Node previous) {
        ArtifactInfoHolder holder = new ArtifactInfoHolder();
        while (previous != null) {
            Element el;
            NodeList lst;
            if (previous instanceof Element && (lst = (el = (Element)previous).getChildNodes()).getLength() > 0) {
                if ("artifactId".equals(el.getNodeName())) {
                    holder.setArtifactId(MavenProjectGrammar.getNodeValue(lst.item(0).getNodeValue(), (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)));
                }
                if ("groupId".equals(el.getNodeName())) {
                    holder.setGroupId(MavenProjectGrammar.getNodeValue(lst.item(0).getNodeValue(), (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)));
                }
                if ("version".equals(el.getNodeName())) {
                    holder.setVersion(MavenProjectGrammar.getNodeValue(lst.item(0).getNodeValue(), (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)));
                }
            }
            previous = previous.getPreviousSibling();
        }
        return holder;
    }

    static String getNodeValue(String value, NbMavenProject prj) {
        StringBuilder sb = new StringBuilder();
        Properties props = prj.getMavenProject().getProperties();
        int idxLeft = value.indexOf("${");
        if (idxLeft < 0) {
            return value;
        }
        if (idxLeft > 0) {
            sb.append(value.substring(0, idxLeft));
        }
        int idxRight = 0;
        while (idxLeft > -1) {
            String prop;
            idxRight = value.indexOf("}", idxLeft + 2);
            if (idxRight > -1) {
                String propName = value.substring(idxLeft + 2, idxRight);
                prop = props.getProperty(propName);
                if (prop == null) {
                    return value;
                }
            } else {
                return value;
            }
            sb.append(prop);
            idxLeft = value.indexOf("${", idxRight);
            if (idxRight < value.length()) {
                if (idxLeft > idxRight) {
                    sb.append(value.substring(idxRight + 1, idxLeft));
                } else {
                    sb.append(value.substring(idxRight + 1, value.length()));
                }
            }
            ++idxRight;
        }
        return sb.toString();
    }

    private ArtifactInfoHolder findPluginInfo(Node previous, MavenEmbedder embedder, boolean checkLocalRepo) {
        File lev1;
        File dir;
        File fil;
        NbMavenProject prj;
        ArtifactInfoHolder holder = this.findArtifactInfo(previous);
        if (holder.getGroupId() == null) {
            holder.setGroupId("org.apache.maven.plugins");
        }
        if (holder.getVersion() != null && holder.getVersion().contains("${")) {
            holder.setVersion(null);
        }
        if (holder.getVersion() == null && holder.getGroupId() != null && holder.getArtifactId() != null && (prj = (NbMavenProject)this.owner.getLookup().lookup(NbMavenProject.class)) != null) {
            PluginManagement man;
            for (Plugin a : prj.getMavenProject().getBuildPlugins()) {
                if (!holder.getGroupId().equals(a.getGroupId()) || !holder.getArtifactId().equals(a.getArtifactId())) continue;
                holder.setVersion(a.getVersion());
                break;
            }
            if (holder.getVersion() == null && (man = prj.getMavenProject().getPluginManagement()) != null) {
                for (Plugin p : man.getPlugins()) {
                    if (!holder.getGroupId().equals(p.getGroupId()) || !holder.getArtifactId().equals(p.getArtifactId())) continue;
                    holder.setVersion(p.getVersion());
                    break;
                }
            }
        }
        if (checkLocalRepo && (holder.getVersion() == null || "LATEST".equals(holder.getVersion()) || "RELEASE".equals(holder.getVersion())) && holder.getArtifactId() != null && holder.getGroupId() != null && (fil = new File(dir = new File(lev1 = new File(embedder.getLocalRepositoryFile(), holder.getGroupId().replace('.', File.separatorChar)), holder.getArtifactId()), "maven-metadata-local.xml")).exists()) {
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            try {
                Metadata data = reader.read((Reader)new InputStreamReader(new FileInputStream(fil)));
                if (data.getVersion() != null) {
                    holder.setVersion(data.getVersion());
                } else {
                    Versioning vers = data.getVersioning();
                    if (vers != null) {
                        if ("LATEST".equals(holder.getVersion())) {
                            holder.setVersion(vers.getLatest());
                        }
                        if ("RELEASE".equals(holder.getVersion())) {
                            holder.setVersion(vers.getRelease());
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.FINER, "", ex);
            }
            catch (XmlPullParserException ex) {
                LOG.log(Level.FINER, "", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINER, "", ex);
            }
        }
        if (holder.getVersion() == null) {
            holder.setVersion("RELEASE");
        }
        return holder;
    }

    private List<GrammarResult> collectPluginParams(Document pluginDoc, HintContext hintCtx) {
        Iterator it = pluginDoc.getRootElement().getDescendants(new Filter(){

            public boolean matches(Object object) {
                org.jdom.Element el;
                return object instanceof org.jdom.Element && "parameter".equals((el = (org.jdom.Element)object).getName()) && el.getParentElement() != null && "parameters".equals(el.getParentElement().getName()) && el.getParentElement().getParentElement() != null && "mojo".equals(el.getParentElement().getParentElement().getName());
            }
        });
        ArrayList<GrammarResult> toReturn = new ArrayList<GrammarResult>();
        HashSet<String> params = new HashSet<String>();
        while (it.hasNext()) {
            String name;
            org.jdom.Element el = (org.jdom.Element)it.next();
            String editable = el.getChildText("editable");
            if (!"true".equalsIgnoreCase(editable) || !(name = el.getChildText("name")).startsWith(hintCtx.getCurrentPrefix()) || params.contains(name)) continue;
            params.add(name);
            toReturn.add(new AbstractSchemaBasedGrammar.MyElement(name));
        }
        return toReturn;
    }

    private List<GrammarResult> collectPluginParams(ArtifactInfoHolder info, HintContext hintCtx) {
        Set params;
        if (info.getGroupId() == null || info.getArtifactId() == null || info.getVersion() == null) {
            return null;
        }
        try {
            params = PluginIndexManager.getPluginParameters((String)info.getGroupId(), (String)info.getArtifactId(), (String)info.getVersion(), null);
            if (params == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ArrayList<GrammarResult> toReturn = new ArrayList<GrammarResult>();
        for (PluginIndexManager.ParameterDetail plg : params) {
            if (!plg.getName().startsWith(hintCtx.getCurrentPrefix())) continue;
            AbstractSchemaBasedGrammar.MyElement me = new AbstractSchemaBasedGrammar.MyElement(plg.getName());
            me.setDescription(plg.getHtmlDetails(true));
            toReturn.add(me);
        }
        return toReturn;
    }

    @Override
    protected Enumeration<GrammarResult> getDynamicValueCompletion(String path, HintContext virtualTextCtx, org.jdom.Element el) {
        FileObject fo;
        ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts;
        List elems;
        RepositoryQueries.Result result;
        ArtifactInfoHolder hold;
        Node previous;
        String prefix;
        if (virtualTextCtx.getCurrentPrefix().length() > 0 && (prefix = virtualTextCtx.getCurrentPrefix()).lastIndexOf("${") > prefix.lastIndexOf("}")) {
            FileObject fo2;
            int s;
            int propStart = prefix.lastIndexOf("${") + 2;
            int delLen = -1;
            String propPrefix = prefix.substring(propStart);
            String val = virtualTextCtx.getNodeValue();
            int e = val.indexOf(125, propStart);
            if (e != -1 && ((s = val.indexOf("${", propStart)) == -1 || e < s)) {
                delLen = e - (propStart + propPrefix.length()) + 1;
            }
            if ((fo2 = this.getEnvironment().getFileObject()) != null) {
                ArrayList<String> set = new ArrayList<String>();
                set.add("basedir");
                set.add("project.build.finalName");
                set.add("project.version");
                set.add("project.groupId");
                try {
                    Properties props;
                    NbMavenProject nbprj;
                    Project p = ProjectManager.getDefault().findProject(fo2.getParent());
                    if (p != null && (nbprj = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class)) != null && (props = nbprj.getMavenProject().getProperties()) != null) {
                        set.addAll(props.stringPropertyNames());
                    }
                }
                catch (IOException ex) {
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                ArrayList<AbstractSchemaBasedGrammar.ExpressionValueTextElement> elems2 = new ArrayList<AbstractSchemaBasedGrammar.ExpressionValueTextElement>();
                Collections.sort(set);
                String suffix = virtualTextCtx.getNodeValue().substring(prefix.length());
                int pplen = propPrefix.length();
                for (String pr : set) {
                    if (!pr.startsWith(propPrefix)) continue;
                    int l = delLen;
                    if (l == -1) {
                        for (l = 0; l < suffix.length() && l + pplen < pr.length() && suffix.charAt(l) == pr.charAt(pplen + l); ++l) {
                        }
                    }
                    elems2.add(new AbstractSchemaBasedGrammar.ExpressionValueTextElement(pr, propPrefix, l));
                }
                return Collections.enumeration(elems2);
            }
        }
        if (path.endsWith("executions/execution/goals/goal")) {
            MavenEmbedder embedder;
            previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getParentNode().getParentNode().getParentNode() : virtualTextCtx.getParentNode().getParentNode().getParentNode().getParentNode();
            ArtifactInfoHolder info = this.findPluginInfo(previous = previous.getPreviousSibling(), embedder = EmbedderFactory.getOnlineEmbedder(), true);
            Enumeration<GrammarResult> res = this.collectGoals(info, virtualTextCtx);
            if (res == null) {
                Document pluginDoc = this.loadDocument(info, embedder);
                if (pluginDoc != null) {
                    return this.collectGoals(pluginDoc, virtualTextCtx);
                }
            } else {
                return res;
            }
        }
        if (path.endsWith("executions/execution/phase")) {
            return super.createTextValueList(Constants.DEFAULT_PHASES.toArray(new String[Constants.DEFAULT_PHASES.size()]), virtualTextCtx);
        }
        if ((path.endsWith("dependencies/dependency/version") || path.endsWith("plugins/plugin/version") || path.endsWith("extensions/extension/version") || path.endsWith("/project/parent/version")) && (hold = this.findPluginInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling(), null, false)).getGroupId() != null && hold.getArtifactId() != null) {
            RepositoryQueries.Result result2 = RepositoryQueries.getVersionsResult((String)hold.getGroupId(), (String)hold.getArtifactId(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            List verStrings = result2.getResults();
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> elems3 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            HashSet<String> uniques = new HashSet<String>();
            for (NBVersionInfo vers : verStrings) {
                if (uniques.contains(vers.getVersion()) || !vers.getVersion().startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                uniques.add(vers.getVersion());
                elems3.add(new AbstractSchemaBasedGrammar.MyTextElement(vers.getVersion(), virtualTextCtx.getCurrentPrefix()));
            }
            if (result2.isPartial()) {
                elems3.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(elems3);
        }
        if (path.endsWith("dependencies/dependency/groupId") || path.endsWith("extensions/extension/groupId")) {
            result = RepositoryQueries.getGroupsResult((List)RepositoryPreferences.getInstance().getRepositoryInfos());
            List elems4 = result.getResults();
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts2 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String elem : elems4) {
                if (!elem.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                texts2.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result.isPartial()) {
                texts2.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts2);
        }
        if (path.endsWith("plugins/plugin/groupId")) {
            result = RepositoryQueries.filterPluginGroupIdsResult((String)virtualTextCtx.getCurrentPrefix(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts3 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String elem : result.getResults()) {
                texts3.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result.isPartial()) {
                texts3.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts3);
        }
        if ((path.endsWith("dependencies/dependency/artifactId") || path.endsWith("extensions/extension/artifactId")) && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null) {
            RepositoryQueries.Result result3 = RepositoryQueries.getArtifactsResult((String)hold.getGroupId(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            elems = result3.getResults();
            texts = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            String currprefix = virtualTextCtx.getCurrentPrefix();
            for (String elem : elems) {
                if (!elem.startsWith(currprefix)) continue;
                texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, currprefix));
            }
            if (result3.isPartial()) {
                texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts);
        }
        if (path.endsWith("dependencies/dependency/classifier") && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null && hold.getArtifactId() != null && hold.getVersion() != null) {
            RepositoryQueries.Result result4 = RepositoryQueries.getRecordsResult((String)hold.getGroupId(), (String)hold.getArtifactId(), (String)hold.getVersion(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            elems = result4.getResults();
            texts = new ArrayList();
            String currprefix = virtualTextCtx.getCurrentPrefix();
            HashSet<String> uniques = new HashSet<String>();
            for (NBVersionInfo elem : elems) {
                if (uniques.contains(elem.getClassifier()) || elem.getClassifier() == null || !elem.getClassifier().startsWith(currprefix)) continue;
                texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem.getClassifier(), currprefix));
                uniques.add(elem.getClassifier());
            }
            if (result4.isPartial()) {
                texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts);
        }
        if (path.endsWith("plugins/plugin/artifactId") && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null) {
            RepositoryQueries.Result result5 = RepositoryQueries.filterPluginArtifactIdsResult((String)hold.getGroupId(), (String)virtualTextCtx.getCurrentPrefix(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts4 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String elem : result5.getResults()) {
                texts4.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result5.isPartial()) {
                texts4.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts4);
        }
        if (path.endsWith("dependencies/dependency/scope")) {
            if (path.contains("dependencyManagement")) {
                ArrayList<String> lst = new ArrayList<String>(Arrays.asList(SCOPES));
                lst.add("import");
                Collections.sort(lst);
                return super.createTextValueList(lst.toArray(new String[0]), virtualTextCtx);
            }
            return super.createTextValueList(SCOPES, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/releases/updatePolicy") || path.endsWith("repositories/repository/snapshots/updatePolicy") || path.endsWith("pluginRepositories/pluginRepository/releases/updatePolicy") || path.endsWith("pluginRepositories/pluginRepository/snapshots/updatePolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.UPDATE_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repository/releases/checksumPolicy") || path.endsWith("repository/snapshots/checksumPolicy") || path.endsWith("pluginRepository/releases/checksumPolicy") || path.endsWith("pluginRepository/snapshots/checksumPolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.CHECKSUM_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/layout") || path.endsWith("pluginRepositories/pluginRepository/layout") || path.endsWith("distributionManagement/repository/layout")) {
            return super.createTextValueList(MavenSettingsGrammar.LAYOUTS, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/url") || path.endsWith("pluginRepositories/pluginRepository/url") || path.endsWith("distributionManagement/repository/url")) {
            List<String> repoIds = this.getRepoUrls();
            return super.createTextValueList(repoIds.toArray(new String[0]), virtualTextCtx);
        }
        if (path.endsWith("modules/module") && (fo = this.getEnvironment().getFileObject()) != null) {
            File dir = FileUtil.toFile((FileObject)fo).getParentFile();
            String prefix2 = virtualTextCtx.getCurrentPrefix();
            boolean endingSlash = prefix2.endsWith("/");
            String[] elms = StringUtils.split((String)prefix2, (String)"/");
            String lastElement = "";
            for (int i = 0; i < elms.length; ++i) {
                if ("..".equals(elms[i])) {
                    dir = dir != null ? dir.getParentFile() : null;
                    continue;
                }
                if (i < elms.length - (endingSlash ? 0 : 1)) {
                    dir = dir != null ? new File(dir, elms[i]) : null;
                    continue;
                }
                lastElement = elms[i];
            }
            String string = prefix2 = lastElement != null ? lastElement : prefix2;
            if (dir == null || !dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File[] modules = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && new File(pathname, "pom.xml").exists();
                }
            });
            ArrayList<AbstractSchemaBasedGrammar.MyTextElement> elems5 = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
            for (int i = 0; i < modules.length; ++i) {
                if (!modules[i].getName().startsWith(prefix2)) continue;
                elems5.add(new AbstractSchemaBasedGrammar.MyTextElement(modules[i].getName(), prefix2));
            }
            return Collections.enumeration(elems5);
        }
        return null;
    }

    private List<String> getRepoUrls() {
        ArrayList<String> repos = new ArrayList<String>();
        List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo ri : ris) {
            if (ri.getRepositoryUrl() == null) continue;
            repos.add(ri.getRepositoryUrl());
        }
        return repos;
    }

    private Document loadDocument(ArtifactInfoHolder info, MavenEmbedder embedder) {
        if (info.getArtifactId() != null && info.getGroupId() != null && info.getVersion() != null) {
            Artifact art = embedder.createArtifact(info.getGroupId(), info.getArtifactId(), info.getVersion(), null, "jar");
            String repopath = embedder.getLocalRepository().pathOf(art);
            File fil = new File(embedder.getLocalRepositoryFile(), repopath);
            if (fil.exists()) {
                try {
                    JarFile jf = new JarFile(fil);
                    JarEntry entry = jf.getJarEntry("META-INF/maven/plugin.xml");
                    if (entry != null) {
                        InputStream str = jf.getInputStream(entry);
                        SAXBuilder builder = new SAXBuilder();
                        return builder.build(str);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINER, "", ex);
                }
                catch (JDOMException ex) {
                    LOG.log(Level.FINER, "", ex);
                }
            }
        }
        return null;
    }

    private Enumeration<GrammarResult> collectGoals(Document pluginDoc, HintContext virtualTextCtx) {
        Iterator it = pluginDoc.getRootElement().getDescendants(new Filter(){

            public boolean matches(Object object) {
                org.jdom.Element el;
                return object instanceof org.jdom.Element && "goal".equals((el = (org.jdom.Element)object).getName()) && el.getParentElement() != null && "mojo".equals(el.getParentElement().getName());
            }
        });
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> toReturn = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        while (it.hasNext()) {
            org.jdom.Element el = (org.jdom.Element)it.next();
            String name = el.getText();
            if (!name.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
            toReturn.add(new AbstractSchemaBasedGrammar.MyTextElement(name, virtualTextCtx.getCurrentPrefix()));
        }
        return Collections.enumeration(toReturn);
    }

    private Enumeration<GrammarResult> collectGoals(ArtifactInfoHolder info, HintContext virtualTextCtx) {
        Set goals;
        if (info.getGroupId() == null || info.getArtifactId() == null || info.getVersion() == null) {
            return null;
        }
        try {
            goals = PluginIndexManager.getPluginGoals((String)info.getGroupId(), (String)info.getArtifactId(), (String)info.getVersion());
            if (goals == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> toReturn = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        for (String name : goals) {
            if (!name.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
            toReturn.add(new AbstractSchemaBasedGrammar.MyTextElement(name, virtualTextCtx.getCurrentPrefix()));
        }
        return Collections.enumeration(toReturn);
    }

    private static class ArtifactInfoHolder {
        private String artifactId;
        private String groupId;
        private String version;

        private ArtifactInfoHolder() {
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

