/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import org.netbeans.modules.cnd.repository.Logger;
import org.netbeans.modules.cnd.repository.disk.FileRWAccess;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public final class BufferedRWAccess
implements FileRWAccess {
    private static final int BUFFER_SIZE = Stats.bufSize > 0 ? Stats.bufSize : 0x100000;
    private final boolean writable;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel channel;
    private final String path;
    private final ByteBuffer writeBuffer;
    private final Object lock = new Object();
    private long actualSize;
    private long virtualSize;
    private static final java.util.logging.Logger log = Logger.getInstance();

    public BufferedRWAccess(File file, boolean writable) throws IOException {
        this.path = file.getAbsolutePath();
        this.writable = writable;
        File parent = new File(file.getParent());
        if (writable && !parent.exists()) {
            parent.mkdirs();
        }
        this.randomAccessFile = new RandomAccessFile(file, writable ? "rw" : "r");
        this.channel = this.randomAccessFile.getChannel();
        this.virtualSize = this.actualSize = this.channel.size();
        this.writeBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readData(long offset, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        long fileSize = this.virtualSize - (long)BUFFER_SIZE;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "will read from the file {0} starting from offset {1} and size {2}", new Object[]{this.path, offset, size});
        }
        if (offset + (long)size <= fileSize) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "will read from the channnel, data are already on the disk");
            }
            this.channel.read(buffer, offset);
        } else {
            Object object = this.lock;
            synchronized (object) {
                fileSize = this.actualSize;
                if (this.writable && offset + (long)size > fileSize) {
                    this.flushWriteBuffer();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "flushed on the disk from the buffer, now will read data from the disk");
                }
                this.channel.read(buffer, offset);
            }
        }
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long appendData(ByteBuffer data) throws IOException {
        long position;
        int dataSize = data.limit();
        Object object = this.lock;
        synchronized (object) {
            position = this.channel.size() + (long)this.writeBuffer.position();
            while (data.hasRemaining()) {
                if (!this.writeBuffer.hasRemaining()) {
                    this.flushWriteBuffer();
                }
                this.writeBuffer.put(data.get());
            }
            this.virtualSize += (long)dataSize;
        }
        return position;
    }

    @Override
    public long size() throws IOException {
        return this.virtualSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long size) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.writeBuffer.clear();
            this.channel.truncate(size);
            this.actualSize = this.virtualSize = size;
        }
    }

    @Override
    public long move(FileRWAccess from, long offset, int size) throws IOException {
        if (!(from instanceof BufferedRWAccess)) {
            throw new IllegalArgumentException("Illegal class to move from: " + from.getClass().getName());
        }
        BufferedRWAccess from2 = (BufferedRWAccess)from;
        ByteBuffer buffer = from2.readData(offset, size);
        return this.appendData(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.writable) {
                this.flushWriteBuffer();
            }
            assert (this.actualSize == this.virtualSize);
            this.channel.close();
        }
    }

    @Override
    public boolean isValid() throws IOException {
        return this.randomAccessFile.getFD().valid();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.path + ']';
    }

    private void flushWriteBuffer() throws IOException {
        this.writeBuffer.flip();
        this.actualSize += (long)this.channel.write(this.writeBuffer, this.actualSize);
        this.writeBuffer.clear();
    }
}

