/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class Util {
    public static final String PROTO_HTTP = "http";
    public static final String PROTO_HTTPS = "https";
    public static final String PROTO_FILE = "file";
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    private static final Set<String> propertiesToFix;

    private Util() {
        throw new IllegalStateException("No instance allowed");
    }

    static ClassPath createClassPath(String classpath) {
        Parameters.notNull((CharSequence)"classpath", (Object)classpath);
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<PathResourceImplementation> list = new ArrayList<PathResourceImplementation>();
        while (tokenizer.hasMoreTokens()) {
            String item = tokenizer.nextToken();
            File f = FileUtil.normalizeFile((File)new File(item));
            URL url = Util.getRootURL(f);
            if (url == null) continue;
            list.add(ClassPathSupport.createResource((URL)url));
        }
        return ClassPathSupport.createClassPath(list);
    }

    static URL getRootURL(File f) {
        try {
            URL url = Utilities.toURI((File)f).toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!f.exists()) {
                String surl = url.toExternalForm();
                if (!surl.endsWith("/")) {
                    url = new URL(surl + "/");
                }
            } else if (f.isFile()) {
                try {
                    ZipFile z = new ZipFile(f);
                    z.close();
                    url = FileUtil.getArchiveRoot((URL)url);
                }
                catch (IOException e) {
                    url = null;
                }
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String normalizeName(String displayName) {
        StringBuilder normalizedName = new StringBuilder();
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                normalizedName.append(c);
                continue;
            }
            normalizedName.append('_');
        }
        return normalizedName.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform plat) {
        String version = (String)plat.getSystemProperties().get("java.specification.version");
        if (version == null) {
            version = "1.1";
        }
        return Util.makeSpec(version);
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders) {
        return Util.findTool(toolName, installFolders, null);
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders, String archFolderName) {
        assert (toolName != null);
        for (FileObject root : installFolders) {
            FileObject tool;
            FileObject bin = root.getFileObject("bin");
            if (bin == null || archFolderName != null && (bin = bin.getFileObject(archFolderName)) == null || (tool = bin.getFileObject(toolName, Utilities.isWindows() ? "exe" : null)) == null) continue;
            return tool;
        }
        return null;
    }

    public static String getExtensions(String extPath) {
        if (extPath == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tk = new StringTokenizer(extPath, File.pathSeparator);
        while (tk.hasMoreTokens()) {
            File extFolder = FileUtil.normalizeFile((File)new File(tk.nextToken()));
            File[] files = extFolder.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.exists()) {
                    LOG.log(Level.WARNING, NbBundle.getMessage(Util.class, (String)"MSG_BrokenExtension"), new Object[]{f.getName(), extFolder.getAbsolutePath()});
                    continue;
                }
                if (Utilities.isMac() && "._.DS_Store".equals(f.getName())) continue;
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo == null) {
                    LOG.log(Level.WARNING, "Cannot create FileObject for file: {0} exists: {1}", new Object[]{f.getAbsolutePath(), f.exists()});
                    continue;
                }
                if (!FileUtil.isArchiveFile((FileObject)fo)) continue;
                sb.append(File.pathSeparator);
                sb.append(files[i].getAbsolutePath());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(File.pathSeparator.length());
    }

    public static boolean isRemote(@NonNull URL url) {
        Parameters.notNull((CharSequence)"url", (Object)url);
        return Util.isRemoteProtocol(url.getProtocol());
    }

    public static boolean isRemoteProtocol(@NonNull String protocol) {
        Parameters.notNull((CharSequence)"protocol", (Object)protocol);
        return PROTO_HTTP.equals(protocol) || PROTO_HTTPS.equals(protocol);
    }

    /*
     * WARNING - void declaration
     */
    @NullUnknown
    public static String fixSymLinks(@NonNull String key, @NullAllowed String value, @NonNull Collection<? extends FileObject> installFolders) {
        if (value != null && propertiesToFix.contains(key)) {
            try {
                String[] pathElements = value.split(File.pathSeparator);
                boolean changed = false;
                for (FileObject fileObject : installFolders) {
                    String canonicalPath;
                    String path;
                    File f = FileUtil.toFile((FileObject)fileObject);
                    if (f == null || (path = f.getAbsolutePath()).equals(canonicalPath = f.getCanonicalPath())) continue;
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (!pathElements[i].startsWith(canonicalPath)) continue;
                        pathElements[i] = path + pathElements[i].substring(canonicalPath.length());
                        changed = true;
                    }
                }
                if (changed) {
                    void var6_9;
                    StringBuilder sb = new StringBuilder();
                    boolean bl = false;
                    while (var6_9 < pathElements.length) {
                        if (var6_9 > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(pathElements[var6_9]);
                        ++var6_9;
                    }
                    return sb.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    @NonNull
    public static Collection<FileObject> toFileObjects(Collection<? extends URL> urls) {
        if (urls.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>(urls.size());
        for (URL uRL : urls) {
            FileObject fo = URLMapper.findFileObject((URL)uRL);
            if (fo == null) continue;
            result.add(fo);
        }
        return result;
    }

    private static SpecificationVersion makeSpec(String vers) {
        if (vers != null) {
            try {
                return new SpecificationVersion(vers);
            }
            catch (NumberFormatException nfe) {
                System.err.println("WARNING: invalid specification version: " + vers);
                while (true) {
                    vers = vers.substring(0, vers.length() - 1);
                    try {
                        return new SpecificationVersion(vers);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (vers.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("sun.boot.class.path");
        p.add("sun.boot.library.path");
        p.add("java.library.path");
        p.add("java.ext.dirs");
        p.add("java.home");
        p.add("java.endorsed.dirs");
        propertiesToFix = Collections.unmodifiableSet(p);
    }
}

