/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.convertor.ProjectConvertorFactory;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ProjectConvertors {
    private ProjectConvertors() {
        throw new IllegalStateException("No instance allowed");
    }

    public static boolean isConvertorProject(@NonNull Project project) {
        return ProjectConvertorFactory.isConvertorProject(project);
    }

    public static void unregisterConvertorProject(@NonNull Project project) {
        ProjectConvertorFactory.unregisterConvertorProject(project);
    }

    @CheckForNull
    public static Project getNonConvertorOwner(@NonNull FileObject file) {
        for (FileObject parent = file.getParent(); parent != null; parent = parent.getParent()) {
            Project prj = FileOwnerQuery.getOwner((FileObject)parent);
            if (prj == null || ProjectConvertors.isConvertorProject(prj)) continue;
            return prj;
        }
        return null;
    }

    @NonNull
    public static FileEncodingQueryImplementation createFileEncodingQuery() {
        return new ConvertorFileEncodingQuery();
    }

    @NonNull
    public static Lookup createProjectConvertorLookup(Object ... instances) {
        return new CloseableLookup(instances);
    }

    private static final class CloseableLookup
    extends ProxyLookup
    implements Closeable {
        CloseableLookup(Object ... instances) {
            this.setLookups(new Lookup[]{Lookups.fixed((Object[])instances)});
        }

        @Override
        public void close() throws IOException {
            this.setLookups(new Lookup[]{Lookup.EMPTY});
        }
    }

    private static final class ConvertorFileEncodingQuery
    extends FileEncodingQueryImplementation {
        ConvertorFileEncodingQuery() {
        }

        @CheckForNull
        public Charset getEncoding(@NonNull FileObject file) {
            Project p = ProjectConvertors.getNonConvertorOwner(file);
            return p != null ? ((FileEncodingQueryImplementation)p.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(file) : null;
        }
    }
}

