/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.lexer;

public class TwigStateStack {
    public byte[] stack;
    private int lastIn = -1;

    public TwigStateStack() {
        this(5);
    }

    public TwigStateStack(int stackSize) {
        this.stack = new byte[stackSize];
        this.lastIn = -1;
    }

    public boolean isEmpty() {
        return this.lastIn == -1;
    }

    public int popStack() {
        byte result = this.stack[this.lastIn];
        --this.lastIn;
        return result;
    }

    public void pushStack(int state) {
        ++this.lastIn;
        if (this.lastIn == this.stack.length) {
            this.multiplySize();
        }
        this.stack[this.lastIn] = (byte)state;
    }

    private void multiplySize() {
        int length = this.stack.length;
        byte[] temp = new byte[length * 2];
        System.arraycopy(this.stack, 0, temp, 0, length);
        this.stack = temp;
    }

    public int clear() {
        this.lastIn = -1;
        return this.lastIn;
    }

    public int size() {
        return this.lastIn + 1;
    }

    public TwigStateStack createClone() {
        TwigStateStack rv = new TwigStateStack(this.size());
        rv.copyFrom(this);
        return rv;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TwigStateStack)) {
            return false;
        }
        TwigStateStack s2 = (TwigStateStack)obj;
        if (this.lastIn != s2.lastIn) {
            return false;
        }
        for (int i = this.lastIn; i >= 0; --i) {
            if (this.stack[i] == s2.stack[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.lastIn;
        for (int i = this.lastIn; i >= 0; --i) {
            hash = 31 * hash + this.stack[i];
        }
        return hash;
    }

    public void copyFrom(TwigStateStack s) {
        while (s.lastIn >= this.stack.length) {
            this.multiplySize();
        }
        this.lastIn = s.lastIn;
        for (int i = 0; i <= s.lastIn; ++i) {
            this.stack[i] = s.stack[i];
        }
    }

    public boolean contains(int state) {
        for (int i = 0; i <= this.lastIn; ++i) {
            if (this.stack[i] != state) continue;
            return true;
        }
        return false;
    }

    public int get(int index) {
        return this.stack[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i <= this.lastIn; ++i) {
            sb.append(" stack[").append(i).append("]= ").append(this.stack[i]);
        }
        return sb.toString();
    }
}

