/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.create;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.create.CreatePanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateAction
implements ActionListener,
HelpCtx.Provider {
    private final File[] rootFiles;

    public CreateAction(List<File> rootFiles) {
        this.rootFiles = rootFiles.toArray(new File[rootFiles.size()]);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.mercurial.ui.create.CreateAction");
    }

    private boolean isEnabled() {
        if (this.rootFiles == null || this.rootFiles.length == 0) {
            this.notifyImportImpossible(NbBundle.getMessage(CreateAction.class, (String)"MSG_WrongSelection"));
            return false;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(this.rootFiles[0]);
        if (root == null) {
            return true;
        }
        this.notifyImportImpossible(NbBundle.getMessage(CreateAction.class, (String)"MSG_AlreadyVersioned"));
        return false;
    }

    private File getCommonAncestor(File firstFile, File secondFile) {
        if (firstFile.equals(secondFile)) {
            return firstFile;
        }
        for (File tempFirstFile = firstFile; tempFirstFile != null; tempFirstFile = tempFirstFile.getParentFile()) {
            for (File tempSecondFile = secondFile; tempSecondFile != null; tempSecondFile = tempSecondFile.getParentFile()) {
                if (!tempFirstFile.equals(tempSecondFile)) continue;
                return tempSecondFile;
            }
        }
        return null;
    }

    private File getCommonAncestor(File[] files) {
        File f1 = files[0];
        for (int i = 1; i < files.length; ++i) {
            File f = this.getCommonAncestor(f1, files[i]);
            if (f == null) {
                Mercurial.LOG.log(Level.SEVERE, "Unable to get common parent of {0} and {1} ", new Object[]{f1.getAbsolutePath(), files[i].getAbsolutePath()});
                continue;
            }
            f1 = f;
        }
        return f1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.performCreate();
    }

    private void performCreate() {
        HgUtils.runIfHgAvailable(new Runnable(){

            @Override
            public void run() {
                final Mercurial hg = Mercurial.getInstance();
                final File rootToManage = CreateAction.this.selectRootToManage();
                if (rootToManage == null) {
                    return;
                }
                RequestProcessor rp = hg.getRequestProcessor(rootToManage);
                HgProgressSupport supportCreate = new HgProgressSupport(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform() {
                        Utils.logVCSActionEvent((String)"HG");
                        try {
                            OutputLogger logger = this.getLogger();
                            logger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE"));
                            logger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE_SEP"));
                            logger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_INIT", (Object)rootToManage));
                            HgCommand.doCreate(rootToManage, logger);
                            hg.versionedFilesChanged();
                            hg.refreshAllAnnotations();
                        }
                        catch (HgException.HgCommandCanceledException ex) {
                        }
                        catch (HgException ex) {
                            HgUtils.notifyException(ex);
                        }
                        finally {
                            Mercurial.getInstance().clearAncestorCaches();
                            VersioningSupport.versionedRootsChanged();
                        }
                    }
                };
                supportCreate.start(rp, rootToManage, NbBundle.getMessage(CreateAction.class, (String)"MSG_Create_Progress"));
                HgProgressSupport supportAdd = new HgProgressSupport(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        try {
                            FileStatusCache cache = hg.getFileStatusCache();
                            Calendar start = Calendar.getInstance();
                            cache.refreshAllRoots(Collections.singletonMap(rootToManage, Collections.singleton(rootToManage)));
                            Calendar end = Calendar.getInstance();
                            Mercurial.LOG.log(Level.FINE, "cache refresh took {0} millisecs", end.getTimeInMillis() - start.getTimeInMillis());
                            File[] repositoryFiles = cache.listFiles(new File[]{rootToManage}, 4);
                            logger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_ADD", (Object)repositoryFiles.length));
                            if (repositoryFiles.length < 500) {
                                for (File f : repositoryFiles) {
                                    logger.output("\t" + f.getAbsolutePath());
                                }
                            }
                            HgUtils.createIgnored(rootToManage);
                            logger.output("");
                            logger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE_WARNING"));
                        }
                        finally {
                            logger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                            logger.output("");
                        }
                    }
                };
                supportAdd.start(rp, rootToManage, NbBundle.getMessage(CreateAction.class, (String)"MSG_Create_Add_Progress"));
            }
        });
    }

    private File selectRootToManage() {
        File rootPath = this.getSuggestedRoot();
        final CreatePanel panel = new CreatePanel();
        panel.lblMessage.setVisible(false);
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Label"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CreatePanel.class), null);
        dd.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        final RequestProcessor.Task validateTask = Mercurial.getInstance().getRequestProcessor().create(new Runnable(){

            @Override
            public void run() {
                FileObject projectDir;
                FileObject fo;
                Project p;
                String validatedPath = panel.tfRootPath.getText();
                String errorMessage = null;
                boolean valid = !validatedPath.trim().isEmpty();
                File dir = new File(validatedPath);
                if (!dir.isDirectory()) {
                    errorMessage = NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Error_Directory");
                    if (Mercurial.LOG.isLoggable(Level.FINE) && dir.exists()) {
                        Mercurial.LOG.fine("CreateAction.selectRootToManage.validateTask: selected a file: " + dir);
                    }
                    valid = false;
                }
                if (valid) {
                    File[] children;
                    if (Thread.interrupted()) {
                        return;
                    }
                    for (File f : children = dir.listFiles()) {
                        File repoRoot = null;
                        if (!f.isDirectory() || (repoRoot = Mercurial.getInstance().getRepositoryRoot(f)) == null) continue;
                        valid = false;
                        if (Mercurial.LOG.isLoggable(Level.FINE) && dir.exists()) {
                            Mercurial.LOG.fine("CreateAction.selectRootToManage.validateTask: file is versioned: " + f + ", root: " + repoRoot);
                        }
                        errorMessage = NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Error_Versioned");
                        break;
                    }
                }
                if (Thread.interrupted()) {
                    return;
                }
                if (valid && (p = FileOwnerQuery.getOwner((FileObject)(fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)dir))))) != null && FileUtil.isParentOf((FileObject)(projectDir = p.getProjectDirectory()), (FileObject)fo)) {
                    errorMessage = NbBundle.getMessage(CreateAction.class, (String)"LBL_Create_Panel_Warning_Under_Project");
                }
                if (Thread.interrupted()) {
                    return;
                }
                dd.setValid(valid);
                if (errorMessage != null) {
                    panel.lblMessage.setText(errorMessage);
                    panel.lblMessage.setForeground(UIManager.getDefaults().getColor(valid ? "nb.warningForeground" : "nb.errorForeground"));
                }
                panel.lblMessage.setVisible(errorMessage != null);
                panel.invalidate();
            }
        });
        panel.tfRootPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.validate();
            }

            private void validate() {
                validateTask.cancel();
                dd.setValid(false);
                validateTask.schedule(300);
            }
        });
        panel.tfRootPath.setText(rootPath == null ? "" : rootPath.getAbsolutePath());
        do {
            dialog.setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                rootPath = new File(panel.tfRootPath.getText());
                validateTask.run();
                continue;
            }
            rootPath = null;
        } while (!dd.isValid() && dd.getValue() == DialogDescriptor.OK_OPTION);
        return rootPath;
    }

    private File getSuggestedRoot() {
        if (this.rootFiles == null || this.rootFiles.length == 0) {
            return null;
        }
        Project proj = Utils.getProject((File[])this.rootFiles);
        File projFile = Utils.getProjectFile((Project)proj);
        File root = null;
        root = this.getCommonAncestor(this.rootFiles);
        if (Mercurial.LOG.isLoggable(Level.FINER)) {
            Mercurial.LOG.finer("CreateAction.getSuggestedRoot: common root for " + Arrays.asList(this.rootFiles) + ": " + root);
        }
        if (projFile != null) {
            root = this.getCommonAncestor(root, projFile);
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.finer("CreateAction.getSuggestedRoot: root with project at " + projFile + ": " + root);
            }
        }
        return root;
    }

    private void notifyImportImpossible(String msg) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, NbBundle.getMessage(CreateAction.class, (String)"MSG_ImportNotAllowed"), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }
}

