/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.SrcMgr;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.Lexer;
import org.clang.lex.MacroArgs;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clang.tools.services.impl.PreprocessorSupport;
import org.clang.tools.services.support.FileInfo;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.raw_ostream;

public class FileInfoCallback
extends PPCallbacks {
    private static final int MAX_GENERATED_TOKENS = Integer.getInteger("apt.limit.tokens", 8000000);
    static final int FILE_SIZE_TO_TOKENS_RATIO = Integer.parseInt(System.getProperty("clank.services.file.tokens.ratio", "8"));
    static final int MAX_INITIAL_TOKENS_CAPACITY = Integer.parseInt(System.getProperty("clank.services.max.tokens.capacity", Integer.toString(0x400000)));
    static final int MIN_INITIAL_TOKENS_CAPACITY = Integer.parseInt(System.getProperty("clank.services.min.tokens.capacity", Integer.toString(16384)));
    protected static final boolean TRACE = Boolean.parseBoolean(System.getProperty("clank.callback.trace", "false"));
    protected static final boolean TRACE_TOKEN = Boolean.parseBoolean(System.getProperty("clank.callback.trace.token", "false"));
    private static final boolean TRACE_ALL_TOKENS = Boolean.parseBoolean(System.getProperty("clank.callback.trace.all.token", "false"));
    protected final raw_ostream traceOS;
    private FileEntry MainFile = null;
    private SourceManager SM;
    private Preprocessor PP;
    private final std.vector<FileInfo> includeStack = new std.vector(16L, (Object)null);
    private final SmallVector<SmallVectorToken> poolOfTokens;
    private FileInfo curStackElement = null;
    private SmallVectorToken curStackElementTokens = null;
    private int curStackElementTokensCount = 0;
    private int curStackElementLocForStartOfFile = -1;
    private boolean curStackElementSawErrorDirective = false;
    private InclusionDirectiveInfo curInclusionDirectiveInfo = null;
    private boolean needPPDirectivesState = false;
    private boolean needTokensState = false;
    private boolean needSkippedRangesState = false;
    private boolean needMacroExpansionState = false;
    private boolean needCommentsState = false;
    private boolean needMacroCommentsState = false;
    private boolean isStoppedState = false;
    private final Token $macroExpansionToken = new Token();
    private static final boolean CATCH_IZ_255337 = Boolean.getBoolean("cnd.catch.iz.255337");
    private int curIndex = 0;

    public FileInfoCallback(raw_ostream traceOS) {
        this.poolOfTokens = new SmallVector(0, null);
        this.poolOfTokens.reserve(32);
        this.traceOS = traceOS;
    }

    public void prepareEnterMainSourceFile(Preprocessor PP) {
        this.PP = PP;
        this.SM = PP.getSourceManager();
        this.includeStack.clear();
        this.curStackElement = null;
        this.curStackElementTokens = null;
        this.curStackElementTokensCount = 0;
        this.curStackElementSawErrorDirective = false;
        this.updatePreprocessorStates();
        PP.SetCommentRetentionState(true, false);
    }

    protected final Preprocessor getPreprocessor() {
        return this.PP;
    }

    protected final SourceManager getSourceManager() {
        return this.SM;
    }

    protected final boolean isAfterErrorDirective() {
        return this.curStackElementSawErrorDirective;
    }

    protected boolean onNotFoundInclusionDirective(FileInfo curFile, StringRef FileName, SmallString RecoveryPath, std.vector<DirectoryLookup> SearchedDirs, int SearchedFromIndex) {
        return false;
    }

    protected void onInclusionDirective(FileInfo curFile, InclusionDirectiveInfo directive) {
    }

    protected void onEnter(FileInfo enteredFrom, FileInfo enteredTo) {
    }

    protected void onSkippedInclusionDirective(FileInfo curFile, InclusionDirectiveInfo directive) {
    }

    protected void onExit(FileInfo exitedFrom, FileInfo exitedTo) {
    }

    protected void onUserDiagnosticDirective(FileInfo curStackElement, UserDiagnosticDirectiveInfo directive) {
    }

    protected boolean needPPDirectives() {
        return false;
    }

    protected boolean needTokens() {
        return false;
    }

    protected boolean needSkippedRanges() {
        return false;
    }

    protected boolean needMacroExpansion() {
        return false;
    }

    protected boolean needComments() {
        return false;
    }

    protected boolean needMacroComments() {
        return false;
    }

    protected boolean isStopped() {
        return this.isStoppedState;
    }

    protected void onDeepInclusion() {
    }

    public FileInfoCallback copy() {
        throw new UnsupportedOperationException("This callback doesn't support cloning");
    }

    public final boolean FileNotFound(StringRef FileName, SmallString RecoveryPath, std.vector<DirectoryLookup> SearchedDirs, int SearchedFromIndex) {
        if (TRACE) {
            this.traceOS.$out((CharSequence)"FileNotFound in ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)"\n").flush();
        }
        if (NativeTrace.VERBOSE_MODE) {
            ++FileInfo.NrNotFoundFiles;
        }
        return this.onNotFoundInclusionDirective(this.curStackElement, FileName, RecoveryPath, SearchedDirs, SearchedFromIndex);
    }

    public final void InclusionDirective(SourceLocation HashLoc, SourceLocation EodLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File2, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        int endOffset;
        long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
        int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
        int EndLocRawEncoding = EodLoc.getRawEncodingUInt();
        if (FilenameRange.isValid()) {
            EndLocRawEncoding = FilenameRange.getRawEnd();
            if (FilenameRange.isTokenRange()) {
                int TokSize = Lexer.MeasureTokenLength((int)EndLocRawEncoding, (SourceManager)this.SM, (LangOptions)this.PP.getLangOpts());
                EndLocRawEncoding = SourceLocation.getRawLocWithOffset((int)EndLocRawEncoding, (int)TokSize);
            }
        }
        if (SourceLocation.isMacroID((int)EndLocRawEncoding)) {
            long curExpansionRange = this.SM.getExpansionRange(EndLocRawEncoding);
            long decomposedRangeEnd = this.SM.getDecomposedLoc(ClangGlobals.$second_SourceLocation((long)curExpansionRange));
            int TokSize = Lexer.MeasureTokenLength((int)ClangGlobals.$second_SourceLocation((long)curExpansionRange), (SourceManager)this.SM, (LangOptions)this.PP.getLangOpts());
            endOffset = ClangGlobals.$second_offset((long)decomposedRangeEnd);
            endOffset += TokSize;
        } else {
            long decomposedLocEnd = this.SM.getDecomposedLoc(EndLocRawEncoding);
            endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
        }
        this.curInclusionDirectiveInfo = new InclusionDirectiveInfo(begOffset, endOffset, IsAngled, File2, FileName, SearchPath);
        if (TRACE) {
            std.pairTypeInt HashLocInfo = this.SM.getDecomposedLoc(HashLoc);
            std.pairTypeInt EodLocInfo = this.SM.getDecomposedLoc(EodLoc);
            this.traceOS.$out((CharSequence)"InclusionDirective in ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)"\n");
            this.traceOS.$out((CharSequence)"#include ");
            if (File2 != null) {
                this.traceOS.$out(File2.getName());
            } else {
                this.traceOS.$out((CharSequence)"<NOT_FOUND>");
            }
            this.traceOS.$out((CharSequence)" at [").$out(HashLocInfo.second).$out((CharSequence)", ").$out(EodLocInfo.second);
            this.traceOS.$out((CharSequence)"]\n").flush();
        }
        assert (this.curStackElement != null);
        if (this.needPPDirectivesState) {
            this.curStackElement.onPPDirective(this.curInclusionDirectiveInfo);
        }
        this.onInclusionDirective(this.curStackElement, this.curInclusionDirectiveInfo);
    }

    public final void FileGuarded(FileEntry guardedFile, IdentifierInfo IfDefMacro, int IfDefMacroLocation, IdentifierInfo DefMacro, int DefinedMacroLocation) {
        if (TRACE) {
            this.traceOS.$out((CharSequence)"FileGuarded called in ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)"\n");
            this.traceOS.$out((CharSequence)"\tGuarded:").$out(guardedFile.getName()).$out((CharSequence)"\n").flush();
        }
        assert (this.curStackElement != null);
        if (this.needPPDirectivesState) {
            this.curStackElement.onGuardPositionDetected(IfDefMacro, IfDefMacroLocation, DefMacro, DefinedMacroLocation);
        }
    }

    public final void FileSkipped(FileEntry guardedFile, Token FilenameTok, SrcMgr.CharacteristicKind FileType) {
        if (TRACE) {
            this.traceOS.$out((CharSequence)"FileSkipped in ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)"\n");
            this.traceOS.$out((CharSequence)"\tSkipped:").$out(guardedFile.getName()).$out((CharSequence)"\n").flush();
        }
        if (NativeTrace.VERBOSE_MODE) {
            ++FileInfo.NrSkippedByGuardsFiles;
        }
        assert (this.curInclusionDirectiveInfo != null) : "can not skip file without seeing include directive " + FileInfoCallback.getTraceName(this.curStackElement);
        this.onSkippedInclusionDirective(this.curStackElement, this.curInclusionDirectiveInfo);
        this.curInclusionDirectiveInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FileChanged(SourceLocation Loc, PPCallbacks.FileChangeReason Reason, SrcMgr.CharacteristicKind FileType, FileID ExitedFID) {
        try {
            if (TRACE) {
                this.traceOS.$out((CharSequence)"FileChanged ").$out((CharSequence)Reason.name()).$out((CharSequence)" in ");
                this.traceOS.$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement));
                this.traceOS.$out((CharSequence)"\n").flush();
            }
            assert (this.SM != null);
            if (this.MainFile == null) {
                if (!this.includeStack.empty()) {
                    this.traceOS.$out((CharSequence)"FileChanged: not empty include stack before Entered Main File\n").flush();
                    return;
                }
                FileID mainFileID = this.SM.getMainFileID();
                SourceLocation MainFileLoc = this.SM.getLocForStartOfFile(mainFileID);
                if (ClangGlobals.$eq_SourceLocation((SourceLocation)Loc, (SourceLocation)MainFileLoc) && Reason == PPCallbacks.FileChangeReason.EnterFile) {
                    this.MainFile = this.SM.getFileEntryForID(mainFileID);
                    this.FileEnterImpl(this.MainFile, mainFileID.$ID(), FileType, true);
                }
            } else {
                if (this.includeStack.empty()) {
                    this.traceOS.$out((CharSequence)"FileChanged:empty stack (before Entered Main File?)\n").flush();
                    return;
                }
                if (Reason == PPCallbacks.FileChangeReason.EnterFile) {
                    long LocInfo = this.SM.getDecomposedLoc(Loc.getRawEncodingUInt());
                    int DestFID = ClangGlobals.$first_FileID((long)LocInfo);
                    FileEntry DestFE = this.SM.getFileEntryForID(DestFID);
                    int FileLoc = this.SM.getLocForStartOfFile(DestFID);
                    if (ClangGlobals.$eq_SourceLocation((int)Loc.getRawEncodingUInt(), (int)FileLoc)) {
                        this.FileEnterImpl(DestFE, DestFID, FileType, false);
                    }
                } else if (Reason == PPCallbacks.FileChangeReason.ExitFile && !ExitedFID.isInvalid()) {
                    FileEntry ExitedFE = this.SM.getFileEntryForID(ExitedFID);
                    this.FileExitImpl(ExitedFE, ExitedFID.$ID(), false);
                }
            }
        }
        finally {
            this.curInclusionDirectiveInfo = null;
        }
    }

    public final void EndOfMainFile() {
        assert (this.SM != null);
        this.FileExitImpl(this.MainFile, this.SM.getMainFileID().$ID(), true);
        if (!this.includeStack.empty()) {
            this.traceOS.$out((CharSequence)"Extra entries after EndOfMainFile \n").flush();
            StdVector.iterator B = this.includeStack.begin();
            StdVector.iterator E = this.includeStack.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)B, (StdVector.iterator)E)) {
                this.traceOS.$out((CharSequence)"\t").$out(((FileInfo)B.$star()).getName()).$out((CharSequence)"\n").flush();
                B.$preInc();
            }
        }
        this.MainFile = null;
        this.curStackElement = null;
        this.curStackElementTokens = null;
        this.curStackElementTokensCount = 0;
        this.curInclusionDirectiveInfo = null;
        if (NativeTrace.VERBOSE_MODE) {
            if (FileInfo.MaxPoolOfVectorTokensSize < this.poolOfTokens.size()) {
                FileInfo.MaxPoolOfVectorTokensSize = this.poolOfTokens.size();
            }
            Object[] $array = this.poolOfTokens.$array();
            long TotalCapacity = 0L;
            for (int i = 0; i < this.poolOfTokens.size(); ++i) {
                TotalCapacity += (long)((SmallVectorToken)$array[i]).capacity();
            }
            if (FileInfo.MaxNrOfTokensInPoolOnEndOfMainFile < TotalCapacity) {
                FileInfo.MaxNrOfTokensInPoolOnEndOfMainFile = TotalCapacity;
            }
        }
    }

    public final void MacroExpands(Token MacroNameTok, MacroDirective MD, SourceRange Range, MacroArgs Args) {
        assert (this.SM != null);
        assert (this.MainFile == null == (this.curStackElement == null)) : this.MainFile + " vs. " + this.curStackElement;
        assert (this.curStackElement == null == this.includeStack.empty()) : this.curStackElement + " vs. " + this.includeStack.size();
        if (this.needMacroExpansionState && this.curStackElement != null) {
            MacroInfo macroInfo;
            if (!SourceLocation.isFileID((int)Range.getRawBegin()) || !SourceLocation.isFileID((int)Range.getRawEnd())) {
                return;
            }
            IdentifierInfo II = MacroNameTok.getIdentifierInfo();
            assert (II != null) : "only identifiers are expandable " + MacroNameTok;
            int macroNameLength = MacroNameTok.getLength();
            long decomposedLocBegin = this.SM.getDecomposedLoc(Range.getRawBegin());
            int EndLocRawEncoding = Range.getRawEnd();
            int TokSize = Lexer.MeasureTokenLength((int)EndLocRawEncoding, (SourceManager)this.SM, (LangOptions)this.PP.getLangOpts());
            EndLocRawEncoding = SourceLocation.getRawLocWithOffset((int)EndLocRawEncoding, (int)TokSize);
            long decomposedLocEnd = this.SM.getDecomposedLoc(EndLocRawEncoding);
            int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
            if (TRACE) {
                this.traceOS.$out((CharSequence)"MacroExpands ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
            }
            MacroExpansionInfo info = this.curStackElement.onMacroExpands(begOffset, endOffset, macroNameLength, Range, MD, II);
            MacroInfo macroInfo2 = macroInfo = MD != null ? MD.getMacroInfo() : null;
            if (macroInfo != null && macroInfo.isFunctionLike() && Args != null) {
                Token[] UnexpArgTokens = Args.$UnexpArgTokens();
                for (int argNum = 0; argNum < macroInfo.getNumArgs(); ++argNum) {
                    int firstTokNum = Args.getUnexpArgument(argNum);
                    int argLen = MacroArgs.getArgLength((Token[])UnexpArgTokens, (int)firstTokNum);
                    for (int i = firstTokNum; i < firstTokNum + argLen; ++i) {
                        Token argTok = UnexpArgTokens[i];
                        this.tryMarkMacroIdentifier(argTok);
                    }
                }
            }
            if (this.needTokensState && this.curStackElementTokensCount < MAX_GENERATED_TOKENS) {
                this.$macroExpansionToken.startToken();
                this.$macroExpansionToken.setKind((short)296);
                this.$macroExpansionToken.setAnnotationRange(Range);
                this.$macroExpansionToken.setAnnotationValue((Object)info);
                this.curStackElementTokens.push_back(this.$macroExpansionToken);
                ++this.curStackElementTokensCount;
                this.$macroExpansionToken.$destroy();
            }
        }
    }

    public final void MacroDefined(SourceLocation HashLoc, SourceLocation EodLoc, Token MacroNameTok, MacroDirective MD) {
        MacroInfo macroInfo = MD.getMacroInfo();
        if (this.needPPDirectivesState) {
            long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
            long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
            int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
            if (TRACE) {
                this.traceOS.$out((CharSequence)"MacroDefined ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
            }
            IdentifierInfo[] args = null;
            boolean isVariadic = false;
            if (macroInfo.isFunctionLike()) {
                args = macroInfo.$ArgumentList();
                isVariadic = macroInfo.isVariadic();
            }
            assert (this.curStackElement != null);
            MacroDirectiveInfo MDI = new MacroDirectiveInfo(this.curStackElement, begOffset, endOffset, MacroNameTok, args, isVariadic, true);
            this.curStackElement.onPPDirective(MDI);
        }
        if (this.needMacroExpansionState) {
            for (int i = 0; i < macroInfo.getNumTokens(); ++i) {
                Token bodyToken = macroInfo.getReplacementToken(i);
                this.tryMarkMacroIdentifier(bodyToken);
            }
        }
    }

    public final void MacroUndefined(SourceLocation HashLoc, SourceLocation EodLoc, Token MacroNameTok, MacroDirective MD) {
        if (this.needPPDirectivesState) {
            long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
            long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
            int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
            if (TRACE) {
                this.traceOS.$out((CharSequence)"MacroUndefined ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
            }
            assert (this.curStackElement != null);
            MacroDirectiveInfo MDI = new MacroDirectiveInfo(this.curStackElement, begOffset, endOffset, MacroNameTok, null, false, false);
            this.curStackElement.onPPDirective(MDI);
        }
        if (this.needMacroExpansionState && MD != null) {
            this.curStackElement.onMacroUsage(MacroNameTok, MD);
        }
    }

    public void Defined(Token MacroNameTok, MacroDirective MD, SourceRange Range) {
        if (this.needMacroExpansionState && MD != null) {
            this.curStackElement.onMacroUsage(MacroNameTok, MD);
        }
    }

    public final void If(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, SourceRange ConditionRange, PPCallbacks.ConditionValueKind ConditionValue) {
        if (!this.needSkippedRangesState) {
            return;
        }
        long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
        long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
        long decomposedIfLoc = this.SM.getDecomposedLoc(Loc.getRawEncodingUInt());
        int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
        int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
        int ifOffset = ClangGlobals.$second_offset((long)decomposedIfLoc);
        if (TRACE) {
            this.traceOS.$out((CharSequence)"If ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" ").$out(ifOffset).$out((CharSequence)" ").$out(FileInfoCallback.getConditionValueKindText(ConditionValue)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
        }
        this.curStackElement.onIf(begOffset, endOffset, ifOffset, ConditionValue);
    }

    public final void Ifdef(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, Token MacroNameTok, MacroDirective MD) {
        if (this.needSkippedRangesState) {
            long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
            long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
            long decomposedIfLoc = this.SM.getDecomposedLoc(Loc.getRawEncodingUInt());
            int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
            int ifOffset = ClangGlobals.$second_offset((long)decomposedIfLoc);
            if (TRACE) {
                this.traceOS.$out((CharSequence)"Ifdef ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" ").$out(ifOffset).$out((CharSequence)" ").$out((CharSequence)(MD != null ? "true" : "false")).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
            }
            this.curStackElement.onIf(begOffset, endOffset, ifOffset, MD != null ? PPCallbacks.ConditionValueKind.CVK_True : PPCallbacks.ConditionValueKind.CVK_False);
        }
        if (this.needMacroExpansionState) {
            this.curStackElement.onMacroUsage(MacroNameTok, MD);
        }
    }

    public final void Ifndef(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, Token MacroNameTok, MacroDirective MD) {
        if (this.needSkippedRangesState) {
            long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
            long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
            long decomposedIfLoc = this.SM.getDecomposedLoc(Loc.getRawEncodingUInt());
            int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
            int ifOffset = ClangGlobals.$second_offset((long)decomposedIfLoc);
            if (TRACE) {
                this.traceOS.$out((CharSequence)"Ifndef ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" ").$out(ifOffset).$out((CharSequence)" ").$out((CharSequence)(MD == null ? "true" : "false")).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
            }
            this.curStackElement.onIf(begOffset, endOffset, ifOffset, MD == null ? PPCallbacks.ConditionValueKind.CVK_True : PPCallbacks.ConditionValueKind.CVK_False);
        }
        if (this.needMacroExpansionState) {
            this.curStackElement.onMacroUsage(MacroNameTok, MD);
        }
    }

    public final void Elif(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, SourceRange ConditionRange, PPCallbacks.ConditionValueKind ConditionValue, SourceLocation IfLoc) {
        if (!this.needSkippedRangesState) {
            return;
        }
        long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
        long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
        long decomposedIfLoc = this.SM.getDecomposedLoc(IfLoc.getRawEncodingUInt());
        int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
        int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
        int ifOffset = ClangGlobals.$second_offset((long)decomposedIfLoc);
        if (TRACE) {
            this.traceOS.$out((CharSequence)"Elif ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" ").$out(ifOffset).$out((CharSequence)" ").$out(FileInfoCallback.getConditionValueKindText(ConditionValue)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
        }
        this.curStackElement.onElif(begOffset, endOffset, ifOffset, ConditionValue);
    }

    public final void Else(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, SourceLocation IfLoc) {
        if (!this.needSkippedRangesState) {
            return;
        }
        long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
        long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
        long decomposedIfLoc = this.SM.getDecomposedLoc(IfLoc.getRawEncodingUInt());
        int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
        int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
        int ifOffset = ClangGlobals.$second_offset((long)decomposedIfLoc);
        if (TRACE) {
            this.traceOS.$out((CharSequence)"Else ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" ").$out(ifOffset).$out((CharSequence)" ").$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
        }
        this.curStackElement.onElse(begOffset, endOffset, ifOffset);
    }

    public final void Endif(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, SourceLocation IfLoc) {
        if (!this.needSkippedRangesState) {
            return;
        }
        long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
        long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
        long decomposedIfLoc = this.SM.getDecomposedLoc(IfLoc.getRawEncodingUInt());
        int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
        int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
        int ifOffset = ClangGlobals.$second_offset((long)decomposedIfLoc);
        if (TRACE) {
            this.traceOS.$out((CharSequence)"Endif ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" ").$out(ifOffset).$out((CharSequence)" ").$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
        }
        if (CATCH_IZ_255337 && (begOffset == 4973714 || begOffset == 4973715 || begOffset == 4973716)) {
            int fid = ClangGlobals.$first_FileID((long)decomposedLocBegin);
            MemoryBuffer mb = this.SM.getBuffer(fid);
            char.ptr p = mb.getBufferStart();
            p = (char.ptr)p.$add(begOffset);
            String textAfter = Native.$toString((char.ptr)p, (long)10L);
            p.$dec(100);
            String textBefore = Native.$toString((char.ptr)p, (long)100L);
            new Exception("IZ 255337: dead block end = " + (begOffset - 1) + "\n MemoryBuffer class: " + mb.getClass().getName() + "\n MemoryBuffer size: " + mb.getBufferSize() + " vs. " + mb.getBuffer().size() + " vs. " + this.curStackElement.getFileSize() + "\n has nonASCII ? " + FileInfoCallback.hasNonASCII(mb) + "\n text=\n[" + textBefore + "]^[" + textAfter + "]\n").printStackTrace(System.err);
        }
        this.curStackElement.onEndif(begOffset, endOffset, ifOffset);
    }

    private static boolean hasNonASCII(MemoryBuffer mb) {
        char.ptr p = Native.$tryClone((char.ptr)mb.getBufferStart());
        char.ptr e = mb.getBufferEnd();
        while (p.$less((Object)e)) {
            byte c = p.$star();
            if (!ClangGlobals.isASCII((byte)c)) {
                return true;
            }
            p.$inc(1);
        }
        return false;
    }

    public final boolean UserDiagnostic(SourceLocation HashLoc, SourceLocation EodLoc, Token Tok, StringRef Msg, boolean isWarning) {
        if (!this.needSkippedRangesState) {
            return super.UserDiagnostic(HashLoc, EodLoc, Tok, Msg, isWarning);
        }
        long decomposedLocBegin = this.SM.getDecomposedLoc(HashLoc.getRawEncodingUInt());
        long decomposedLocEnd = this.SM.getDecomposedLoc(EodLoc.getRawEncodingUInt());
        int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
        int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
        if (TRACE) {
            this.traceOS.$out((CharSequence)"UserDiagnostic ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
        }
        assert (this.curStackElement != null);
        UserDiagnosticDirectiveInfo UDI = new UserDiagnosticDirectiveInfo(begOffset, endOffset, Msg, isWarning);
        if (this.needPPDirectivesState) {
            this.curStackElement.onPPDirective(UDI);
        }
        if (!isWarning) {
            this.curStackElement.onUserErrorDiagnostic(begOffset, endOffset);
            this.curStackElementSawErrorDirective = this.curStackElement.sawErrorDirective;
        }
        this.onUserDiagnosticDirective(this.curStackElement, UDI);
        return true;
    }

    public void PragmaOnceDirective(Token once) {
        this.curStackElement.onPragmaOnceDetected(once);
    }

    public final void SourceRangeSkipped(SourceRange Range) {
        assert (this.SM != null);
        assert (this.MainFile == null == (this.curStackElement == null)) : this.MainFile + " vs. " + this.curStackElement;
        assert (this.curStackElement == null == this.includeStack.empty()) : this.curStackElement + " vs. " + this.includeStack.size();
        if (this.needSkippedRangesState && this.curStackElement != null) {
            long decomposedLocBegin = this.SM.getDecomposedLoc(Range.getRawBegin());
            long decomposedLocEnd = this.SM.getDecomposedLoc(Range.getRawEnd());
            int begOffset = ClangGlobals.$second_offset((long)decomposedLocBegin);
            int endOffset = ClangGlobals.$second_offset((long)decomposedLocEnd);
            if (TRACE) {
                this.traceOS.$out((CharSequence)"SourceRangeSkipped ").$out((CharSequence)FileInfoCallback.getTraceName(this.curStackElement)).$out((CharSequence)" [").$out(begOffset).$out((CharSequence)"-").$out(endOffset).$out((CharSequence)"]\n").flush();
            }
            this.curStackElement.onSourceRangeSkipped(begOffset, endOffset);
        }
    }

    public void DeepFileInclusion(SourceLocation HashLoc, SourceLocation EodLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange) {
        this.onDeepInclusion();
    }

    private static String getTraceName(FileEntry FE, int FID) {
        return FE == null ? "" + FID : new std.string(FE.getName()).toJavaString();
    }

    private static String getTraceName(FileInfo FileInfo2) {
        if (FileInfo2 == null) {
            return "null";
        }
        if (FileInfo2.isFile()) {
            return (FileInfo2.isMainFile() ? "[MainFile] " : "") + Casts.toJavaString((char.ptr)FileInfo2.getName());
        }
        return "" + FileInfo2.getFileID();
    }

    private void FileEnterImpl(FileEntry enteredFile, int enteredFID, SrcMgr.CharacteristicKind FileType, boolean startOfMainFile) {
        if (FileID.isInvalid((int)enteredFID)) {
            this.traceOS.$out((CharSequence)"Invalid file is passed to onFileEnter ").$out((CharSequence)FileInfoCallback.getTraceName(enteredFile, enteredFID)).$out((CharSequence)"\n").flush();
            return;
        }
        if (TRACE) {
            this.traceOS.$out((CharSequence)"onFileEnter ").$out((CharSequence)(startOfMainFile ? "Main " : "")).$out((CharSequence)"File ").$out((CharSequence)FileInfoCallback.getTraceName(enteredFile, enteredFID)).$out((CharSequence)"\n").flush();
        }
        if (!startOfMainFile) {
            if (this.includeStack.empty()) {
                this.traceOS.$out((CharSequence)"No entries on InclusionDirective ").$out((CharSequence)FileInfoCallback.getTraceName(enteredFile, enteredFID)).$out((CharSequence)"\n").flush();
                return;
            }
            assert (this.curStackElement == this.includeStack.back());
            this.curStackElement.enterInnerInclude();
        }
        int StartOfFile = this.SM.getLocForStartOfFile(enteredFID);
        FileInfo enterFrom = this.curStackElement;
        this.curStackElement = new FileInfo(this.PP, enteredFile, enteredFID, StartOfFile, FileType, startOfMainFile, this.curIndex++, this.curInclusionDirectiveInfo);
        this.curStackElement.enter();
        this.includeStack.push_back((Object)this.curStackElement);
        this.curStackElementLocForStartOfFile = StartOfFile;
        this.curStackElementSawErrorDirective = false;
        this.curStackElementTokens = null;
        this.curStackElementTokensCount = 0;
        this.onEnter(enterFrom, this.curStackElement);
        this.updatePreprocessorStates();
        if (this.needTokensState) {
            this.curStackElement.prepareTokens(this.poolOfTokens);
            this.curStackElementTokens = this.curStackElement.tokens;
            if (this.curStackElementTokens != null) {
                this.curStackElementTokensCount = this.curStackElementTokens.size();
            }
        }
    }

    private void FileExitImpl(FileEntry exitedFile, int exitedFID, boolean EndOfMainFile) {
        if (FileID.isInvalid((int)exitedFID)) {
            this.traceOS.$out((CharSequence)"Invalid file is passed to onFileExit ").$out((CharSequence)FileInfoCallback.getTraceName(exitedFile, exitedFID)).$out((CharSequence)"\n").flush();
            return;
        }
        if (TRACE) {
            this.traceOS.$out((CharSequence)"onFileExit ").$out((CharSequence)(EndOfMainFile ? "Main " : "")).$out((CharSequence)"File ").$out((CharSequence)FileInfoCallback.getTraceName(exitedFile, exitedFID)).$out((CharSequence)"\n").flush();
        }
        if (this.includeStack.empty()) {
            this.traceOS.$out((CharSequence)"No entries on exitAndPopFile ").$out((CharSequence)FileInfoCallback.getTraceName(exitedFile, exitedFID)).$out((CharSequence)"\n").flush();
            return;
        }
        FileInfo exitedFrom = this.curStackElement;
        assert (this.curStackElement == this.includeStack.back());
        if (this.curStackElement.getFileID() != exitedFID) {
            this.traceOS.$out((CharSequence)"onFileExit ").$out((CharSequence)("" + this.curStackElement));
            this.traceOS.$out((CharSequence)" vs ").$out((CharSequence)FileInfoCallback.getTraceName(exitedFile, exitedFID)).$out((CharSequence)"\n").flush();
            return;
        }
        this.includeStack.pop_back();
        this.curStackElement.exit();
        FileInfo exitedTo = EndOfMainFile ? null : (FileInfo)this.includeStack.back();
        this.onExit(exitedFrom, exitedTo);
        this.curStackElement.releaseTokensIfPossible(this.poolOfTokens);
        this.curStackElementTokens = null;
        this.curStackElementTokensCount = 0;
        this.curStackElement = null;
        this.curStackElementLocForStartOfFile = -1;
        this.curStackElementSawErrorDirective = false;
        if (!EndOfMainFile) {
            if (this.includeStack.empty()) {
                this.traceOS.$out((CharSequence)"No parent entries for FileChanged:ExitFile \n").flush();
                return;
            }
            this.curStackElement = exitedTo;
            this.curStackElementTokens = this.curStackElement.tokens;
            if (this.curStackElementTokens != null) {
                this.curStackElementTokensCount = this.curStackElementTokens.size();
            }
            this.curStackElementLocForStartOfFile = this.curStackElement.StartOfFile;
            this.curStackElementSawErrorDirective = this.curStackElement.sawErrorDirective;
            this.updatePreprocessorStates();
        }
    }

    private void updatePreprocessorStates() {
        this.needPPDirectivesState = this.needPPDirectives();
        this.needTokensState = this.needTokens();
        this.needSkippedRangesState = this.needSkippedRanges();
        this.needMacroExpansionState = this.needMacroExpansion();
        this.needCommentsState = this.needComments();
        this.needMacroCommentsState = this.needMacroComments();
        this.isStoppedState = this.isStopped();
        if (this.isStoppedState) {
            this.PP.cutOffCurFilePreprocessing();
        } else {
            if (PreprocessorSupport.ALLOW_TO_SKIP_TOKENS_BETWEEN_DIRECTIVES) {
                this.PP.SetSkipTokensBetweenDirectives(!this.needTokensState);
            }
            if (this.needTokensState || this.needMacroExpansionState) {
                this.PP.SetCommentRetentionState(this.needCommentsState, this.needMacroCommentsState);
                this.PP.SetMacroExpansionOnlyInDirectives(false);
            } else {
                this.PP.SetCommentRetentionState(false, false);
                this.PP.SetMacroExpansionOnlyInDirectives(true);
            }
        }
    }

    public final void onToken(Token Tok) {
        assert (this.SM != null);
        if (TRACE_ALL_TOKENS) {
            if (!this.needTokensState) {
                this.traceOS.$out(NativePointer.$((String)"needTokens FALSE for ")).$out((CharSequence)"=>");
            }
            this.PP.DumpToken(Tok, true, this.traceOS);
            this.traceOS.$out(NativePointer.$((String)"\n"));
        }
        if (this.needTokensState && !this.isAfterErrorDirective()) {
            if (this.curStackElementTokensCount >= MAX_GENERATED_TOKENS) {
                return;
            }
            assert (this.curStackElementTokens != null);
            assert (this.MainFile == null == (this.curStackElementTokens == null)) : this.MainFile + " vs. " + this.curStackElementTokens;
            assert (this.curStackElementTokens == null == this.includeStack.empty()) : this.curStackElementTokens + " vs. " + this.includeStack.size();
            assert (this.curStackElementTokensCount == this.curStackElementTokens.size()) : this.curStackElementTokensCount + " vs. " + this.curStackElementTokens.size();
            if (NativeTrace.isDebugMode()) {
                int tokOffset;
                int rawLocation = Tok.getRawLocation();
                if (SourceLocation.isFileID((int)rawLocation)) {
                    assert (SourceLocation.getOffset((int)rawLocation) == rawLocation);
                    tokOffset = rawLocation - this.curStackElementLocForStartOfFile;
                    assert (tokOffset == ClangGlobals.$second_offset((long)this.SM.getDecomposedExpansionLoc(rawLocation))) : tokOffset + " vs. " + ClangGlobals.$second_offset((long)this.SM.getDecomposedExpansionLoc(rawLocation));
                } else {
                    tokOffset = ClangGlobals.$second_offset((long)this.SM.getDecomposedExpansionLoc(rawLocation));
                }
                assert (Tok.isNot((short)2)) : "unexpected EOD: " + this.SM.getBufferName(rawLocation) + ":" + tokOffset;
            }
            this.curStackElementTokens.push_back(Tok);
            ++this.curStackElementTokensCount;
            if (TRACE_TOKEN) {
                this.PP.DumpToken(Tok, true, this.traceOS);
                this.traceOS.$out(NativePointer.$((String)"\n"));
            }
            assert (this.curStackElementTokensCount == this.curStackElementTokens.size()) : this.curStackElementTokensCount + " vs. " + this.curStackElementTokens.size();
        }
    }

    private void tryMarkMacroIdentifier(Token possibleMacroToken) {
        MacroDirective bodyMacroDirective;
        IdentifierInfo identInfo;
        if (possibleMacroToken != null && possibleMacroToken.isAnyIdentifier() && (identInfo = possibleMacroToken.getIdentifierInfo()) != null && identInfo.hasMacroDefinition() && (bodyMacroDirective = this.PP.getMacroDirective(identInfo)) != null) {
            this.curStackElement.onMacroUsage(possibleMacroToken, bodyMacroDirective);
        }
    }

    private static CharSequence getConditionValueKindText(PPCallbacks.ConditionValueKind kind) {
        switch (kind) {
            case CVK_True: {
                return "true";
            }
            case CVK_False: {
                return "false";
            }
        }
        return "unevaluated";
    }

    public static final class FileGuardInfo {
        private final IdentifierInfo IfDefMacro;
        private final int IfDefMacroLocation;
        private final IdentifierInfo DefMacro;
        private final int DefinedMacroLocation;

        FileGuardInfo(IdentifierInfo IfDefMacro, int IfDefMacroLocation, IdentifierInfo DefMacro, int DefinedMacroLocation) {
            this.IfDefMacro = IfDefMacro;
            this.IfDefMacroLocation = IfDefMacroLocation;
            this.DefMacro = DefMacro;
            this.DefinedMacroLocation = DefinedMacroLocation;
        }

        public IdentifierInfo getIfDefMacro() {
            return this.IfDefMacro;
        }

        public int getIfDefMacroLocation() {
            return this.IfDefMacroLocation;
        }

        public IdentifierInfo getDefinedMacro() {
            return this.DefMacro;
        }

        public int getDefinedMacroLocation() {
            return this.DefinedMacroLocation;
        }

        public String toString() {
            return "FileGuardInfo{IfDefMacro=" + this.IfDefMacro + ", IfDefMacroLocation=" + SourceLocation.getFromRawEncoding((int)this.IfDefMacroLocation) + ", DefMacro=" + this.DefMacro + ", DefinedMacroLocation=" + SourceLocation.getFromRawEncoding((int)this.DefinedMacroLocation) + '}';
        }
    }

    public static class MacroExpansionInfo {
        private final int startOffset;
        private final int endOffset;
        private final int macroNameLength;
        private final long curExpansionRange;
        private final MacroDirective MD;
        private final IdentifierInfo ExpandedMacroName;

        MacroExpansionInfo(int StartOffset, int EndOffset, int macroNameLength, SourceRange ExpansionRange, MacroDirective MD, IdentifierInfo II) {
            this.startOffset = StartOffset;
            this.endOffset = EndOffset;
            this.macroNameLength = macroNameLength;
            this.curExpansionRange = ClangGlobals.wrap_SourceLocation_SourceLocation((int)ExpansionRange.getRawBegin(), (int)ExpansionRange.getRawEnd());
            this.MD = MD;
            assert (II != null);
            this.ExpandedMacroName = II;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public final int getMacroNameLength() {
            return this.macroNameLength;
        }

        public long getRawExpansionRange() {
            return this.curExpansionRange;
        }

        public MacroDirective getReferencedMacroDirective() {
            return this.MD;
        }

        public IdentifierInfo getExpandedMacroName() {
            return this.ExpandedMacroName;
        }

        public SourceRange getExpansionRange() {
            return new SourceRange(ClangGlobals.$first_SourceLocation((long)this.curExpansionRange), ClangGlobals.$second_SourceLocation((long)this.curExpansionRange));
        }

        public String toString() {
            return "ExpansionInfo [" + this.startOffset + "-" + this.endOffset + ";" + this.getExpansionRange() + "]";
        }
    }

    public static class MacroUsageInfo {
        private final int macroUsageLocation;
        private final int macroTokenLength;
        private final MacroDirective MD;
        private final IdentifierInfo UsedMacroName;

        MacroUsageInfo(int macroUsageLocation, int macroTokenLength, MacroDirective MD, IdentifierInfo MacroName) {
            this.macroUsageLocation = macroUsageLocation;
            this.macroTokenLength = macroTokenLength;
            this.MD = MD;
            this.UsedMacroName = MacroName;
        }

        public final int getUsedMacroNameLocation() {
            return this.macroUsageLocation;
        }

        public final int getUsedMacroNameLength() {
            return this.macroTokenLength;
        }

        public MacroDirective getReferencedMacroDirective() {
            return this.MD;
        }

        public IdentifierInfo getUsedMacroName() {
            return this.UsedMacroName;
        }

        public String toString() {
            return super.toString() + " MacroUsageInfo{" + SourceLocation.getFromRawEncoding((int)this.macroUsageLocation) + "\nUsedMacroName=" + this.UsedMacroName + '}';
        }
    }

    protected static final class MacroDirectiveInfo
    extends PreprocessorDirectiveInfo {
        private final IdentifierInfo MacroName;
        private final int MacroNameLocation;
        private final boolean defined;
        private final IdentifierInfo[] arguments;
        private final boolean isVariadic;
        private final FileInfo fileOwner;

        private MacroDirectiveInfo(FileInfo owner, int HashOffset, int EodOffset, Token MacroNameTok, IdentifierInfo[] args, boolean lastArgIsVariadic, boolean defined) {
            super(HashOffset, EodOffset);
            this.fileOwner = owner;
            this.MacroName = MacroNameTok.getIdentifierInfo();
            assert (this.MacroName != null) : "where is macro name? " + MacroNameTok;
            this.MacroNameLocation = MacroNameTok.getRawLocation();
            this.arguments = args;
            this.isVariadic = lastArgIsVariadic;
            this.defined = defined;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public FileInfo getFileOwner() {
            return this.fileOwner;
        }

        public IdentifierInfo getMacroName() {
            return this.MacroName;
        }

        public int getMacroNameLocation() {
            return this.MacroNameLocation;
        }

        public boolean isFunctionLike() {
            return this.arguments != null;
        }

        public IdentifierInfo[] getArguments() {
            return this.arguments;
        }

        public boolean isVariadic() {
            return this.isVariadic;
        }

        @Override
        public String toString() {
            return super.toString() + " MacroDirectiveInfo{NameAt=" + SourceLocation.getFromRawEncoding((int)this.MacroNameLocation) + "\nMacroName=" + this.MacroName + ",\n" + " defined=" + this.defined + '}';
        }
    }

    protected static final class InclusionDirectiveInfo
    extends PreprocessorDirectiveInfo {
        private final boolean IsAngled;
        private final FileEntry File;
        private final StringRef FileName;
        private final StringRef SearchPath;

        private InclusionDirectiveInfo(int HashOffset, int EodOffset, boolean IsAngled, FileEntry File2, StringRef FileName, StringRef SearchPath) {
            super(HashOffset, EodOffset);
            this.IsAngled = IsAngled;
            this.File = File2;
            this.FileName = new StringRef(FileName);
            this.SearchPath = new StringRef(SearchPath);
        }

        public StringRef getSearchPath() {
            return this.SearchPath;
        }

        public StringRef getFileNameSpelling() {
            return this.FileName;
        }

        public boolean isAngled() {
            return this.IsAngled;
        }

        public FileEntry getFileEntry() {
            return this.File;
        }

        @Override
        public String toString() {
            return super.toString() + " InclusionDirectiveInfo{" + "IsAngled=" + this.IsAngled + ",\n" + " File=" + this.File + ",\n" + " FileName=" + this.FileName + ",\n" + " SearchPath=" + this.SearchPath + ",\n" + '}';
        }
    }

    protected static final class UserDiagnosticDirectiveInfo
    extends PreprocessorDirectiveInfo {
        private final boolean isWarning;
        private final StringRef Msg;

        private UserDiagnosticDirectiveInfo(int HashOffset, int EodOffset, StringRef Msg, boolean isWarning) {
            super(HashOffset, EodOffset);
            this.Msg = new StringRef(Msg);
            this.isWarning = isWarning;
        }

        public StringRef getMessage() {
            return this.Msg;
        }

        public boolean isWarning() {
            return this.isWarning;
        }
    }

    protected static class PreprocessorDirectiveInfo {
        private final int HashOffset;
        private final int EodOffset;
        private Object clientAnnotation;

        private PreprocessorDirectiveInfo(int HashOffset, int EodOffset) {
            this.HashOffset = HashOffset;
            this.EodOffset = EodOffset;
        }

        public final int getHashOffset() {
            return this.HashOffset;
        }

        public final int getEodOffset() {
            return this.EodOffset;
        }

        public final void setAnnotation(Object annotation) {
            assert (this.clientAnnotation == null) : "replacing? " + this.clientAnnotation;
            this.clientAnnotation = annotation;
        }

        public final Object getAnnotation() {
            return this.clientAnnotation;
        }

        public String toString() {
            return "[" + this.HashOffset + "-" + this.EodOffset + "]" + (this.clientAnnotation != null ? " annotation=" + this.clientAnnotation.getClass().getSimpleName() : "");
        }
    }
}

