/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class Utils {
    public static final String DEFAULT_FX_PLATFORM_NAME = NbBundle.getMessage(Utils.class, (String)"Default_JavaFX_Platform");
    public static final String NO_PLATFORM_CHECK_PROPERTY = "org.netbeans.modules.javafx2.platform.NoPlatformCheck";
    private static final String JFXRT_JAR_NAME = "jfxrt.jar";
    private static final String JDK_JRE_PATH = "jre/";
    private static final String[] JFXRT_JAR_JRE_PATHS = new String[]{"lib/", "lib/ext/"};
    private static final String[] JFXRT_OPTIONAL_JARS = new String[]{"javaws.jar", "deploy.jar", "plugin.jar"};
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.javafx2.platform.Utils");
    private static boolean isTest = false;

    private Utils() {
    }

    public static boolean isTest() {
        return isTest;
    }

    public static void setIsTest(boolean test) {
        isTest = test;
    }

    @NonNull
    public static String[] getJavaFxRuntimeLocations() {
        return JFXRT_JAR_JRE_PATHS;
    }

    @NonNull
    public static String getJavaFxRuntimeSubDir() {
        return JDK_JRE_PATH;
    }

    @NonNull
    public static String getJavaFxRuntimeArchiveName() {
        return JFXRT_JAR_NAME;
    }

    @NonNull
    public static String[] getJavaFxRuntimeOptionalNames() {
        return JFXRT_OPTIONAL_JARS;
    }

    public static boolean isArchitechtureCorrect(@NonNull String runtimePath) {
        Parameters.notNull((CharSequence)"runtimePath", (Object)runtimePath);
        if (Boolean.getBoolean(NO_PLATFORM_CHECK_PROPERTY)) {
            return true;
        }
        return true;
    }

    @NonNull
    public static List<? extends URL> getRuntimeClassPath(@NonNull File javafxRuntime) {
        Parameters.notNull((CharSequence)"javafxRuntime", (Object)javafxRuntime);
        ArrayList<URL> result = new ArrayList<URL>();
        File lib = new File(javafxRuntime, "lib");
        File[] children = lib.listFiles(new FileFilter(){

            @Override
            public boolean accept(@NonNull File pathname) {
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        });
        if (children != null) {
            for (File f : children) {
                URL root = FileUtil.urlForArchiveOrDir((File)f);
                if (root == null) continue;
                result.add(root);
            }
        }
        return result;
    }
}

