/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jdk.nashorn.internal.codegen.BranchOptimizer;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Frame;
import jdk.nashorn.internal.codegen.FunctionSignature;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.RuntimeCallSite;
import jdk.nashorn.internal.codegen.SharedScopeCall;
import jdk.nashorn.internal.codegen.objects.FieldObjectCreator;
import jdk.nashorn.internal.codegen.objects.FunctionObjectCreator;
import jdk.nashorn.internal.codegen.objects.MapCreator;
import jdk.nashorn.internal.codegen.objects.ObjectMapCreator;
import jdk.nashorn.internal.codegen.types.ArrayType;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.Scope;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Undefined;

public final class CodeGenerator
extends NodeOperatorVisitor {
    private final Compiler compiler;
    private final Context context;
    private final int callSiteFlags;
    private int regexFieldCount;
    private final Map<SharedScopeCall, SharedScopeCall> scopeCalls = new HashMap<SharedScopeCall, SharedScopeCall>();
    private static final int MAX_REGEX_FIELDS = 2048;

    CodeGenerator(Compiler compiler) {
        this.compiler = compiler;
        this.context = compiler.getContext();
        this.callSiteFlags = this.context._callsite_flags;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public int getCallSiteFlags() {
        return this.getCurrentFunctionNode().isStrictMode() ? this.callSiteFlags | 2 : this.callSiteFlags;
    }

    private MethodEmitter loadIdent(IdentNode identNode) {
        Symbol symbol = identNode.getSymbol();
        if (!symbol.isScope()) {
            assert (symbol.hasSlot() || symbol.isParam());
            return this.method.load(symbol);
        }
        String name = symbol.getName();
        if (CompilerConstants.__FILE__.name().equals(name)) {
            return this.method.load(identNode.getSource().getName());
        }
        if (CompilerConstants.__DIR__.name().equals(name)) {
            return this.method.load(identNode.getSource().getBase());
        }
        if (CompilerConstants.__LINE__.name().equals(name)) {
            return this.method.load(identNode.getSource().getLine(identNode.position())).convert(Type.OBJECT);
        }
        assert (identNode.getSymbol().isScope()) : identNode + " is not in scope!";
        int flags = 1 | this.getCallSiteFlags();
        this.method.loadScope();
        if (symbol.isFastScope(this.getCurrentFunctionNode())) {
            if (symbol.getUseCount() > 200) {
                return this.loadSharedScopeVar(identNode.getType(), symbol, flags);
            }
            return this.loadFastScopeVar(identNode.getType(), symbol, flags, identNode.isFunction());
        }
        return this.method.dynamicGet(identNode.getType(), identNode.getName(), flags, identNode.isFunction());
    }

    private MethodEmitter loadSharedScopeVar(Type valueType, Symbol symbol, int flags) {
        this.method.load(symbol.isFastScope(this.getCurrentFunctionNode()) ? CodeGenerator.getScopeProtoDepth(this.getCurrentBlock(), symbol) : -1);
        SharedScopeCall scopeCall = this.getScopeGet(valueType, symbol, flags | 0x400);
        scopeCall.generateInvoke(this.method);
        return this.method;
    }

    private MethodEmitter loadFastScopeVar(Type valueType, Symbol symbol, int flags, boolean isMethod) {
        this.loadFastScopeProto(symbol, false);
        this.method.dynamicGet(valueType, symbol.getName(), flags | 0x400, isMethod);
        return this.method;
    }

    private MethodEmitter storeFastScopeVar(Type valueType, Symbol symbol, int flags) {
        this.loadFastScopeProto(symbol, true);
        this.method.dynamicSet(valueType, symbol.getName(), flags | 0x400);
        return this.method;
    }

    private static int getScopeProtoDepth(Block currentBlock, Symbol symbol) {
        int result;
        if (currentBlock == symbol.getBlock()) {
            return 0;
        }
        int delta = currentBlock.needsScope() ? 1 : 0;
        Block parentBlock = currentBlock.getParent();
        if (parentBlock != null && (result = CodeGenerator.getScopeProtoDepth(parentBlock, symbol)) != -1) {
            return delta + result;
        }
        if (currentBlock instanceof FunctionNode) {
            for (Block lookupBlock : ((FunctionNode)currentBlock).getReferencingParentBlocks()) {
                int result2 = CodeGenerator.getScopeProtoDepth(lookupBlock, symbol);
                if (result2 == -1) continue;
                return delta + result2;
            }
        }
        return -1;
    }

    private void loadFastScopeProto(Symbol symbol, boolean swap) {
        int depth = CodeGenerator.getScopeProtoDepth(this.getCurrentBlock(), symbol);
        assert (depth != -1);
        if (depth > 0) {
            if (swap) {
                this.method.swap();
            }
            for (int i = 0; i < depth; ++i) {
                this.method.invoke(ScriptObject.GET_PROTO);
            }
            if (swap) {
                this.method.swap();
            }
        }
    }

    public MethodEmitter load(Node node) {
        return this.load(node, false);
    }

    private MethodEmitter load(final Node node, final boolean baseAlreadyOnStack) {
        final Symbol symbol = node.getSymbol();
        if (symbol == null) {
            node.accept(this);
            return this.method;
        }
        final CodeGenerator codegen = this;
        node.accept(new NodeVisitor(this.compileUnit, this.method){

            @Override
            public Node enter(IdentNode identNode) {
                CodeGenerator.this.loadIdent(identNode);
                return null;
            }

            @Override
            public Node enter(AccessNode accessNode) {
                if (!baseAlreadyOnStack) {
                    CodeGenerator.this.load(accessNode.getBase()).convert(Type.OBJECT);
                }
                assert (this.method.peekType().isObject());
                this.method.dynamicGet(node.getType(), accessNode.getProperty().getName(), CodeGenerator.this.getCallSiteFlags(), accessNode.isFunction());
                return null;
            }

            @Override
            public Node enter(IndexNode indexNode) {
                if (!baseAlreadyOnStack) {
                    CodeGenerator.this.load(indexNode.getBase()).convert(Type.OBJECT);
                    CodeGenerator.this.load(indexNode.getIndex());
                }
                this.method.dynamicGetIndex(node.getType(), CodeGenerator.this.getCallSiteFlags(), indexNode.isFunction());
                return null;
            }

            @Override
            public Node enterDefault(Node otherNode) {
                otherNode.accept(codegen);
                this.method.load(symbol);
                return null;
            }
        });
        return this.method;
    }

    @Override
    public Node enter(AccessNode accessNode) {
        if (accessNode.testResolved()) {
            return null;
        }
        this.load(accessNode);
        return null;
    }

    private void initSymbols(Iterable<Symbol> symbols) {
        LinkedList<Symbol> numbers = new LinkedList<Symbol>();
        LinkedList<Symbol> objects = new LinkedList<Symbol>();
        for (Symbol symbol : symbols) {
            boolean isInternal;
            boolean bl = isInternal = symbol.isParam() || symbol.isInternal() || symbol.isThis() || !symbol.canBeUndefined();
            if (!symbol.hasSlot() || isInternal) continue;
            assert (symbol.getSymbolType().isNumber() || symbol.getSymbolType().isObject()) : "no potentially undefined narrower local vars than doubles are allowed: " + symbol + " in " + this.getCurrentFunctionNode();
            if (symbol.getSymbolType().isNumber()) {
                numbers.add(symbol);
                continue;
            }
            if (!symbol.getSymbolType().isObject()) continue;
            objects.add(symbol);
        }
        this.initSymbols(numbers, Type.NUMBER);
        this.initSymbols(objects, Type.OBJECT);
    }

    private void initSymbols(LinkedList<Symbol> symbols, Type type) {
        if (symbols.isEmpty()) {
            return;
        }
        this.method.loadUndefined(type);
        while (!symbols.isEmpty()) {
            Symbol symbol = symbols.removeFirst();
            if (!symbols.isEmpty()) {
                this.method.dup();
            }
            this.method.store(symbol);
        }
    }

    private void symbolInfo(Block block) {
        for (Symbol symbol : block.getFrame().getSymbols()) {
            this.method.localVariable(symbol, block.getEntryLabel(), block.getBreakLabel());
        }
    }

    @Override
    public Node enter(Block block) {
        if (block.testResolved()) {
            return null;
        }
        this.method.label(block.getEntryLabel());
        this.initLocals(block);
        return block;
    }

    @Override
    public Node leave(Block block) {
        this.method.label(block.getBreakLabel());
        this.symbolInfo(block);
        if (block.needsScope()) {
            this.popBlockScope(block);
        }
        return block;
    }

    private void popBlockScope(Block block) {
        MethodEmitter.Label exitLabel = new MethodEmitter.Label("block_exit");
        MethodEmitter.Label recoveryLabel = new MethodEmitter.Label("block_catch");
        MethodEmitter.Label skipLabel = new MethodEmitter.Label("skip_catch");
        this.method.loadScope();
        this.method.invoke(ScriptObject.GET_PROTO);
        this.method.storeScope();
        this.method._goto(skipLabel);
        this.method.label(exitLabel);
        this.method._catch(recoveryLabel);
        this.method.loadScope();
        this.method.invoke(ScriptObject.GET_PROTO);
        this.method.storeScope();
        this.method.athrow();
        this.method.label(skipLabel);
        this.method._try(block.getEntryLabel(), exitLabel, recoveryLabel, Throwable.class);
    }

    @Override
    public Node enter(BreakNode breakNode) {
        if (breakNode.testResolved()) {
            return null;
        }
        for (int i = 0; i < breakNode.getScopeNestingLevel(); ++i) {
            this.closeWith();
        }
        this.method.splitAwareGoto(breakNode.getTargetLabel());
        return null;
    }

    private int loadArgs(List<Node> args) {
        return this.loadArgs(args, null, false, args.size());
    }

    private int loadArgs(List<Node> args, String signature, boolean isVarArg, int argCount) {
        if (isVarArg || argCount > 250) {
            this.loadArgsArray(args);
            return 1;
        }
        int n = 0;
        Type[] params = signature == null ? null : Type.getMethodArguments(signature);
        for (Node arg : args) {
            assert (arg != null);
            this.load(arg);
            if (n >= argCount) {
                this.method.pop();
            } else if (params != null) {
                this.method.convert(params[n]);
            }
            ++n;
        }
        while (n < argCount) {
            this.method.loadUndefined(Type.OBJECT);
            ++n;
        }
        return argCount;
    }

    @Override
    public Node enter(final CallNode callNode) {
        if (callNode.testResolved()) {
            return null;
        }
        final List<Node> args = callNode.getArgs();
        final Node function = callNode.getFunction();
        final FunctionNode currentFunction = this.getCurrentFunctionNode();
        final Block currentBlock = this.getCurrentBlock();
        function.accept(new NodeVisitor(this.compileUnit, this.method){

            private void sharedScopeCall(IdentNode identNode, int flags) {
                Symbol symbol = identNode.getSymbol();
                int scopeCallFlags = flags;
                this.method.loadScope();
                if (symbol.isFastScope(currentFunction)) {
                    this.method.load(CodeGenerator.getScopeProtoDepth(currentBlock, symbol));
                    scopeCallFlags |= 0x400;
                } else {
                    this.method.load(-1);
                }
                CodeGenerator.this.loadArgs(args);
                Type[] paramTypes = this.method.getTypesFromStack(args.size());
                SharedScopeCall scopeCall = CodeGenerator.this.getScopeCall(symbol, identNode.getType(), callNode.getType(), paramTypes, scopeCallFlags);
                scopeCall.generateInvoke(this.method);
            }

            private void scopeCall(IdentNode node, int flags) {
                CodeGenerator.this.load(node);
                this.method.convert(Type.OBJECT);
                this.method.loadNull();
                this.method.dynamicCall(callNode.getType(), 2 + CodeGenerator.this.loadArgs(args), flags);
            }

            private void evalCall(IdentNode node, int flags) {
                CodeGenerator.this.load(node);
                this.method.convert(Type.OBJECT);
                MethodEmitter.Label not_eval = new MethodEmitter.Label("not_eval");
                MethodEmitter.Label eval_done = new MethodEmitter.Label("eval_done");
                this.method.dup();
                CodeGenerator.this.globalIsEval();
                this.method.ifeq(not_eval);
                this.method.pop();
                this.method.loadScope();
                CallNode.EvalArgs evalArgs = callNode.getEvalArgs();
                CodeGenerator.this.load(evalArgs.getCode());
                this.method.convert(Type.OBJECT);
                CodeGenerator.this.load(evalArgs.getThis());
                this.method.load(evalArgs.getLocation());
                this.method.load(evalArgs.getStrictMode());
                this.method.convert(Type.OBJECT);
                CodeGenerator.this.globalDirectEval();
                this.method.convert(callNode.getType());
                this.method._goto(eval_done);
                this.method.label(not_eval);
                this.method.loadNull();
                this.method.dynamicCall(callNode.getType(), 2 + CodeGenerator.this.loadArgs(args), flags);
                this.method.label(eval_done);
            }

            @Override
            public Node enter(IdentNode node) {
                Symbol symbol = node.getSymbol();
                if (symbol.isScope()) {
                    int flags = CodeGenerator.this.getCallSiteFlags() | 1;
                    int useCount = symbol.getUseCount();
                    if (callNode.isEval()) {
                        this.evalCall(node, flags);
                    } else if (useCount <= 4 || !symbol.isFastScope(currentFunction) && useCount <= 500 || callNode.inWithBlock()) {
                        this.scopeCall(node, flags);
                    } else {
                        this.sharedScopeCall(node, flags);
                    }
                    assert (this.method.peekType().equals(callNode.getType()));
                } else {
                    this.enterDefault(node);
                }
                return null;
            }

            @Override
            public Node enter(AccessNode node) {
                CodeGenerator.this.load(node.getBase());
                this.method.convert(Type.OBJECT);
                this.method.dup();
                this.method.dynamicGet(node.getType(), node.getProperty().getName(), CodeGenerator.this.getCallSiteFlags(), true);
                this.method.swap();
                this.method.dynamicCall(callNode.getType(), 2 + CodeGenerator.this.loadArgs(args), CodeGenerator.this.getCallSiteFlags());
                assert (this.method.peekType().equals(callNode.getType()));
                return null;
            }

            @Override
            public Node enter(ReferenceNode node) {
                FunctionNode callee = node.getReference();
                boolean isVarArg = callee.isVarArg();
                int argCount = isVarArg ? -1 : callee.getParameters().size();
                String signature = new FunctionSignature(true, callee.needsCallee(), callee.getReturnType(), isVarArg ? null : callee.getParameters()).toString();
                if (callee.isStrictMode()) {
                    this.method.loadUndefined(Type.OBJECT);
                } else {
                    CodeGenerator.this.globalInstance();
                }
                if (callee.needsCallee()) {
                    new FunctionObjectCreator(CodeGenerator.this, callee).makeObject(this.method);
                }
                CodeGenerator.this.loadArgs(args, signature, isVarArg, argCount);
                this.method.invokeStatic(callee.getCompileUnit().getUnitClassName(), callee.getName(), signature);
                assert (this.method.peekType().equals(callee.getReturnType())) : this.method.peekType() + " != " + callee.getReturnType();
                return null;
            }

            @Override
            public Node enter(IndexNode node) {
                CodeGenerator.this.load(node.getBase());
                this.method.convert(Type.OBJECT);
                this.method.dup();
                CodeGenerator.this.load(node.getIndex());
                Type indexType = node.getIndex().getType();
                if (indexType.isObject() || indexType.isBoolean()) {
                    this.method.convert(Type.OBJECT);
                }
                this.method.dynamicGetIndex(node.getType(), CodeGenerator.this.getCallSiteFlags(), true);
                this.method.swap();
                this.method.dynamicCall(callNode.getType(), 2 + CodeGenerator.this.loadArgs(args), CodeGenerator.this.getCallSiteFlags());
                assert (this.method.peekType().equals(callNode.getType()));
                return null;
            }

            @Override
            protected Node enterDefault(Node node) {
                CodeGenerator.this.load(function);
                this.method.convert(Type.OBJECT);
                this.method.loadNull();
                this.method.dynamicCall(callNode.getType(), 2 + CodeGenerator.this.loadArgs(args), CodeGenerator.this.getCallSiteFlags() | 1);
                assert (this.method.peekType().equals(callNode.getType()));
                return null;
            }
        });
        this.method.store(callNode.getSymbol());
        return null;
    }

    @Override
    public Node enter(ContinueNode continueNode) {
        if (continueNode.testResolved()) {
            return null;
        }
        for (int i = 0; i < continueNode.getScopeNestingLevel(); ++i) {
            this.closeWith();
        }
        this.method.splitAwareGoto(continueNode.getTargetLabel());
        return null;
    }

    @Override
    public Node enter(DoWhileNode doWhileNode) {
        return this.enter((WhileNode)doWhileNode);
    }

    @Override
    public Node enter(EmptyNode emptyNode) {
        return null;
    }

    @Override
    public Node enter(ExecuteNode executeNode) {
        if (executeNode.testResolved()) {
            return null;
        }
        Node expression = executeNode.getExpression();
        expression.accept(this);
        return null;
    }

    @Override
    public Node enter(ForNode forNode) {
        if (forNode.testResolved()) {
            return null;
        }
        Node test = forNode.getTest();
        Block body = forNode.getBody();
        Node modify = forNode.getModify();
        MethodEmitter.Label breakLabel = forNode.getBreakLabel();
        MethodEmitter.Label continueLabel = forNode.getContinueLabel();
        MethodEmitter.Label loopLabel = new MethodEmitter.Label("loop");
        Node init = forNode.getInit();
        if (forNode.isForIn()) {
            final Symbol iter = forNode.getIterator();
            if (init instanceof VarNode) {
                init.accept(this);
                init = ((VarNode)init).getName();
            }
            this.load(modify);
            assert (modify.getType().isObject());
            this.method.invoke(forNode.isForEach() ? ScriptRuntime.TO_VALUE_ITERATOR : ScriptRuntime.TO_PROPERTY_ITERATOR);
            this.method.store(iter);
            this.method._goto(continueLabel);
            this.method.label(loopLabel);
            new Store<Node>(init){

                @Override
                protected void evaluate() {
                    CodeGenerator.this.method.load(iter);
                    CodeGenerator.this.method.invoke(CompilerConstants.interfaceCallNoLookup(Iterator.class, "next", Object.class, new Class[0]));
                }
            }.store();
            body.accept(this);
            this.method.label(continueLabel);
            this.method.load(iter);
            this.method.invoke(CompilerConstants.interfaceCallNoLookup(Iterator.class, "hasNext", Boolean.TYPE, new Class[0]));
            this.method.ifne(loopLabel);
            this.method.label(breakLabel);
        } else {
            if (init != null) {
                init.accept(this);
            }
            MethodEmitter.Label testLabel = new MethodEmitter.Label("test");
            this.method._goto(testLabel);
            this.method.label(loopLabel);
            body.accept(this);
            this.method.label(continueLabel);
            if (!body.isTerminal() && modify != null) {
                this.load(modify);
            }
            this.method.label(testLabel);
            if (test != null) {
                new BranchOptimizer(this, this.method).execute(test, loopLabel, true);
            } else {
                this.method._goto(loopLabel);
            }
            this.method.label(breakLabel);
        }
        return null;
    }

    private void initLocals(Block block) {
        final FunctionNode function = block.getFunction();
        boolean isFunctionNode = block == function;
        Frame frame = block.getFrame();
        List<Symbol> symbols = frame.getSymbols();
        frame.realign();
        if (isFunctionNode) {
            if (function.needsParentScope()) {
                this.initParentScope();
            }
            if (function.needsArguments()) {
                this.initArguments(function);
            }
        }
        if (block.needsScope()) {
            boolean varsInScope = function.varsInScope();
            ArrayList<String> nameList = new ArrayList<String>();
            ArrayList<Symbol> locals = new ArrayList<Symbol>();
            ArrayList<Symbol> newSymbols = new ArrayList<Symbol>();
            ArrayList<Symbol> values = new ArrayList<Symbol>();
            boolean hasArguments = function.needsArguments();
            for (Symbol symbol : symbols) {
                if (symbol.isInternal() || symbol.isThis()) continue;
                if (symbol.isVar()) {
                    if (varsInScope || symbol.isScope()) {
                        nameList.add(symbol.getName());
                        newSymbols.add(symbol);
                        values.add(null);
                        assert (symbol.isScope()) : "scope for " + symbol + " should have been set in Lower already " + function.getName();
                        assert (!symbol.hasSlot()) : "slot for " + symbol + " should have been removed in Lower already" + function.getName();
                        continue;
                    }
                    assert (symbol.hasSlot()) : symbol + " should have a slot only, no scope";
                    locals.add(symbol);
                    continue;
                }
                if (!symbol.isParam() || !varsInScope && !hasArguments && !symbol.isScope()) continue;
                nameList.add(symbol.getName());
                newSymbols.add(symbol);
                values.add(hasArguments ? null : symbol);
                assert (symbol.isScope()) : "scope for " + symbol + " should have been set in Lower already " + function.getName() + " varsInScope=" + varsInScope + " hasArguments=" + hasArguments + " symbol.isScope()=" + symbol.isScope();
                assert (!hasArguments || !symbol.hasSlot()) : "slot for " + symbol + " should have been removed in Lower already " + function.getName();
            }
            frame.realign();
            this.initSymbols(locals);
            FieldObjectCreator<Symbol> foc = new FieldObjectCreator<Symbol>(this, nameList, newSymbols, values, true, hasArguments){

                @Override
                protected Type getValueType(Symbol value) {
                    return value.getSymbolType();
                }

                @Override
                protected void loadValue(Symbol value) {
                    CodeGenerator.this.method.load(value);
                }

                @Override
                protected void loadScope(MethodEmitter m) {
                    if (function.needsParentScope()) {
                        m.loadScope();
                    } else {
                        m.loadNull();
                    }
                }
            };
            foc.makeObject(this.method);
            if (isFunctionNode && function.isScript()) {
                this.method.invoke(ScriptRuntime.MERGE_SCOPE);
            }
            this.method.storeScope();
        } else {
            int nextParam = 0;
            if (isFunctionNode && function.isVarArg()) {
                for (IdentNode param : function.getParameters()) {
                    param.getSymbol().setFieldIndex(nextParam++);
                }
            }
            this.initSymbols(symbols);
        }
        this.printSymbols(block, (isFunctionNode ? "Function " : "Block in ") + (function.getIdent() == null ? "<anonymous>" : function.getIdent().getName()));
    }

    private void initArguments(FunctionNode function) {
        this.method.loadVarArgs();
        if (function.needsCallee()) {
            this.method.loadCallee();
        } else {
            assert (function.isStrictMode());
            this.method.loadNull();
        }
        this.method.load(function.getParameters().size());
        this.globalAllocateArguments();
        this.method.storeArguments();
    }

    private void initParentScope() {
        this.method.loadCallee();
        this.method.invoke(ScriptFunction.GET_SCOPE);
        this.method.storeScope();
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        if (functionNode.testResolved()) {
            return null;
        }
        this.compileUnit = functionNode.getCompileUnit();
        assert (this.compileUnit != null);
        this.method = this.compileUnit.getClassEmitter().method(functionNode);
        functionNode.setMethodEmitter(this.method);
        this.method.begin();
        this.method.label(functionNode.getEntryLabel());
        this.initLocals(functionNode);
        return functionNode;
    }

    @Override
    public Node leave(FunctionNode functionNode) {
        this.method.label(functionNode.getBreakLabel());
        if (!functionNode.needsScope()) {
            this.method.markerVariable(CompilerConstants.LEAF.tag(), functionNode.getEntryLabel(), functionNode.getBreakLabel());
        }
        this.symbolInfo(functionNode);
        try {
            this.method.end();
        }
        catch (Throwable t) {
            Context.printStackTrace(t);
            VerifyError e = new VerifyError("Code generation bug in \"" + functionNode.getName() + "\": likely stack misaligned: " + t + " " + functionNode.getSource().getName());
            e.initCause(t);
            throw e;
        }
        return functionNode;
    }

    @Override
    public Node enter(IdentNode identNode) {
        return null;
    }

    @Override
    public Node enter(IfNode ifNode) {
        if (ifNode.testResolved()) {
            return null;
        }
        Node test = ifNode.getTest();
        Block pass = ifNode.getPass();
        Block fail = ifNode.getFail();
        MethodEmitter.Label failLabel = new MethodEmitter.Label("if_fail");
        MethodEmitter.Label afterLabel = fail == null ? failLabel : new MethodEmitter.Label("if_done");
        new BranchOptimizer(this, this.method).execute(test, failLabel, false);
        boolean passTerminal = false;
        boolean failTerminal = false;
        pass.accept(this);
        if (!pass.hasTerminalFlags()) {
            this.method._goto(afterLabel);
        } else {
            passTerminal = pass.isTerminal();
        }
        if (fail != null) {
            this.method.label(failLabel);
            fail.accept(this);
            failTerminal = fail.isTerminal();
        }
        if (!passTerminal || !failTerminal) {
            this.method.label(afterLabel);
        }
        return null;
    }

    @Override
    public Node enter(IndexNode indexNode) {
        if (indexNode.testResolved()) {
            return null;
        }
        this.load(indexNode);
        return null;
    }

    @Override
    public Node enter(LineNumberNode lineNumberNode) {
        if (lineNumberNode.testResolved()) {
            return null;
        }
        MethodEmitter.Label label = new MethodEmitter.Label("line:" + lineNumberNode.getLineNumber() + " (" + this.getCurrentFunctionNode().getName() + ")");
        this.method.label(label);
        this.method.lineNumber(lineNumberNode.getLineNumber(), label);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodEmitter loadArray(LiteralNode.ArrayLiteralNode arrayLiteralNode, ArrayType arrayType) {
        assert (arrayType == Type.INT_ARRAY || arrayType == Type.NUMBER_ARRAY || arrayType == Type.OBJECT_ARRAY);
        Node[] nodes = (Node[])arrayLiteralNode.getValue();
        Object presets = arrayLiteralNode.getPresets();
        int[] postsets = arrayLiteralNode.getPostsets();
        Class<?> type = arrayType.getTypeClass();
        List<LiteralNode.ArrayLiteralNode.ArrayUnit> units = arrayLiteralNode.getUnits();
        this.loadConstant(presets);
        Type elementType = arrayType.getElementType();
        if (units != null) {
            CompileUnit savedCompileUnit = this.compileUnit;
            MethodEmitter savedMethod = this.method;
            try {
                for (LiteralNode.ArrayLiteralNode.ArrayUnit unit : units) {
                    this.compileUnit = unit.getCompileUnit();
                    String className = this.compileUnit.getUnitClassName();
                    String name = this.compiler.uniqueName(CompilerConstants.SPLIT_PREFIX.tag());
                    String signature = CompilerConstants.methodDescriptor(type, Object.class, ScriptFunction.class, ScriptObject.class, type);
                    this.method = this.compileUnit.getClassEmitter().method(EnumSet.of(ClassEmitter.Flag.PUBLIC, ClassEmitter.Flag.STATIC), name, signature);
                    this.method.setFunctionNode(this.getCurrentFunctionNode());
                    this.method.begin();
                    this.fixScopeSlot();
                    this.method.load(arrayType, CompilerConstants.SPLIT_ARRAY_ARG.slot());
                    for (int i = unit.getLo(); i < unit.getHi(); ++i) {
                        this.storeElement(nodes, elementType, postsets[i]);
                    }
                    this.method._return();
                    this.method.end();
                    savedMethod.loadThis();
                    savedMethod.swap();
                    savedMethod.loadCallee();
                    savedMethod.swap();
                    savedMethod.loadScope();
                    savedMethod.swap();
                    savedMethod.invokeStatic(className, name, signature);
                }
            }
            finally {
                this.compileUnit = savedCompileUnit;
                this.method = savedMethod;
            }
            return this.method;
        }
        for (int postset : postsets) {
            this.storeElement(nodes, elementType, postset);
        }
        return this.method;
    }

    private void storeElement(Node[] nodes, Type elementType, int index) {
        this.method.dup();
        this.method.load(index);
        Node element = nodes[index];
        if (element == null) {
            this.method.loadEmpty(elementType);
        } else {
            assert (elementType.isEquivalentTo(element.getType())) : "array element type doesn't match array type";
            this.load(element);
        }
        this.method.arraystore();
    }

    private MethodEmitter loadArgsArray(List<Node> args) {
        Object[] array = new Object[args.size()];
        this.loadConstant(array);
        for (int i = 0; i < args.size(); ++i) {
            this.method.dup();
            this.method.load(i);
            this.load(args.get(i)).convert(Type.OBJECT);
            this.method.arraystore();
        }
        return this.method;
    }

    public void loadConstant(String string) {
        String unitClassName = this.compileUnit.getUnitClassName();
        ClassEmitter classEmitter = this.compileUnit.getClassEmitter();
        int index = this.compiler.getConstantData().add(string);
        this.method.load(index);
        this.method.invokeStatic(unitClassName, CompilerConstants.GET_STRING.tag(), CompilerConstants.methodDescriptor(String.class, Integer.TYPE));
        classEmitter.needGetConstantMethod(String.class);
    }

    public void loadConstant(Object object) {
        String unitClassName = this.compileUnit.getUnitClassName();
        ClassEmitter classEmitter = this.compileUnit.getClassEmitter();
        int index = this.compiler.getConstantData().add(object);
        Class<?> cls = object.getClass();
        if (cls == PropertyMap.class) {
            this.method.load(index);
            this.method.invokeStatic(unitClassName, CompilerConstants.GET_MAP.tag(), CompilerConstants.methodDescriptor(PropertyMap.class, Integer.TYPE));
            classEmitter.needGetConstantMethod(PropertyMap.class);
        } else if (cls.isArray()) {
            this.method.load(index);
            String methodName = ClassEmitter.getArrayMethodName(cls);
            this.method.invokeStatic(unitClassName, methodName, CompilerConstants.methodDescriptor(cls, Integer.TYPE));
            classEmitter.needGetConstantMethod(cls);
        } else {
            this.method.loadConstants(unitClassName).load(index).arrayload();
            if (cls != Object.class) {
                this.method.checkcast(cls);
            }
        }
    }

    private MethodEmitter load(LiteralNode<?> node) {
        Object value = node.getValue();
        if (value == null) {
            this.method.loadNull();
        } else if (value instanceof Undefined) {
            this.method.loadUndefined(Type.OBJECT);
        } else if (value instanceof String) {
            String string = (String)value;
            if (string.length() > 10922) {
                this.loadConstant(string);
            } else {
                this.method.load(string);
            }
        } else if (value instanceof Lexer.RegexToken) {
            this.loadRegex((Lexer.RegexToken)value);
        } else if (value instanceof Boolean) {
            this.method.load((Boolean)value);
        } else if (value instanceof Integer) {
            this.method.load((Integer)value);
        } else if (value instanceof Long) {
            this.method.load((Long)value);
        } else if (value instanceof Double) {
            this.method.load((Double)value);
        } else if (node instanceof LiteralNode.ArrayLiteralNode) {
            ArrayType type = (ArrayType)node.getType();
            this.loadArray((LiteralNode.ArrayLiteralNode)node, type);
            this.globalAllocateArray(type);
        } else assert (false) : "Unknown literal for " + node.getClass() + " " + value.getClass() + " " + value;
        return this.method;
    }

    private MethodEmitter loadRegexToken(Lexer.RegexToken value) {
        this.method.load(value.getExpression());
        this.method.load(value.getOptions());
        return this.globalNewRegExp();
    }

    private MethodEmitter loadRegex(Lexer.RegexToken regexToken) {
        if (this.regexFieldCount > 2048) {
            return this.loadRegexToken(regexToken);
        }
        String regexName = this.compiler.uniqueName(CompilerConstants.REGEX_PREFIX.tag());
        ClassEmitter classEmitter = this.compileUnit.getClassEmitter();
        classEmitter.field(EnumSet.of(ClassEmitter.Flag.PRIVATE, ClassEmitter.Flag.STATIC), regexName, Object.class);
        ++this.regexFieldCount;
        this.method.getStatic(this.compileUnit.getUnitClassName(), regexName, CompilerConstants.typeDescriptor(Object.class));
        this.method.dup();
        MethodEmitter.Label cachedLabel = new MethodEmitter.Label("cached");
        this.method.ifnonnull(cachedLabel);
        this.method.pop();
        this.loadRegexToken(regexToken);
        this.method.dup();
        this.method.putStatic(this.compileUnit.getUnitClassName(), regexName, CompilerConstants.typeDescriptor(Object.class));
        this.method.label(cachedLabel);
        this.globalRegExpCopy();
        return this.method;
    }

    @Override
    public Node enter(LiteralNode literalNode) {
        assert (literalNode.getSymbol() != null) : literalNode + " has no symbol";
        this.load(literalNode).store(literalNode.getSymbol());
        return null;
    }

    @Override
    public Node enter(ObjectNode objectNode) {
        Object key;
        if (objectNode.testResolved()) {
            return null;
        }
        List<Node> elements = objectNode.getElements();
        int size = elements.size();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        ArrayList<Node> values = new ArrayList<Node>();
        boolean hasGettersSetters = false;
        for (int i = 0; i < size; ++i) {
            Symbol symbol;
            PropertyNode propertyNode = (PropertyNode)elements.get(i);
            Node value = propertyNode.getValue();
            key = propertyNode.getKeyName();
            Symbol symbol2 = symbol = value == null ? null : propertyNode.getSymbol();
            if (value == null) {
                hasGettersSetters = true;
            }
            keys.add((String)key);
            symbols.add(symbol);
            values.add(value);
        }
        new FieldObjectCreator<Node>(this, keys, symbols, values){

            @Override
            protected Type getValueType(Node node) {
                return node.getType();
            }

            @Override
            protected void loadValue(Node node) {
                CodeGenerator.this.load(node);
            }

            @Override
            protected MapCreator newMapCreator(Class<?> fieldObjectClass) {
                return new ObjectMapCreator(fieldObjectClass, this.keys, this.symbols);
            }
        }.makeObject(this.method);
        this.method.dup();
        this.globalObjectPrototype();
        this.method.invoke(ScriptObject.SET_PROTO);
        if (!hasGettersSetters) {
            this.method.store(objectNode.getSymbol());
            return null;
        }
        for (Node element : elements) {
            PropertyNode propertyNode = (PropertyNode)element;
            key = propertyNode.getKey();
            ReferenceNode getter = (ReferenceNode)propertyNode.getGetter();
            ReferenceNode setter = (ReferenceNode)propertyNode.getSetter();
            if (getter == null && setter == null) continue;
            this.method.dup().loadKey(key);
            if (getter == null) {
                this.method.loadNull();
            } else {
                getter.accept(this);
            }
            if (setter == null) {
                this.method.loadNull();
            } else {
                setter.accept(this);
            }
            this.method.invoke(ScriptObject.SET_USER_ACCESSORS);
        }
        this.method.store(objectNode.getSymbol());
        return null;
    }

    @Override
    public Node enter(ReferenceNode referenceNode) {
        if (referenceNode.testResolved()) {
            return null;
        }
        new FunctionObjectCreator(this, referenceNode.getReference()).makeObject(this.method);
        return null;
    }

    @Override
    public Node enter(ReturnNode returnNode) {
        Node expression;
        if (returnNode.testResolved()) {
            return null;
        }
        if (this.method.getSplitNode() != null) {
            assert (this.method.getSplitNode().hasReturn()) : "unexpected return in split node";
            this.method.loadScope();
            this.method.checkcast(Scope.class);
            this.method.load(0);
            this.method.invoke(Scope.SET_SPLIT_STATE);
        }
        if ((expression = returnNode.getExpression()) != null) {
            this.load(expression);
        } else {
            this.method.loadUndefined(this.getCurrentFunctionNode().getReturnType());
        }
        this.method._return(this.getCurrentFunctionNode().getReturnType());
        return null;
    }

    private static boolean isNullLiteral(Node node) {
        return node instanceof LiteralNode && ((LiteralNode)node).isNull();
    }

    private boolean nullCheck(RuntimeNode runtimeNode, List<Node> args, String signature) {
        RuntimeNode.Request request = runtimeNode.getRequest();
        if (!RuntimeNode.Request.isEQ(request) && !RuntimeNode.Request.isNE(request)) {
            return false;
        }
        assert (args.size() == 2) : "EQ or NE or TYPEOF need two args";
        Node lhs = args.get(0);
        Node rhs = args.get(1);
        if (CodeGenerator.isNullLiteral(lhs)) {
            Node tmp = lhs;
            lhs = rhs;
            rhs = tmp;
        }
        if (CodeGenerator.isNullLiteral(rhs)) {
            MethodEmitter.Label trueLabel = new MethodEmitter.Label("trueLabel");
            MethodEmitter.Label falseLabel = new MethodEmitter.Label("falseLabel");
            MethodEmitter.Label endLabel = new MethodEmitter.Label("end");
            this.load(lhs);
            this.method.dup();
            if (RuntimeNode.Request.isEQ(request)) {
                this.method.ifnull(trueLabel);
            } else if (RuntimeNode.Request.isNE(request)) {
                this.method.ifnonnull(trueLabel);
            } else assert (false) : "Invalid request " + (Object)((Object)request);
            this.method.label(falseLabel);
            this.load(rhs);
            this.method.invokeStatic(CompilerConstants.className(ScriptRuntime.class), request.toString(), signature);
            this.method._goto(endLabel);
            this.method.label(trueLabel);
            if (request == RuntimeNode.Request.NE) {
                this.method.loadUndefined(Type.OBJECT);
                MethodEmitter.Label isUndefined = new MethodEmitter.Label("isUndefined");
                MethodEmitter.Label afterUndefinedCheck = new MethodEmitter.Label("afterUndefinedCheck");
                this.method.if_acmpeq(isUndefined);
                this.method.load(true);
                this.method._goto(afterUndefinedCheck);
                this.method.label(isUndefined);
                this.method.load(false);
                this.method.label(afterUndefinedCheck);
            } else {
                this.method.pop();
                this.method.load(true);
            }
            this.method.label(endLabel);
            this.method.convert(runtimeNode.getType());
            this.method.store(runtimeNode.getSymbol());
            return true;
        }
        return false;
    }

    private boolean specializationCheck(RuntimeNode.Request request, Node node, List<Node> args) {
        if (!request.canSpecialize()) {
            return false;
        }
        assert (args.size() == 2);
        Node lhs = args.get(0);
        Node rhs = args.get(1);
        Type returnType = node.getType();
        this.load(lhs);
        this.load(rhs);
        RuntimeNode.Request finalRequest = request;
        RuntimeNode.Request reverse = RuntimeNode.Request.reverse(request);
        if (this.method.peekType().isObject() && reverse != null && !this.method.peekType(1).isObject()) {
            this.method.swap();
            finalRequest = reverse;
        }
        this.method.dynamicRuntimeCall(new RuntimeCallSite.SpecializedRuntimeNode(finalRequest, new Type[]{this.method.peekType(1), this.method.peekType()}, returnType).getInitialName(), returnType, finalRequest);
        this.method.convert(node.getType());
        this.method.store(node.getSymbol());
        return true;
    }

    @Override
    public Node enter(RuntimeNode runtimeNode) {
        List<Node> args;
        if (runtimeNode.testResolved()) {
            return null;
        }
        if (runtimeNode.isPrimitive() && !runtimeNode.isFinal()) {
            Node lhs = runtimeNode.getArgs().get(0);
            Node rhs = runtimeNode.getArgs().size() > 1 ? runtimeNode.getArgs().get(1) : null;
            Type type = runtimeNode.getType();
            Symbol symbol = runtimeNode.getSymbol();
            switch (runtimeNode.getRequest()) {
                case EQ: 
                case EQ_STRICT: {
                    return this.enterCmp(lhs, rhs, MethodEmitter.Condition.EQ, type, symbol);
                }
                case NE: 
                case NE_STRICT: {
                    return this.enterCmp(lhs, rhs, MethodEmitter.Condition.NE, type, symbol);
                }
                case LE: {
                    return this.enterCmp(lhs, rhs, MethodEmitter.Condition.LE, type, symbol);
                }
                case LT: {
                    return this.enterCmp(lhs, rhs, MethodEmitter.Condition.LT, type, symbol);
                }
                case GE: {
                    return this.enterCmp(lhs, rhs, MethodEmitter.Condition.GE, type, symbol);
                }
                case GT: {
                    return this.enterCmp(lhs, rhs, MethodEmitter.Condition.GT, type, symbol);
                }
                case ADD: {
                    Type widest = Type.widest(lhs.getType(), rhs.getType());
                    this.load(lhs);
                    this.method.convert(widest);
                    this.load(rhs);
                    this.method.convert(widest);
                    this.method.add();
                    this.method.convert(type);
                    this.method.store(symbol);
                    return null;
                }
            }
        }
        if (this.nullCheck(runtimeNode, args = runtimeNode.getArgs(), new FunctionSignature(false, false, runtimeNode.getType(), args).toString())) {
            return null;
        }
        if (!runtimeNode.isFinal() && this.specializationCheck(runtimeNode.getRequest(), runtimeNode, args)) {
            return null;
        }
        for (Node arg : runtimeNode.getArgs()) {
            this.load(arg).convert(Type.OBJECT);
        }
        this.method.invokeStatic(CompilerConstants.className(ScriptRuntime.class), runtimeNode.getRequest().toString(), new FunctionSignature(false, false, runtimeNode.getType(), runtimeNode.getArgs().size()).toString());
        this.method.convert(runtimeNode.getType());
        this.method.store(runtimeNode.getSymbol());
        return null;
    }

    @Override
    public Node enter(SplitNode splitNode) {
        Class[] classArray;
        if (splitNode.testResolved()) {
            return null;
        }
        CompileUnit splitCompileUnit = splitNode.getCompileUnit();
        FunctionNode fn = this.getCurrentFunctionNode();
        String className = splitCompileUnit.getUnitClassName();
        String name = splitNode.getName();
        Class<?> rtype = fn.getReturnType().getTypeClass();
        boolean needsArguments = fn.needsArguments();
        if (needsArguments) {
            Class[] classArray2 = new Class[4];
            classArray2[0] = Object.class;
            classArray2[1] = ScriptFunction.class;
            classArray2[2] = ScriptObject.class;
            classArray = classArray2;
            classArray2[3] = Object.class;
        } else {
            Class[] classArray3 = new Class[3];
            classArray3[0] = Object.class;
            classArray3[1] = ScriptFunction.class;
            classArray = classArray3;
            classArray3[2] = ScriptObject.class;
        }
        Class[] ptypes = classArray;
        this.setCurrentCompileUnit(splitCompileUnit);
        splitNode.setCompileUnit(splitCompileUnit);
        CompilerConstants.Call splitCall = CompilerConstants.staticCallNoLookup(className, name, CompilerConstants.methodDescriptor(rtype, ptypes));
        this.setCurrentMethodEmitter(splitCompileUnit.getClassEmitter().method(EnumSet.of(ClassEmitter.Flag.PUBLIC, ClassEmitter.Flag.STATIC), name, rtype, ptypes));
        this.method.setFunctionNode(fn);
        this.method.setSplitNode(splitNode);
        splitNode.setMethodEmitter(this.method);
        MethodEmitter caller = splitNode.getCaller();
        caller.loadThis();
        if (fn.needsCallee()) {
            caller.loadCallee();
        } else {
            caller.loadNull();
        }
        caller.loadScope();
        if (needsArguments) {
            caller.loadArguments();
        }
        caller.invoke(splitCall);
        caller.storeResult();
        this.method.begin();
        this.method.loadUndefined(fn.getReturnType());
        this.method.storeResult();
        this.fixScopeSlot();
        return splitNode;
    }

    private void fixScopeSlot() {
        if (this.getCurrentFunctionNode().getScopeNode().getSymbol().getSlot() != CompilerConstants.SCOPE.slot()) {
            this.method.load(Type.typeFor(ScriptObject.class), CompilerConstants.SCOPE.slot());
            this.method.storeScope();
        }
    }

    @Override
    public Node leave(SplitNode splitNode) {
        try {
            this.method.loadResult();
            this.method._return(this.getCurrentFunctionNode().getReturnType());
            this.method.end();
        }
        catch (Throwable t) {
            Context.printStackTrace(t);
            VerifyError e = new VerifyError("Code generation bug in \"" + splitNode.getName() + "\": likely stack misaligned: " + t + " " + this.compiler.getSource().getName());
            e.initCause(t);
            throw e;
        }
        MethodEmitter caller = splitNode.getCaller();
        List<MethodEmitter.Label> targets = splitNode.getExternalTargets();
        int targetCount = targets.size();
        if (splitNode.hasReturn() || targetCount > 0) {
            int i;
            caller.loadScope();
            caller.checkcast(Scope.class);
            caller.invoke(Scope.GET_SPLIT_STATE);
            MethodEmitter.Label breakLabel = new MethodEmitter.Label("no_split_state");
            int low = splitNode.hasReturn() ? 0 : 1;
            int labelCount = targetCount + 1 - low;
            MethodEmitter.Label[] labels = new MethodEmitter.Label[labelCount];
            for (i = 0; i < labelCount; ++i) {
                labels[i] = new MethodEmitter.Label("split_state_" + i);
            }
            caller.tableSwitch(low, targetCount, breakLabel, labels);
            for (i = low; i <= targetCount; ++i) {
                caller.label(labels[i - low]);
                if (i == 0) {
                    caller.loadResult();
                    caller._return(this.getCurrentFunctionNode().getReturnType());
                    continue;
                }
                caller.loadScope();
                caller.checkcast(Scope.class);
                caller.load(-1);
                caller.invoke(Scope.SET_SPLIT_STATE);
                caller.splitAwareGoto(targets.get(i - 1));
            }
            caller.label(breakLabel);
        }
        return splitNode;
    }

    @Override
    public Node enter(SwitchNode switchNode) {
        MethodEmitter.Label breakLabel;
        if (switchNode.testResolved()) {
            return null;
        }
        Node expression = switchNode.getExpression();
        Symbol tag = switchNode.getTag();
        boolean allInteger = tag.getSymbolType().isInteger();
        List<CaseNode> cases = switchNode.getCases();
        CaseNode defaultCase = switchNode.getDefaultCase();
        MethodEmitter.Label defaultLabel = breakLabel = switchNode.getBreakLabel();
        boolean hasDefault = false;
        if (defaultCase != null) {
            defaultLabel = defaultCase.getEntry();
            hasDefault = true;
        }
        if (cases.isEmpty()) {
            this.method.label(breakLabel);
            return null;
        }
        if (allInteger) {
            int i;
            int value;
            TreeMap<Integer, MethodEmitter.Label> tree = new TreeMap<Integer, MethodEmitter.Label>();
            for (CaseNode caseNode : cases) {
                Node test = caseNode.getTest();
                if (test == null) continue;
                Integer value2 = (Integer)((LiteralNode)test).getValue();
                MethodEmitter.Label entry = caseNode.getEntry();
                if (tree.containsKey(value2)) continue;
                tree.put(value2, entry);
            }
            int size = tree.size();
            Integer[] values = tree.keySet().toArray(new Integer[size]);
            MethodEmitter.Label[] labels = tree.values().toArray(new MethodEmitter.Label[size]);
            int lo = values[0];
            int hi = values[size - 1];
            int range = hi - lo + 1;
            int deflt = Integer.MIN_VALUE;
            Integer[] arr$ = values;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                value = arr$[i$];
                if (deflt == value) {
                    ++deflt;
                    continue;
                }
                if (deflt < value) break;
            }
            this.load(expression);
            Type type = expression.getType();
            if (!type.isInteger()) {
                this.method.load(deflt);
                this.method.invoke(CompilerConstants.staticCallNoLookup(ScriptRuntime.class, "switchTagAsInt", Integer.TYPE, type.getTypeClass(), Integer.TYPE));
            }
            if (range > 0 && range < 4096 && range < size * 5 / 4) {
                MethodEmitter.Label[] table = new MethodEmitter.Label[range];
                Arrays.fill((Object[])table, (Object)defaultLabel);
                for (i = 0; i < size; ++i) {
                    value = values[i];
                    table[value - lo] = labels[i];
                }
                this.method.tableSwitch(lo, hi, defaultLabel, table);
            } else {
                int[] ints = new int[size];
                for (i = 0; i < size; ++i) {
                    ints[i] = values[i];
                }
                this.method.lookupSwitch(defaultLabel, ints, labels);
            }
        } else {
            this.load(expression);
            if (expression.getType().isInteger()) {
                this.method.convert(Type.NUMBER).dup();
                this.method.store(tag);
                this.method.conditionalJump(MethodEmitter.Condition.NE, true, defaultLabel);
            } else {
                this.method.store(tag);
            }
            for (CaseNode caseNode : cases) {
                Node test = caseNode.getTest();
                if (test == null) continue;
                this.method.load(tag);
                this.load(test);
                this.method.invoke(ScriptRuntime.EQ_STRICT);
                this.method.ifne(caseNode.getEntry());
            }
            this.method._goto(hasDefault ? defaultLabel : breakLabel);
        }
        for (CaseNode caseNode : cases) {
            this.method.label(caseNode.getEntry());
            caseNode.getBody().accept(this);
        }
        if (!switchNode.isTerminal()) {
            this.method.label(breakLabel);
        }
        return null;
    }

    @Override
    public Node enter(ThrowNode throwNode) {
        if (throwNode.testResolved()) {
            return null;
        }
        this.method._new(ECMAException.class).dup();
        Node expression = throwNode.getExpression();
        Source source = this.compiler.getSource();
        int position = throwNode.position();
        int line = source.getLine(position);
        int column = source.getColumn(position);
        this.load(expression);
        assert (expression.getType().isObject());
        this.method.load(source.getName());
        this.method.load(line);
        this.method.load(column);
        this.method.invoke(ECMAException.THROW_INIT);
        this.method.athrow();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(TryNode tryNode) {
        if (tryNode.testResolved()) {
            return null;
        }
        Block body = tryNode.getBody();
        List<Block> catchBlocks = tryNode.getCatchBlocks();
        final Symbol symbol = tryNode.getException();
        MethodEmitter.Label entry = new MethodEmitter.Label("try");
        MethodEmitter.Label recovery = new MethodEmitter.Label("catch");
        MethodEmitter.Label exit = tryNode.getExit();
        MethodEmitter.Label skip = new MethodEmitter.Label("skip");
        this.method.label(entry);
        body.accept(this);
        if (!body.hasTerminalFlags()) {
            this.method._goto(skip);
        }
        this.method.label(exit);
        this.method._catch(recovery);
        this.method.store(symbol);
        for (int i = 0; i < catchBlocks.size(); ++i) {
            Block saveBlock = this.getCurrentBlock();
            Block catchBlock = catchBlocks.get(i);
            this.setCurrentBlock(catchBlock);
            try {
                MethodEmitter.Label next;
                this.enter(catchBlock);
                CatchNode catchNode = (CatchNode)catchBlocks.get(i).getStatements().get(0);
                IdentNode exception = catchNode.getException();
                Node exceptionCondition = catchNode.getExceptionCondition();
                Block catchBody = catchNode.getBody();
                if (catchNode.isSyntheticRethrow()) {
                    catchBody.accept(this);
                    this.method.load(symbol).athrow();
                    continue;
                }
                new Store<IdentNode>(exception){

                    @Override
                    protected void evaluate() {
                        MethodEmitter.Label notEcmaException = new MethodEmitter.Label("no_ecma_exception");
                        CodeGenerator.this.method.load(symbol).dup()._instanceof(ECMAException.class).ifeq(notEcmaException);
                        CodeGenerator.this.method.checkcast(ECMAException.class);
                        CodeGenerator.this.method.getField(ECMAException.THROWN);
                        CodeGenerator.this.method.label(notEcmaException);
                    }
                }.store();
                if (exceptionCondition != null) {
                    next = new MethodEmitter.Label("next");
                    this.load(exceptionCondition).convert(Type.BOOLEAN).ifeq(next);
                } else {
                    next = null;
                }
                catchBody.accept(this);
                if (i + 1 != catchBlocks.size() && !catchBody.hasTerminalFlags()) {
                    this.method._goto(skip);
                }
                if (next != null) {
                    if (i + 1 == catchBlocks.size()) {
                        this.method._goto(skip);
                        this.method.label(next);
                        this.method.load(symbol).athrow();
                    } else {
                        this.method.label(next);
                    }
                }
                this.leave(catchBlock);
                continue;
            }
            finally {
                this.setCurrentBlock(saveBlock);
            }
        }
        this.method.label(skip);
        this.method._try(entry, exit, recovery, Throwable.class);
        return null;
    }

    @Override
    public Node enter(VarNode varNode) {
        Node init = varNode.getInit();
        if (varNode.testResolved() || init == null) {
            return null;
        }
        Symbol varSymbol = varNode.getSymbol();
        assert (varSymbol != null) : "variable node " + varNode + " requires a symbol";
        assert (this.method != null);
        boolean needsScope = varSymbol.isScope();
        if (needsScope) {
            this.method.loadScope();
        }
        this.load(init);
        if (needsScope) {
            int flags = 1 | this.getCallSiteFlags();
            if (varNode.isFunctionVarNode()) {
                flags |= 4;
            }
            IdentNode identNode = varNode.getName();
            Type type = identNode.getType();
            if (varSymbol.isFastScope(this.getCurrentFunctionNode())) {
                this.storeFastScopeVar(type, varSymbol, flags);
            } else {
                this.method.dynamicSet(type, identNode.getName(), flags);
            }
        } else {
            assert (varNode.getType() == varNode.getName().getType()) : "varNode type=" + varNode.getType() + " nametype=" + varNode.getName().getType() + " inittype=" + init.getType();
            this.method.convert(varNode.getType());
            this.method.store(varSymbol);
        }
        return null;
    }

    @Override
    public Node enter(WhileNode whileNode) {
        if (whileNode.testResolved()) {
            return null;
        }
        Node test = whileNode.getTest();
        Block body = whileNode.getBody();
        MethodEmitter.Label breakLabel = whileNode.getBreakLabel();
        MethodEmitter.Label continueLabel = whileNode.getContinueLabel();
        MethodEmitter.Label loopLabel = new MethodEmitter.Label("loop");
        if (!(whileNode instanceof DoWhileNode)) {
            this.method._goto(continueLabel);
        }
        this.method.label(loopLabel);
        body.accept(this);
        if (!whileNode.isTerminal()) {
            this.method.label(continueLabel);
            new BranchOptimizer(this, this.method).execute(test, loopLabel, true);
            this.method.label(breakLabel);
        }
        return null;
    }

    private void closeWith() {
        this.method.loadScope();
        this.method.invoke(ScriptRuntime.CLOSE_WITH);
        this.method.storeScope();
    }

    @Override
    public Node enter(WithNode withNode) {
        if (withNode.testResolved()) {
            return null;
        }
        Node expression = withNode.getExpression();
        Block body = withNode.getBody();
        MethodEmitter.Label tryLabel = new MethodEmitter.Label("with_try");
        MethodEmitter.Label endLabel = new MethodEmitter.Label("with_end");
        MethodEmitter.Label catchLabel = new MethodEmitter.Label("with_catch");
        MethodEmitter.Label exitLabel = new MethodEmitter.Label("with_exit");
        this.method.label(tryLabel);
        this.method.loadScope();
        this.load(expression);
        assert (expression.getType().isObject()) : "with expression needs to be object: " + expression;
        this.method.invoke(ScriptRuntime.OPEN_WITH);
        this.method.storeScope();
        ((Node)body).accept(this);
        if (!body.isTerminal()) {
            this.closeWith();
            this.method._goto(exitLabel);
        }
        this.method.label(endLabel);
        this.method._catch(catchLabel);
        this.closeWith();
        this.method.athrow();
        this.method.label(exitLabel);
        this.method._try(tryLabel, endLabel, catchLabel);
        return null;
    }

    @Override
    public Node enterADD(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        this.load(unaryNode.rhs());
        assert (unaryNode.rhs().getType().isNumber());
        this.method.store(unaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterBIT_NOT(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        this.load(unaryNode.rhs()).convert(Type.INT).load(-1).xor().store(unaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterCONVERT(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        Node rhs = unaryNode.rhs();
        Type to = unaryNode.getType();
        if (to.isObject() && rhs instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)rhs;
            Object value = literalNode.getValue();
            if (value instanceof Number) {
                assert (!to.isArray()) : "type hygiene - cannot convert number to array: (" + to.getTypeClass().getSimpleName() + ')' + value;
                if (value instanceof Integer) {
                    this.method.load((Integer)value);
                } else if (value instanceof Long) {
                    this.method.load((Long)value);
                } else if (value instanceof Double) {
                    this.method.load((Double)value);
                } else assert (false);
                this.method.convert(Type.OBJECT);
            } else if (value instanceof Boolean) {
                this.method.getField(CompilerConstants.staticField(Boolean.class, value.toString().toUpperCase(), Boolean.class));
            } else {
                this.load(rhs);
                this.method.convert(unaryNode.getType());
            }
        } else {
            this.load(rhs);
            this.method.convert(unaryNode.getType());
        }
        this.method.store(unaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterDECINC(UnaryNode unaryNode) {
        boolean isIncrement;
        if (unaryNode.testResolved()) {
            return null;
        }
        final Node rhs = unaryNode.rhs();
        final Type type = unaryNode.getType();
        TokenType tokenType = unaryNode.tokenType();
        final boolean isPostfix = tokenType == TokenType.DECPOSTFIX || tokenType == TokenType.INCPOSTFIX;
        boolean bl = isIncrement = tokenType == TokenType.INCPREFIX || tokenType == TokenType.INCPOSTFIX;
        assert (!type.isObject());
        new SelfModifyingStore<UnaryNode>(unaryNode, rhs){

            @Override
            protected void evaluate() {
                CodeGenerator.this.load(rhs, true);
                CodeGenerator.this.method.convert(type);
                if (!isPostfix) {
                    if (type.isInteger()) {
                        CodeGenerator.this.method.load(isIncrement ? 1 : -1);
                    } else if (type.isLong()) {
                        CodeGenerator.this.method.load(isIncrement ? 1L : -1L);
                    } else {
                        CodeGenerator.this.method.load(isIncrement ? 1.0 : -1.0);
                    }
                    CodeGenerator.this.method.add();
                }
            }

            @Override
            protected void storeNonDiscard() {
                super.storeNonDiscard();
                if (isPostfix) {
                    if (type.isInteger()) {
                        CodeGenerator.this.method.load(isIncrement ? 1 : -1);
                    } else if (type.isLong()) {
                        CodeGenerator.this.method.load(isIncrement ? 1L : 1L);
                    } else {
                        CodeGenerator.this.method.load(isIncrement ? 1.0 : -1.0);
                    }
                    CodeGenerator.this.method.add();
                }
            }
        }.store();
        return null;
    }

    @Override
    public Node enterDISCARD(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        Node rhs = unaryNode.rhs();
        this.load(rhs);
        if (rhs.shouldDiscard()) {
            this.method.pop();
        }
        return null;
    }

    @Override
    public Node enterNEW(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        CallNode callNode = (CallNode)unaryNode.rhs();
        List<Node> args = callNode.getArgs();
        this.load(callNode.getFunction()).convert(Type.OBJECT);
        this.method.dynamicNew(1 + this.loadArgs(args), this.getCallSiteFlags());
        this.method.store(unaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterNOT(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        Node rhs = unaryNode.rhs();
        this.load(rhs);
        MethodEmitter.Label trueLabel = new MethodEmitter.Label("true");
        MethodEmitter.Label afterLabel = new MethodEmitter.Label("after");
        this.method.convert(Type.BOOLEAN);
        this.method.ifne(trueLabel);
        this.method.load(true);
        this.method._goto(afterLabel);
        this.method.label(trueLabel);
        this.method.load(false);
        this.method.label(afterLabel);
        this.method.store(unaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterSUB(UnaryNode unaryNode) {
        if (unaryNode.testResolved()) {
            return null;
        }
        this.load(unaryNode.rhs()).neg().store(unaryNode.getSymbol());
        return null;
    }

    private Node enterNumericAdd(Node lhs, Node rhs, Type type, Symbol symbol) {
        assert (lhs.getType().equals(rhs.getType()) && lhs.getType().equals(type)) : lhs.getType() + " != " + rhs.getType() + " != " + type + " " + new ASTWriter(lhs) + " " + new ASTWriter(rhs);
        this.load(lhs);
        this.load(rhs);
        this.method.add();
        this.method.store(symbol);
        return null;
    }

    @Override
    public Node enterADD(BinaryNode binaryNode) {
        if (binaryNode.testResolved()) {
            return null;
        }
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type type = binaryNode.getType();
        if (type.isNumeric()) {
            this.enterNumericAdd(lhs, rhs, type, binaryNode.getSymbol());
        } else {
            this.load(lhs).convert(Type.OBJECT);
            this.load(rhs).convert(Type.OBJECT);
            this.method.add();
            this.method.store(binaryNode.getSymbol());
        }
        return null;
    }

    private Node enterAND_OR(BinaryNode binaryNode) {
        if (binaryNode.testResolved()) {
            return null;
        }
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        MethodEmitter.Label skip = new MethodEmitter.Label("skip");
        this.load(lhs).convert(Type.OBJECT).dup().convert(Type.BOOLEAN);
        if (binaryNode.tokenType() == TokenType.AND) {
            this.method.ifeq(skip);
        } else {
            this.method.ifne(skip);
        }
        this.method.pop();
        this.load(rhs).convert(Type.OBJECT);
        this.method.label(skip);
        this.method.store(binaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterAND(BinaryNode binaryNode) {
        return this.enterAND_OR(binaryNode);
    }

    @Override
    public Node enterASSIGN(BinaryNode binaryNode) {
        Type rhsType;
        if (binaryNode.testResolved()) {
            return null;
        }
        Node lhs = binaryNode.lhs();
        final Node rhs = binaryNode.rhs();
        Type lhsType = lhs.getType();
        if (!lhsType.isEquivalentTo(rhsType = rhs.getType())) assert (!(lhs instanceof IdentNode) || lhs.getSymbol().isScope()) : new ASTWriter(binaryNode);
        new Store<BinaryNode>(binaryNode, lhs){

            @Override
            protected void evaluate() {
                CodeGenerator.this.load(rhs);
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_ADD(BinaryNode binaryNode) {
        assert (RuntimeNode.Request.ADD.canSpecialize());
        final boolean specialize = binaryNode.getType() == Type.OBJECT;
        new AssignOp(binaryNode){

            @Override
            protected boolean isSelfModifying() {
                return !specialize;
            }

            @Override
            protected void op() {
                CodeGenerator.this.method.add();
            }

            @Override
            protected void evaluate() {
                if (specialize && CodeGenerator.this.specializationCheck(RuntimeNode.Request.ADD, this.assignNode, Arrays.asList(((BinaryNode)this.assignNode).lhs(), ((BinaryNode)this.assignNode).rhs()))) {
                    return;
                }
                super.evaluate();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_BIT_AND(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.and();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_BIT_OR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.or();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_BIT_XOR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.xor();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_DIV(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.div();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_MOD(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.rem();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_MUL(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.mul();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_SAR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.sar();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_SHL(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.shl();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_SHR(BinaryNode binaryNode) {
        new AssignOp(Type.INT, binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.shr();
                CodeGenerator.this.method.convert(Type.LONG).load(0xFFFFFFFFL).and();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterASSIGN_SUB(BinaryNode binaryNode) {
        new AssignOp(binaryNode){

            @Override
            protected void op() {
                CodeGenerator.this.method.sub();
            }
        }.store();
        return null;
    }

    @Override
    public Node enterBIT_AND(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.and();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterBIT_OR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.or();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterBIT_XOR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.xor();
            }
        }.evaluate(binaryNode);
        return null;
    }

    private Node enterComma(BinaryNode binaryNode) {
        if (binaryNode.testResolved()) {
            return null;
        }
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        this.load(lhs);
        this.load(rhs);
        this.method.store(binaryNode.getSymbol());
        return null;
    }

    @Override
    public Node enterCOMMARIGHT(BinaryNode binaryNode) {
        return this.enterComma(binaryNode);
    }

    @Override
    public Node enterCOMMALEFT(BinaryNode binaryNode) {
        return this.enterComma(binaryNode);
    }

    @Override
    public Node enterDIV(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.div();
            }
        }.evaluate(binaryNode);
        return null;
    }

    private Node enterCmp(Node lhs, Node rhs, MethodEmitter.Condition cond, Type type, Symbol symbol) {
        Type lhsType = lhs.getType();
        Type rhsType = rhs.getType();
        Type widest = Type.widest(lhsType, rhsType);
        assert (widest.isNumeric() || widest.isBoolean()) : widest;
        this.load(lhs);
        this.method.convert(widest);
        this.load(rhs);
        this.method.convert(widest);
        MethodEmitter.Label trueLabel = new MethodEmitter.Label("trueLabel");
        MethodEmitter.Label afterLabel = new MethodEmitter.Label("skip");
        this.method.conditionalJump(cond, trueLabel);
        this.method.load(Boolean.FALSE);
        this.method._goto(afterLabel);
        this.method.label(trueLabel);
        this.method.load(Boolean.TRUE);
        this.method.label(afterLabel);
        this.method.convert(type);
        this.method.store(symbol);
        return null;
    }

    private Node enterCmp(BinaryNode binaryNode, MethodEmitter.Condition cond) {
        if (binaryNode.testResolved()) {
            return null;
        }
        return this.enterCmp(binaryNode.lhs(), binaryNode.rhs(), cond, binaryNode.getType(), binaryNode.getSymbol());
    }

    @Override
    public Node enterEQ(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.EQ);
    }

    @Override
    public Node enterEQ_STRICT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.EQ);
    }

    @Override
    public Node enterGE(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.GE);
    }

    @Override
    public Node enterGT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.GT);
    }

    @Override
    public Node enterLE(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.LE);
    }

    @Override
    public Node enterLT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.LT);
    }

    @Override
    public Node enterMOD(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.rem();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterMUL(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.mul();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterNE(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.NE);
    }

    @Override
    public Node enterNE_STRICT(BinaryNode binaryNode) {
        return this.enterCmp(binaryNode, MethodEmitter.Condition.NE);
    }

    @Override
    public Node enterOR(BinaryNode binaryNode) {
        return this.enterAND_OR(binaryNode);
    }

    @Override
    public Node enterSAR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.sar();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterSHL(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.shl();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterSHR(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.shr();
                CodeGenerator.this.method.convert(Type.LONG).load(0xFFFFFFFFL).and();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enterSUB(BinaryNode binaryNode) {
        new BinaryArith(){

            @Override
            protected void op() {
                CodeGenerator.this.method.sub();
            }
        }.evaluate(binaryNode);
        return null;
    }

    @Override
    public Node enter(TernaryNode ternaryNode) {
        if (ternaryNode.testResolved()) {
            return null;
        }
        Node lhs = ternaryNode.lhs();
        Node rhs = ternaryNode.rhs();
        Node third = ternaryNode.third();
        Symbol symbol = ternaryNode.getSymbol();
        MethodEmitter.Label falseLabel = new MethodEmitter.Label("ternary_false");
        MethodEmitter.Label exitLabel = new MethodEmitter.Label("ternary_exit");
        Type widest = Type.widest(rhs.getType(), third.getType());
        if (rhs.getType().isArray() || third.getType().isArray()) {
            widest = Type.OBJECT;
        }
        this.load(lhs);
        assert (lhs.getType().isBoolean()) : "lhs in ternary must be boolean";
        this.method.ifeq(falseLabel);
        this.load(rhs);
        this.method.convert(widest);
        this.method._goto(exitLabel);
        this.method.label(falseLabel);
        this.load(third);
        this.method.convert(widest);
        this.method.label(exitLabel);
        this.method.store(symbol);
        return null;
    }

    protected void generateScopeCalls() {
        for (SharedScopeCall scopeAccess : this.scopeCalls.values()) {
            scopeAccess.generateScopeCall();
        }
    }

    private SharedScopeCall getScopeCall(Symbol symbol, Type valueType, Type returnType, Type[] paramTypes, int flags) {
        SharedScopeCall scopeCall = new SharedScopeCall(symbol, valueType, returnType, paramTypes, flags);
        if (this.scopeCalls.containsKey(scopeCall)) {
            return this.scopeCalls.get(scopeCall);
        }
        scopeCall.setClassAndName(this.compileUnit, this.compiler);
        this.scopeCalls.put(scopeCall, scopeCall);
        return scopeCall;
    }

    private SharedScopeCall getScopeGet(Type type, Symbol symbol, int flags) {
        SharedScopeCall scopeCall = new SharedScopeCall(symbol, type, type, null, flags);
        if (this.scopeCalls.containsKey(scopeCall)) {
            return this.scopeCalls.get(scopeCall);
        }
        scopeCall.setClassAndName(this.compileUnit, this.compiler);
        this.scopeCalls.put(scopeCall, scopeCall);
        return scopeCall;
    }

    private void printSymbols(Block block, String ident) {
        if (!this.context._print_symbols) {
            return;
        }
        PrintWriter out = this.context.getErr();
        out.println("[BLOCK in '" + ident + "']");
        if (!block.printSymbols(out)) {
            out.println("<no symbols>");
        }
        out.println();
    }

    private MethodEmitter globalInstance() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "instance", "()Ljdk/nashorn/internal/objects/Global;");
    }

    private MethodEmitter globalObjectPrototype() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "objectPrototype", CompilerConstants.methodDescriptor(ScriptObject.class, new Class[0]));
    }

    private MethodEmitter globalAllocateArguments() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "allocateArguments", CompilerConstants.methodDescriptor(ScriptObject.class, Object[].class, Object.class, Integer.TYPE));
    }

    private MethodEmitter globalNewRegExp() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "newRegExp", CompilerConstants.methodDescriptor(Object.class, String.class, String.class));
    }

    private MethodEmitter globalRegExpCopy() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "regExpCopy", CompilerConstants.methodDescriptor(Object.class, Object.class));
    }

    private MethodEmitter globalAllocateArray(ArrayType type) {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "allocate", "(" + type.getDescriptor() + ")Ljdk/nashorn/internal/objects/NativeArray;");
    }

    private MethodEmitter globalIsEval() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "isEval", CompilerConstants.methodDescriptor(Boolean.TYPE, Object.class));
    }

    private MethodEmitter globalDirectEval() {
        return this.method.invokeStatic("jdk/nashorn/internal/objects/Global", "directEval", CompilerConstants.methodDescriptor(Object.class, Object.class, Object.class, Object.class, Object.class, Object.class));
    }

    private static abstract class Store<T extends Node> {
        protected final T assignNode;
        private final Node target;
        private final boolean alwaysDiscard;
        private int depth;
        private Symbol quick;
        final /* synthetic */ CodeGenerator this$0;

        protected Store(T assignNode, Node target) {
            this.this$0 = var1_1;
            this.assignNode = assignNode;
            this.target = target;
            this.alwaysDiscard = assignNode == target;
        }

        protected Store(T assignNode) {
            this(var1_1, (Node)assignNode, (Node)assignNode);
        }

        protected boolean isSelfModifying() {
            return false;
        }

        private void prologue() {
            final Symbol targetSymbol = this.target.getSymbol();
            final Symbol scopeSymbol = this.this$0.getCurrentFunctionNode().getScopeNode().getSymbol();
            this.target.accept(new NodeVisitor(this.this$0.compileUnit, this.this$0.method){

                @Override
                public Node enter(IdentNode node) {
                    if (targetSymbol.isScope()) {
                        this.method.load(scopeSymbol);
                        Store.this.depth++;
                    }
                    return null;
                }

                private void enterBaseNode() {
                    assert (Store.this.target instanceof BaseNode) : "error - base node " + Store.access$5500(Store.this) + " must be instanceof BaseNode";
                    BaseNode baseNode = (BaseNode)Store.this.target;
                    Node base = baseNode.getBase();
                    Store.this.this$0.load(base);
                    this.method.convert(Type.OBJECT);
                    Store.this.depth += Type.OBJECT.getSlots();
                    if (Store.this.isSelfModifying()) {
                        this.method.dup();
                    }
                }

                @Override
                public Node enter(AccessNode node) {
                    this.enterBaseNode();
                    return null;
                }

                @Override
                public Node enter(IndexNode node) {
                    this.enterBaseNode();
                    Node index = node.getIndex();
                    Store.this.this$0.load(index);
                    if (!index.getType().isNumeric()) {
                        this.method.convert(Type.OBJECT);
                    }
                    Store.this.depth += index.getType().getSlots();
                    if (Store.this.isSelfModifying()) {
                        this.method.dup(1);
                    }
                    return null;
                }
            });
        }

        private Symbol quickSymbol(Type type) {
            return this.quickSymbol(type, CompilerConstants.QUICK_PREFIX.tag());
        }

        private Symbol quickSymbol(Type type, String prefix) {
            String name = this.this$0.compiler.uniqueName(prefix);
            Symbol symbol = new Symbol(name, 513, null, null);
            symbol.setType(type);
            symbol.setSlot(this.this$0.getCurrentBlock().getFrame().getSlotCount());
            return symbol;
        }

        protected void storeNonDiscard() {
            if (((Node)this.assignNode).shouldDiscard() || this.alwaysDiscard) {
                ((Node)this.assignNode).setDiscard(false);
                return;
            }
            Symbol symbol = ((Node)this.assignNode).getSymbol();
            if (symbol.hasSlot()) {
                this.this$0.method.dup().store(symbol);
                return;
            }
            if (this.this$0.method.dup(this.depth) == null) {
                this.this$0.method.dup();
                this.quick = this.quickSymbol(this.this$0.method.peekType());
                this.this$0.method.store(this.quick);
            }
        }

        private void epilogue() {
            final FunctionNode currentFunction = this.this$0.getCurrentFunctionNode();
            this.this$0.method.convert(this.target.getType());
            this.target.accept(new NodeVisitor(this.this$0.compileUnit, this.this$0.method){

                @Override
                protected Node enterDefault(Node node) {
                    throw new AssertionError((Object)("Unexpected node " + node + " in store epilogue"));
                }

                @Override
                public Node enter(UnaryNode node) {
                    if (node.tokenType() == TokenType.CONVERT && node.getSymbol() != null) {
                        this.method.convert(node.rhs().getType());
                    }
                    return node;
                }

                @Override
                public Node enter(IdentNode node) {
                    Symbol symbol = node.getSymbol();
                    if (symbol.isScope()) {
                        if (symbol.isFastScope(currentFunction)) {
                            Store.this.this$0.storeFastScopeVar(node.getType(), symbol, 1 | Store.this.this$0.getCallSiteFlags());
                        } else {
                            this.method.dynamicSet(node.getType(), node.getName(), 1 | Store.this.this$0.getCallSiteFlags());
                        }
                    } else {
                        assert (symbol != null);
                        this.method.store(symbol);
                    }
                    return null;
                }

                @Override
                public Node enter(AccessNode node) {
                    this.method.dynamicSet(node.getProperty().getType(), node.getProperty().getName(), Store.this.this$0.getCallSiteFlags());
                    return null;
                }

                @Override
                public Node enter(IndexNode node) {
                    this.method.dynamicSetIndex(Store.this.this$0.getCallSiteFlags());
                    return null;
                }
            });
        }

        protected abstract void evaluate();

        void store() {
            this.prologue();
            this.evaluate();
            this.storeNonDiscard();
            this.epilogue();
            if (this.quick != null) {
                this.this$0.method.load(this.quick);
            }
        }
    }

    private static abstract class SelfModifyingStore<T extends Node>
    extends Store<T> {
        final /* synthetic */ CodeGenerator this$0;

        protected SelfModifyingStore(T assignNode, Node target) {
            this.this$0 = var1_1;
            super((CodeGenerator)var1_1, assignNode, target);
        }

        @Override
        protected boolean isSelfModifying() {
            return true;
        }
    }

    private abstract class BinaryArith {
        private BinaryArith() {
        }

        protected abstract void op();

        protected void evaluate(BinaryNode node) {
            if (node.testResolved()) {
                return;
            }
            CodeGenerator.this.load(node.lhs());
            CodeGenerator.this.load(node.rhs());
            this.op();
            CodeGenerator.this.method.store(node.getSymbol());
        }
    }

    private abstract class AssignOp
    extends SelfModifyingStore<BinaryNode> {
        private final Type opType;

        AssignOp(BinaryNode node) {
            this(node.getType(), node);
        }

        AssignOp(Type opType, BinaryNode node) {
            super(CodeGenerator.this, (Node)node, node.lhs());
            this.opType = opType;
        }

        @Override
        public void store() {
            if (((BinaryNode)this.assignNode).testResolved()) {
                return;
            }
            super.store();
        }

        protected abstract void op();

        @Override
        protected void evaluate() {
            CodeGenerator.this.load(((BinaryNode)this.assignNode).lhs(), true).convert(this.opType);
            CodeGenerator.this.load(((BinaryNode)this.assignNode).rhs()).convert(this.opType);
            this.op();
            CodeGenerator.this.method.convert(((BinaryNode)this.assignNode).getType());
        }
    }
}

