/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.FunctionScope;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.options.Options;

public final class ObjectClassGenerator {
    public static final String SCOPE_MARKER = "P";
    public static final DebugLogger LOG = new DebugLogger("fields", "nashorn.fields.debug");
    public static final boolean DEBUG_FIELDS = LOG.isEnabled();
    public static final boolean OBJECT_FIELDS_ONLY = !Options.getBooleanProperty("nashorn.fields.dual");
    private static final List<Type> FIELD_TYPES = new LinkedList<Type>();
    public static final Type PRIMITIVE_TYPE = Type.LONG;
    private final Context context;
    public static final List<Type> ACCESSOR_TYPES;
    private static final int TYPE_INT_INDEX = 0;
    private static final int TYPE_LONG_INDEX = 1;
    private static final int TYPE_DOUBLE_INDEX = 2;
    private static final int TYPE_OBJECT_INDEX = 3;
    private static final MethodHandle PACK_DOUBLE;
    private static MethodHandle UNPACK_DOUBLE;
    private static MethodHandle[] CONVERT_OBJECT;
    private static final MethodHandle IS_TYPE_GUARD;
    public static final int UNDEFINED_INT = 0;
    public static final long UNDEFINED_LONG = 0L;
    public static final double UNDEFINED_DOUBLE = Double.NaN;
    private static final MethodHandle[] GET_UNDEFINED;

    public ObjectClassGenerator(Context context) {
        this.context = context;
        assert (context != null);
    }

    public static int getAccessorTypeIndex(Type type) {
        return ObjectClassGenerator.getAccessorTypeIndex(type.getTypeClass());
    }

    public static int getAccessorTypeIndex(Class<?> type) {
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 1;
        }
        if (type == Double.TYPE) {
            return 2;
        }
        if (!type.isPrimitive()) {
            return 3;
        }
        return -1;
    }

    public static int getNumberOfAccessorTypes() {
        return ACCESSOR_TYPES.size();
    }

    public static Type getAccessorType(int index) {
        return ACCESSOR_TYPES.get(index);
    }

    public static String getClassName(int fieldCount) {
        return fieldCount != 0 ? "jdk/nashorn/internal/scripts/" + CompilerConstants.JS_OBJECT_PREFIX.tag() + fieldCount : "jdk/nashorn/internal/scripts/" + CompilerConstants.JS_OBJECT_PREFIX.tag();
    }

    public static String getClassName(int fieldCount, int paramCount) {
        return "jdk/nashorn/internal/scripts/" + CompilerConstants.JS_OBJECT_PREFIX.tag() + fieldCount + SCOPE_MARKER + paramCount;
    }

    public static String getFieldName(int fieldIndex, Type type) {
        return type.getDescriptor().substring(0, 1) + fieldIndex;
    }

    private static void initializeToUndefined(MethodEmitter init, String className, List<String> fieldNames) {
        if (fieldNames.isEmpty()) {
            return;
        }
        init.load(Type.OBJECT, CompilerConstants.THIS.slot());
        init.loadUndefined(Type.OBJECT);
        Iterator<String> iter = fieldNames.iterator();
        while (iter.hasNext()) {
            String fieldName = iter.next();
            if (iter.hasNext()) {
                init.dup2();
            }
            init.putField(className, fieldName, Type.OBJECT.getDescriptor());
        }
    }

    public byte[] generate(String descriptor) {
        String[] counts = descriptor.split(SCOPE_MARKER);
        int fieldCount = Integer.valueOf(counts[0]);
        if (counts.length == 1) {
            return this.generate(fieldCount);
        }
        int paramCount = Integer.valueOf(counts[1]);
        return this.generate(fieldCount, paramCount);
    }

    public byte[] generate(int fieldCount) {
        String className = ObjectClassGenerator.getClassName(fieldCount);
        String superName = CompilerConstants.className(ScriptObject.class);
        ClassEmitter classEmitter = this.newClassEmitter(className, superName);
        List<String> initFields = ObjectClassGenerator.addFields(classEmitter, fieldCount);
        MethodEmitter init = ObjectClassGenerator.newInitMethod(classEmitter);
        ObjectClassGenerator.initializeToUndefined(init, className, initFields);
        init.returnVoid();
        init.end();
        ObjectClassGenerator.newEmptyInit(classEmitter, className);
        ObjectClassGenerator.newAllocate(classEmitter, className);
        return this.toByteArray(classEmitter);
    }

    public byte[] generate(int fieldCount, int paramCount) {
        String className = ObjectClassGenerator.getClassName(fieldCount, paramCount);
        String superName = CompilerConstants.className(FunctionScope.class);
        ClassEmitter classEmitter = this.newClassEmitter(className, superName);
        List<String> initFields = ObjectClassGenerator.addFields(classEmitter, fieldCount);
        MethodEmitter init = ObjectClassGenerator.newInitScopeMethod(classEmitter);
        ObjectClassGenerator.initializeToUndefined(init, className, initFields);
        init.returnVoid();
        init.end();
        MethodEmitter initWithArguments = ObjectClassGenerator.newInitScopeWithArgumentsMethod(classEmitter);
        ObjectClassGenerator.initializeToUndefined(initWithArguments, className, initFields);
        initWithArguments.returnVoid();
        initWithArguments.end();
        return this.toByteArray(classEmitter);
    }

    private static List<String> addFields(ClassEmitter classEmitter, int fieldCount) {
        LinkedList<String> initFields = new LinkedList<String>();
        for (int i = 0; i < fieldCount; ++i) {
            for (Type type : FIELD_TYPES) {
                String fieldName = ObjectClassGenerator.getFieldName(i, type);
                classEmitter.field(fieldName, type.getTypeClass());
                if (type != Type.OBJECT) continue;
                initFields.add(fieldName);
            }
        }
        return initFields;
    }

    private ClassEmitter newClassEmitter(String className, String superName) {
        ClassEmitter classEmitter = new ClassEmitter(this.context, className, superName, new String[0]);
        classEmitter.begin();
        return classEmitter;
    }

    private static MethodEmitter newInitMethod(ClassEmitter classEmitter) {
        MethodEmitter init = classEmitter.init(PropertyMap.class);
        init.begin();
        init.load(Type.OBJECT, CompilerConstants.THIS.slot());
        init.load(Type.OBJECT, CompilerConstants.MAP.slot());
        init.invoke(CompilerConstants.constructorNoLookup(ScriptObject.class, PropertyMap.class));
        return init;
    }

    private static MethodEmitter newInitScopeMethod(ClassEmitter classEmitter) {
        MethodEmitter init = classEmitter.init(PropertyMap.class, ScriptObject.class);
        init.begin();
        init.load(Type.OBJECT, CompilerConstants.THIS.slot());
        init.load(Type.OBJECT, CompilerConstants.MAP.slot());
        init.load(Type.OBJECT, CompilerConstants.INIT_SCOPE.slot());
        init.invoke(CompilerConstants.constructorNoLookup(FunctionScope.class, PropertyMap.class, ScriptObject.class));
        return init;
    }

    private static MethodEmitter newInitScopeWithArgumentsMethod(ClassEmitter classEmitter) {
        MethodEmitter init = classEmitter.init(PropertyMap.class, ScriptObject.class, Object.class);
        init.begin();
        init.load(Type.OBJECT, CompilerConstants.THIS.slot());
        init.load(Type.OBJECT, CompilerConstants.MAP.slot());
        init.load(Type.OBJECT, CompilerConstants.INIT_SCOPE.slot());
        init.load(Type.OBJECT, CompilerConstants.INIT_ARGUMENTS.slot());
        init.invoke(CompilerConstants.constructorNoLookup(FunctionScope.class, PropertyMap.class, ScriptObject.class, Object.class));
        return init;
    }

    private static void newEmptyInit(ClassEmitter classEmitter, String className) {
        MethodEmitter emptyInit = classEmitter.init();
        emptyInit.begin();
        emptyInit.load(Type.OBJECT, CompilerConstants.THIS.slot());
        emptyInit.loadNull();
        emptyInit.invoke(CompilerConstants.constructorNoLookup(className, PropertyMap.class));
        emptyInit.returnVoid();
        emptyInit.end();
    }

    private static void newAllocate(ClassEmitter classEmitter, String className) {
        MethodEmitter allocate = classEmitter.method(EnumSet.of(ClassEmitter.Flag.PUBLIC, ClassEmitter.Flag.STATIC), CompilerConstants.ALLOCATE.tag(), ScriptObject.class, PropertyMap.class);
        allocate.begin();
        allocate._new(className);
        allocate.dup();
        allocate.load(Type.typeFor(PropertyMap.class), 0);
        allocate.invoke(CompilerConstants.constructorNoLookup(className, PropertyMap.class));
        allocate._return();
        allocate.end();
    }

    private byte[] toByteArray(ClassEmitter classEmitter) {
        classEmitter.end();
        byte[] code = classEmitter.toByteArray();
        if (this.context != null && this.context._print_code) {
            ClassEmitter.disassemble(this.context, code);
        }
        if (this.context != null && this.context._verify_code) {
            ClassEmitter.verify(this.context, code);
        }
        return code;
    }

    public static MethodHandle createGetter(Class<?> forType, Class<?> type, MethodHandle primitiveGetter, MethodHandle objectGetter) {
        int fti = forType == null ? -1 : ObjectClassGenerator.getAccessorTypeIndex(forType);
        int ti = ObjectClassGenerator.getAccessorTypeIndex(type);
        if (fti == 3 || OBJECT_FIELDS_ONLY) {
            if (ti == 3) {
                return objectGetter;
            }
            return Lookup.MH.filterReturnValue(objectGetter, CONVERT_OBJECT[ti]);
        }
        assert (!OBJECT_FIELDS_ONLY);
        if (forType == null) {
            return GET_UNDEFINED[ti];
        }
        MethodType pmt = primitiveGetter.type();
        switch (fti) {
            case 0: 
            case 1: {
                switch (ti) {
                    case 0: {
                        return Lookup.MH.explicitCastArguments(primitiveGetter, pmt.changeReturnType(Integer.TYPE));
                    }
                    case 1: {
                        return primitiveGetter;
                    }
                }
                return Lookup.MH.asType(primitiveGetter, pmt.changeReturnType(type));
            }
            case 2: {
                MethodHandle getPrimitiveAsDouble = Lookup.MH.filterReturnValue(primitiveGetter, UNPACK_DOUBLE);
                switch (ti) {
                    case 0: 
                    case 1: {
                        return Lookup.MH.explicitCastArguments(getPrimitiveAsDouble, pmt.changeReturnType(type));
                    }
                    case 2: {
                        return getPrimitiveAsDouble;
                    }
                }
                return Lookup.MH.asType(getPrimitiveAsDouble, pmt.changeReturnType(Object.class));
            }
        }
        assert (false);
        return null;
    }

    private static boolean isType(Class<?> boxedForType, Object x) {
        return x.getClass() == boxedForType;
    }

    private static Class<? extends Number> getBoxedType(Class<?> forType) {
        if (forType == Integer.TYPE) {
            return Integer.class;
        }
        if (forType == Long.TYPE) {
            return Long.class;
        }
        if (forType == Double.TYPE) {
            return Double.class;
        }
        assert (false);
        return null;
    }

    public static MethodHandle createGuardBoxedPrimitiveSetter(Class<?> forType, MethodHandle primitiveSetter, MethodHandle objectSetter) {
        Class<? extends Number> boxedForType = ObjectClassGenerator.getBoxedType(forType);
        return Lookup.MH.guardWithTest(Lookup.MH.insertArguments(Lookup.MH.dropArguments(IS_TYPE_GUARD, 1, Object.class), 0, boxedForType), Lookup.MH.asType(primitiveSetter, objectSetter.type()), objectSetter);
    }

    public static MethodHandle createSetter(Class<?> forType, Class<?> type, MethodHandle primitiveSetter, MethodHandle objectSetter) {
        assert (forType != null);
        int fti = ObjectClassGenerator.getAccessorTypeIndex(forType);
        int ti = ObjectClassGenerator.getAccessorTypeIndex(type);
        if (fti == 3 || OBJECT_FIELDS_ONLY) {
            if (ti == 3) {
                return objectSetter;
            }
            return Lookup.MH.asType(objectSetter, objectSetter.type().changeParameterType(1, type));
        }
        assert (!OBJECT_FIELDS_ONLY);
        MethodType pmt = primitiveSetter.type();
        switch (fti) {
            case 0: 
            case 1: {
                switch (ti) {
                    case 0: {
                        return Lookup.MH.asType(primitiveSetter, pmt.changeParameterType(1, Integer.TYPE));
                    }
                    case 1: {
                        return primitiveSetter;
                    }
                    case 2: {
                        return Lookup.MH.filterArguments(primitiveSetter, 1, PACK_DOUBLE);
                    }
                }
                return objectSetter;
            }
            case 2: {
                if (ti == 3) {
                    return objectSetter;
                }
                return Lookup.MH.asType(Lookup.MH.filterArguments(primitiveSetter, 1, PACK_DOUBLE), pmt.changeParameterType(1, type));
            }
        }
        assert (false);
        return null;
    }

    private static String typeName(Type type) {
        String name = type.getTypeClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            name = name.substring(dot + 1);
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static MethodHandle getUndefined(Class<?> returnType) {
        return GET_UNDEFINED[ObjectClassGenerator.getAccessorTypeIndex(returnType)];
    }

    private static int getUndefinedInt(Object obj) {
        return 0;
    }

    private static long getUndefinedLong(Object obj) {
        return 0L;
    }

    private static double getUndefinedDouble(Object obj) {
        return Double.NaN;
    }

    private static Object getUndefinedObject(Object obj) {
        return ScriptRuntime.UNDEFINED;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), ObjectClassGenerator.class, name, Lookup.MH.type(rtype, types));
    }

    static {
        if (!OBJECT_FIELDS_ONLY) {
            System.err.println("WARNING!!! Running with primitive fields - there is untested functionality!");
            FIELD_TYPES.add(PRIMITIVE_TYPE);
        }
        FIELD_TYPES.add(Type.OBJECT);
        ACCESSOR_TYPES = Collections.unmodifiableList(Arrays.asList(Type.INT, Type.LONG, Type.NUMBER, Type.OBJECT));
        PACK_DOUBLE = Lookup.MH.explicitCastArguments(Lookup.MH.findStatic(MethodHandles.publicLookup(), Double.class, "doubleToRawLongBits", Lookup.MH.type(Long.TYPE, Double.TYPE)), Lookup.MH.type(Long.TYPE, Double.TYPE));
        UNPACK_DOUBLE = Lookup.MH.findStatic(MethodHandles.publicLookup(), Double.class, "longBitsToDouble", Lookup.MH.type(Double.TYPE, Long.TYPE));
        CONVERT_OBJECT = new MethodHandle[]{JSType.TO_INT32.methodHandle(), JSType.TO_UINT32.methodHandle(), JSType.TO_NUMBER.methodHandle(), null};
        IS_TYPE_GUARD = ObjectClassGenerator.findOwnMH("isType", Boolean.TYPE, Class.class, Object.class);
        GET_UNDEFINED = new MethodHandle[ObjectClassGenerator.getNumberOfAccessorTypes()];
        int pos = 0;
        for (Type type : ACCESSOR_TYPES) {
            ObjectClassGenerator.GET_UNDEFINED[pos++] = ObjectClassGenerator.findOwnMH("getUndefined" + ObjectClassGenerator.typeName(type), type.getTypeClass(), Object.class);
        }
    }
}

